/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.devtools.impl.summaries;

import com.intellij.lang.Language;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.rml.dfa.devtools.impl.summaries.RmlProvidersDiskStorage;
import com.intellij.rml.dfa.impl.DfaStorageError;
import com.intellij.rml.dfa.impl.domains.DomainTypeManager;
import com.intellij.rml.dfa.impl.providers.RMLImmutableInstancesProvider;
import com.intellij.rml.dfa.impl.providers.RMLInstancesProviderBase;
import com.intellij.rml.dfa.impl.providers.RmlProviderDescriptor;
import com.intellij.rml.dfa.impl.providers.RmlProvidersStorage;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/rml/dfa/devtools/impl/summaries/RmlProvidersDiskStorageService;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "storageFile", "Ljava/nio/file/Path;", "storageMap", "Lcom/intellij/util/io/PersistentHashMap;", "Lcom/intellij/rml/dfa/impl/providers/RmlProviderDescriptor;", "Lcom/intellij/rml/dfa/impl/providers/RMLInstancesProviderBase;", "getProvidersStorage", "Lcom/intellij/rml/dfa/impl/providers/RmlProvidersStorage;", "language", "Lcom/intellij/lang/Language;", "typeManager", "Lcom/intellij/rml/dfa/impl/domains/DomainTypeManager;", "Companion", "intellij.rml.dfa.devtools.impl"})
public final class RmlProvidersDiskStorageService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Path storageFile;
    @Nullable
    private PersistentHashMap<RmlProviderDescriptor, RMLInstancesProviderBase> storageMap;

    public RmlProvidersDiskStorageService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.storageFile = ProjectUtil.getProjectDataPath((Project)this.project, (String)"rml-dfa/summaries.bin");
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final RmlProvidersStorage getProvidersStorage(@NotNull Language language, @NotNull DomainTypeManager typeManager) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)typeManager, (String)"typeManager");
        try {
            PersistentHashMap<RmlProviderDescriptor, RMLInstancesProviderBase> persistentHashMap = this.storageMap;
            if (persistentHashMap != null) {
                persistentHashMap.closeAndClean();
            }
            this.storageMap = new PersistentHashMap(this.storageFile, (KeyDescriptor)new KeyDescriptor<RmlProviderDescriptor>(){

                public boolean isEqual(@NotNull RmlProviderDescriptor desc1, @NotNull RmlProviderDescriptor desc2) {
                    Intrinsics.checkNotNullParameter((Object)desc1, (String)"desc1");
                    Intrinsics.checkNotNullParameter((Object)desc2, (String)"desc2");
                    return Intrinsics.areEqual((Object)desc1, (Object)desc2);
                }

                public int getHashCode(@NotNull RmlProviderDescriptor descriptor) {
                    Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                    return descriptor.hashCode();
                }

                public void save(@NotNull DataOutput stream, @NotNull RmlProviderDescriptor descriptor) {
                    Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                    Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                    descriptor.save(stream);
                }

                @NotNull
                public RmlProviderDescriptor read(@NotNull DataInput stream) {
                    Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                    return RmlProviderDescriptor.Companion.load(stream);
                }
            }, (DataExternalizer)new DataExternalizer<RMLInstancesProviderBase>(typeManager){
                final /* synthetic */ DomainTypeManager $typeManager;
                {
                    this.$typeManager = $typeManager;
                }

                public void save(@NotNull DataOutput stream, @NotNull RMLInstancesProviderBase provider) {
                    Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                    Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
                    provider.save(stream);
                }

                @NotNull
                public RMLInstancesProviderBase read(@NotNull DataInput stream) {
                    Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                    return RMLImmutableInstancesProvider.Companion.load(this.$typeManager, stream);
                }
            });
            File file2 = this.storageFile.toFile().getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getParentFile(...)");
            PersistentHashMap<RmlProviderDescriptor, RMLInstancesProviderBase> persistentHashMap2 = this.storageMap;
            Intrinsics.checkNotNull(persistentHashMap2);
            return new RmlProvidersDiskStorage(file2, persistentHashMap2, language);
        }
        catch (IOException e) {
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            throw new DfaStorageError(null, string);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/rml/dfa/devtools/impl/summaries/RmlProvidersDiskStorageService$Companion;", "", "()V", "getInstance", "Lcom/intellij/rml/dfa/devtools/impl/summaries/RmlProvidersDiskStorageService;", "kotlin.jvm.PlatformType", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rml.dfa.devtools.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final RmlProvidersDiskStorageService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return (RmlProvidersDiskStorageService)project.getService(RmlProvidersDiskStorageService.class);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

