/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view.details.image;

import com.intellij.docker.DockerIcons;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentRepositoryConfig;
import com.intellij.docker.agent.DockerRepoTag;
import com.intellij.docker.agent.progress.DockerResponseItem;
import com.intellij.docker.agent.terminal.pipe.DockerTerminalPipe;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.image.DockerSearchImageTextField;
import com.intellij.docker.runtimes.DockerGroupRuntime;
import com.intellij.docker.runtimes.DockerRuntimeContextKt;
import com.intellij.docker.ui.utils.DockerRedirectToTerminal;
import com.intellij.docker.ui.utils.DockerUiUtilsKt;
import com.intellij.docker.utils.InternalUtilsKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.remoteServer.impl.runtime.log.TerminalHandlerBase;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0002J\n\u0010!\u001a\u0004\u0018\u00010 H\u0002J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020#H\u0002J\u001a\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0&0\u001c2\u0006\u0010\u001f\u001a\u00020 J\b\u0010(\u001a\u00020#H\u0002J\b\u0010)\u001a\u00020#H\u0002J\u0010\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020\u0015H\u0002R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/docker/view/details/image/ImagePullPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "runtime", "Lcom/intellij/docker/runtimes/DockerGroupRuntime$ImagesGroup;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/docker/runtimes/DockerGroupRuntime$ImagesGroup;)V", "focusManager", "Lcom/intellij/openapi/wm/IdeFocusManager;", "getFocusManager", "()Lcom/intellij/openapi/wm/IdeFocusManager;", "imageTagField", "Lcom/intellij/docker/image/DockerSearchImageTextField;", "mainPanel", "Ljavax/swing/JComponent;", "getMainPanel$intellij_clouds_docker", "()Ljavax/swing/JComponent;", "operationLabel", "Lcom/intellij/ui/components/JBLabel;", "pullQueue", "Ljava/util/Deque;", "", "spinningLabel", "terminalHandler", "Lcom/intellij/remoteServer/impl/runtime/log/TerminalHandlerBase;", "terminalPipe", "Lcom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe$WithTty;", "asyncPullImage", "Ljava/util/concurrent/CompletableFuture;", "Ljava/util/concurrent/BlockingQueue;", "", "tag", "Lcom/intellij/docker/agent/DockerRepoTag;", "chooseNextValidTagToPull", "dispose", "", "doPull", "pullImage", "", "Lcom/intellij/docker/agent/progress/DockerResponseItem$AuxDetail;", "pullNextOne", "refreshQueueLabel", "requestPull", "request", "Companion", "intellij.clouds.docker"})
public final class ImagePullPanel
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final DockerGroupRuntime.ImagesGroup runtime;
    @NotNull
    private final JBLabel spinningLabel;
    @NotNull
    private final JBLabel operationLabel;
    @NotNull
    private final DockerSearchImageTextField imageTagField;
    @NotNull
    private final DockerTerminalPipe.WithTty terminalPipe;
    @NotNull
    private final Deque<String> pullQueue;
    @NotNull
    private final TerminalHandlerBase terminalHandler;
    @NotNull
    private final JComponent mainPanel;
    public static final int ICON_GAP = 6;

    public ImagePullPanel(@NotNull Project project, @NotNull DockerGroupRuntime.ImagesGroup runtime2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)runtime2, (String)"runtime");
        this.project = project;
        this.runtime = runtime2;
        this.spinningLabel = new JBLabel((Icon)new AnimatedIcon.Default());
        this.operationLabel = new JBLabel("");
        this.terminalPipe = InternalUtilsKt.makeTerminalPipeWithTty();
        this.pullQueue = new ArrayDeque();
        this.terminalPipe.setShowCursor(false);
        this.imageTagField = new DockerSearchImageTextField(this.project);
        this.imageTagField.setPreferredSize(new JTextField(30).getPreferredSize());
        ShortcutSet shortcut = CommonShortcuts.getCtrlEnter();
        DialogPanel imageTagPanel2 = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this, shortcut){
            final /* synthetic */ ImagePullPanel this$0;
            final /* synthetic */ ShortcutSet $shortcut;
            {
                this.this$0 = $receiver;
                this.$shortcut = $shortcut;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0, this.$shortcut){
                    final /* synthetic */ ImagePullPanel this$0;
                    final /* synthetic */ ShortcutSet $shortcut;
                    {
                        this.this$0 = $receiver;
                        this.$shortcut = $shortcut;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string = DockerBundle.message("ImagePullPanel.image.to.pull.label", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        $this$row.label(string).gap(RightGap.SMALL);
                        $this$row.cell((JComponent)((Object)ImagePullPanel.access$getImageTagField$p(this.this$0))).gap(RightGap.SMALL);
                        String string2 = DockerBundle.message("DockerRegistryServiceViewContributor.dialog.ok", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                        AbstractButton abstractButton = (AbstractButton)$this$row.button(string2, (Function1)new Function1<ActionEvent, Unit>(this.this$0){
                            final /* synthetic */ ImagePullPanel this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull ActionEvent it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                ImagePullPanel.access$doPull(this.this$0);
                            }
                        }).gap(RightGap.SMALL).getComponent();
                        Icon icon = DockerIcons.PullImage;
                        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"PullImage");
                        DockerUiUtilsKt.withIcon(abstractButton, icon);
                        Object[] objectArray = new Object[]{KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)this.$shortcut)};
                        String string3 = DockerBundle.message("ImagePullPanel.image.to.pull.comment", objectArray);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                        Row.comment$default((Row)$this$row, (String)string3, (int)0, null, (int)6, null);
                    }
                }), (int)1, null);
            }
        }));
        this.mainPanel = new JPanel(new BorderLayout(0, 0));
        Object object = new JPanel((LayoutManager)new HorizontalLayout(6, 0, 2, null));
        JPanel it = object;
        boolean bl = false;
        it.setBorder((Border)JBUI.Borders.emptyRight((int)ImagePullPanel.Companion.scale(10)));
        it.add((Component)new JBLabel(), "LEFT");
        it.add((Component)imageTagPanel2, "LEFT");
        it.add((Component)this.operationLabel, "RIGHT");
        it.add((Component)this.spinningLabel, "RIGHT");
        JPanel topRow = object;
        this.mainPanel.add((Component)topRow, "North");
        DockerTerminalPipe dockerTerminalPipe = this.terminalPipe;
        String string = DockerBundle.message("ImagePullPanel.terminal.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.terminalHandler = DockerUiUtilsKt.createTerminal(dockerTerminalPipe, string, this.project);
        JComponent jComponent = this.terminalHandler.getComponent();
        JBInsets jBInsets = JBUI.insetsTop((int)1);
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insetsTop(...)");
        this.mainPanel.add((Component)DockerUiUtilsKt.withBorder(jComponent, (Insets)jBInsets), "Center");
        object = DockerBundle.message("ImagePullPanel.action.pull", new Object[0]);
        new DumbAwareAction((String)object){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.doPull();
            }
        }.registerCustomShortcutSet(shortcut, (JComponent)((Object)this.imageTagField), null);
        this.refreshQueueLabel();
    }

    @NotNull
    public final JComponent getMainPanel$intellij_clouds_docker() {
        return this.mainPanel;
    }

    public void dispose() {
        if (!this.terminalHandler.isClosed()) {
            this.terminalHandler.close();
        }
    }

    private final void doPull() {
        String string = this.imageTagField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String tag2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
        boolean bl = false;
        if (((CharSequence)tag2).length() > 0) {
            this.imageTagField.setText("");
            this.getFocusManager().requestFocusInProject((Component)this.terminalHandler.getComponent(), this.project);
            DockerRuntimeContextKt.launch$default(this.runtime.getContext(), null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, tag2, null){
                int label;
                final /* synthetic */ ImagePullPanel this$0;
                final /* synthetic */ String $tag;
                {
                    this.this$0 = $receiver;
                    this.$tag = $tag;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            ImagePullPanel.access$requestPull(this.this$0, this.$tag);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 3, null);
        }
    }

    private final void requestPull(String request2) {
        CharSequence charSequence = request2;
        Regex regex = new Regex("\\s+");
        int n = 0;
        List newTags = regex.split(charSequence, n);
        boolean queueWasEmpty = this.pullQueue.isEmpty();
        this.pullQueue.addAll(newTags);
        if (queueWasEmpty) {
            this.pullNextOne();
        }
    }

    private final void pullNextOne() {
        DockerRepoTag tagToPull = this.chooseNextValidTagToPull();
        if (tagToPull == null) {
            ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(this){
                final /* synthetic */ ImagePullPanel this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    ImagePullPanel.access$getFocusManager(this.this$0).requestFocusInProject((Component)((Object)ImagePullPanel.access$getImageTagField$p(this.this$0)), ImagePullPanel.access$getProject$p(this.this$0));
                }
            }), (int)1, null);
            return;
        }
        ((CompletableFuture)this.pullImage(tagToPull).thenRun(() -> ImagePullPanel.pullNextOne$lambda$2(this))).thenRun(() -> ImagePullPanel.pullNextOne$lambda$3(this));
    }

    @NotNull
    public final CompletableFuture<List<DockerResponseItem.AuxDetail>> pullImage(@NotNull DockerRepoTag tag2) {
        Intrinsics.checkNotNullParameter((Object)tag2, (String)"tag");
        return new DockerRedirectToTerminal(this.terminalPipe.asTtySink()).redirectToTerminalLater(this.asyncPullImage(tag2));
    }

    private final CompletableFuture<BlockingQueue<byte[]>> asyncPullImage(DockerRepoTag tag2) {
        DockerAgentRepositoryConfig repoConfig = tag2.toAgentRepositoryConfig();
        DockerAgent dockerAgent = this.runtime.getContext().getAgent();
        Intrinsics.checkNotNull((Object)repoConfig);
        return dockerAgent.asyncPullImage(repoConfig);
    }

    private final DockerRepoTag chooseNextValidTagToPull() {
        while (!this.pullQueue.isEmpty()) {
            DockerRepoTag nextTag;
            String nextTagString = this.pullQueue.removeFirst();
            this.refreshQueueLabel();
            this.terminalPipe.printInfo("docker pull " + nextTagString);
            Intrinsics.checkNotNullExpressionValue((Object)DockerRepoTag.fromString(nextTagString), (String)"fromString(...)");
            if (!nextTag.hasCustomTag()) {
                Intrinsics.checkNotNull((Object)nextTagString);
                CharSequence charSequence = nextTagString;
                String string = nextTag.getTagNotNull();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTagNotNull(...)");
                if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null)) {
                    String string2 = DockerBundle.message("ImagePullPanel.terminal.info.using.default.tag", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                    this.terminalPipe.printInfo(string2);
                }
            }
            if (nextTag.isValidReferenceFormat()) {
                return nextTag;
            }
            Object[] objectArray = new Object[]{nextTagString};
            String string = DockerBundle.message("ImagePullPanel.terminal.error.reference.format", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.terminalPipe.printError(string);
            DockerTerminalPipe.WithTty.println$default(this.terminalPipe, null, 1, null);
        }
        return null;
    }

    private final void refreshQueueLabel() {
        Object[] objectArray = new Object[]{this.pullQueue.size()};
        this.operationLabel.setText(DockerBundle.message("ImagePullPanel.queue.label", objectArray));
        this.operationLabel.setVisible(!((Collection)this.pullQueue).isEmpty());
        this.spinningLabel.setVisible(!((Collection)this.pullQueue).isEmpty());
    }

    private final IdeFocusManager getFocusManager() {
        IdeFocusManager ideFocusManager = IdeFocusManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)ideFocusManager, (String)"getInstance(...)");
        return ideFocusManager;
    }

    private static final void pullNextOne$lambda$2(ImagePullPanel this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        DockerTerminalPipe.WithTty.println$default(this$0.terminalPipe, null, 1, null);
    }

    private static final void pullNextOne$lambda$3(ImagePullPanel this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.pullNextOne();
    }

    public static final /* synthetic */ IdeFocusManager access$getFocusManager(ImagePullPanel $this) {
        return $this.getFocusManager();
    }

    public static final /* synthetic */ DockerSearchImageTextField access$getImageTagField$p(ImagePullPanel $this) {
        return $this.imageTagField;
    }

    public static final /* synthetic */ Project access$getProject$p(ImagePullPanel $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$requestPull(ImagePullPanel $this, String request2) {
        $this.requestPull(request2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/docker/view/details/image/ImagePullPanel$Companion;", "", "()V", "ICON_GAP", "", "scale", "value", "intellij.clouds.docker"})
    public static final class Companion {
        private Companion() {
        }

        private final int scale(int value) {
            return JBUIScale.scale((int)value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

