/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.ui.utils;

import com.intellij.docker.DockerContainerStatus;
import com.intellij.docker.DockerIcons;
import com.intellij.docker.DockerServerStatus;
import com.intellij.docker.runtimes.ComposeServiceStatus;
import com.intellij.docker.ui.utils.DockerIconUtilsKt;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.BadgeIconSupplier;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.LayeredIcon;
import icons.RemoteServersIcons;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0000\u001a\f\u0010\f\u001a\u00020\u0007*\u00020\rH\u0000\u001a\u0014\u0010\u000e\u001a\u00020\u0007*\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0011"}, d2={"checkHealthyAnimatedIcon", "Lcom/intellij/ui/AnimatedIcon;", "getCheckHealthyAnimatedIcon", "()Lcom/intellij/ui/AnimatedIcon;", "checkHealthyAnimatedIcon$delegate", "Lkotlin/Lazy;", "getContainerIcon", "Ljavax/swing/Icon;", "status", "Lcom/intellij/docker/DockerContainerStatus;", "getServerIcon", "Lcom/intellij/docker/DockerServerStatus;", "getComposeProjectIcon", "Lcom/intellij/docker/runtimes/ComposeServiceStatus;", "getComposeServiceIcon", "scaledService", "", "intellij.clouds.docker"})
public final class DockerIconUtilsKt {
    @NotNull
    private static final Lazy checkHealthyAnimatedIcon$delegate = LazyKt.lazy((Function0)checkHealthyAnimatedIcon.2.INSTANCE);

    private static final AnimatedIcon getCheckHealthyAnimatedIcon() {
        Lazy lazy = checkHealthyAnimatedIcon$delegate;
        return (AnimatedIcon)lazy.getValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final Icon getContainerIcon(@NotNull DockerContainerStatus status2) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)status2, (String)"status");
        if (ExperimentalUI.Companion.isNewUI()) {
            DockerContainerStatus dockerContainerStatus = status2;
            if (dockerContainerStatus instanceof DockerContainerStatus.Up.Running ? true : dockerContainerStatus instanceof DockerContainerStatus.Up.Healthy) {
                Icon icon2 = DockerIcons.SingleRunningContainer;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"SingleRunningContainer");
                icon = new BadgeIconSupplier(icon2).getLiveIndicatorIcon();
                return icon;
            } else if (dockerContainerStatus instanceof DockerContainerStatus.Up.Unhealthy) {
                Icon icon3 = DockerIcons.SingleRunningContainer;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"SingleRunningContainer");
                icon = new BadgeIconSupplier(icon3).getWarningIcon();
                return icon;
            } else if (dockerContainerStatus instanceof DockerContainerStatus.Up.CheckHealthy) {
                icon = (Icon)DockerIconUtilsKt.getCheckHealthyAnimatedIcon();
                return icon;
            } else if (dockerContainerStatus instanceof DockerContainerStatus.Stopped) {
                Icon icon4 = DockerIcons.SingleStoppedContainer;
                icon = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"SingleStoppedContainer");
                return icon;
            } else {
                if (!(dockerContainerStatus instanceof DockerContainerStatus.Paused)) throw new NoWhenBranchMatchedException();
                Icon icon5 = AllIcons.RunConfigurations.TestPaused;
                icon = icon5;
                Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"TestPaused");
            }
            return icon;
        } else {
            DockerContainerStatus dockerContainerStatus = status2;
            Icon icon6 = dockerContainerStatus instanceof DockerContainerStatus.Stopped ? DockerIcons.SingleStoppedContainer : (dockerContainerStatus instanceof DockerContainerStatus.Paused ? AllIcons.RunConfigurations.TestPaused : DockerIcons.SingleRunningContainer);
            Intrinsics.checkNotNull((Object)icon6);
            icon = icon6;
        }
        return icon;
    }

    @NotNull
    public static final Icon getServerIcon(@NotNull DockerServerStatus status2) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)status2, (String)"status");
        DockerServerStatus dockerServerStatus = status2;
        if (Intrinsics.areEqual((Object)dockerServerStatus, (Object)DockerServerStatus.Connected.INSTANCE)) {
            if (ExperimentalUI.Companion.isNewUI()) {
                Icon icon2 = DockerIcons.Docker;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Docker");
                icon = new BadgeIconSupplier(icon2).getLiveIndicatorIcon();
            } else {
                icon = (Icon)LayeredIcon.Companion.layeredIcon(DockerIconUtilsKt::getServerIcon$lambda$0);
            }
        } else if (dockerServerStatus instanceof DockerServerStatus.Error) {
            icon = (Icon)LayeredIcon.Companion.layeredIcon(DockerIconUtilsKt::getServerIcon$lambda$1);
        } else if (Intrinsics.areEqual((Object)dockerServerStatus, (Object)DockerServerStatus.Disconnected.INSTANCE)) {
            icon = (Icon)LayeredIcon.Companion.layeredIcon(DockerIconUtilsKt::getServerIcon$lambda$2);
        } else if (Intrinsics.areEqual((Object)dockerServerStatus, (Object)DockerServerStatus.Connecting.INSTANCE)) {
            AnimatedIcon animatedIcon = AnimatedIcon.Default.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)animatedIcon, (String)"INSTANCE");
            icon = (Icon)animatedIcon;
        } else {
            Icon icon3 = DockerIcons.Docker;
            icon = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Docker");
        }
        return icon;
    }

    @NotNull
    public static final Icon getComposeProjectIcon(@NotNull ComposeServiceStatus $this$getComposeProjectIcon) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$getComposeProjectIcon), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$getComposeProjectIcon.ordinal()]) {
            case 1: {
                Icon[] iconArray = new Icon[2];
                Intrinsics.checkNotNullExpressionValue((Object)DockerIcons.ContainersList_2_grey, (String)"ContainersList_2_grey");
                Intrinsics.checkNotNullExpressionValue((Object)AllIcons.RunConfigurations.InvalidConfigurationLayer, (String)"InvalidConfigurationLayer");
                icon = (Icon)LayeredIcon.Companion.layeredIcon(iconArray);
                break;
            }
            case 2: {
                Icon icon2 = DockerIcons.ContainersList_2_grey;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"ContainersList_2_grey");
                icon = IconLoader.getTransparentIcon((Icon)icon2, (float)0.5f);
                break;
            }
            case 3: {
                Icon icon3 = DockerIcons.ContainersList_2_grey;
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"ContainersList_2_grey");
                break;
            }
            case 4: 
            case 5: {
                Icon icon4 = DockerIcons.ContainersList_2;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"ContainersList_2");
                icon = new BadgeIconSupplier(icon4).getLiveIndicatorIcon();
                break;
            }
            case 6: {
                Icon icon5 = DockerIcons.ContainersList_2;
                Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"ContainersList_2");
                icon = new BadgeIconSupplier(icon5).getWarningIcon();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return icon;
    }

    @NotNull
    public static final Icon getComposeServiceIcon(@NotNull ComposeServiceStatus $this$getComposeServiceIcon, boolean scaledService) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$getComposeServiceIcon), (String)"<this>");
        Icon icon = scaledService ? DockerIcons.DockerComposeScaledService : DockerIcons.DockerComposeService;
        Intrinsics.checkNotNull((Object)icon);
        Icon icon2 = icon;
        Icon icon3 = scaledService ? DockerIcons.DockerComposeScaledServiceStopped : DockerIcons.DockerComposeServiceStopped;
        Intrinsics.checkNotNull((Object)icon3);
        Icon iconStopped = icon3;
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$getComposeServiceIcon.ordinal()]) {
            case 1 -> {
                Icon[] var5_5 = new Icon[2];
                var5_5[0] = iconStopped;
                Intrinsics.checkNotNullExpressionValue((Object)AllIcons.RunConfigurations.InvalidConfigurationLayer, (String)"InvalidConfigurationLayer");
                yield (Icon)LayeredIcon.Companion.layeredIcon(var5_5);
            }
            case 2 -> IconLoader.getTransparentIcon((Icon)iconStopped, (float)0.5f);
            case 4, 5 -> new BadgeIconSupplier(icon2).getLiveIndicatorIcon();
            case 3 -> iconStopped;
            case 6 -> new BadgeIconSupplier(icon2).getWarningIcon();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final Icon[] getServerIcon$lambda$0() {
        Icon[] iconArray = new Icon[2];
        Intrinsics.checkNotNullExpressionValue((Object)DockerIcons.Docker, (String)"Docker");
        Intrinsics.checkNotNullExpressionValue((Object)RemoteServersIcons.ResumeScaled, (String)"ResumeScaled");
        return iconArray;
    }

    private static final Icon[] getServerIcon$lambda$1() {
        Icon[] iconArray = new Icon[2];
        Intrinsics.checkNotNullExpressionValue((Object)DockerIcons.Docker, (String)"Docker");
        Intrinsics.checkNotNullExpressionValue((Object)AllIcons.RunConfigurations.InvalidConfigurationLayer, (String)"InvalidConfigurationLayer");
        return iconArray;
    }

    private static final Icon[] getServerIcon$lambda$2() {
        Icon[] iconArray = new Icon[2];
        Intrinsics.checkNotNullExpressionValue((Object)DockerIcons.Docker, (String)"Docker");
        Intrinsics.checkNotNullExpressionValue((Object)RemoteServersIcons.SuspendScaled, (String)"SuspendScaled");
        return iconArray;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ComposeServiceStatus.values().length];
            try {
                nArray[ComposeServiceStatus.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComposeServiceStatus.WITHOUT_CONTAINERS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComposeServiceStatus.STOPPED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComposeServiceStatus.UP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComposeServiceStatus.HEALTHY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComposeServiceStatus.UNHEALTHY.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

