/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.settings;

import com.intellij.DynamicBundle;
import com.intellij.docker.agent.settings.DockerPathMappingImpl;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class DockerMappingConfigurable
implements Configurable {
    private JPanel myMainPanel;
    private JTextField myVirtualMachinePathField;
    private TextFieldWithBrowseButton myLocalPathField;
    final DockerPathMappingImpl myPathMapping;

    public DockerMappingConfigurable(DockerPathMappingImpl item) {
        this.myPathMapping = item;
        this.$$$setupUI$$$();
        this.myLocalPathField.addBrowseFolderListener(DockerBundle.message("DockerMappingConfigurable.browse.title", new Object[0]), DockerBundle.message("DockerMappingConfigurable.browse.description", new Object[0]), null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
    }

    @Nls
    public String getDisplayName() {
        return DockerBundle.message("DockerMappingConfigurable.displayName", new Object[0]);
    }

    @Nullable
    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        return true;
    }

    public void apply() throws ConfigurationException {
        String virtualMachinePath = this.myVirtualMachinePathField.getText();
        if (StringUtil.isEmpty((String)virtualMachinePath)) {
            throw new ConfigurationException(DockerBundle.message("DockerMappingConfigurable.error.remote.path.required", new Object[0]));
        }
        String localPath = this.myLocalPathField.getText();
        if (StringUtil.isEmpty((String)localPath)) {
            throw new ConfigurationException(DockerBundle.message("DockerMappingConfigurable.error.local.path.required", new Object[0]));
        }
        this.myPathMapping.setVirtualMachinePath(virtualMachinePath);
        this.myPathMapping.setLocalPath(localPath);
    }

    public void reset() {
        this.myVirtualMachinePathField.setText(this.myPathMapping.getVirtualMachinePath());
        this.myLocalPathField.setText(this.myPathMapping.getLocalPath());
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.docker.settings.path-mappings";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JTextField jTextField;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerMappingConfigurable.class).getString("DockerMappingConfigurable.virtual.machine.path.text"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myVirtualMachinePathField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerMappingConfigurable.class).getString("DockerMappingConfigurable.local.path.text"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLocalPathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        jLabel.setLabelFor(jTextField);
        jLabel2.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

