/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.github.dockerjava.api.model.ContainerNetwork;
import com.intellij.docker.DockerIcons;
import com.intellij.docker.DockerStatus;
import com.intellij.docker.DockerTransitionStatus;
import com.intellij.docker.agent.DockerAgentNetwork;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerNetworkRuntime;
import com.intellij.docker.runtimes.DockerNetworkRuntimeImplKt;
import com.intellij.docker.runtimes.DockerRuntimeContext;
import com.intellij.docker.runtimes.DockerRuntimeDetailsProvider;
import com.intellij.docker.ui.scaffold.Scaffold;
import com.intellij.docker.ui.scaffold.ScaffoldKt;
import com.intellij.docker.view.details.DockerAbstractDashboardTabKt;
import com.intellij.docker.view.details.network.DockerNetworkRuntimeDetailsProvider;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.SimpleTextAttributes;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0014J\u0015\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0010\u00a2\u0006\u0002\b\u001fR\u0014\u0010\t\u001a\u00020\nX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000f\u00a8\u0006!"}, d2={"Lcom/intellij/docker/runtimes/DockerNetworkRuntimeImpl;", "Lcom/intellij/docker/runtimes/DockerNetworkRuntime;", "context", "Lcom/intellij/docker/runtimes/DockerRuntimeContext;", "agentApplication", "Lcom/intellij/docker/agent/DockerAgentNetwork;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/docker/runtimes/DockerRuntimeContext;Lcom/intellij/docker/agent/DockerAgentNetwork;Lcom/intellij/openapi/project/Project;)V", "detailsProvider", "Lcom/intellij/docker/runtimes/DockerRuntimeDetailsProvider;", "getDetailsProvider$intellij_clouds_docker", "()Lcom/intellij/docker/runtimes/DockerRuntimeDetailsProvider;", "isPredefined", "", "()Z", "connectContainer", "Ljava/util/concurrent/CompletableFuture;", "", "containerId", "", "config", "Lcom/github/dockerjava/api/model/ContainerNetwork;", "deleteNetwork", "disconnectContainer", "doGetStatus", "Lcom/intellij/docker/DockerStatus;", "getHeaderComponent", "Lcom/intellij/docker/ui/scaffold/Scaffold$SimpleSegment;", "scaffold", "Lcom/intellij/docker/ui/scaffold/Scaffold;", "getHeaderComponent$intellij_clouds_docker", "Companion", "intellij.clouds.docker"})
public final class DockerNetworkRuntimeImpl
extends DockerNetworkRuntime {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DockerRuntimeDetailsProvider detailsProvider;
    private final boolean isPredefined;
    @NotNull
    private static final DockerStatus STATUS;
    @NlsSafe
    @NotNull
    private static final String HOST = "host";
    @NlsSafe
    @NotNull
    private static final String BRIDGE = "bridge";
    @NlsSafe
    @NotNull
    private static final String NONE = "none";

    public DockerNetworkRuntimeImpl(@NotNull DockerRuntimeContext context, @NotNull DockerAgentNetwork agentApplication, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)agentApplication, (String)"agentApplication");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(context, agentApplication, project);
        this.detailsProvider = new DockerNetworkRuntimeDetailsProvider(this);
        Object[] objectArray = new String[]{HOST, BRIDGE, NONE};
        this.isPredefined = CollectionsKt.arrayListOf((Object[])objectArray).contains(agentApplication.getNetwork().getName());
    }

    @Override
    @NotNull
    public DockerRuntimeDetailsProvider getDetailsProvider$intellij_clouds_docker() {
        return this.detailsProvider;
    }

    @Override
    @NotNull
    protected DockerStatus doGetStatus() {
        return STATUS;
    }

    @Override
    @NotNull
    public Scaffold.SimpleSegment getHeaderComponent$intellij_clouds_docker(@NotNull Scaffold scaffold) {
        Intrinsics.checkNotNullParameter((Object)scaffold, (String)"scaffold");
        DockerNetworkRuntimeImpl runtime2 = this;
        Scaffold $this$getHeaderComponent_u24lambda_u240 = scaffold;
        boolean bl = false;
        return $this$getHeaderComponent_u24lambda_u240.segment((Function1<? super Scaffold.SimpleSegment, Unit>)((Function1)new Function1<Scaffold.SimpleSegment, Unit>(runtime2){
            final /* synthetic */ DockerNetworkRuntimeImpl $runtime;
            {
                this.$runtime = $runtime;
                super(1);
            }

            public final void invoke(@NotNull Scaffold.SimpleSegment $this$segment) {
                Intrinsics.checkNotNullParameter((Object)$this$segment, (String)"$this$segment");
                $this$segment.textFragment((Function1<? super Scaffold.SimpleSegment.TextFragment, Unit>)((Function1)new Function1<Scaffold.SimpleSegment.TextFragment, Unit>(this.$runtime){
                    final /* synthetic */ DockerNetworkRuntimeImpl $runtime;
                    {
                        this.$runtime = $runtime;
                        super(1);
                    }

                    public final void invoke(@NotNull Scaffold.SimpleSegment.TextFragment $this$textFragment) {
                        Intrinsics.checkNotNullParameter((Object)$this$textFragment, (String)"$this$textFragment");
                        $this$textFragment.setIcon(DockerIcons.Network);
                        $this$textFragment.append(this.$runtime.getNetwork().getName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                        String string = this.$runtime.getNetwork().getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                        $this$textFragment.append(" " + DockerAbstractDashboardTabKt.shortenDockerId(string), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        $this$textFragment.setToolTipText(DockerNetworkRuntimeImplKt.access$getTooltipText(this.$runtime.getNetwork()));
                    }
                }));
                $this$segment.textFragment((Function1<? super Scaffold.SimpleSegment.TextFragment, Unit>)((Function1)new Function1<Scaffold.SimpleSegment.TextFragment, Unit>(this.$runtime){
                    final /* synthetic */ DockerNetworkRuntimeImpl $runtime;
                    {
                        this.$runtime = $runtime;
                        super(1);
                    }

                    public final void invoke(@NotNull Scaffold.SimpleSegment.TextFragment $this$textFragment) {
                        Intrinsics.checkNotNullParameter((Object)$this$textFragment, (String)"$this$textFragment");
                        Boolean bl = this.$runtime.getNetwork().getEnableIPv6();
                        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getEnableIPv6(...)");
                        if (bl.booleanValue()) {
                            $this$textFragment.setIcon(AllIcons.Actions.Commit);
                            $this$textFragment.append(DockerBundle.message("DockerNetworkDetails.NetworkPropertiesEditor.property.ipv6.enabled", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        } else {
                            $this$textFragment.setIcon(AllIcons.Actions.CloseHovered);
                            $this$textFragment.append(DockerBundle.message("DockerNetworkDetails.DockerNetworkDashboardTab.ipv6.disabled", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        }
                        $this$textFragment.setToolTipText(DockerNetworkRuntimeImplKt.access$getTooltipText(this.$runtime.getNetwork()));
                    }
                }));
                ScaffoldKt.button$default($this$segment, null, null, "Docker.RemoteServers.InspectContainerOrImage", null, 11, null);
                if (!this.$runtime.isPredefined()) {
                    ScaffoldKt.button$default($this$segment, AllIcons.Actions.GC, DockerBundle.message("DockerAbstractDashboardTab.action.remove.hint", new Object[0]), "Docker.RemoteServers.DeleteNetwork", null, 8, null);
                }
            }
        }));
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> deleteNetwork() {
        if (this.isPredefined()) {
            CompletableFuture<Unit> completableFuture = CompletableFuture.failedFuture(new IllegalStateException("Pre-defined network cannot be removed"));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"failedFuture(...)");
            return completableFuture;
        }
        return this.runStatusTransition(DockerTransitionStatus.DELETING, this.getAgentApplication().deleteNetwork());
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> connectContainer(@NotNull String containerId, @Nullable ContainerNetwork config2) {
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        return this.getAgentApplication().connectContainer(containerId, config2);
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> disconnectContainer(@NotNull String containerId) {
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        return this.getAgentApplication().disconnectContainer(containerId);
    }

    @Override
    public boolean isPredefined() {
        return this.isPredefined;
    }

    private static final String STATUS$lambda$1() {
        return "";
    }

    static {
        Icon icon = DockerIcons.Network;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Network");
        STATUS = DockerStatus.Companion.create(icon, DockerNetworkRuntimeImpl::STATUS$lambda$1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/docker/runtimes/DockerNetworkRuntimeImpl$Companion;", "", "()V", "BRIDGE", "", "HOST", "NONE", "STATUS", "Lcom/intellij/docker/DockerStatus;", "intellij.clouds.docker"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

