/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.target;

import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.cli.AsyncCliProcess;
import com.intellij.docker.agent.cli.Cli;
import com.intellij.docker.agent.cli.DockerCli;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remote.run.target.DockerDownloadVolumeBase;
import com.intellij.docker.remote.run.target.DockerVolumeBase;
import com.intellij.docker.remote.run.target.MovingFileVisitor;
import com.intellij.docker.remoteRunRuntime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u0000 \u00112\u00020\u00012\u00020\u0002:\u0001\u0011B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H$R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/intellij/docker/remote/run/target/DockerDownloadVolumeBase;", "Lcom/intellij/docker/remote/run/target/DockerVolumeBase;", "Lcom/intellij/execution/target/TargetEnvironment$DownloadableVolume;", "localRoot", "Ljava/nio/file/Path;", "targetRoot", "", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "getLocalRoot", "()Ljava/nio/file/Path;", "download", "", "relativePath", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getContainerToCopyFrom", "Lcom/intellij/docker/remoteRunRuntime/RemoteDockerApplicationRuntime;", "Companion", "intellij.clouds.docker.remoteRun"})
@SourceDebugExtension(value={"SMAP\ndockerTargetVolumes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 dockerTargetVolumes.kt\ncom/intellij/docker/remote/run/target/DockerDownloadVolumeBase\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,148:1\n58#2,5:149\n58#2,5:155\n1#3:154\n*S KotlinDebug\n*F\n+ 1 dockerTargetVolumes.kt\ncom/intellij/docker/remote/run/target/DockerDownloadVolumeBase\n*L\n79#1:149,5\n114#1:155,5\n*E\n"})
public abstract class DockerDownloadVolumeBase
extends DockerVolumeBase
implements TargetEnvironment.DownloadableVolume {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path localRoot;
    @NotNull
    private static final Lazy<Logger> LOG$delegate = LazyKt.lazy((Function0)Companion.LOG.2.INSTANCE);

    public DockerDownloadVolumeBase(@NotNull Path localRoot, @NotNull String targetRoot) {
        Intrinsics.checkNotNullParameter((Object)localRoot, (String)"localRoot");
        Intrinsics.checkNotNullParameter((Object)targetRoot, (String)"targetRoot");
        super(targetRoot);
        this.localRoot = localRoot;
    }

    @NotNull
    public Path getLocalRoot() {
        return this.localRoot;
    }

    public void download(@NotNull String relativePath, @NotNull ProgressIndicator progressIndicator) throws IOException {
        Object $i$f$debug2;
        Logger logger2;
        String string;
        RemoteDockerApplicationRuntime container;
        block15: {
            block14: {
                Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
                Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
                container = this.getContainerToCopyFrom();
                string = container.getContainerId();
                if (string == null) break block14;
                String string2 = string.substring(0, 10);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                string = string2;
                if (string2 != null) break block15;
            }
            throw new IOException("Cannot find container id in the environment");
        }
        String shortId = string;
        Object object = container.getDockerRuntime();
        if (object == null || (object = ((RemoteDockerRuntime)object).getDockerCommunicator()) == null) {
            throw new IOException("Cannot create CLI communicator");
        }
        Object cli = object;
        Pair pair = Intrinsics.areEqual((Object)relativePath, (Object)".") || StringsKt.endsWith$default((CharSequence)relativePath, (char)'/', (boolean)false, (int)2, null) ? TuplesKt.to(null, (Object)(this.resolveTargetPath(relativePath) + "/.")) : TuplesKt.to((Object)FileUtil.createTempDirectory((String)"docker_download_volume", null, (boolean)true), (Object)this.resolveTargetPath(relativePath));
        File tempDestDir = (File)pair.component1();
        String containerSrc = (String)pair.component2();
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(this.getLocalRoot(), Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        Path localDest = this.getLocalRoot().resolve(FileUtilRt.toSystemDependentName((String)relativePath)).toAbsolutePath();
        Object[] objectArray = new String[3];
        objectArray[0] = "cp";
        objectArray[1] = shortId + ":" + containerSrc;
        File file2 = tempDestDir;
        objectArray[2] = String.valueOf(file2 != null ? (Comparable)file2 : (Comparable)localDest);
        List args = CollectionsKt.listOf((Object[])objectArray);
        String fullCommand = "docker " + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        Object[] objectArray2 = new Object[]{fullCommand};
        String string3 = DockerBundle.message("DockerDownloadVolume.progress.message.executing.command", objectArray2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        String message = string3;
        progressIndicator.setText2(message);
        Logger logger3 = DockerDownloadVolumeBase.Companion.getLOG();
        Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"access$getLOG(...)");
        Logger $this$debug_u24default$iv = logger3;
        Throwable e$iv = null;
        boolean $i$f$debug2 = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger2 = $this$debug_u24default$iv;
            boolean bl = false;
            logger2.debug(message, e$iv);
        }
        List errors = new ArrayList();
        try {
            $i$f$debug2 = (AsyncCliProcess)CoroutinesKt.indicatorRunBlockingCancellable((ProgressIndicator)progressIndicator, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super AsyncCliProcess<Unit>>, Object>((DockerCli)cli, (List<String>)args, (List<String>)errors, progressIndicator, null){
                int label;
                final /* synthetic */ DockerCli $cli;
                final /* synthetic */ List<String> $args;
                final /* synthetic */ List<String> $errors;
                final /* synthetic */ ProgressIndicator $progressIndicator;
                {
                    this.$cli = $cli;
                    this.$args = $args;
                    this.$errors = $errors;
                    this.$progressIndicator = $progressIndicator;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = Cli.execAsync$default(this.$cli, this.$args, null, (Function1)new Function1<String, Unit>(this.$errors){
                                final /* synthetic */ List<String> $errors;
                                {
                                    this.$errors = $errors;
                                    super(1);
                                }

                                public final void invoke(@NotNull String err) {
                                    Intrinsics.checkNotNullParameter((Object)err, (String)"err");
                                    if (!StringsKt.isBlank((CharSequence)err)) {
                                        Logger logger2 = com.intellij.docker.remote.run.target.DockerDownloadVolumeBase$Companion.access$getLOG(DockerDownloadVolumeBase.Companion);
                                        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"access$getLOG(...)");
                                        Logger $this$debug_u24default$iv = logger2;
                                        Throwable e$iv = null;
                                        boolean $i$f$debug = false;
                                        if ($this$debug_u24default$iv.isDebugEnabled()) {
                                            Logger logger3 = $this$debug_u24default$iv;
                                            boolean bl = false;
                                            logger3.debug("\terror recorded: " + err, e$iv);
                                        }
                                        this.$errors.add(err);
                                    }
                                }
                            }, (Function1)new Function1<String, Unit>(this.$errors, this.$progressIndicator){
                                final /* synthetic */ List<String> $errors;
                                final /* synthetic */ ProgressIndicator $progressIndicator;
                                {
                                    this.$errors = $errors;
                                    this.$progressIndicator = $progressIndicator;
                                    super(1);
                                }

                                public final void invoke(@NotNull String out) {
                                    Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                                    if (!StringsKt.isBlank((CharSequence)out)) {
                                        Logger logger2 = com.intellij.docker.remote.run.target.DockerDownloadVolumeBase$Companion.access$getLOG(DockerDownloadVolumeBase.Companion);
                                        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"access$getLOG(...)");
                                        Logger $this$debug_u24default$iv = logger2;
                                        Throwable e$iv = null;
                                        boolean $i$f$debug = false;
                                        if ($this$debug_u24default$iv.isDebugEnabled()) {
                                            Logger logger3 = $this$debug_u24default$iv;
                                            boolean bl = false;
                                            logger3.debug("\toutput recorded: " + out, e$iv);
                                        }
                                        if (StringsKt.startsWith$default((String)out, (String)"Error", (boolean)false, (int)2, null)) {
                                            this.$errors.add(out);
                                        }
                                        this.$progressIndicator.checkCanceled();
                                        this.$progressIndicator.setText2(out);
                                    }
                                }
                            }, null, null, null, null, (Continuation)this, 242, null);
                            if (object3 != object2) return object3;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super AsyncCliProcess<Unit>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
        catch (ApiTaskException ex) {
            throw new IOException(ex);
        }
        AsyncCliProcess process2 = $i$f$debug2;
        CoroutinesKt.indicatorRunBlockingCancellable((ProgressIndicator)progressIndicator, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((AsyncCliProcess<Unit>)process2, null){
            int label;
            final /* synthetic */ AsyncCliProcess<Unit> $process;
            {
                this.$process = $process;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$process.await((Continuation<Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        $i$f$debug2 = (String)CollectionsKt.firstOrNull((List)errors);
        if ($i$f$debug2 != null) {
            Object it = $i$f$debug2;
            boolean bl = false;
            throw new IOException((String)it);
        }
        Logger logger4 = DockerDownloadVolumeBase.Companion.getLOG();
        Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"access$getLOG(...)");
        Logger $this$debug_u24default$iv2 = logger4;
        Throwable e$iv2 = null;
        boolean $i$f$debug3 = false;
        if ($this$debug_u24default$iv2.isDebugEnabled()) {
            logger2 = $this$debug_u24default$iv2;
            boolean bl = false;
            logger2.debug("Completed: " + message, e$iv2);
        }
        if (tempDestDir != null) {
            String string4 = PathUtil.getFileName((String)containerSrc);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getFileName(...)");
            String fileName = string4;
            File copiedFileOrDir = new File(tempDestDir, fileName);
            if (copiedFileOrDir.isDirectory()) {
                Path path = copiedFileOrDir.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                Intrinsics.checkNotNull((Object)localDest);
                DockerDownloadVolumeBase.Companion.moveDirectory(path, localDest);
            } else {
                File file3 = localDest.toFile().getParentFile();
                if (file3 != null) {
                    File parentDir = file3;
                    boolean bl = false;
                    if (!parentDir.exists() && !parentDir.mkdirs()) {
                        throw new IOException("Cannot create directory " + parentDir.getPath());
                    }
                }
                Path path = copiedFileOrDir.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                Path path2 = path;
                Intrinsics.checkNotNull((Object)localDest);
                Path path3 = localDest;
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                CopyOption[] copyOptionArray2 = copyOptionArray;
                Intrinsics.checkNotNullExpressionValue((Object)Files.move(path2, path3, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length)), (String)"move(...)");
            }
        }
    }

    @NotNull
    protected abstract RemoteDockerApplicationRuntime getContainerToCopyFrom() throws IOException;

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002R \u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/intellij/docker/remote/run/target/DockerDownloadVolumeBase$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "LOG$delegate", "Lkotlin/Lazy;", "moveDirectory", "", "Ljava/nio/file/Path;", "target", "intellij.clouds.docker.remoteRun"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLOG() {
            Lazy lazy = LOG$delegate;
            return (Logger)lazy.getValue();
        }

        private final void moveDirectory(Path $this$moveDirectory, Path target2) {
            Files.walkFileTree($this$moveDirectory, new MovingFileVisitor($this$moveDirectory, target2));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

