/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.dockerFile;

import com.intellij.docker.dockerFile.DockerFileContextFolderDetectorKt;
import com.intellij.docker.dockerFile.DockerFileCopyCommandUtilsKt;
import com.intellij.docker.dockerFile.DockerPsiFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.BaseProjectDirectories;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t\u001a*\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0007\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u000f"}, d2={"logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "logger$delegate", "Lkotlin/Lazy;", "detectContextFolderForDockerfile", "", "dockerFile", "Lcom/intellij/docker/dockerFile/DockerPsiFile;", "fs", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "baseDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "virtualFile", "intellij.clouds.docker.file"})
public final class DockerFileContextFolderDetectorKt {
    @NotNull
    private static final Lazy logger$delegate = LazyKt.lazy((Function0)logger.2.INSTANCE);

    private static final Logger getLogger() {
        Lazy lazy = logger$delegate;
        return (Logger)lazy.getValue();
    }

    @Nullable
    public static final String detectContextFolderForDockerfile(@NotNull DockerPsiFile dockerFile) {
        Intrinsics.checkNotNullParameter((Object)((Object)dockerFile), (String)"dockerFile");
        VirtualFile virtualFile2 = dockerFile.getVirtualFile();
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile virtualFile3 = virtualFile2;
        Project project = dockerFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        VirtualFile virtualFile4 = BaseProjectDirectories.Companion.getInstance(project).getBaseDirectoryFor(virtualFile3);
        if (virtualFile4 == null) {
            return null;
        }
        VirtualFile baseDirectory = virtualFile4;
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
        return DockerFileContextFolderDetectorKt.detectContextFolderForDockerfile((VirtualFileSystem)localFileSystem, baseDirectory, virtualFile3, dockerFile);
    }

    @TestOnly
    @Nullable
    public static final String detectContextFolderForDockerfile(@NotNull VirtualFileSystem fs, @NotNull VirtualFile baseDirectory, @NotNull VirtualFile virtualFile2, @NotNull DockerPsiFile dockerFile) {
        Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
        Intrinsics.checkNotNullParameter((Object)baseDirectory, (String)"baseDirectory");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)((Object)dockerFile), (String)"dockerFile");
        int maxFilesToTraverse = 50;
        List<String> pathsToTraverse = DockerFileCopyCommandUtilsKt.localCopySourcePaths(dockerFile);
        if (pathsToTraverse.isEmpty()) {
            return null;
        }
        boolean isDefaultContextPath = true;
        int filesTraversed = 0;
        for (VirtualFile contextPath = virtualFile2.getParent(); contextPath != null && FileUtil.isAncestor((String)baseDirectory.getPath(), (String)contextPath.getPath(), (boolean)false); contextPath = contextPath.getParent()) {
            for (String path : pathsToTraverse) {
                ProgressManager.checkCanceled();
                if (FileUtil.isAbsolute((String)path)) continue;
                if (maxFilesToTraverse <= filesTraversed++) {
                    DockerFileContextFolderDetectorKt.getLogger().info("Traversed " + filesTraversed + " files while checking Dockerfile " + virtualFile2.getPath() + ", exiting");
                    return null;
                }
                String[] stringArray = new String[]{contextPath.getPath(), path};
                VirtualFile localFile = fs.findFileByPath(FileUtil.join((String[])stringArray));
                if (localFile == null || !localFile.exists() || localFile.isDirectory()) continue;
                DockerFileContextFolderDetectorKt.getLogger().info("Detected context path " + contextPath.getPath() + " for Dockerfile " + virtualFile2.getPath());
                return isDefaultContextPath ? null : contextPath.getPath();
            }
            isDefaultContextPath = false;
        }
        return null;
    }
}

