/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.events;

import com.github.dockerjava.api.model.Event;
import com.github.dockerjava.api.model.EventActor;
import com.github.dockerjava.api.model.EventType;
import com.intellij.docker.agent.DockerAgentContainer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.hc.core5.annotation.Internal;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 \u00062\u00020\u0001:\u0007\u0006\u0007\b\t\n\u000b\fR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0005\r\u000e\u000f\u0010\u0011\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0012\u00c0\u0006\u0001"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent;", "", "elementId", "", "getElementId", "()Ljava/lang/String;", "Companion", "Container", "Image", "Listener", "Network", "Unknown", "Volume", "Lcom/intellij/docker/agent/events/DockerEvent$Container;", "Lcom/intellij/docker/agent/events/DockerEvent$Image;", "Lcom/intellij/docker/agent/events/DockerEvent$Network;", "Lcom/intellij/docker/agent/events/DockerEvent$Unknown;", "Lcom/intellij/docker/agent/events/DockerEvent$Volume;", "intellij.clouds.docker.agent"})
public interface DockerEvent {
    @NotNull
    public static final Companion Companion = com.intellij.docker.agent.events.DockerEvent$Companion.$$INSTANCE;

    @NotNull
    public String getElementId();

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u000f"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "elementId", "", "Lcom/github/dockerjava/api/model/Event;", "getElementId", "(Lcom/github/dockerjava/api/model/Event;)Ljava/lang/String;", "eventAction", "getEventAction", "createFrom", "Lcom/intellij/docker/agent/events/DockerEvent;", "event", "intellij.clouds.docker.agent"})
    @SourceDebugExtension(value={"SMAP\nDockerEvent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerEvent.kt\ncom/intellij/docker/agent/events/DockerEvent$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logging.kt\ncom/intellij/docker/agent/util/LoggingKt\n*L\n1#1,152:1\n1#2:153\n7#3:154\n*S KotlinDebug\n*F\n+ 1 DockerEvent.kt\ncom/intellij/docker/agent/events/DockerEvent$Companion\n*L\n130#1:154\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final Logger logger;

        private Companion() {
        }

        private final String getElementId(Event $this$elementId) {
            String string = $this$elementId.getId();
            if (string == null) {
                EventActor eventActor = $this$elementId.getActor();
                string = eventActor != null ? eventActor.getId() : null;
                if (string == null) {
                    String string2;
                    String it = string2 = "unknownId";
                    boolean bl = false;
                    logger.warn("Event without id or actor id: {}", (Object)$this$elementId);
                    string = string2;
                }
            }
            return string;
        }

        private final String getEventAction(Event $this$eventAction) {
            String string = $this$eventAction.getStatus();
            if (string == null && (string = $this$eventAction.getAction()) == null) {
                String string2;
                String it = string2 = "unknownAction";
                boolean bl = false;
                logger.warn("Event without action or status: {}", (Object)$this$eventAction);
                string = string2;
            }
            return string;
        }

        @NotNull
        public final DockerEvent createFrom(@NotNull Event event) {
            EventType type;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            EventType eventType = type = event.getType();
            return switch (eventType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[eventType.ordinal()]) {
                case 1 -> Network.Companion.createFrom(event);
                case 2 -> Container.Companion.createFrom(event);
                case 3 -> Image.Companion.createFrom(event);
                case 4 -> Volume.Companion.createFrom(event);
                default -> new Unknown(this.getElementId(event), type);
            };
        }

        static {
            $$INSTANCE = new Companion();
            boolean $i$f$logger = false;
            Logger logger2 = LoggerFactory.getLogger(DockerEvent.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
            logger = logger2;
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[EventType.values().length];
                try {
                    nArray[EventType.NETWORK.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EventType.CONTAINER.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EventType.IMAGE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EventType.VOLUME.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 \u00022\u00020\u0001:\u0010\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0082\u0001\u000f\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f \u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006!\u00c0\u0006\u0001"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Container;", "Lcom/intellij/docker/agent/events/DockerEvent;", "Companion", "Create", "Destroy", "Die", "Healthy", "Kill", "Pause", "Restart", "Start", "Stop", "Unhealthy", "Unknown", "Unpause", "UpdateFailed", "Updated", "Updating", "Lcom/intellij/docker/agent/events/DockerEvent$Container$Create;", "Lcom/intellij/docker/agent/events/DockerEvent$Container$Destroy;", "Lcom/intellij/docker/agent/events/DockerEvent$Container$Die;", "Lcom/intellij/docker/agent/events/DockerEvent$Container$Healthy;", "Lcom/intellij/docker/agent/events/DockerEvent$Container$Kill;", "Lcom/intellij/docker/agent/events/DockerEvent$Container$Pause;", "Lcom/intellij/docker/agent/events/DockerEvent$Container$Restart;", "Lcom/intellij/docker/agent/events/DockerEvent$Container$Start;", "Lcom/intellij/docker/agent/events/DockerEvent$Container$Stop;", "Lcom/intellij/docker/agent/events/DockerEvent$Container$Unhealthy;", "Lcom/intellij/docker/agent/events/DockerEvent$Container$Unknown;", "Lcom/intellij/docker/agent/events/DockerEvent$Container$Unpause;", "Lcom/intellij/docker/agent/events/DockerEvent$Container$UpdateFailed;", "Lcom/intellij/docker/agent/events/DockerEvent$Container$Updated;", "Lcom/intellij/docker/agent/events/DockerEvent$Container$Updating;", "intellij.clouds.docker.agent"})
    public static interface Container
    extends DockerEvent {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Container$Companion;", "", "()V", "createFrom", "Lcom/intellij/docker/agent/events/DockerEvent$Container;", "event", "Lcom/github/dockerjava/api/model/Event;", "intellij.clouds.docker.agent"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Container createFrom(@NotNull Event event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                return switch (DockerEvent.Companion.getEventAction(event)) {
                    case "start" -> new Start(DockerEvent.Companion.getElementId(event));
                    case "stop" -> new Stop(DockerEvent.Companion.getElementId(event));
                    case "die" -> new Die(DockerEvent.Companion.getElementId(event));
                    case "kill" -> new Kill(DockerEvent.Companion.getElementId(event));
                    case "create" -> new Create(DockerEvent.Companion.getElementId(event));
                    case "health_status: healthy" -> new Healthy(DockerEvent.Companion.getElementId(event));
                    case "health_status: unhealthy" -> new Unhealthy(DockerEvent.Companion.getElementId(event));
                    case "unpause" -> new Unpause(DockerEvent.Companion.getElementId(event));
                    case "pause" -> new Pause(DockerEvent.Companion.getElementId(event));
                    case "destroy", "remove" -> new Destroy(DockerEvent.Companion.getElementId(event));
                    default -> {
                        String action;
                        yield new Unknown(DockerEvent.Companion.getElementId(event), action);
                    }
                };
            }

            static {
                $$INSTANCE = new Companion();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Container$Create;", "Lcom/intellij/docker/agent/events/DockerEvent$Container;", "elementId", "", "(Ljava/lang/String;)V", "getElementId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
        public static final class Create
        implements Container {
            @NotNull
            private final String elementId;

            public Create(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                this.elementId = elementId;
            }

            @Override
            @NotNull
            public String getElementId() {
                return this.elementId;
            }

            @NotNull
            public final String component1() {
                return this.elementId;
            }

            @NotNull
            public final Create copy(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                return new Create(elementId);
            }

            public static /* synthetic */ Create copy$default(Create create2, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = create2.elementId;
                }
                return create2.copy(string);
            }

            @NotNull
            public String toString() {
                return "Create(elementId=" + this.elementId + ")";
            }

            public int hashCode() {
                return this.elementId.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Create)) {
                    return false;
                }
                Create create2 = (Create)other;
                return Intrinsics.areEqual((Object)this.elementId, (Object)create2.elementId);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Container$Destroy;", "Lcom/intellij/docker/agent/events/DockerEvent$Container;", "elementId", "", "(Ljava/lang/String;)V", "getElementId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
        public static final class Destroy
        implements Container {
            @NotNull
            private final String elementId;

            public Destroy(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                this.elementId = elementId;
            }

            @Override
            @NotNull
            public String getElementId() {
                return this.elementId;
            }

            @NotNull
            public final String component1() {
                return this.elementId;
            }

            @NotNull
            public final Destroy copy(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                return new Destroy(elementId);
            }

            public static /* synthetic */ Destroy copy$default(Destroy destroy, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = destroy.elementId;
                }
                return destroy.copy(string);
            }

            @NotNull
            public String toString() {
                return "Destroy(elementId=" + this.elementId + ")";
            }

            public int hashCode() {
                return this.elementId.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Destroy)) {
                    return false;
                }
                Destroy destroy = (Destroy)other;
                return Intrinsics.areEqual((Object)this.elementId, (Object)destroy.elementId);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Container$Die;", "Lcom/intellij/docker/agent/events/DockerEvent$Container;", "elementId", "", "(Ljava/lang/String;)V", "getElementId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
        public static final class Die
        implements Container {
            @NotNull
            private final String elementId;

            public Die(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                this.elementId = elementId;
            }

            @Override
            @NotNull
            public String getElementId() {
                return this.elementId;
            }

            @NotNull
            public final String component1() {
                return this.elementId;
            }

            @NotNull
            public final Die copy(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                return new Die(elementId);
            }

            public static /* synthetic */ Die copy$default(Die die, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = die.elementId;
                }
                return die.copy(string);
            }

            @NotNull
            public String toString() {
                return "Die(elementId=" + this.elementId + ")";
            }

            public int hashCode() {
                return this.elementId.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Die)) {
                    return false;
                }
                Die die = (Die)other;
                return Intrinsics.areEqual((Object)this.elementId, (Object)die.elementId);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Container$Healthy;", "Lcom/intellij/docker/agent/events/DockerEvent$Container;", "elementId", "", "(Ljava/lang/String;)V", "getElementId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
        public static final class Healthy
        implements Container {
            @NotNull
            private final String elementId;

            public Healthy(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                this.elementId = elementId;
            }

            @Override
            @NotNull
            public String getElementId() {
                return this.elementId;
            }

            @NotNull
            public final String component1() {
                return this.elementId;
            }

            @NotNull
            public final Healthy copy(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                return new Healthy(elementId);
            }

            public static /* synthetic */ Healthy copy$default(Healthy healthy, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = healthy.elementId;
                }
                return healthy.copy(string);
            }

            @NotNull
            public String toString() {
                return "Healthy(elementId=" + this.elementId + ")";
            }

            public int hashCode() {
                return this.elementId.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Healthy)) {
                    return false;
                }
                Healthy healthy = (Healthy)other;
                return Intrinsics.areEqual((Object)this.elementId, (Object)healthy.elementId);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Container$Kill;", "Lcom/intellij/docker/agent/events/DockerEvent$Container;", "elementId", "", "(Ljava/lang/String;)V", "getElementId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
        public static final class Kill
        implements Container {
            @NotNull
            private final String elementId;

            public Kill(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                this.elementId = elementId;
            }

            @Override
            @NotNull
            public String getElementId() {
                return this.elementId;
            }

            @NotNull
            public final String component1() {
                return this.elementId;
            }

            @NotNull
            public final Kill copy(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                return new Kill(elementId);
            }

            public static /* synthetic */ Kill copy$default(Kill kill, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = kill.elementId;
                }
                return kill.copy(string);
            }

            @NotNull
            public String toString() {
                return "Kill(elementId=" + this.elementId + ")";
            }

            public int hashCode() {
                return this.elementId.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Kill)) {
                    return false;
                }
                Kill kill = (Kill)other;
                return Intrinsics.areEqual((Object)this.elementId, (Object)kill.elementId);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Container$Pause;", "Lcom/intellij/docker/agent/events/DockerEvent$Container;", "elementId", "", "(Ljava/lang/String;)V", "getElementId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
        public static final class Pause
        implements Container {
            @NotNull
            private final String elementId;

            public Pause(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                this.elementId = elementId;
            }

            @Override
            @NotNull
            public String getElementId() {
                return this.elementId;
            }

            @NotNull
            public final String component1() {
                return this.elementId;
            }

            @NotNull
            public final Pause copy(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                return new Pause(elementId);
            }

            public static /* synthetic */ Pause copy$default(Pause pause, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = pause.elementId;
                }
                return pause.copy(string);
            }

            @NotNull
            public String toString() {
                return "Pause(elementId=" + this.elementId + ")";
            }

            public int hashCode() {
                return this.elementId.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Pause)) {
                    return false;
                }
                Pause pause = (Pause)other;
                return Intrinsics.areEqual((Object)this.elementId, (Object)pause.elementId);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Container$Restart;", "Lcom/intellij/docker/agent/events/DockerEvent$Container;", "elementId", "", "(Ljava/lang/String;)V", "getElementId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
        public static final class Restart
        implements Container {
            @NotNull
            private final String elementId;

            public Restart(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                this.elementId = elementId;
            }

            @Override
            @NotNull
            public String getElementId() {
                return this.elementId;
            }

            @NotNull
            public final String component1() {
                return this.elementId;
            }

            @NotNull
            public final Restart copy(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                return new Restart(elementId);
            }

            public static /* synthetic */ Restart copy$default(Restart restart2, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = restart2.elementId;
                }
                return restart2.copy(string);
            }

            @NotNull
            public String toString() {
                return "Restart(elementId=" + this.elementId + ")";
            }

            public int hashCode() {
                return this.elementId.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Restart)) {
                    return false;
                }
                Restart restart2 = (Restart)other;
                return Intrinsics.areEqual((Object)this.elementId, (Object)restart2.elementId);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Container$Start;", "Lcom/intellij/docker/agent/events/DockerEvent$Container;", "elementId", "", "(Ljava/lang/String;)V", "getElementId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
        public static final class Start
        implements Container {
            @NotNull
            private final String elementId;

            public Start(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                this.elementId = elementId;
            }

            @Override
            @NotNull
            public String getElementId() {
                return this.elementId;
            }

            @NotNull
            public final String component1() {
                return this.elementId;
            }

            @NotNull
            public final Start copy(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                return new Start(elementId);
            }

            public static /* synthetic */ Start copy$default(Start start2, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = start2.elementId;
                }
                return start2.copy(string);
            }

            @NotNull
            public String toString() {
                return "Start(elementId=" + this.elementId + ")";
            }

            public int hashCode() {
                return this.elementId.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Start)) {
                    return false;
                }
                Start start2 = (Start)other;
                return Intrinsics.areEqual((Object)this.elementId, (Object)start2.elementId);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Container$Stop;", "Lcom/intellij/docker/agent/events/DockerEvent$Container;", "elementId", "", "(Ljava/lang/String;)V", "getElementId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
        public static final class Stop
        implements Container {
            @NotNull
            private final String elementId;

            public Stop(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                this.elementId = elementId;
            }

            @Override
            @NotNull
            public String getElementId() {
                return this.elementId;
            }

            @NotNull
            public final String component1() {
                return this.elementId;
            }

            @NotNull
            public final Stop copy(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                return new Stop(elementId);
            }

            public static /* synthetic */ Stop copy$default(Stop stop, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = stop.elementId;
                }
                return stop.copy(string);
            }

            @NotNull
            public String toString() {
                return "Stop(elementId=" + this.elementId + ")";
            }

            public int hashCode() {
                return this.elementId.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Stop)) {
                    return false;
                }
                Stop stop = (Stop)other;
                return Intrinsics.areEqual((Object)this.elementId, (Object)stop.elementId);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Container$Unhealthy;", "Lcom/intellij/docker/agent/events/DockerEvent$Container;", "elementId", "", "(Ljava/lang/String;)V", "getElementId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
        public static final class Unhealthy
        implements Container {
            @NotNull
            private final String elementId;

            public Unhealthy(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                this.elementId = elementId;
            }

            @Override
            @NotNull
            public String getElementId() {
                return this.elementId;
            }

            @NotNull
            public final String component1() {
                return this.elementId;
            }

            @NotNull
            public final Unhealthy copy(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                return new Unhealthy(elementId);
            }

            public static /* synthetic */ Unhealthy copy$default(Unhealthy unhealthy, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = unhealthy.elementId;
                }
                return unhealthy.copy(string);
            }

            @NotNull
            public String toString() {
                return "Unhealthy(elementId=" + this.elementId + ")";
            }

            public int hashCode() {
                return this.elementId.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Unhealthy)) {
                    return false;
                }
                Unhealthy unhealthy = (Unhealthy)other;
                return Intrinsics.areEqual((Object)this.elementId, (Object)unhealthy.elementId);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Container$Unknown;", "Lcom/intellij/docker/agent/events/DockerEvent$Container;", "elementId", "", "action", "(Ljava/lang/String;Ljava/lang/String;)V", "getAction", "()Ljava/lang/String;", "getElementId", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
        public static final class Unknown
        implements Container {
            @NotNull
            private final String elementId;
            @NotNull
            private final String action;

            public Unknown(@NotNull String elementId, @NotNull String action2) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                this.elementId = elementId;
                this.action = action2;
            }

            @Override
            @NotNull
            public String getElementId() {
                return this.elementId;
            }

            @NotNull
            public final String getAction() {
                return this.action;
            }

            @NotNull
            public final String component1() {
                return this.elementId;
            }

            @NotNull
            public final String component2() {
                return this.action;
            }

            @NotNull
            public final Unknown copy(@NotNull String elementId, @NotNull String action2) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                return new Unknown(elementId, action2);
            }

            public static /* synthetic */ Unknown copy$default(Unknown unknown, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = unknown.elementId;
                }
                if ((n & 2) != 0) {
                    string2 = unknown.action;
                }
                return unknown.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "Unknown(elementId=" + this.elementId + ", action=" + this.action + ")";
            }

            public int hashCode() {
                int result2 = this.elementId.hashCode();
                result2 = result2 * 31 + this.action.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Unknown)) {
                    return false;
                }
                Unknown unknown = (Unknown)other;
                if (!Intrinsics.areEqual((Object)this.elementId, (Object)unknown.elementId)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.action, (Object)unknown.action);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Container$Unpause;", "Lcom/intellij/docker/agent/events/DockerEvent$Container;", "elementId", "", "(Ljava/lang/String;)V", "getElementId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
        public static final class Unpause
        implements Container {
            @NotNull
            private final String elementId;

            public Unpause(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                this.elementId = elementId;
            }

            @Override
            @NotNull
            public String getElementId() {
                return this.elementId;
            }

            @NotNull
            public final String component1() {
                return this.elementId;
            }

            @NotNull
            public final Unpause copy(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                return new Unpause(elementId);
            }

            public static /* synthetic */ Unpause copy$default(Unpause unpause, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = unpause.elementId;
                }
                return unpause.copy(string);
            }

            @NotNull
            public String toString() {
                return "Unpause(elementId=" + this.elementId + ")";
            }

            public int hashCode() {
                return this.elementId.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Unpause)) {
                    return false;
                }
                Unpause unpause = (Unpause)other;
                return Intrinsics.areEqual((Object)this.elementId, (Object)unpause.elementId);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Container$UpdateFailed;", "Lcom/intellij/docker/agent/events/DockerEvent$Container;", "elementId", "", "(Ljava/lang/String;)V", "getElementId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
        @Internal
        public static final class UpdateFailed
        implements Container {
            @NotNull
            private final String elementId;

            public UpdateFailed(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                this.elementId = elementId;
            }

            @Override
            @NotNull
            public String getElementId() {
                return this.elementId;
            }

            @NotNull
            public final String component1() {
                return this.elementId;
            }

            @NotNull
            public final UpdateFailed copy(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                return new UpdateFailed(elementId);
            }

            public static /* synthetic */ UpdateFailed copy$default(UpdateFailed updateFailed, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = updateFailed.elementId;
                }
                return updateFailed.copy(string);
            }

            @NotNull
            public String toString() {
                return "UpdateFailed(elementId=" + this.elementId + ")";
            }

            public int hashCode() {
                return this.elementId.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof UpdateFailed)) {
                    return false;
                }
                UpdateFailed updateFailed = (UpdateFailed)other;
                return Intrinsics.areEqual((Object)this.elementId, (Object)updateFailed.elementId);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\u0007\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Container$Updated;", "Lcom/intellij/docker/agent/events/DockerEvent$Container;", "newContainer", "Lcom/intellij/docker/agent/DockerAgentContainer;", "oldContainerId", "", "(Lcom/intellij/docker/agent/DockerAgentContainer;Ljava/lang/String;)V", "elementId", "getElementId", "()Ljava/lang/String;", "getNewContainer", "()Lcom/intellij/docker/agent/DockerAgentContainer;", "getOldContainerId", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
        @ApiStatus.Internal
        public static final class Updated
        implements Container {
            @NotNull
            private final DockerAgentContainer newContainer;
            @NotNull
            private final String oldContainerId;

            public Updated(@NotNull DockerAgentContainer newContainer, @NotNull String oldContainerId) {
                Intrinsics.checkNotNullParameter((Object)newContainer, (String)"newContainer");
                Intrinsics.checkNotNullParameter((Object)oldContainerId, (String)"oldContainerId");
                this.newContainer = newContainer;
                this.oldContainerId = oldContainerId;
            }

            @NotNull
            public final DockerAgentContainer getNewContainer() {
                return this.newContainer;
            }

            @NotNull
            public final String getOldContainerId() {
                return this.oldContainerId;
            }

            @Override
            @NotNull
            public String getElementId() {
                return this.newContainer.getContainerId();
            }

            @NotNull
            public final DockerAgentContainer component1() {
                return this.newContainer;
            }

            @NotNull
            public final String component2() {
                return this.oldContainerId;
            }

            @NotNull
            public final Updated copy(@NotNull DockerAgentContainer newContainer, @NotNull String oldContainerId) {
                Intrinsics.checkNotNullParameter((Object)newContainer, (String)"newContainer");
                Intrinsics.checkNotNullParameter((Object)oldContainerId, (String)"oldContainerId");
                return new Updated(newContainer, oldContainerId);
            }

            public static /* synthetic */ Updated copy$default(Updated updated, DockerAgentContainer dockerAgentContainer, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    dockerAgentContainer = updated.newContainer;
                }
                if ((n & 2) != 0) {
                    string = updated.oldContainerId;
                }
                return updated.copy(dockerAgentContainer, string);
            }

            @NotNull
            public String toString() {
                return "Updated(newContainer=" + this.newContainer + ", oldContainerId=" + this.oldContainerId + ")";
            }

            public int hashCode() {
                int result2 = this.newContainer.hashCode();
                result2 = result2 * 31 + this.oldContainerId.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Updated)) {
                    return false;
                }
                Updated updated = (Updated)other;
                if (!Intrinsics.areEqual((Object)this.newContainer, (Object)updated.newContainer)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.oldContainerId, (Object)updated.oldContainerId);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Container$Updating;", "Lcom/intellij/docker/agent/events/DockerEvent$Container;", "elementId", "", "(Ljava/lang/String;)V", "getElementId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
        @ApiStatus.Internal
        public static final class Updating
        implements Container {
            @NotNull
            private final String elementId;

            public Updating(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                this.elementId = elementId;
            }

            @Override
            @NotNull
            public String getElementId() {
                return this.elementId;
            }

            @NotNull
            public final String component1() {
                return this.elementId;
            }

            @NotNull
            public final Updating copy(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                return new Updating(elementId);
            }

            public static /* synthetic */ Updating copy$default(Updating updating, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = updating.elementId;
                }
                return updating.copy(string);
            }

            @NotNull
            public String toString() {
                return "Updating(elementId=" + this.elementId + ")";
            }

            public int hashCode() {
                return this.elementId.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Updating)) {
                    return false;
                }
                Updating updating = (Updating)other;
                return Intrinsics.areEqual((Object)this.elementId, (Object)updating.elementId);
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 \u00022\u00020\u0001:\u0007\u0002\u0003\u0004\u0005\u0006\u0007\b\u0082\u0001\u0006\t\n\u000b\f\r\u000e\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Image;", "Lcom/intellij/docker/agent/events/DockerEvent;", "Companion", "Delete", "Prune", "Pull", "Tag", "Unknown", "Untag", "Lcom/intellij/docker/agent/events/DockerEvent$Image$Delete;", "Lcom/intellij/docker/agent/events/DockerEvent$Image$Prune;", "Lcom/intellij/docker/agent/events/DockerEvent$Image$Pull;", "Lcom/intellij/docker/agent/events/DockerEvent$Image$Tag;", "Lcom/intellij/docker/agent/events/DockerEvent$Image$Unknown;", "Lcom/intellij/docker/agent/events/DockerEvent$Image$Untag;", "intellij.clouds.docker.agent"})
    public static interface Image
    extends DockerEvent {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Image$Companion;", "", "()V", "createFrom", "Lcom/intellij/docker/agent/events/DockerEvent$Image;", "event", "Lcom/github/dockerjava/api/model/Event;", "intellij.clouds.docker.agent"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Image createFrom(@NotNull Event event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                return switch (DockerEvent.Companion.getEventAction(event)) {
                    case "tag" -> new Tag(DockerEvent.Companion.getElementId(event));
                    case "untag" -> new Untag(DockerEvent.Companion.getElementId(event));
                    case "delete" -> new Delete(DockerEvent.Companion.getElementId(event));
                    case "pull" -> new Pull(DockerEvent.Companion.getElementId(event));
                    case "prune" -> new Prune(DockerEvent.Companion.getElementId(event));
                    default -> {
                        String action;
                        yield new Unknown(DockerEvent.Companion.getElementId(event), action);
                    }
                };
            }

            static {
                $$INSTANCE = new Companion();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Image$Delete;", "Lcom/intellij/docker/agent/events/DockerEvent$Image;", "elementId", "", "(Ljava/lang/String;)V", "getElementId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
        public static final class Delete
        implements Image {
            @NotNull
            private final String elementId;

            public Delete(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                this.elementId = elementId;
            }

            @Override
            @NotNull
            public String getElementId() {
                return this.elementId;
            }

            @NotNull
            public final String component1() {
                return this.elementId;
            }

            @NotNull
            public final Delete copy(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                return new Delete(elementId);
            }

            public static /* synthetic */ Delete copy$default(Delete delete2, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = delete2.elementId;
                }
                return delete2.copy(string);
            }

            @NotNull
            public String toString() {
                return "Delete(elementId=" + this.elementId + ")";
            }

            public int hashCode() {
                return this.elementId.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Delete)) {
                    return false;
                }
                Delete delete2 = (Delete)other;
                return Intrinsics.areEqual((Object)this.elementId, (Object)delete2.elementId);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Image$Prune;", "Lcom/intellij/docker/agent/events/DockerEvent$Image;", "elementId", "", "(Ljava/lang/String;)V", "getElementId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
        public static final class Prune
        implements Image {
            @NotNull
            private final String elementId;

            public Prune(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                this.elementId = elementId;
            }

            @Override
            @NotNull
            public String getElementId() {
                return this.elementId;
            }

            @NotNull
            public final String component1() {
                return this.elementId;
            }

            @NotNull
            public final Prune copy(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                return new Prune(elementId);
            }

            public static /* synthetic */ Prune copy$default(Prune prune, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = prune.elementId;
                }
                return prune.copy(string);
            }

            @NotNull
            public String toString() {
                return "Prune(elementId=" + this.elementId + ")";
            }

            public int hashCode() {
                return this.elementId.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Prune)) {
                    return false;
                }
                Prune prune = (Prune)other;
                return Intrinsics.areEqual((Object)this.elementId, (Object)prune.elementId);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Image$Pull;", "Lcom/intellij/docker/agent/events/DockerEvent$Image;", "elementId", "", "(Ljava/lang/String;)V", "getElementId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
        public static final class Pull
        implements Image {
            @NotNull
            private final String elementId;

            public Pull(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                this.elementId = elementId;
            }

            @Override
            @NotNull
            public String getElementId() {
                return this.elementId;
            }

            @NotNull
            public final String component1() {
                return this.elementId;
            }

            @NotNull
            public final Pull copy(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                return new Pull(elementId);
            }

            public static /* synthetic */ Pull copy$default(Pull pull2, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = pull2.elementId;
                }
                return pull2.copy(string);
            }

            @NotNull
            public String toString() {
                return "Pull(elementId=" + this.elementId + ")";
            }

            public int hashCode() {
                return this.elementId.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Pull)) {
                    return false;
                }
                Pull pull2 = (Pull)other;
                return Intrinsics.areEqual((Object)this.elementId, (Object)pull2.elementId);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Image$Tag;", "Lcom/intellij/docker/agent/events/DockerEvent$Image;", "elementId", "", "(Ljava/lang/String;)V", "getElementId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
        public static final class Tag
        implements Image {
            @NotNull
            private final String elementId;

            public Tag(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                this.elementId = elementId;
            }

            @Override
            @NotNull
            public String getElementId() {
                return this.elementId;
            }

            @NotNull
            public final String component1() {
                return this.elementId;
            }

            @NotNull
            public final Tag copy(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                return new Tag(elementId);
            }

            public static /* synthetic */ Tag copy$default(Tag tag2, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = tag2.elementId;
                }
                return tag2.copy(string);
            }

            @NotNull
            public String toString() {
                return "Tag(elementId=" + this.elementId + ")";
            }

            public int hashCode() {
                return this.elementId.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Tag)) {
                    return false;
                }
                Tag tag2 = (Tag)other;
                return Intrinsics.areEqual((Object)this.elementId, (Object)tag2.elementId);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Image$Unknown;", "Lcom/intellij/docker/agent/events/DockerEvent$Image;", "elementId", "", "action", "(Ljava/lang/String;Ljava/lang/String;)V", "getAction", "()Ljava/lang/String;", "getElementId", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
        public static final class Unknown
        implements Image {
            @NotNull
            private final String elementId;
            @NotNull
            private final String action;

            public Unknown(@NotNull String elementId, @NotNull String action2) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                this.elementId = elementId;
                this.action = action2;
            }

            @Override
            @NotNull
            public String getElementId() {
                return this.elementId;
            }

            @NotNull
            public final String getAction() {
                return this.action;
            }

            @NotNull
            public final String component1() {
                return this.elementId;
            }

            @NotNull
            public final String component2() {
                return this.action;
            }

            @NotNull
            public final Unknown copy(@NotNull String elementId, @NotNull String action2) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                return new Unknown(elementId, action2);
            }

            public static /* synthetic */ Unknown copy$default(Unknown unknown, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = unknown.elementId;
                }
                if ((n & 2) != 0) {
                    string2 = unknown.action;
                }
                return unknown.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "Unknown(elementId=" + this.elementId + ", action=" + this.action + ")";
            }

            public int hashCode() {
                int result2 = this.elementId.hashCode();
                result2 = result2 * 31 + this.action.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Unknown)) {
                    return false;
                }
                Unknown unknown = (Unknown)other;
                if (!Intrinsics.areEqual((Object)this.elementId, (Object)unknown.elementId)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.action, (Object)unknown.action);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Image$Untag;", "Lcom/intellij/docker/agent/events/DockerEvent$Image;", "elementId", "", "(Ljava/lang/String;)V", "getElementId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
        public static final class Untag
        implements Image {
            @NotNull
            private final String elementId;

            public Untag(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                this.elementId = elementId;
            }

            @Override
            @NotNull
            public String getElementId() {
                return this.elementId;
            }

            @NotNull
            public final String component1() {
                return this.elementId;
            }

            @NotNull
            public final Untag copy(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                return new Untag(elementId);
            }

            public static /* synthetic */ Untag copy$default(Untag untag, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = untag.elementId;
                }
                return untag.copy(string);
            }

            @NotNull
            public String toString() {
                return "Untag(elementId=" + this.elementId + ")";
            }

            public int hashCode() {
                return this.elementId.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Untag)) {
                    return false;
                }
                Untag untag = (Untag)other;
                return Intrinsics.areEqual((Object)this.elementId, (Object)untag.elementId);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Listener;", "", "onDockerEvent", "", "event", "Lcom/intellij/docker/agent/events/DockerEvent;", "intellij.clouds.docker.agent"})
    public static interface Listener {
        public void onDockerEvent(@NotNull DockerEvent var1);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 \u00022\u00020\u0001:\u0007\u0002\u0003\u0004\u0005\u0006\u0007\b\u0082\u0001\u0006\t\n\u000b\f\r\u000e\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Network;", "Lcom/intellij/docker/agent/events/DockerEvent;", "Companion", "Connect", "Create", "Destroy", "Disconnect", "Remove", "Unknown", "Lcom/intellij/docker/agent/events/DockerEvent$Network$Connect;", "Lcom/intellij/docker/agent/events/DockerEvent$Network$Create;", "Lcom/intellij/docker/agent/events/DockerEvent$Network$Destroy;", "Lcom/intellij/docker/agent/events/DockerEvent$Network$Disconnect;", "Lcom/intellij/docker/agent/events/DockerEvent$Network$Remove;", "Lcom/intellij/docker/agent/events/DockerEvent$Network$Unknown;", "intellij.clouds.docker.agent"})
    public static interface Network
    extends DockerEvent {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Network$Companion;", "", "()V", "createFrom", "Lcom/intellij/docker/agent/events/DockerEvent$Network;", "event", "Lcom/github/dockerjava/api/model/Event;", "intellij.clouds.docker.agent"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Network createFrom(@NotNull Event event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                return switch (DockerEvent.Companion.getEventAction(event)) {
                    case "create" -> new Create(DockerEvent.Companion.getElementId(event));
                    case "connect" -> {
                        Object v1;
                        yield new Connect(DockerEvent.Companion.getElementId(event), (v1 = event.getActor()) != null && (v1 = ((EventActor)v1).getAttributes()) != null ? (String)v1.get("container") : null);
                    }
                    case "destroy" -> new Destroy(DockerEvent.Companion.getElementId(event));
                    case "disconnect" -> {
                        Object v2;
                        yield new Disconnect(DockerEvent.Companion.getElementId(event), (v2 = event.getActor()) != null && (v2 = ((EventActor)v2).getAttributes()) != null ? (String)v2.get("container") : null);
                    }
                    case "remove" -> new Remove(DockerEvent.Companion.getElementId(event));
                    default -> {
                        String action;
                        yield new Unknown(DockerEvent.Companion.getElementId(event), action);
                    }
                };
            }

            static {
                $$INSTANCE = new Companion();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Network$Connect;", "Lcom/intellij/docker/agent/events/DockerEvent$Network;", "elementId", "", "containerId", "(Ljava/lang/String;Ljava/lang/String;)V", "getContainerId", "()Ljava/lang/String;", "getElementId", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
        public static final class Connect
        implements Network {
            @NotNull
            private final String elementId;
            @Nullable
            private final String containerId;

            public Connect(@NotNull String elementId, @Nullable String containerId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                this.elementId = elementId;
                this.containerId = containerId;
            }

            @Override
            @NotNull
            public String getElementId() {
                return this.elementId;
            }

            @Nullable
            public final String getContainerId() {
                return this.containerId;
            }

            @NotNull
            public final String component1() {
                return this.elementId;
            }

            @Nullable
            public final String component2() {
                return this.containerId;
            }

            @NotNull
            public final Connect copy(@NotNull String elementId, @Nullable String containerId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                return new Connect(elementId, containerId);
            }

            public static /* synthetic */ Connect copy$default(Connect connect2, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = connect2.elementId;
                }
                if ((n & 2) != 0) {
                    string2 = connect2.containerId;
                }
                return connect2.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "Connect(elementId=" + this.elementId + ", containerId=" + this.containerId + ")";
            }

            public int hashCode() {
                int result2 = this.elementId.hashCode();
                result2 = result2 * 31 + (this.containerId == null ? 0 : this.containerId.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Connect)) {
                    return false;
                }
                Connect connect2 = (Connect)other;
                if (!Intrinsics.areEqual((Object)this.elementId, (Object)connect2.elementId)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.containerId, (Object)connect2.containerId);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Network$Create;", "Lcom/intellij/docker/agent/events/DockerEvent$Network;", "elementId", "", "(Ljava/lang/String;)V", "getElementId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
        public static final class Create
        implements Network {
            @NotNull
            private final String elementId;

            public Create(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                this.elementId = elementId;
            }

            @Override
            @NotNull
            public String getElementId() {
                return this.elementId;
            }

            @NotNull
            public final String component1() {
                return this.elementId;
            }

            @NotNull
            public final Create copy(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                return new Create(elementId);
            }

            public static /* synthetic */ Create copy$default(Create create2, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = create2.elementId;
                }
                return create2.copy(string);
            }

            @NotNull
            public String toString() {
                return "Create(elementId=" + this.elementId + ")";
            }

            public int hashCode() {
                return this.elementId.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Create)) {
                    return false;
                }
                Create create2 = (Create)other;
                return Intrinsics.areEqual((Object)this.elementId, (Object)create2.elementId);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Network$Destroy;", "Lcom/intellij/docker/agent/events/DockerEvent$Network;", "elementId", "", "(Ljava/lang/String;)V", "getElementId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
        public static final class Destroy
        implements Network {
            @NotNull
            private final String elementId;

            public Destroy(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                this.elementId = elementId;
            }

            @Override
            @NotNull
            public String getElementId() {
                return this.elementId;
            }

            @NotNull
            public final String component1() {
                return this.elementId;
            }

            @NotNull
            public final Destroy copy(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                return new Destroy(elementId);
            }

            public static /* synthetic */ Destroy copy$default(Destroy destroy, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = destroy.elementId;
                }
                return destroy.copy(string);
            }

            @NotNull
            public String toString() {
                return "Destroy(elementId=" + this.elementId + ")";
            }

            public int hashCode() {
                return this.elementId.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Destroy)) {
                    return false;
                }
                Destroy destroy = (Destroy)other;
                return Intrinsics.areEqual((Object)this.elementId, (Object)destroy.elementId);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Network$Disconnect;", "Lcom/intellij/docker/agent/events/DockerEvent$Network;", "elementId", "", "containerId", "(Ljava/lang/String;Ljava/lang/String;)V", "getContainerId", "()Ljava/lang/String;", "getElementId", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
        public static final class Disconnect
        implements Network {
            @NotNull
            private final String elementId;
            @Nullable
            private final String containerId;

            public Disconnect(@NotNull String elementId, @Nullable String containerId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                this.elementId = elementId;
                this.containerId = containerId;
            }

            @Override
            @NotNull
            public String getElementId() {
                return this.elementId;
            }

            @Nullable
            public final String getContainerId() {
                return this.containerId;
            }

            @NotNull
            public final String component1() {
                return this.elementId;
            }

            @Nullable
            public final String component2() {
                return this.containerId;
            }

            @NotNull
            public final Disconnect copy(@NotNull String elementId, @Nullable String containerId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                return new Disconnect(elementId, containerId);
            }

            public static /* synthetic */ Disconnect copy$default(Disconnect disconnect2, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = disconnect2.elementId;
                }
                if ((n & 2) != 0) {
                    string2 = disconnect2.containerId;
                }
                return disconnect2.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "Disconnect(elementId=" + this.elementId + ", containerId=" + this.containerId + ")";
            }

            public int hashCode() {
                int result2 = this.elementId.hashCode();
                result2 = result2 * 31 + (this.containerId == null ? 0 : this.containerId.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Disconnect)) {
                    return false;
                }
                Disconnect disconnect2 = (Disconnect)other;
                if (!Intrinsics.areEqual((Object)this.elementId, (Object)disconnect2.elementId)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.containerId, (Object)disconnect2.containerId);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Network$Remove;", "Lcom/intellij/docker/agent/events/DockerEvent$Network;", "elementId", "", "(Ljava/lang/String;)V", "getElementId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
        public static final class Remove
        implements Network {
            @NotNull
            private final String elementId;

            public Remove(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                this.elementId = elementId;
            }

            @Override
            @NotNull
            public String getElementId() {
                return this.elementId;
            }

            @NotNull
            public final String component1() {
                return this.elementId;
            }

            @NotNull
            public final Remove copy(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                return new Remove(elementId);
            }

            public static /* synthetic */ Remove copy$default(Remove remove, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = remove.elementId;
                }
                return remove.copy(string);
            }

            @NotNull
            public String toString() {
                return "Remove(elementId=" + this.elementId + ")";
            }

            public int hashCode() {
                return this.elementId.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Remove)) {
                    return false;
                }
                Remove remove = (Remove)other;
                return Intrinsics.areEqual((Object)this.elementId, (Object)remove.elementId);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Network$Unknown;", "Lcom/intellij/docker/agent/events/DockerEvent$Network;", "elementId", "", "action", "(Ljava/lang/String;Ljava/lang/String;)V", "getAction", "()Ljava/lang/String;", "getElementId", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
        public static final class Unknown
        implements Network {
            @NotNull
            private final String elementId;
            @NotNull
            private final String action;

            public Unknown(@NotNull String elementId, @NotNull String action2) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                this.elementId = elementId;
                this.action = action2;
            }

            @Override
            @NotNull
            public String getElementId() {
                return this.elementId;
            }

            @NotNull
            public final String getAction() {
                return this.action;
            }

            @NotNull
            public final String component1() {
                return this.elementId;
            }

            @NotNull
            public final String component2() {
                return this.action;
            }

            @NotNull
            public final Unknown copy(@NotNull String elementId, @NotNull String action2) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                return new Unknown(elementId, action2);
            }

            public static /* synthetic */ Unknown copy$default(Unknown unknown, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = unknown.elementId;
                }
                if ((n & 2) != 0) {
                    string2 = unknown.action;
                }
                return unknown.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "Unknown(elementId=" + this.elementId + ", action=" + this.action + ")";
            }

            public int hashCode() {
                int result2 = this.elementId.hashCode();
                result2 = result2 * 31 + this.action.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Unknown)) {
                    return false;
                }
                Unknown unknown = (Unknown)other;
                if (!Intrinsics.areEqual((Object)this.elementId, (Object)unknown.elementId)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.action, (Object)unknown.action);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Unknown;", "Lcom/intellij/docker/agent/events/DockerEvent;", "elementId", "", "type", "Lcom/github/dockerjava/api/model/EventType;", "(Ljava/lang/String;Lcom/github/dockerjava/api/model/EventType;)V", "getElementId", "()Ljava/lang/String;", "getType", "()Lcom/github/dockerjava/api/model/EventType;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
    public static final class Unknown
    implements DockerEvent {
        @NotNull
        private final String elementId;
        @Nullable
        private final EventType type;

        public Unknown(@NotNull String elementId, @Nullable EventType type) {
            Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
            this.elementId = elementId;
            this.type = type;
        }

        @Override
        @NotNull
        public String getElementId() {
            return this.elementId;
        }

        @Nullable
        public final EventType getType() {
            return this.type;
        }

        @NotNull
        public final String component1() {
            return this.elementId;
        }

        @Nullable
        public final EventType component2() {
            return this.type;
        }

        @NotNull
        public final Unknown copy(@NotNull String elementId, @Nullable EventType type) {
            Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
            return new Unknown(elementId, type);
        }

        public static /* synthetic */ Unknown copy$default(Unknown unknown, String string, EventType eventType, int n, Object object) {
            if ((n & 1) != 0) {
                string = unknown.elementId;
            }
            if ((n & 2) != 0) {
                eventType = unknown.type;
            }
            return unknown.copy(string, eventType);
        }

        @NotNull
        public String toString() {
            return "Unknown(elementId=" + this.elementId + ", type=" + this.type + ")";
        }

        public int hashCode() {
            int result2 = this.elementId.hashCode();
            result2 = result2 * 31 + (this.type == null ? 0 : this.type.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Unknown)) {
                return false;
            }
            Unknown unknown = (Unknown)other;
            if (!Intrinsics.areEqual((Object)this.elementId, (Object)unknown.elementId)) {
                return false;
            }
            return this.type == unknown.type;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 \u00022\u00020\u0001:\u0007\u0002\u0003\u0004\u0005\u0006\u0007\b\u0082\u0001\u0006\t\n\u000b\f\r\u000e\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Volume;", "Lcom/intellij/docker/agent/events/DockerEvent;", "Companion", "Create", "Destroy", "Mount", "Prune", "Unknown", "Unmount", "Lcom/intellij/docker/agent/events/DockerEvent$Volume$Create;", "Lcom/intellij/docker/agent/events/DockerEvent$Volume$Destroy;", "Lcom/intellij/docker/agent/events/DockerEvent$Volume$Mount;", "Lcom/intellij/docker/agent/events/DockerEvent$Volume$Prune;", "Lcom/intellij/docker/agent/events/DockerEvent$Volume$Unknown;", "Lcom/intellij/docker/agent/events/DockerEvent$Volume$Unmount;", "intellij.clouds.docker.agent"})
    public static interface Volume
    extends DockerEvent {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Volume$Companion;", "", "()V", "createFrom", "Lcom/intellij/docker/agent/events/DockerEvent$Volume;", "event", "Lcom/github/dockerjava/api/model/Event;", "intellij.clouds.docker.agent"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Volume createFrom(@NotNull Event event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                return switch (DockerEvent.Companion.getEventAction(event)) {
                    case "create" -> new Create(DockerEvent.Companion.getElementId(event));
                    case "destroy", "remove" -> new Destroy(DockerEvent.Companion.getElementId(event));
                    case "mount" -> {
                        Object v1;
                        yield new Mount(DockerEvent.Companion.getElementId(event), (v1 = event.getActor()) != null && (v1 = ((EventActor)v1).getAttributes()) != null ? (String)v1.get("container") : null);
                    }
                    case "unmount" -> new Unmount(DockerEvent.Companion.getElementId(event));
                    case "prune" -> new Prune(DockerEvent.Companion.getElementId(event));
                    default -> {
                        String action;
                        yield new Unknown(DockerEvent.Companion.getElementId(event), action);
                    }
                };
            }

            static {
                $$INSTANCE = new Companion();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Volume$Create;", "Lcom/intellij/docker/agent/events/DockerEvent$Volume;", "elementId", "", "(Ljava/lang/String;)V", "getElementId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
        public static final class Create
        implements Volume {
            @NotNull
            private final String elementId;

            public Create(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                this.elementId = elementId;
            }

            @Override
            @NotNull
            public String getElementId() {
                return this.elementId;
            }

            @NotNull
            public final String component1() {
                return this.elementId;
            }

            @NotNull
            public final Create copy(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                return new Create(elementId);
            }

            public static /* synthetic */ Create copy$default(Create create2, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = create2.elementId;
                }
                return create2.copy(string);
            }

            @NotNull
            public String toString() {
                return "Create(elementId=" + this.elementId + ")";
            }

            public int hashCode() {
                return this.elementId.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Create)) {
                    return false;
                }
                Create create2 = (Create)other;
                return Intrinsics.areEqual((Object)this.elementId, (Object)create2.elementId);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Volume$Destroy;", "Lcom/intellij/docker/agent/events/DockerEvent$Volume;", "elementId", "", "(Ljava/lang/String;)V", "getElementId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
        public static final class Destroy
        implements Volume {
            @NotNull
            private final String elementId;

            public Destroy(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                this.elementId = elementId;
            }

            @Override
            @NotNull
            public String getElementId() {
                return this.elementId;
            }

            @NotNull
            public final String component1() {
                return this.elementId;
            }

            @NotNull
            public final Destroy copy(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                return new Destroy(elementId);
            }

            public static /* synthetic */ Destroy copy$default(Destroy destroy, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = destroy.elementId;
                }
                return destroy.copy(string);
            }

            @NotNull
            public String toString() {
                return "Destroy(elementId=" + this.elementId + ")";
            }

            public int hashCode() {
                return this.elementId.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Destroy)) {
                    return false;
                }
                Destroy destroy = (Destroy)other;
                return Intrinsics.areEqual((Object)this.elementId, (Object)destroy.elementId);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Volume$Mount;", "Lcom/intellij/docker/agent/events/DockerEvent$Volume;", "elementId", "", "containerId", "(Ljava/lang/String;Ljava/lang/String;)V", "getContainerId", "()Ljava/lang/String;", "getElementId", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
        public static final class Mount
        implements Volume {
            @NotNull
            private final String elementId;
            @Nullable
            private final String containerId;

            public Mount(@NotNull String elementId, @Nullable String containerId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                this.elementId = elementId;
                this.containerId = containerId;
            }

            @Override
            @NotNull
            public String getElementId() {
                return this.elementId;
            }

            @Nullable
            public final String getContainerId() {
                return this.containerId;
            }

            @NotNull
            public final String component1() {
                return this.elementId;
            }

            @Nullable
            public final String component2() {
                return this.containerId;
            }

            @NotNull
            public final Mount copy(@NotNull String elementId, @Nullable String containerId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                return new Mount(elementId, containerId);
            }

            public static /* synthetic */ Mount copy$default(Mount mount, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = mount.elementId;
                }
                if ((n & 2) != 0) {
                    string2 = mount.containerId;
                }
                return mount.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "Mount(elementId=" + this.elementId + ", containerId=" + this.containerId + ")";
            }

            public int hashCode() {
                int result2 = this.elementId.hashCode();
                result2 = result2 * 31 + (this.containerId == null ? 0 : this.containerId.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Mount)) {
                    return false;
                }
                Mount mount = (Mount)other;
                if (!Intrinsics.areEqual((Object)this.elementId, (Object)mount.elementId)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.containerId, (Object)mount.containerId);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Volume$Prune;", "Lcom/intellij/docker/agent/events/DockerEvent$Volume;", "elementId", "", "(Ljava/lang/String;)V", "getElementId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
        public static final class Prune
        implements Volume {
            @NotNull
            private final String elementId;

            public Prune(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                this.elementId = elementId;
            }

            @Override
            @NotNull
            public String getElementId() {
                return this.elementId;
            }

            @NotNull
            public final String component1() {
                return this.elementId;
            }

            @NotNull
            public final Prune copy(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                return new Prune(elementId);
            }

            public static /* synthetic */ Prune copy$default(Prune prune, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = prune.elementId;
                }
                return prune.copy(string);
            }

            @NotNull
            public String toString() {
                return "Prune(elementId=" + this.elementId + ")";
            }

            public int hashCode() {
                return this.elementId.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Prune)) {
                    return false;
                }
                Prune prune = (Prune)other;
                return Intrinsics.areEqual((Object)this.elementId, (Object)prune.elementId);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Volume$Unknown;", "Lcom/intellij/docker/agent/events/DockerEvent$Volume;", "elementId", "", "action", "(Ljava/lang/String;Ljava/lang/String;)V", "getAction", "()Ljava/lang/String;", "getElementId", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
        public static final class Unknown
        implements Volume {
            @NotNull
            private final String elementId;
            @NotNull
            private final String action;

            public Unknown(@NotNull String elementId, @NotNull String action2) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                this.elementId = elementId;
                this.action = action2;
            }

            @Override
            @NotNull
            public String getElementId() {
                return this.elementId;
            }

            @NotNull
            public final String getAction() {
                return this.action;
            }

            @NotNull
            public final String component1() {
                return this.elementId;
            }

            @NotNull
            public final String component2() {
                return this.action;
            }

            @NotNull
            public final Unknown copy(@NotNull String elementId, @NotNull String action2) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                return new Unknown(elementId, action2);
            }

            public static /* synthetic */ Unknown copy$default(Unknown unknown, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = unknown.elementId;
                }
                if ((n & 2) != 0) {
                    string2 = unknown.action;
                }
                return unknown.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "Unknown(elementId=" + this.elementId + ", action=" + this.action + ")";
            }

            public int hashCode() {
                int result2 = this.elementId.hashCode();
                result2 = result2 * 31 + this.action.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Unknown)) {
                    return false;
                }
                Unknown unknown = (Unknown)other;
                if (!Intrinsics.areEqual((Object)this.elementId, (Object)unknown.elementId)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.action, (Object)unknown.action);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/events/DockerEvent$Volume$Unmount;", "Lcom/intellij/docker/agent/events/DockerEvent$Volume;", "elementId", "", "(Ljava/lang/String;)V", "getElementId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
        public static final class Unmount
        implements Volume {
            @NotNull
            private final String elementId;

            public Unmount(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                this.elementId = elementId;
            }

            @Override
            @NotNull
            public String getElementId() {
                return this.elementId;
            }

            @NotNull
            public final String component1() {
                return this.elementId;
            }

            @NotNull
            public final Unmount copy(@NotNull String elementId) {
                Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                return new Unmount(elementId);
            }

            public static /* synthetic */ Unmount copy$default(Unmount unmount, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = unmount.elementId;
                }
                return unmount.copy(string);
            }

            @NotNull
            public String toString() {
                return "Unmount(elementId=" + this.elementId + ")";
            }

            public int hashCode() {
                return this.elementId.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Unmount)) {
                    return false;
                }
                Unmount unmount = (Unmount)other;
                return Intrinsics.areEqual((Object)this.elementId, (Object)unmount.elementId);
            }
        }
    }
}

