/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.compose.beans.v2;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.intellij.docker.agent.compose.beans.DockerComposeConfiguration;
import com.intellij.docker.agent.compose.beans.v2.DockerComposeServiceV2;
import com.intellij.docker.agent.compose.beans.v2.DockerComposeVolumeV2;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"version", "services", "volumes"})
public class DockerComposeConfigurationV2
implements DockerComposeConfiguration {
    public static final String VERSION_TAG = "version";
    public static final String VERSION_2 = "2";
    @Nullable
    private String myVersion;
    @Nullable
    private String myName;
    private Map<String, DockerComposeServiceV2> myServices;
    private Map<String, DockerComposeVolumeV2> myVolumes;

    public DockerComposeConfigurationV2() {
    }

    public DockerComposeConfigurationV2(Map<String, DockerComposeServiceV2> services) {
        this(null, null, services);
    }

    public DockerComposeConfigurationV2(@Nullable String version2, Map<String, DockerComposeServiceV2> services) {
        this(version2, null, services);
    }

    public DockerComposeConfigurationV2(@Nullable String version2, @Nullable String name2, Map<String, DockerComposeServiceV2> services) {
        this.myVersion = version2;
        this.myServices = services;
        this.myName = name2;
    }

    @JsonProperty
    @Nullable
    public String getVersion() {
        return this.myVersion;
    }

    @JsonProperty
    @Nullable
    public String getName() {
        return this.myName;
    }

    @JsonProperty
    public void setName(@Nullable String name2) {
        this.myName = name2;
    }

    @JsonProperty
    public void setVersion(@Nullable String version2) {
        this.myVersion = version2;
    }

    @JsonProperty
    public Map<String, DockerComposeServiceV2> getServices() {
        if (this.myServices == null) {
            this.myServices = new LinkedHashMap<String, DockerComposeServiceV2>();
        }
        return this.myServices;
    }

    @JsonProperty
    public void setServices(Map<String, DockerComposeServiceV2> services) {
        this.myServices = services;
    }

    @JsonProperty
    public Map<String, DockerComposeVolumeV2> getVolumes() {
        return this.myVolumes;
    }

    @JsonProperty
    public void setVolumes(Map<String, DockerComposeVolumeV2> volumes) {
        this.myVolumes = volumes;
    }

    @Override
    public <T> T accept(DockerComposeConfiguration.Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return "DockerComposeConfigurationV2{myVersion='" + this.myVersion + "', myServices=" + this.myServices + ", myVolumes=" + this.myVolumes + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerComposeConfigurationV2 v2 = (DockerComposeConfigurationV2)o;
        if (!Objects.equals(this.myVersion, v2.myVersion)) {
            return false;
        }
        if (!Objects.equals(this.myServices, v2.myServices)) {
            return false;
        }
        return Objects.equals(this.myVolumes, v2.myVolumes);
    }

    public int hashCode() {
        int result2 = this.myVersion != null ? this.myVersion.hashCode() : 0;
        result2 = 31 * result2 + (this.myServices != null ? this.myServices.hashCode() : 0);
        result2 = 31 * result2 + (this.myVolumes != null ? this.myVolumes.hashCode() : 0);
        return result2;
    }
}

