/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.intellij.docker.agent.DockerAgentRepositoryConfig;
import com.intellij.docker.agent.DockerAuthConfig;
import com.intellij.docker.agent.impl.DockerRepoTagsKt;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerRepoTag
implements Cloneable {
    @NonNls
    public static final String DEFAULT_TAG = "latest";
    @NonNls
    private static final String LEGACY_DOCKER_HUB_ADDRESS = "registry.hub.docker.com";
    @NonNls
    private static final String LEGACY_DEFAULT_DOMAIN = "index.docker.io";
    @NonNls
    private static final String DEFAULT_DOMAIN = "docker.io";
    @NonNls
    private static final String OFFICIAL_REPO_NAME = "library";
    @NonNls
    private static final String REPOSITORY_PARTS_SEPARATOR = "/";
    @NonNls
    private static final String TAG_SEPARATOR = ":";
    @NonNls
    private static final String DIGEST_SEPARATOR = "@";
    private String myDomain;
    private String myNamespace;
    private String myRepository;
    private String myTag;
    private String myDigest;
    private String myPlatform;

    @NotNull
    public static DockerRepoTag fromString(@NotNull String repoTag) {
        String[] parts;
        if (repoTag == null) {
            DockerRepoTag.$$$reportNull$$$0(0);
        }
        if ((parts = repoTag.split("/+")).length == 0) {
            throw new IllegalStateException();
        }
        DockerRepoTag result2 = new DockerRepoTag();
        String digest = DockerRepoTag.substringAfterLast(parts[parts.length - 1], DIGEST_SEPARATOR);
        String withoutDigest = DockerRepoTag.substringBeforeLast(parts[parts.length - 1], DIGEST_SEPARATOR);
        result2.setDigest(digest);
        result2.setTag(DockerRepoTag.substringAfterLast(withoutDigest, TAG_SEPARATOR));
        parts[parts.length - 1] = DockerRepoTag.substringBeforeLast(withoutDigest, TAG_SEPARATOR);
        switch (parts.length) {
            case 0: {
                throw new InternalError();
            }
            case 1: {
                result2.setRepository(parts[parts.length - 1]);
                break;
            }
            default: {
                int namespaceIdx;
                if (DockerRepoTag.isDomain(parts[0])) {
                    result2.setDomain(parts[0]);
                    namespaceIdx = 1;
                } else {
                    result2.setDomain(null);
                    namespaceIdx = 0;
                }
                result2.setNamespace(parts[namespaceIdx]);
                result2.setRepository(Arrays.stream(parts).skip(namespaceIdx + 1).collect(Collectors.joining(REPOSITORY_PARTS_SEPARATOR)));
            }
        }
        DockerRepoTag dockerRepoTag = result2;
        if (dockerRepoTag == null) {
            DockerRepoTag.$$$reportNull$$$0(1);
        }
        return dockerRepoTag;
    }

    public void setRepository(@NotNull String repository) {
        if (repository == null) {
            DockerRepoTag.$$$reportNull$$$0(2);
        }
        this.myRepository = repository;
    }

    public DockerRepoTag clone() {
        try {
            return (DockerRepoTag)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    @Nullable
    public String getDomain() {
        return this.myDomain;
    }

    @Nullable
    public String getNamespace() {
        return this.myNamespace;
    }

    public void setNamespace(String namespace) {
        this.myNamespace = namespace;
    }

    @NotNull
    public String getSimpleRepositoryName() {
        String string = this.myRepository;
        if (string == null) {
            DockerRepoTag.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getTagNotNull() {
        String string = Optional.ofNullable(this.myTag).orElse(DEFAULT_TAG);
        if (string == null) {
            DockerRepoTag.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean hasCustomTag() {
        return this.myTag != null;
    }

    public void setTag(String tag2) {
        this.myTag = DockerRepoTag.nullifyDefaultTag(tag2);
    }

    public void setDigest(@Nullable String digest) {
        this.myDigest = digest;
    }

    @Nullable
    public String getDigest() {
        return this.myDigest;
    }

    public void setDomain(String domain) {
        this.myDomain = DockerRepoTag.nullifyDefaultDomain(domain);
    }

    @Nullable
    public String getPlatform() {
        return this.myPlatform;
    }

    public void setPlatform(String platform2) {
        this.myPlatform = platform2;
    }

    @NotNull
    public String getQualifiedRepository() {
        LinkedList<String> pieces = new LinkedList<String>();
        if (!DockerRepoTag.isEmptyOrSpaces(this.myDomain)) {
            pieces.add(this.myDomain);
        }
        if (!DockerRepoTag.isEmptyOrSpaces(this.myNamespace)) {
            pieces.add(this.myNamespace);
        }
        if (!DockerRepoTag.isEmptyOrSpaces(this.myRepository)) {
            pieces.add(this.myRepository);
        }
        String string = String.join((CharSequence)REPOSITORY_PARTS_SEPARATOR, pieces);
        if (string == null) {
            DockerRepoTag.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getFullyQualifiedReference() {
        String string = this.getFullyQualifiedReference(false);
        if (string == null) {
            DockerRepoTag.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getFullyQualifiedReference(boolean expandDefaultTag) {
        StringBuilder result2 = new StringBuilder(this.getQualifiedRepository());
        if (this.hasCustomTag() || expandDefaultTag) {
            result2.append(TAG_SEPARATOR).append(this.getTagNotNull());
        }
        if (this.myDigest != null) {
            result2.append(DIGEST_SEPARATOR).append(this.myDigest);
        }
        String string = result2.toString();
        if (string == null) {
            DockerRepoTag.$$$reportNull$$$0(7);
        }
        return string;
    }

    public DockerAgentRepositoryConfig toAgentRepositoryConfig() {
        return new DockerAgentRepositoryConfig(){

            @Override
            @Nullable
            public DockerAuthConfig getAuthConfig() {
                return null;
            }

            @Override
            @NotNull
            public String getQualifiedRepository() {
                String string = DockerRepoTag.this.getQualifiedRepository();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @NotNull
            public String getTag() {
                String string = DockerRepoTag.this.getTagNotNull();
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            @Nullable
            public String getPlatform() {
                return DockerRepoTag.this.getPlatform();
            }

            @Override
            @Nullable
            public String getDigest() {
                return DockerRepoTag.this.getDigest();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/docker/agent/DockerRepoTag$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getQualifiedRepository";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTag";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    public boolean matchesRepoTag(@NotNull String thatFqn) {
        Object withExpandedTag;
        String thisFqn;
        if (thatFqn == null) {
            DockerRepoTag.$$$reportNull$$$0(8);
        }
        if (thatFqn.equals(thisFqn = this.getFullyQualifiedReference())) {
            return true;
        }
        Object object = withExpandedTag = this.myTag == null ? thisFqn + ":latest" : thisFqn;
        if (this.myTag == null && thatFqn.equals(withExpandedTag)) {
            return true;
        }
        if (this.myDomain == null) {
            Object withExpandedNamespace;
            Object object2 = withExpandedNamespace = this.myNamespace == null ? "library/" + (String)withExpandedTag : withExpandedTag;
            if (thatFqn.equals("docker.io/" + (String)withExpandedNamespace)) {
                return true;
            }
        }
        return false;
    }

    public boolean matchesOneOfRepoTags(String @Nullable [] repoTags) {
        return repoTags != null && repoTags.length > 0 && Arrays.stream(repoTags).filter(Objects::nonNull).anyMatch(this::matchesRepoTag);
    }

    public boolean isOwnedBy(@Nullable String registryAddress, @Nullable String registryUsername) {
        return Objects.equals(DockerRepoTag.nullifyDefaultDomain(this.myDomain), DockerRepoTag.nullifyDefaultDomain(registryAddress)) && Objects.equals(DockerRepoTag.nullifyDefaultNamespace(this.myDomain, this.myNamespace), DockerRepoTag.nullifyDefaultNamespace(registryAddress, registryUsername));
    }

    public boolean isValidReferenceFormat() {
        DockerRepoTag valid = DockerRepoTagsKt.toValidDockerRepoTag(this);
        return this.getFullyQualifiedReference().equals(valid.getFullyQualifiedReference());
    }

    public String toString() {
        return "DockerRepoTag:" + this.getFullyQualifiedReference();
    }

    private static String nullifyDefaultDomain(@Nullable String domain) {
        return DockerRepoTag.isDefaultDomain(domain) ? null : domain;
    }

    private static String nullifyDefaultNamespace(@Nullable String domain, @Nullable String namespace) {
        return DockerRepoTag.isDefaultDomain(domain) && OFFICIAL_REPO_NAME.equals(namespace) ? null : namespace;
    }

    private static String nullifyDefaultTag(@Nullable String tag2) {
        return DEFAULT_TAG.equals(tag2) ? null : tag2;
    }

    private static boolean isDefaultDomain(@Nullable String domain) {
        return domain == null || DEFAULT_DOMAIN.equals(domain) || LEGACY_DEFAULT_DOMAIN.equals(domain) || LEGACY_DOCKER_HUB_ADDRESS.equals(domain);
    }

    private static boolean isEmptyOrSpaces(@Nullable String text2) {
        return text2 == null || text2.length() == 0 || text2.trim().length() == 0;
    }

    private static String substringBeforeLast(@NotNull String text2, @NotNull String substring) {
        int idx;
        if (text2 == null) {
            DockerRepoTag.$$$reportNull$$$0(9);
        }
        if (substring == null) {
            DockerRepoTag.$$$reportNull$$$0(10);
        }
        return (idx = text2.lastIndexOf(substring)) < 0 ? text2 : text2.substring(0, idx);
    }

    private static String substringAfterLast(@NotNull String text2, @NotNull String substring) {
        int idx;
        if (text2 == null) {
            DockerRepoTag.$$$reportNull$$$0(11);
        }
        if (substring == null) {
            DockerRepoTag.$$$reportNull$$$0(12);
        }
        return (idx = text2.lastIndexOf(substring)) < 0 ? null : text2.substring(idx + substring.length());
    }

    private static boolean isDomain(@NotNull String part) {
        if (part == null) {
            DockerRepoTag.$$$reportNull$$$0(13);
        }
        return "localhost".equals(part) || part.contains(".") || part.contains(TAG_SEPARATOR);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repoTag";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/agent/DockerRepoTag";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thatFqn";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substring";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/agent/DockerRepoTag";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "fromString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleRepositoryName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagNotNull";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedRepository";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullyQualifiedReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setRepository";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "matchesRepoTag";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "substringBeforeLast";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "substringAfterLast";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isDomain";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

