/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.exception.ConflictException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.ContainerNetwork;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.ExposedPorts;
import com.github.dockerjava.api.model.HealthCheck;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.Volumes;
import com.github.dockerjava.core.command.AbstrDockerCmd;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, creatorVisibility=JsonAutoDetect.Visibility.NONE)
public class CreateContainerCmdImpl
extends AbstrDockerCmd<CreateContainerCmd, CreateContainerResponse>
implements CreateContainerCmd {
    private String name;
    @JsonProperty(value="Hostname")
    private String hostName;
    @JsonProperty(value="Domainname")
    private String domainName;
    @JsonProperty(value="User")
    private String user;
    @JsonProperty(value="AttachStdin")
    private Boolean attachStdin;
    @JsonProperty(value="AttachStdout")
    private Boolean attachStdout;
    @JsonProperty(value="AttachStderr")
    private Boolean attachStderr;
    @JsonProperty(value="PortSpecs")
    private String[] portSpecs;
    @JsonProperty(value="Tty")
    private Boolean tty;
    @JsonProperty(value="OpenStdin")
    private Boolean stdinOpen;
    @JsonProperty(value="StdinOnce")
    private Boolean stdInOnce;
    @JsonProperty(value="Env")
    private String[] env;
    @JsonProperty(value="Cmd")
    private String[] cmd;
    @JsonProperty(value="Healthcheck")
    private HealthCheck healthcheck;
    @JsonProperty(value="ArgsEscaped")
    private Boolean argsEscaped;
    @JsonProperty(value="Entrypoint")
    private String[] entrypoint;
    @JsonProperty(value="Image")
    private String image;
    @JsonProperty(value="Volumes")
    private Volumes volumes = new Volumes(new Volume[0]);
    @JsonProperty(value="WorkingDir")
    private String workingDir;
    @JsonProperty(value="MacAddress")
    private String macAddress;
    @JsonProperty(value="OnBuild")
    private List<String> onBuild;
    @JsonProperty(value="NetworkDisabled")
    private Boolean networkDisabled;
    @JsonProperty(value="ExposedPorts")
    private ExposedPorts exposedPorts = new ExposedPorts(new ExposedPort[0]);
    @JsonProperty(value="StopSignal")
    private String stopSignal;
    @JsonProperty(value="StopTimeout")
    private Integer stopTimeout;
    @JsonProperty(value="HostConfig")
    private HostConfig hostConfig = new HostConfig();
    @JsonProperty(value="Labels")
    private Map<String, String> labels;
    @JsonProperty(value="Shell")
    private List<String> shell;
    @JsonProperty(value="NetworkingConfig")
    private NetworkingConfig networkingConfig;
    private String ipv4Address = null;
    private String ipv6Address = null;
    private List<String> aliases = null;
    private AuthConfig authConfig;
    private String platform;

    public CreateContainerCmdImpl(CreateContainerCmd.Exec exec2, AuthConfig authConfig, String image) {
        super(exec2);
        this.withAuthConfig(authConfig);
        this.withImage(image);
    }

    @Override
    public AuthConfig getAuthConfig() {
        return this.authConfig;
    }

    @Override
    public CreateContainerCmd withAuthConfig(AuthConfig authConfig) {
        this.authConfig = authConfig;
        return this;
    }

    @Override
    public List<String> getAliases() {
        return this.aliases;
    }

    @Override
    public CreateContainerCmd withAliases(String ... aliases) {
        this.aliases = Arrays.asList(aliases);
        return this;
    }

    @Override
    public CreateContainerCmd withAliases(List<String> aliases) {
        Objects.requireNonNull(aliases, "aliases was not specified");
        this.aliases = aliases;
        return this;
    }

    @Override
    public String[] getCmd() {
        return this.cmd;
    }

    @Override
    public CreateContainerCmd withCmd(String ... cmd) {
        Objects.requireNonNull(cmd, "cmd was not specified");
        this.cmd = cmd;
        return this;
    }

    @Override
    public CreateContainerCmd withCmd(List<String> cmd) {
        Objects.requireNonNull(cmd, "cmd was not specified");
        return this.withCmd(cmd.toArray(new String[0]));
    }

    @Override
    @CheckForNull
    public HealthCheck getHealthcheck() {
        return this.healthcheck;
    }

    @Override
    public CreateContainerCmdImpl withHealthcheck(HealthCheck healthcheck) {
        this.healthcheck = healthcheck;
        return this;
    }

    @Override
    public Boolean getArgsEscaped() {
        return this.argsEscaped;
    }

    @Override
    public CreateContainerCmdImpl withArgsEscaped(Boolean argsEscaped) {
        this.argsEscaped = argsEscaped;
        return this;
    }

    @Override
    public String getDomainName() {
        return this.domainName;
    }

    @Override
    public CreateContainerCmd withDomainName(String domainName) {
        Objects.requireNonNull(domainName, "no domainName was specified");
        this.domainName = domainName;
        return this;
    }

    @Override
    public String[] getEntrypoint() {
        return this.entrypoint;
    }

    @Override
    public CreateContainerCmd withEntrypoint(String ... entrypoint2) {
        Objects.requireNonNull(entrypoint2, "entrypoint was not specified");
        this.entrypoint = entrypoint2;
        return this;
    }

    @Override
    public CreateContainerCmd withEntrypoint(List<String> entrypoint2) {
        Objects.requireNonNull(entrypoint2, "entrypoint was not specified");
        return this.withEntrypoint(entrypoint2.toArray(new String[0]));
    }

    @Override
    public String[] getEnv() {
        return this.env;
    }

    @Override
    public CreateContainerCmd withEnv(String ... env2) {
        Objects.requireNonNull(env2, "env was not specified");
        this.env = env2;
        return this;
    }

    @Override
    public CreateContainerCmd withEnv(List<String> env2) {
        Objects.requireNonNull(env2, "env was not specified");
        return this.withEnv(env2.toArray(new String[0]));
    }

    @Override
    public ExposedPort[] getExposedPorts() {
        return this.exposedPorts.getExposedPorts();
    }

    @Override
    public CreateContainerCmd withExposedPorts(ExposedPort ... exposedPorts) {
        Objects.requireNonNull(exposedPorts, "exposedPorts was not specified");
        this.exposedPorts = new ExposedPorts(exposedPorts);
        return this;
    }

    @Override
    public CreateContainerCmd withExposedPorts(List<ExposedPort> exposedPorts) {
        Objects.requireNonNull(exposedPorts, "exposedPorts was not specified");
        return this.withExposedPorts(exposedPorts.toArray(new ExposedPort[0]));
    }

    @Override
    public String getStopSignal() {
        return this.stopSignal;
    }

    @Override
    public CreateContainerCmd withStopSignal(String stopSignal) {
        Objects.requireNonNull(stopSignal, "stopSignal wasn't specified.");
        this.stopSignal = stopSignal;
        return this;
    }

    @Override
    public Integer getStopTimeout() {
        return this.stopTimeout;
    }

    @Override
    public CreateContainerCmd withStopTimeout(Integer stopTimeout) {
        this.stopTimeout = stopTimeout;
        return this;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public CreateContainerCmd withHostName(String hostName) {
        Objects.requireNonNull(hostName, "no hostName was specified");
        this.hostName = hostName;
        return this;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public CreateContainerCmd withImage(String image) {
        Objects.requireNonNull(image, "no image was specified");
        this.image = image;
        return this;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    public CreateContainerCmd withLabels(Map<String, String> labels) {
        Objects.requireNonNull(labels, "labels was not specified");
        this.labels = labels;
        return this;
    }

    @Override
    public String getMacAddress() {
        return this.macAddress;
    }

    @Override
    public CreateContainerCmd withMacAddress(String macAddress2) {
        Objects.requireNonNull(macAddress2, "macAddress was not specified");
        this.macAddress = macAddress2;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CreateContainerCmd withName(String name2) {
        Objects.requireNonNull(name2, "name was not specified");
        this.name = name2;
        return this;
    }

    @Override
    public String[] getPortSpecs() {
        return this.portSpecs;
    }

    @Override
    public CreateContainerCmd withPortSpecs(String ... portSpecs) {
        Objects.requireNonNull(portSpecs, "portSpecs was not specified");
        this.portSpecs = portSpecs;
        return this;
    }

    @Override
    public CreateContainerCmd withPortSpecs(List<String> portSpecs) {
        Objects.requireNonNull(portSpecs, "portSpecs was not specified");
        return this.withPortSpecs(portSpecs.toArray(new String[0]));
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public CreateContainerCmd withUser(String user2) {
        Objects.requireNonNull(user2, "user was not specified");
        this.user = user2;
        return this;
    }

    @Override
    public Boolean isAttachStderr() {
        return this.attachStderr;
    }

    @Override
    public CreateContainerCmd withAttachStderr(Boolean attachStderr) {
        Objects.requireNonNull(attachStderr, "attachStderr was not specified");
        this.attachStderr = attachStderr;
        return this;
    }

    @Override
    public Boolean isAttachStdin() {
        return this.attachStdin;
    }

    @Override
    public CreateContainerCmd withAttachStdin(Boolean attachStdin) {
        Objects.requireNonNull(attachStdin, "attachStdin was not specified");
        this.attachStdin = attachStdin;
        return this;
    }

    @Override
    public Boolean isAttachStdout() {
        return this.attachStdout;
    }

    @Override
    public CreateContainerCmd withAttachStdout(Boolean attachStdout) {
        Objects.requireNonNull(attachStdout, "attachStdout was not specified");
        this.attachStdout = attachStdout;
        return this;
    }

    @Override
    public Volume[] getVolumes() {
        return this.volumes.getVolumes();
    }

    @Override
    public CreateContainerCmd withVolumes(Volume ... volumes) {
        Objects.requireNonNull(volumes, "volumes was not specified");
        this.volumes = new Volumes(volumes);
        return this;
    }

    @Override
    public CreateContainerCmd withVolumes(List<Volume> volumes) {
        Objects.requireNonNull(volumes, "volumes was not specified");
        return this.withVolumes(volumes.toArray(new Volume[0]));
    }

    @Override
    public String getWorkingDir() {
        return this.workingDir;
    }

    @Override
    public CreateContainerCmd withWorkingDir(String workingDir2) {
        Objects.requireNonNull(workingDir2, "workingDir was not specified");
        this.workingDir = workingDir2;
        return this;
    }

    @Override
    public Boolean isNetworkDisabled() {
        return this.networkDisabled;
    }

    @Override
    public CreateContainerCmd withNetworkDisabled(Boolean disableNetwork) {
        Objects.requireNonNull(disableNetwork, "disableNetwork was not specified");
        this.networkDisabled = disableNetwork;
        return this;
    }

    @Override
    public Boolean isStdInOnce() {
        return this.stdInOnce;
    }

    @Override
    public CreateContainerCmd withStdInOnce(Boolean stdInOnce) {
        Objects.requireNonNull(stdInOnce, "no stdInOnce was specified");
        this.stdInOnce = stdInOnce;
        return this;
    }

    @Override
    public Boolean isStdinOpen() {
        return this.stdinOpen;
    }

    @Override
    public CreateContainerCmd withStdinOpen(Boolean stdinOpen) {
        Objects.requireNonNull(stdinOpen, "no stdinOpen was specified");
        this.stdinOpen = stdinOpen;
        return this;
    }

    @Override
    public Boolean isTty() {
        return this.tty;
    }

    @Override
    public CreateContainerCmd withTty(Boolean tty2) {
        Objects.requireNonNull(tty2, "no tty was specified");
        this.tty = tty2;
        return this;
    }

    @Override
    public HostConfig getHostConfig() {
        return this.hostConfig;
    }

    @Override
    public CreateContainerCmd withHostConfig(HostConfig hostConfig) {
        this.hostConfig = hostConfig;
        return this;
    }

    @Override
    public String getIpv4Address() {
        return this.ipv4Address;
    }

    @Override
    public CreateContainerCmd withIpv4Address(String ipv4Address) {
        Objects.requireNonNull(ipv4Address, "no ipv4Address was specified");
        this.ipv4Address = ipv4Address;
        return this;
    }

    @Override
    public String getIpv6Address() {
        return this.ipv6Address;
    }

    @Override
    public CreateContainerCmd withIpv6Address(String ipv6Address) {
        Objects.requireNonNull(ipv6Address, "no ipv6Address was specified");
        this.ipv6Address = ipv6Address;
        return this;
    }

    @Override
    @CheckForNull
    public List<String> getOnBuild() {
        return this.onBuild;
    }

    @Override
    public CreateContainerCmdImpl withOnBuild(List<String> onBuild) {
        this.onBuild = onBuild;
        return this;
    }

    @Override
    @CheckForNull
    public String getPlatform() {
        return this.platform;
    }

    @Override
    public CreateContainerCmd withPlatform(String platform2) {
        this.platform = platform2;
        return this;
    }

    @Override
    public CreateContainerResponse exec() throws NotFoundException, ConflictException {
        ContainerNetwork containerNetwork = null;
        if (this.ipv4Address != null || this.ipv6Address != null) {
            containerNetwork = new ContainerNetwork().withIpamConfig(new ContainerNetwork.Ipam().withIpv4Address(this.ipv4Address).withIpv6Address(this.ipv6Address));
        }
        if (this.hostConfig.isUserDefinedNetwork() && this.hostConfig.getLinks().length > 0) {
            if (containerNetwork == null) {
                containerNetwork = new ContainerNetwork();
            }
            containerNetwork.withLinks(this.hostConfig.getLinks());
        }
        if (this.aliases != null) {
            if (containerNetwork == null) {
                containerNetwork = new ContainerNetwork();
            }
            containerNetwork.withAliases(this.aliases);
        }
        if (containerNetwork != null && this.hostConfig.getNetworkMode() != null) {
            this.networkingConfig = new NetworkingConfig().withEndpointsConfig(Collections.singletonMap(this.hostConfig.getNetworkMode(), containerNetwork));
        }
        return (CreateContainerResponse)super.exec();
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public static class NetworkingConfig {
        @JsonProperty(value="EndpointsConfig")
        public Map<String, ContainerNetwork> endpointsConfig;

        public Map<String, ContainerNetwork> getEndpointsConfig() {
            return this.endpointsConfig;
        }

        public NetworkingConfig withEndpointsConfig(Map<String, ContainerNetwork> endpointsConfig) {
            this.endpointsConfig = endpointsConfig;
            return this;
        }
    }
}

