/*
 * Decompiled with CFR 0.152.
 */
package com.goide.template;

import com.goide.template.GoTemplateTypes;
import com.intellij.codeInsight.editorActions.SimpleTokenSetQuoteHandler;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;

public final class GoTemplateQuoteHandler
extends SimpleTokenSetQuoteHandler {
    public GoTemplateQuoteHandler() {
        super(new IElementType[]{GoTemplateTypes.STRING, GoTemplateTypes.RAW_STRING, GoTemplateTypes.CHAR, TokenType.BAD_CHARACTER});
    }

    public boolean isOpeningQuote(HighlighterIterator iterator, int offset) {
        return GoTemplateQuoteHandler.isQuoteInRawString(iterator, offset) || super.isOpeningQuote(iterator, offset);
    }

    public boolean isClosingQuote(HighlighterIterator iterator, int offset) {
        return GoTemplateQuoteHandler.isQuoteInRawString(iterator, offset) || super.isClosingQuote(iterator, offset);
    }

    private static boolean isQuoteInRawString(HighlighterIterator iterator, int offset) {
        Document document;
        if (iterator.getTokenType() == GoTemplateTypes.RAW_STRING && (document = iterator.getDocument()) != null) {
            char c = document.getCharsSequence().charAt(offset);
            return c == '\"' || c == '\'';
        }
        return false;
    }
}

