/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jline.builtins.Completers;
import org.jline.builtins.ConfigurationPath;
import org.jline.builtins.Less;
import org.jline.builtins.Nano;
import org.jline.builtins.Options;
import org.jline.builtins.Source;
import org.jline.builtins.Styles;
import org.jline.builtins.SyntaxHighlighter;
import org.jline.builtins.Tmux;
import org.jline.keymap.KeyMap;
import org.jline.reader.Binding;
import org.jline.reader.Highlighter;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.Macro;
import org.jline.reader.Reference;
import org.jline.reader.Widget;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.StyleResolver;

public class Commands {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tmux(Terminal terminal, PrintStream out, PrintStream err, Supplier<Object> getter, Consumer<Object> setter, Consumer<Terminal> runner, String[] argv) throws Exception {
        String[] usage = new String[]{"tmux -  terminal multiplexer", "Usage: tmux [command]", "  -? --help                    Show help"};
        Options opt = Options.compile(usage).parse(argv);
        if (opt.isSet("help")) {
            throw new Options.HelpException(opt.usage());
        }
        if (argv.length == 0) {
            Object instance = getter.get();
            if (instance != null) {
                err.println("tmux: can't run tmux inside itself");
            } else {
                Tmux tmux = new Tmux(terminal, err, runner);
                setter.accept(tmux);
                try {
                    tmux.run();
                }
                finally {
                    setter.accept(null);
                }
            }
        } else {
            Object instance = getter.get();
            if (instance != null) {
                ((Tmux)instance).execute(out, err, Arrays.asList(argv));
            } else {
                err.println("tmux: no instance running");
            }
        }
    }

    public static void nano(Terminal terminal, PrintStream out, PrintStream err, Path currentDir, String[] argv) throws Exception {
        Commands.nano(terminal, out, err, currentDir, argv, null);
    }

    public static void nano(Terminal terminal, PrintStream out, PrintStream err, Path currentDir, String[] argv, ConfigurationPath configPath) throws Exception {
        Options opt = Options.compile(Nano.usage()).parse(argv);
        if (opt.isSet("help")) {
            throw new Options.HelpException(opt.usage());
        }
        Nano edit = new Nano(terminal, currentDir, opt, configPath);
        edit.open(opt.args());
        edit.run();
    }

    public static void less(Terminal terminal, InputStream in, PrintStream out, PrintStream err, Path currentDir, Object[] argv) throws Exception {
        Commands.less(terminal, in, out, err, currentDir, argv, null);
    }

    public static void less(Terminal terminal, InputStream in, PrintStream out, PrintStream err, Path currentDir, Object[] argv, ConfigurationPath configPath) throws Exception {
        Options opt = Options.compile(Less.usage()).parse(argv);
        if (opt.isSet("help")) {
            throw new Options.HelpException(opt.usage());
        }
        Less less = new Less(terminal, currentDir, opt, configPath);
        ArrayList<Source> sources = new ArrayList<Source>();
        if (opt.argObjects().isEmpty()) {
            opt.argObjects().add("-");
        }
        for (Object o : opt.argObjects()) {
            if (o instanceof String) {
                String arg = (String)o;
                String string = arg = arg.startsWith("~") ? arg.replace("~", System.getProperty("user.home")) : arg;
                if ("-".equals(arg)) {
                    sources.add(new Source.StdInSource(in));
                    continue;
                }
                if (arg.contains("*") || arg.contains("?")) {
                    for (Path p : Commands.findFiles(currentDir, arg)) {
                        sources.add(new Source.URLSource(p.toUri().toURL(), p.toString()));
                    }
                    continue;
                }
                sources.add(new Source.URLSource(currentDir.resolve(arg).toUri().toURL(), arg));
                continue;
            }
            if (o instanceof Source) {
                sources.add((Source)o);
                continue;
            }
            ByteArrayInputStream bais = null;
            if (o instanceof String[]) {
                bais = new ByteArrayInputStream(String.join((CharSequence)"\n", (String[])o).getBytes());
            } else if (o instanceof ByteArrayInputStream) {
                bais = (ByteArrayInputStream)o;
            } else if (o instanceof byte[]) {
                bais = new ByteArrayInputStream((byte[])o);
            }
            if (bais == null) continue;
            sources.add(new Source.InputStreamSource(bais, true, "Less"));
        }
        less.run(sources);
    }

    protected static List<Path> findFiles(Path root2, String files2) throws IOException {
        String regex = files2 = files2.startsWith("~") ? files2.replace("~", System.getProperty("user.home")) : files2;
        Path searchRoot = Paths.get("/", new String[0]);
        if (new File(files2).isAbsolute()) {
            if ((regex = regex.replaceAll("\\\\", "/").replaceAll("//", "/")).contains("/")) {
                String sr = regex.substring(0, regex.lastIndexOf("/") + 1);
                while (sr.contains("*") || sr.contains("?")) {
                    sr = sr.substring(0, sr.lastIndexOf("/"));
                }
                searchRoot = Paths.get(sr + "/", new String[0]);
            }
        } else {
            regex = (root2.toString().length() == 0 ? "" : root2 + "/") + files2;
            regex = regex.replaceAll("\\\\", "/").replaceAll("//", "/");
            searchRoot = root2;
        }
        PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + regex);
        try (Stream<Path> pathStream = Files.walk(searchRoot, new FileVisitOption[0]);){
            List<Path> list2 = pathStream.filter(pathMatcher::matches).collect(Collectors.toList());
            return list2;
        }
    }

    public static void history(LineReader reader, PrintStream out, PrintStream err, Path currentDir, String[] argv) throws Exception {
        Path file;
        String[] usage = new String[]{"history -  list history of commands", "Usage: history [-dnrfEie] [-m match] [first] [last]", "       history -ARWI [filename]", "       history -s [old=new] [command]", "       history --clear", "       history --save", "  -? --help                       Displays command help", "     --clear                      Clear history", "     --save                       Save history", "  -m match                        If option -m is present the first argument is taken as a pattern", "                                  and only the history events matching the pattern will be shown", "  -d                              Print timestamps for each event", "  -f                              Print full time date stamps in the US format", "  -E                              Print full time date stamps in the European format", "  -i                              Print full time date stamps in ISO8601 format", "  -n                              Suppresses command numbers", "  -r                              Reverses the order of the commands", "  -A                              Appends the history out to the given file", "  -R                              Reads the history from the given file", "  -W                              Writes the history out to the given file", "  -I                              If added to -R, only the events that are not contained within the internal list are added", "                                  If added to -W or -A, only the events that are new since the last incremental operation", "                                  to the file are added", "  [first] [last]                  These optional arguments may be specified as a number or as a string. A negative number", "                                  is used as an offset to the current history event number. A string specifies the most", "                                  recent event beginning with the given string.", "  -e                              Uses the nano editor to edit the commands before executing", "  -s                              Re-executes the command without invoking an editor"};
        Options opt = Options.compile(usage).parse(argv);
        if (opt.isSet("help")) {
            throw new Options.HelpException(opt.usage());
        }
        History history = reader.getHistory();
        boolean done = true;
        boolean increment2 = opt.isSet("I");
        if (opt.isSet("clear")) {
            history.purge();
        } else if (opt.isSet("save")) {
            history.save();
        } else if (opt.isSet("A")) {
            file = opt.args().size() > 0 ? currentDir.resolve(opt.args().get(0)) : null;
            history.append(file, increment2);
        } else if (opt.isSet("R")) {
            file = opt.args().size() > 0 ? currentDir.resolve(opt.args().get(0)) : null;
            history.read(file, increment2);
        } else if (opt.isSet("W")) {
            file = opt.args().size() > 0 ? currentDir.resolve(opt.args().get(0)) : null;
            history.write(file, increment2);
        } else {
            done = false;
        }
        if (done) {
            return;
        }
        ReExecute execute2 = new ReExecute(history, opt);
        int argId = execute2.getArgId();
        Pattern pattern = null;
        if (opt.isSet("m") && opt.args().size() > argId) {
            StringBuilder sb = new StringBuilder();
            int prev = 48;
            for (int n : opt.args().get(argId++).toCharArray()) {
                if (n == 42 && prev != 92 && prev != 46) {
                    sb.append('.');
                }
                sb.append((char)n);
                prev = n;
            }
            pattern = Pattern.compile(sb.toString(), 32);
        }
        boolean reverse = opt.isSet("r") || opt.isSet("s") && opt.args().size() <= argId;
        int firstId = opt.args().size() > argId ? Commands.retrieveHistoryId(history, opt.args().get(argId++)) : -17;
        int lastId = opt.args().size() > argId ? Commands.retrieveHistoryId(history, opt.args().get(argId++)) : -1;
        if ((firstId = Commands.historyId(firstId, history.first(), history.last())) > (lastId = Commands.historyId(lastId, history.first(), history.last()))) {
            int tmpId = firstId;
            firstId = lastId;
            lastId = tmpId;
            reverse = !reverse;
        }
        int tot = lastId - firstId + 1;
        int listed = 0;
        Highlighter highlighter = reader.getHighlighter();
        Iterator<History.Entry> iter = null;
        iter = reverse ? history.reverseIterator(lastId) : history.iterator(firstId);
        while (iter.hasNext() && listed < tot) {
            History.Entry entry = iter.next();
            ++listed;
            if (pattern != null && !pattern.matcher(entry.line()).matches()) continue;
            if (execute2.isExecute()) {
                if (execute2.isEdit()) {
                    execute2.addCommandInFile(entry.line());
                    continue;
                }
                execute2.addCommandInBuffer(reader, entry.line());
                break;
            }
            AttributedStringBuilder sb = new AttributedStringBuilder();
            if (!opt.isSet("n")) {
                sb.append("  ");
                sb.styled(AttributedStyle::bold, (CharSequence)String.format("%3d", entry.index()));
            }
            if (opt.isSet("d") || opt.isSet("f") || opt.isSet("E") || opt.isSet("i")) {
                Comparable<LocalTime> lt;
                sb.append("  ");
                if (opt.isSet("d")) {
                    lt = LocalTime.from(entry.time().atZone(ZoneId.systemDefault())).truncatedTo(ChronoUnit.SECONDS);
                    DateTimeFormatter.ISO_LOCAL_TIME.formatTo((TemporalAccessor)((Object)lt), sb);
                } else {
                    lt = LocalDateTime.from(entry.time().atZone(ZoneId.systemDefault()).truncatedTo(ChronoUnit.MINUTES));
                    String format2 = "yyyy-MM-dd hh:mm";
                    if (opt.isSet("f")) {
                        format2 = "MM/dd/yy hh:mm";
                    } else if (opt.isSet("E")) {
                        format2 = "dd.MM.yyyy hh:mm";
                    }
                    DateTimeFormatter.ofPattern(format2).formatTo((TemporalAccessor)((Object)lt), sb);
                }
            }
            sb.append("  ");
            sb.append(highlighter.highlight(reader, entry.line()));
            out.println(sb.toAnsi(reader.getTerminal()));
        }
        execute2.editCommandsAndClose(reader);
    }

    private static int historyId(int id, int minId, int maxId) {
        int out = id;
        if (id < 0) {
            out = maxId + id + 1;
        }
        if (out < minId) {
            out = minId;
        } else if (out > maxId) {
            out = maxId;
        }
        return out;
    }

    private static int retrieveHistoryId(History history, String s) throws IllegalArgumentException {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            for (History.Entry entry : history) {
                if (!entry.line().startsWith(s)) continue;
                return entry.index();
            }
            throw new IllegalArgumentException("history: event not found: " + s);
        }
    }

    public static void complete(LineReader reader, PrintStream out, PrintStream err, Map<String, List<Completers.CompletionData>> completions, String[] argv) throws Options.HelpException {
        String[] usage = new String[]{"complete -  edit command specific tab-completions", "Usage: complete", "  -? --help                       Displays command help", "  -c --command=COMMAND            Command to add completion to", "  -d --description=DESCRIPTION    Description of this completions", "  -e --erase                      Erase the completions", "  -s --short-option=SHORT_OPTION  Posix-style option to complete", "  -l --long-option=LONG_OPTION    GNU-style option to complete", "  -a --argument=ARGUMENTS         A list of possible arguments", "  -n --condition=CONDITION        The completion should only be used if the", "                                  specified command has a zero exit status"};
        Options opt = Options.compile(usage).parse(argv);
        if (opt.isSet("help")) {
            throw new Options.HelpException(opt.usage());
        }
        String command = opt.get("command");
        if (opt.isSet("erase")) {
            completions.remove(command);
            return;
        }
        List cmdCompletions = completions.computeIfAbsent(command, s -> new ArrayList());
        ArrayList<String> options = null;
        if (opt.isSet("short-option")) {
            for (String op : opt.getList("short-option")) {
                if (options == null) {
                    options = new ArrayList<String>();
                }
                options.add("-" + op);
            }
        }
        if (opt.isSet("long-option")) {
            for (String op : opt.getList("long-option")) {
                if (options == null) {
                    options = new ArrayList();
                }
                options.add("--" + op);
            }
        }
        String description2 = opt.isSet("description") ? opt.get("description") : null;
        String argument = opt.isSet("argument") ? opt.get("argument") : null;
        String condition = opt.isSet("condition") ? opt.get("condition") : null;
        cmdCompletions.add(new Completers.CompletionData(options, description2, argument, condition));
    }

    public static void widget(LineReader reader, PrintStream out, PrintStream err, Function<String, Widget> widgetCreator, String[] argv) throws Exception {
        String[] usage = new String[]{"widget -  manipulate widgets", "Usage: widget -N new-widget [function-name]", "       widget -D widget ...", "       widget -A old-widget new-widget", "       widget -U string ...", "       widget -l [options]", "  -? --help                       Displays command help", "  -A                              Create alias to widget", "  -N                              Create new widget", "  -D                              Delete widgets", "  -U                              Push characters to the stack", "  -l                              List user-defined widgets", "  -a                              With -l, list all widgets"};
        Options opt = Options.compile(usage).parse(argv);
        if (opt.isSet("help")) {
            throw new Options.HelpException(opt.usage());
        }
        int actions = (opt.isSet("N") ? 1 : 0) + (opt.isSet("D") ? 1 : 0) + (opt.isSet("U") ? 1 : 0) + (opt.isSet("l") ? 1 : 0) + (opt.isSet("A") ? 1 : 0);
        if (actions > 1) {
            err.println("widget: incompatible operation selection options");
            return;
        }
        if (opt.isSet("l")) {
            TreeSet<String> ws = new TreeSet<String>(reader.getWidgets().keySet());
            if (opt.isSet("a")) {
                HashSet<String> temp = new HashSet<String>(ws);
                Iterator iterator2 = temp.iterator();
                while (iterator2.hasNext()) {
                    String s = (String)iterator2.next();
                    ws.add(reader.getWidgets().get(s).toString());
                }
            }
            for (String s : ws) {
                if (opt.isSet("a")) {
                    out.println(s);
                    continue;
                }
                if (reader.getWidgets().get(s).toString().startsWith(".")) continue;
                out.println(s + " (" + reader.getWidgets().get(s) + ")");
            }
        } else if (opt.isSet("N")) {
            if (opt.args().size() < 1) {
                err.println("widget: not enough arguments for -N");
                return;
            }
            if (opt.args().size() > 2) {
                err.println("widget: too many arguments for -N");
                return;
            }
            String name = opt.args().get(0);
            String func = opt.args().size() == 2 ? opt.args().get(1) : name;
            reader.getWidgets().put(name, widgetCreator.apply(func));
        } else if (opt.isSet("D")) {
            for (String name : opt.args()) {
                reader.getWidgets().remove(name);
            }
        } else if (opt.isSet("A")) {
            if (opt.args().size() < 2) {
                err.println("widget: not enough arguments for -A");
                return;
            }
            if (opt.args().size() > 2) {
                err.println("widget: too many arguments for -A");
                return;
            }
            Widget org = null;
            org = opt.args().get(0).startsWith(".") ? reader.getBuiltinWidgets().get(opt.args().get(0).substring(1)) : reader.getWidgets().get(opt.args().get(0));
            if (org == null) {
                err.println("widget: no such widget `" + opt.args().get(0) + "'");
                return;
            }
            reader.getWidgets().put(opt.args().get(1), org);
        } else if (opt.isSet("U")) {
            for (String arg : opt.args()) {
                reader.runMacro(KeyMap.translate(arg));
            }
        } else if (opt.args().size() == 1) {
            reader.callWidget(opt.args().get(0));
        }
    }

    public static void keymap(LineReader reader, PrintStream out, PrintStream err, String[] argv) throws Options.HelpException {
        String[] usage = new String[]{"keymap -  manipulate keymaps", "Usage: keymap [options] -l [-L] [keymap ...]", "       keymap [options] -d", "       keymap [options] -D keymap ...", "       keymap [options] -A old-keymap new-keymap", "       keymap [options] -N new-keymap [old-keymap]", "       keymap [options] -M", "       keymap [options] -r in-string ...", "       keymap [options] -s in-string out-string ...", "       keymap [options] in-string command ...", "       keymap [options] [in-string]", "  -? --help                       Displays command help", "  -A                              Create alias to keymap", "  -D                              Delete named keymaps", "  -L                              Output in form of keymap commands", "  -M (default=main)               Specify keymap to select", "  -N                              Create new keymap", "  -R                              Interpret in-strings as ranges", "  -a                              Select vicmd keymap", "  -d                              Delete existing keymaps and reset to default state", "  -e                              Select emacs keymap and bind it to main", "  -l                              List existing keymap names", "  -p                              List bindings which have given key sequence as a a prefix", "  -r                              Unbind specified in-strings ", "  -s                              Bind each in-string to each out-string ", "  -v                              Select viins keymap and bind it to main"};
        Options opt = Options.compile(usage).parse(argv);
        if (opt.isSet("help")) {
            throw new Options.HelpException(opt.usage());
        }
        Map<String, KeyMap<Binding>> keyMaps = reader.getKeyMaps();
        int actions = (opt.isSet("N") ? 1 : 0) + (opt.isSet("d") ? 1 : 0) + (opt.isSet("D") ? 1 : 0) + (opt.isSet("l") ? 1 : 0) + (opt.isSet("r") ? 1 : 0) + (opt.isSet("s") ? 1 : 0) + (opt.isSet("A") ? 1 : 0);
        if (actions > 1) {
            err.println("keymap: incompatible operation selection options");
            return;
        }
        if (opt.isSet("l")) {
            boolean commands = opt.isSet("L");
            if (opt.args().size() > 0) {
                for (String arg : opt.args()) {
                    KeyMap<Binding> map2 = keyMaps.get(arg);
                    if (map2 == null) {
                        err.println("keymap: no such keymap: `" + arg + "'");
                        continue;
                    }
                    out.println(arg);
                }
            } else {
                keyMaps.keySet().forEach(out::println);
            }
        } else if (opt.isSet("N")) {
            if (opt.isSet("e") || opt.isSet("v") || opt.isSet("a") || opt.isSet("M")) {
                err.println("keymap: keymap can not be selected with -N");
                return;
            }
            if (opt.args().size() < 1) {
                err.println("keymap: not enough arguments for -N");
                return;
            }
            if (opt.args().size() > 2) {
                err.println("keymap: too many arguments for -N");
                return;
            }
            KeyMap<Binding> org = null;
            if (opt.args().size() == 2 && (org = keyMaps.get(opt.args().get(1))) == null) {
                err.println("keymap: no such keymap `" + opt.args().get(1) + "'");
                return;
            }
            KeyMap<Binding> map3 = new KeyMap<Binding>();
            if (org != null) {
                for (Map.Entry<String, Binding> bound : org.getBoundKeys().entrySet()) {
                    map3.bind(bound.getValue(), (CharSequence)bound.getKey());
                }
            }
            keyMaps.put(opt.args().get(0), map3);
        } else if (opt.isSet("A")) {
            if (opt.isSet("e") || opt.isSet("v") || opt.isSet("a") || opt.isSet("M")) {
                err.println("keymap: keymap can not be selected with -N");
                return;
            }
            if (opt.args().size() < 2) {
                err.println("keymap: not enough arguments for -A");
                return;
            }
            if (opt.args().size() > 2) {
                err.println("keymap: too many arguments for -A");
                return;
            }
            KeyMap<Binding> org = keyMaps.get(opt.args().get(0));
            if (org == null) {
                err.println("keymap: no such keymap `" + opt.args().get(0) + "'");
                return;
            }
            keyMaps.put(opt.args().get(1), org);
        } else if (opt.isSet("d")) {
            if (opt.isSet("e") || opt.isSet("v") || opt.isSet("a") || opt.isSet("M")) {
                err.println("keymap: keymap can not be selected with -N");
                return;
            }
            if (opt.args().size() > 0) {
                err.println("keymap: too many arguments for -d");
                return;
            }
            keyMaps.clear();
            keyMaps.putAll(reader.defaultKeyMaps());
        } else if (opt.isSet("D")) {
            if (opt.isSet("e") || opt.isSet("v") || opt.isSet("a") || opt.isSet("M")) {
                err.println("keymap: keymap can not be selected with -N");
                return;
            }
            if (opt.args().size() < 1) {
                err.println("keymap: not enough arguments for -A");
                return;
            }
            for (String name : opt.args()) {
                if (keyMaps.remove(name) != null) continue;
                err.println("keymap: no such keymap `" + name + "'");
                return;
            }
        } else if (opt.isSet("r")) {
            String keyMapName = "main";
            int sel = (opt.isSet("a") ? 1 : 0) + (opt.isSet("e") ? 1 : 0) + (opt.isSet("v") ? 1 : 0) + (opt.isSet("M") ? 1 : 0);
            if (sel > 1) {
                err.println("keymap: incompatible keymap selection options");
                return;
            }
            if (opt.isSet("a")) {
                keyMapName = "vicmd";
            } else if (opt.isSet("e")) {
                keyMapName = "emacs";
            } else if (opt.isSet("v")) {
                keyMapName = "viins";
            } else if (opt.isSet("M")) {
                if (opt.args().isEmpty()) {
                    err.println("keymap: argument expected: -M");
                    return;
                }
                keyMapName = opt.args().remove(0);
            }
            KeyMap<Binding> map4 = keyMaps.get(keyMapName);
            if (map4 == null) {
                err.println("keymap: no such keymap `" + keyMapName + "'");
                return;
            }
            boolean range = opt.isSet("R");
            boolean prefix = opt.isSet("p");
            HashSet<String> toRemove = new HashSet<String>();
            Map<String, Binding> bound = map4.getBoundKeys();
            for (String arg : opt.args()) {
                if (range) {
                    Collection<String> r = KeyMap.range(opt.args().get(0));
                    if (r == null) {
                        err.println("keymap: malformed key range `" + opt.args().get(0) + "'");
                        return;
                    }
                    toRemove.addAll(r);
                    continue;
                }
                String seq = KeyMap.translate(arg);
                for (String k : bound.keySet()) {
                    if ((!prefix || !k.startsWith(seq) || k.length() <= seq.length()) && (prefix || !k.equals(seq))) continue;
                    toRemove.add(k);
                }
            }
            for (String seq : toRemove) {
                map4.unbind((CharSequence)seq);
            }
            if (opt.isSet("e") || opt.isSet("v")) {
                keyMaps.put("main", map4);
            }
        } else if (opt.isSet("s") || opt.args().size() > 1) {
            String keyMapName = "main";
            int sel = (opt.isSet("a") ? 1 : 0) + (opt.isSet("e") ? 1 : 0) + (opt.isSet("v") ? 1 : 0) + (opt.isSet("M") ? 1 : 0);
            if (sel > 1) {
                err.println("keymap: incompatible keymap selection options");
                return;
            }
            if (opt.isSet("a")) {
                keyMapName = "vicmd";
            } else if (opt.isSet("e")) {
                keyMapName = "emacs";
            } else if (opt.isSet("v")) {
                keyMapName = "viins";
            } else if (opt.isSet("M")) {
                if (opt.args().isEmpty()) {
                    err.println("keymap: argument expected: -M");
                    return;
                }
                keyMapName = opt.args().remove(0);
            }
            KeyMap<Binding> map5 = keyMaps.get(keyMapName);
            if (map5 == null) {
                err.println("keymap: no such keymap `" + keyMapName + "'");
                return;
            }
            boolean range = opt.isSet("R");
            if (opt.args().size() % 2 == 1) {
                err.println("keymap: even number of arguments required");
                return;
            }
            for (int i = 0; i < opt.args().size(); i += 2) {
                Binding bout;
                Binding binding = bout = opt.isSet("s") ? new Macro(KeyMap.translate(opt.args().get(i + 1))) : new Reference(opt.args().get(i + 1));
                if (range) {
                    Collection<String> r = KeyMap.range(opt.args().get(i));
                    if (r == null) {
                        err.println("keymap: malformed key range `" + opt.args().get(i) + "'");
                        return;
                    }
                    map5.bind(bout, r);
                    continue;
                }
                String in = KeyMap.translate(opt.args().get(i));
                map5.bind(bout, (CharSequence)in);
            }
            if (opt.isSet("e") || opt.isSet("v")) {
                keyMaps.put("main", map5);
            }
        } else {
            String keyMapName = "main";
            int sel = (opt.isSet("a") ? 1 : 0) + (opt.isSet("e") ? 1 : 0) + (opt.isSet("v") ? 1 : 0) + (opt.isSet("M") ? 1 : 0);
            if (sel > 1) {
                err.println("keymap: incompatible keymap selection options");
                return;
            }
            if (opt.isSet("a")) {
                keyMapName = "vicmd";
            } else if (opt.isSet("e")) {
                keyMapName = "emacs";
            } else if (opt.isSet("v")) {
                keyMapName = "viins";
            } else if (opt.isSet("M")) {
                if (opt.args().isEmpty()) {
                    err.println("keymap: argument expected: -M");
                    return;
                }
                keyMapName = opt.args().remove(0);
            }
            KeyMap<Binding> map6 = keyMaps.get(keyMapName);
            if (map6 == null) {
                err.println("keymap: no such keymap `" + keyMapName + "'");
                return;
            }
            boolean prefix = opt.isSet("p");
            boolean commands = opt.isSet("L");
            if (prefix && opt.args().isEmpty()) {
                err.println("keymap: option -p requires a prefix string");
                return;
            }
            if (opt.args().size() > 0 || !opt.isSet("e") && !opt.isSet("v")) {
                Map<String, Binding> bound = map6.getBoundKeys();
                String seq = opt.args().size() > 0 ? KeyMap.translate(opt.args().get(0)) : null;
                Map.Entry<String, Binding> begin = null;
                String last = null;
                Iterator<Map.Entry<String, Binding>> iterator2 = bound.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<String, Binding> entry = iterator2.next();
                    String key = entry.getKey();
                    if (seq != null && (!prefix || !key.startsWith(seq) || key.equals(seq)) && (prefix || !key.equals(seq))) continue;
                    if (begin != null || !iterator2.hasNext()) {
                        String n = (last.length() > 1 ? last.substring(0, last.length() - 1) : "") + (char)(last.charAt(last.length() - 1) + '\u0001');
                        if (key.equals(n) && entry.getValue().equals(begin.getValue())) {
                            last = key;
                            continue;
                        }
                        StringBuilder sb = new StringBuilder();
                        if (commands) {
                            sb.append("keymap -M ");
                            sb.append(keyMapName);
                            sb.append(" ");
                        }
                        if (begin.getKey().equals(last)) {
                            sb.append(KeyMap.display(last));
                            sb.append(" ");
                            Commands.displayValue(sb, begin.getValue());
                            out.println(sb);
                        } else {
                            if (commands) {
                                sb.append("-R ");
                            }
                            sb.append(KeyMap.display(begin.getKey()));
                            sb.append("-");
                            sb.append(KeyMap.display(last));
                            sb.append(" ");
                            Commands.displayValue(sb, begin.getValue());
                            out.println(sb);
                        }
                        begin = entry;
                        last = key;
                        continue;
                    }
                    begin = entry;
                    last = key;
                }
            }
            if (opt.isSet("e") || opt.isSet("v")) {
                keyMaps.put("main", map6);
            }
        }
    }

    public static void setopt(LineReader reader, PrintStream out, PrintStream err, String[] argv) throws Options.HelpException {
        String[] usage = new String[]{"setopt -  set options", "Usage: setopt [-m] option ...", "       setopt", "  -? --help                       Displays command help", "  -m                              Use pattern matching"};
        Options opt = Options.compile(usage).parse(argv);
        if (opt.isSet("help")) {
            throw new Options.HelpException(opt.usage());
        }
        if (opt.args().isEmpty()) {
            for (LineReader.Option option : LineReader.Option.values()) {
                if (reader.isSet(option) == option.isDef()) continue;
                out.println((option.isDef() ? "no-" : "") + option.toString().toLowerCase().replace('_', '-'));
            }
        } else {
            boolean match = opt.isSet("m");
            Commands.doSetOpts(reader, out, err, opt.args(), match, true);
        }
    }

    public static void unsetopt(LineReader reader, PrintStream out, PrintStream err, String[] argv) throws Options.HelpException {
        String[] usage = new String[]{"unsetopt -  unset options", "Usage: unsetopt [-m] option ...", "       unsetopt", "  -? --help                       Displays command help", "  -m                              Use pattern matching"};
        Options opt = Options.compile(usage).parse(argv);
        if (opt.isSet("help")) {
            throw new Options.HelpException(opt.usage());
        }
        if (opt.args().isEmpty()) {
            for (LineReader.Option option : LineReader.Option.values()) {
                if (reader.isSet(option) != option.isDef()) continue;
                out.println((option.isDef() ? "no-" : "") + option.toString().toLowerCase().replace('_', '-'));
            }
        } else {
            boolean match = opt.isSet("m");
            Commands.doSetOpts(reader, out, err, opt.args(), match, false);
        }
    }

    private static void doSetOpts(LineReader reader, PrintStream out, PrintStream err, List<String> options, boolean match, boolean set) {
        for (String name : options) {
            String tname = name.toLowerCase().replaceAll("[-_]", "");
            if (match) {
                tname = tname.replaceAll("\\*", "[a-z]*");
                tname = tname.replaceAll("\\?", "[a-z]");
            }
            boolean found = false;
            for (LineReader.Option option : LineReader.Option.values()) {
                String optName = option.name().toLowerCase().replaceAll("[-_]", "");
                if (match ? optName.matches(tname) : optName.equals(tname)) {
                    if (set) {
                        reader.setOpt(option);
                    } else {
                        reader.unsetOpt(option);
                    }
                    found = true;
                    if (match) continue;
                    break;
                }
                if (!(match ? ("no" + optName).matches(tname) : ("no" + optName).equals(tname))) continue;
                if (set) {
                    reader.unsetOpt(option);
                } else {
                    reader.setOpt(option);
                }
                if (match) break;
                found = true;
                break;
            }
            if (found) continue;
            err.println("No matching option: " + name);
        }
    }

    private static void displayValue(StringBuilder sb, Object value2) {
        if (value2 == null) {
            sb.append("undefined-key");
        } else if (value2 instanceof Macro) {
            sb.append(KeyMap.display(((Macro)value2).getSequence()));
        } else if (value2 instanceof Reference) {
            sb.append(((Reference)value2).name());
        } else {
            sb.append(value2);
        }
    }

    public static void setvar(LineReader lineReader, PrintStream out, PrintStream err, String[] argv) throws Options.HelpException {
        String[] usage = new String[]{"setvar -  set lineReader variable value", "Usage: setvar [variable] [value]", "  -? --help                    Show help"};
        Options opt = Options.compile(usage).parse(argv);
        if (opt.isSet("help")) {
            throw new Options.HelpException(opt.usage());
        }
        if (opt.args().isEmpty()) {
            for (Map.Entry<String, Object> entry : lineReader.getVariables().entrySet()) {
                out.println(entry.getKey() + ": " + entry.getValue());
            }
        } else if (opt.args().size() == 1) {
            out.println(lineReader.getVariable(opt.args().get(0)));
        } else {
            lineReader.setVariable(opt.args().get(0), opt.args().get(1));
        }
    }

    public static void colors(Terminal terminal, PrintStream out, String[] argv) throws Options.HelpException, IOException {
        String[] usage = new String[]{"colors -  view 256-color table and ANSI-styles", "Usage: colors [OPTIONS]", "  -? --help                     Displays command help", "  -a --ansistyles               List ANSI-styles", "  -c --columns=COLUMNS          Number of columns in name/rgb table", "                                COLUMNS = 1, display columns: color, style, ansi and HSL", "  -f --find=NAME                Find color names which contains NAME ", "  -l --lock=STYLE               Lock fore- or background color", "  -n --name                     Color name table (default number table)", "  -r --rgb                      Use and display rgb value", "  -s --small                    View 16-color table (default 256-color)", "  -v --view=COLOR               View 24bit color table of COLOR ", "                                COLOR = <colorName>, <color24bit> or hue<angle>"};
        Options opt = Options.compile(usage).parse(argv);
        if (opt.isSet("help")) {
            throw new Options.HelpException(opt.usage());
        }
        Colors colors = new Colors(terminal, out);
        if (opt.isSet("ansistyles")) {
            colors.printStyles();
        } else {
            String style = null;
            if (opt.isSet("lock") && (style = opt.get("lock")).length() - style.replace(":", "").length() > 1) {
                style = null;
            }
            if (!opt.isSet("view")) {
                boolean rgb = opt.isSet("rgb");
                int columns = terminal.getWidth() > (rgb ? 71 : 122) ? 6 : 5;
                String findName = null;
                boolean nameTable = opt.isSet("name");
                boolean table16 = opt.isSet("small");
                if (opt.isSet("find")) {
                    findName = opt.get("find").toLowerCase();
                    nameTable = true;
                    table16 = false;
                    columns = 4;
                }
                if (table16) {
                    columns += 2;
                }
                if (opt.isSet("columns")) {
                    columns = opt.getNumber("columns");
                }
                colors.printColors(nameTable, rgb, table16, columns, findName, style);
            } else {
                colors.printColor(opt.get("view").toLowerCase(), style);
            }
        }
    }

    public static void highlighter(LineReader lineReader, Terminal terminal, PrintStream out, PrintStream err, String[] argv, ConfigurationPath configPath) throws Options.HelpException {
        block24: {
            String[] usage = new String[]{"highlighter -  manage nanorc theme system", "Usage: highlighter [OPTIONS]", "  -? --help                       Displays command help", "  -c --columns=COLUMNS            Number of columns in theme view", "  -l --list                       List available nanorc themes", "  -r --refresh                    Refresh highlighter config", "  -s --switch=THEME               Switch nanorc theme", "  -v --view=THEME                 View nanorc theme"};
            Options opt = Options.compile(usage).parse(argv);
            if (opt.isSet("help")) {
                throw new Options.HelpException(opt.usage());
            }
            try {
                Path currentTheme;
                if (opt.isSet("refresh")) {
                    lineReader.getHighlighter().refresh(lineReader);
                    break block24;
                }
                if (opt.isSet("switch")) {
                    SyntaxHighlighter sh;
                    Path currentTheme2;
                    String newTheme;
                    File themeFile;
                    Path userConfig = configPath.getUserConfig("jnanorc");
                    if (userConfig != null && (themeFile = new File(newTheme = Commands.replaceFileName(currentTheme2 = (sh = SyntaxHighlighter.build(userConfig, null)).getCurrentTheme(), opt.get("switch")))).exists()) {
                        Commands.switchTheme(err, userConfig, newTheme);
                        Path lessConfig = configPath.getUserConfig("jlessrc");
                        if (lessConfig != null) {
                            Commands.switchTheme(err, lessConfig, newTheme);
                        }
                        lineReader.getHighlighter().refresh(lineReader);
                    }
                    break block24;
                }
                Path config = configPath.getConfig("jnanorc");
                Path path = currentTheme = config != null ? SyntaxHighlighter.build(config, null).getCurrentTheme() : null;
                if (currentTheme == null) break block24;
                if (opt.isSet("list")) {
                    String parameter = Commands.replaceFileName(currentTheme, "*.nanorctheme");
                    out.println(currentTheme.getParent() + ":");
                    PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + parameter);
                    try (Stream<Path> pathStream = Files.walk(Paths.get(new File(parameter).getParent(), new String[0]), new FileVisitOption[0]);){
                        pathStream.filter(pathMatcher::matches).forEach(p -> out.println(p.getFileName()));
                        break block24;
                    }
                }
                File themeFile = opt.isSet("view") ? new File(Commands.replaceFileName(currentTheme, opt.get("view"))) : currentTheme.toFile();
                out.println(themeFile.getAbsolutePath());
                try (BufferedReader reader = new BufferedReader(new FileReader(themeFile));){
                    String line;
                    ArrayList<List<String>> tokens = new ArrayList<List<String>>();
                    int maxKeyLen = 0;
                    int maxValueLen = 0;
                    while ((line = reader.readLine()) != null) {
                        List<String> parts;
                        if ((line = line.trim()).length() <= 0 || line.startsWith("#") || !(parts = Arrays.asList(line.split("\\s+", 2))).get(0).matches("[A-Z_]+")) continue;
                        if (parts.get(0).length() > maxKeyLen) {
                            maxKeyLen = parts.get(0).length();
                        }
                        if (parts.get(1).length() > maxValueLen) {
                            maxValueLen = parts.get(1).length();
                        }
                        tokens.add(parts);
                    }
                    AttributedStringBuilder asb = new AttributedStringBuilder();
                    maxKeyLen += 2;
                    ++maxValueLen;
                    int cols = opt.isSet("columns") ? opt.getNumber("columns") : 2;
                    ArrayList<Integer> tabstops = new ArrayList<Integer>();
                    for (int c = 0; c < cols; ++c) {
                        tabstops.add((c + 1) * maxKeyLen + c * maxValueLen);
                        tabstops.add((c + 1) * maxKeyLen + (c + 1) * maxValueLen);
                    }
                    asb.tabs(tabstops);
                    int ind = 0;
                    for (List list2 : tokens) {
                        asb.style(AttributedStyle.DEFAULT).append(" ");
                        asb.style(Commands.compileStyle("token" + ind++, (String)list2.get(1)));
                        asb.append((CharSequence)list2.get(0)).append("\t");
                        asb.append((CharSequence)list2.get(1));
                        asb.style(AttributedStyle.DEFAULT).append("\t");
                        if (ind % cols != 0) continue;
                        asb.style(AttributedStyle.DEFAULT).append("\n");
                    }
                    asb.toAttributedString().println(terminal);
                }
            }
            catch (Exception e) {
                err.println(e.getMessage());
            }
        }
    }

    private static void switchTheme(PrintStream err, Path config, String theme) {
        try (Stream<String> stream = Files.lines(config, StandardCharsets.UTF_8);){
            List list2 = stream.map(line -> line.matches("\\s*theme\\s+.*") ? "theme " + theme : line).collect(Collectors.toList());
            Files.write(config, list2, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            err.println(e.getMessage());
        }
    }

    private static String replaceFileName(Path path, String name) {
        int nameLength = path.getFileName().toString().length();
        int pathLength = path.toString().length();
        return (path.toString().substring(0, pathLength - nameLength) + name).replace("\\", "\\\\");
    }

    private static AttributedStyle compileStyle(String reference, String colorDef) {
        HashMap<String, String> spec = new HashMap<String, String>();
        spec.put(reference, colorDef);
        Styles.StyleCompiler sh = new Styles.StyleCompiler(spec, true);
        return new StyleResolver(sh::getStyle).resolve("." + reference);
    }

    private static class ReExecute {
        private final boolean execute;
        private final boolean edit;
        private String oldParam;
        private String newParam;
        private FileWriter cmdWriter;
        private File cmdFile;
        private int argId = 0;

        public ReExecute(History history, Options opt) throws IOException {
            this.execute = opt.isSet("e") || opt.isSet("s");
            this.edit = opt.isSet("e");
            if (this.execute) {
                String[] s;
                Iterator<History.Entry> iter = history.reverseIterator(history.last());
                if (iter.hasNext()) {
                    iter.next();
                    iter.remove();
                }
                if (this.edit) {
                    this.cmdFile = File.createTempFile("jline-history-", null);
                    this.cmdWriter = new FileWriter(this.cmdFile);
                } else if (opt.args().size() > 0 && (s = opt.args().get(this.argId).split("=")).length == 2) {
                    ++this.argId;
                    this.oldParam = s[0];
                    this.newParam = s[1];
                }
            }
        }

        public int getArgId() {
            return this.argId;
        }

        public boolean isEdit() {
            return this.edit;
        }

        public boolean isExecute() {
            return this.execute;
        }

        public void addCommandInFile(String command) throws IOException {
            this.cmdWriter.write(command + "\n");
        }

        public void addCommandInBuffer(LineReader reader, String command) {
            reader.addCommandsInBuffer(Arrays.asList(this.replaceParam(command)));
        }

        private String replaceParam(String command) {
            String out = command;
            if (this.oldParam != null && this.newParam != null) {
                out = command.replaceAll(this.oldParam, this.newParam);
            }
            return out;
        }

        public void editCommandsAndClose(LineReader reader) throws Exception {
            if (this.edit) {
                this.cmdWriter.close();
                try {
                    reader.editAndAddInBuffer(this.cmdFile);
                }
                finally {
                    this.cmdFile.delete();
                }
            }
        }
    }

    private static class Colors {
        private static final String COLORS_24BIT = "[0-9a-fA-F]{6}";
        private static final List<String> COLORS_16 = Arrays.asList("black", "red", "green", "yellow", "blue", "magenta", "cyan", "white", "!black", "!red", "!green", "!yellow", "!blue", "!magenta", "!cyan", "!white");
        boolean name;
        boolean rgb;
        private final Terminal terminal;
        private final PrintStream out;
        private boolean fixedBg;
        private String fixedStyle;
        int r;
        int g;
        int b;

        public Colors(Terminal terminal, PrintStream out) {
            this.terminal = terminal;
            this.out = out;
        }

        private String getAnsiStyle(String style) {
            return style;
        }

        public void printStyles() {
            AttributedStringBuilder asb = new AttributedStringBuilder();
            asb.tabs(13);
            for (String s : Styles.ANSI_STYLES) {
                AttributedStyle as = new StyleResolver(this::getAnsiStyle).resolve("." + s);
                asb.style(as);
                asb.append(s);
                asb.style(AttributedStyle.DEFAULT);
                asb.append("\t");
                asb.append(this.getAnsiStyle(s));
                asb.append("\t");
                asb.append(as.toAnsi());
                asb.append("\n");
            }
            asb.toAttributedString().println(this.terminal);
        }

        private String getStyle(String color) {
            String out;
            int fg = 32;
            if (this.name) {
                out = (this.fixedBg ? "fg:" : "bg:") + "~" + color.substring(1);
                fg = color.charAt(0);
            } else if (this.rgb) {
                out = (this.fixedBg ? "fg-rgb:" : "bg-rgb:") + "#" + color.substring(1);
                fg = color.charAt(0);
            } else if (color.substring(1).matches("\\d+")) {
                out = (this.fixedBg ? "38;5;" : "48;5;") + color.substring(1);
                fg = color.charAt(0);
            } else {
                out = (this.fixedBg ? "fg:" : "bg:") + color;
            }
            out = this.fixedStyle == null ? (color.startsWith("!") || color.equals("white") || fg == 98 ? out + ",fg:black" : out + ",fg:!white") : out + "," + this.fixedStyle;
            return out;
        }

        private String foreground(int idx) {
            String fg = "w";
            if (idx > 6 && idx < 16 || idx > 33 && idx < 52 || idx > 69 && idx < 88 || idx > 105 && idx < 124 || idx > 141 && idx < 160 || idx > 177 && idx < 196 || idx > 213 && idx < 232 || idx > 243) {
                fg = "b";
            }
            return fg;
        }

        private String addPadding(int width, String field) {
            int i;
            int s = width - field.length();
            int left = s / 2;
            StringBuilder lp = new StringBuilder();
            StringBuilder rp = new StringBuilder();
            for (i = 0; i < left; ++i) {
                lp.append(" ");
            }
            for (i = 0; i < s - left; ++i) {
                rp.append(" ");
            }
            return lp + field + rp;
        }

        private String addLeftPadding(int width, String field) {
            int s = width - field.length();
            StringBuilder lp = new StringBuilder();
            for (int i = 0; i < s; ++i) {
                lp.append(" ");
            }
            return lp + field;
        }

        private void setFixedStyle(String style) {
            this.fixedStyle = style;
            if (style != null && (style.contains("b:") || style.contains("b-") || style.contains("bg:") || style.contains("bg-") || style.contains("background"))) {
                this.fixedBg = true;
            }
        }

        private List<String> retrieveColorNames() throws IOException {
            List<String> out;
            try (InputStream is = new Source.ResourceSource("/org/jline/utils/colors.txt", null).read();
                 BufferedReader br = new BufferedReader(new InputStreamReader(is));){
                out = br.lines().map(String::trim).filter(s -> !s.startsWith("#")).filter(s -> !s.isEmpty()).collect(Collectors.toList());
            }
            return out;
        }

        public void printColors(boolean name, boolean rgb, boolean small, int columns, String findName, String style) throws IOException {
            String tableName;
            this.name = !rgb && name;
            this.rgb = rgb;
            this.setFixedStyle(style);
            AttributedStringBuilder asb = new AttributedStringBuilder();
            int width = this.terminal.getWidth();
            String string = tableName = small ? " 16-color " : "256-color ";
            if (!name && !rgb) {
                this.out.print(tableName);
                this.out.print("table, fg:<name> ");
                if (!small) {
                    this.out.print("/ 38;5;<n>");
                }
                this.out.println();
                this.out.print("                 bg:<name> ");
                if (!small) {
                    this.out.print("/ 48;5;<n>");
                }
                this.out.println("\n");
                boolean narrow = width < 180;
                for (String c : COLORS_16) {
                    AttributedStyle ss = new StyleResolver(this::getStyle).resolve('.' + c, null);
                    asb.style(ss);
                    asb.append(this.addPadding(11, c));
                    asb.style(AttributedStyle.DEFAULT);
                    if (c.equals("white")) {
                        if (narrow || small) {
                            asb.append('\n');
                            continue;
                        }
                        asb.append("    ");
                        continue;
                    }
                    if (!c.equals("!white")) continue;
                    asb.append('\n');
                }
                asb.append('\n');
                if (!small) {
                    for (int i = 16; i < 256; ++i) {
                        String fg = this.foreground(i);
                        String code = Integer.toString(i);
                        AttributedStyle ss = new StyleResolver(this::getStyle).resolve("." + fg + code, null);
                        asb.style(ss);
                        String str = " ";
                        if (i < 100) {
                            str = "  ";
                        } else if (i > 231) {
                            str = i % 2 == 0 ? "    " : "   ";
                        }
                        asb.append(str).append(code).append(' ');
                        if (i != 51 && i != 87 && i != 123 && i != 159 && i != 195 && i != 231 && (!narrow || i != 33 && i != 69 && i != 105 && i != 141 && i != 177 && i != 213 && i != 243)) continue;
                        asb.style(AttributedStyle.DEFAULT);
                        asb.append('\n');
                        if (i != 231) continue;
                        asb.append('\n');
                    }
                }
            } else {
                this.out.print(tableName);
                if (name) {
                    asb.tabs(Arrays.asList(25, 60, 75));
                    this.out.println("table, fg:~<name> OR 38;5;<n>");
                    this.out.println("                 bg:~<name> OR 48;5;<n>");
                } else {
                    asb.tabs(Arrays.asList(15, 45, 70));
                    this.out.println("table, fg-rgb:<color24bit> OR 38;5;<n>");
                    this.out.println("                 bg-rgb:<color24bit> OR 48;5;<n>");
                }
                this.out.println();
                int col = 0;
                int idx = 0;
                int colWidth = rgb ? 12 : 21;
                int lb = 1;
                if (findName != null && (findName.startsWith("#") || findName.startsWith("x"))) {
                    findName = findName.substring(1);
                }
                for (String line : this.retrieveColorNames()) {
                    if (!rgb) {
                        if (findName != null) {
                            if (!line.toLowerCase().contains(findName)) {
                                ++idx;
                                continue;
                            }
                        } else if (small) {
                            colWidth = 15;
                            lb = 1;
                        } else if (columns > 4) {
                            if (idx > 15 && idx < 232) {
                                colWidth = columns != 6 || col == 1 || col == 2 || col == 3 ? 21 : 20;
                                lb = 1;
                            } else {
                                colWidth = columns != 6 || idx % 2 == 0 || col == 7 ? 15 : 16;
                                lb = -1;
                            }
                        }
                    }
                    String fg = this.foreground(idx);
                    if (rgb) {
                        line = Integer.toHexString(org.jline.utils.Colors.DEFAULT_COLORS_256[idx]);
                        for (int p = line.length(); p < 6; ++p) {
                            line = "0" + line;
                        }
                        if (findName != null && !line.toLowerCase().matches(findName)) {
                            ++idx;
                            continue;
                        }
                    }
                    AttributedStyle ss = new StyleResolver(this::getStyle).resolve("." + fg + line, null);
                    if (rgb) {
                        line = "#" + line;
                    }
                    asb.style(ss);
                    String idxstr = Integer.toString(idx);
                    if (rgb) {
                        if (idx < 10) {
                            idxstr = "  " + idxstr;
                        } else if (idx < 100) {
                            idxstr = " " + idxstr;
                        }
                    }
                    asb.append(idxstr).append(this.addPadding(colWidth - idxstr.length(), line));
                    if (columns == 1) {
                        asb.style(AttributedStyle.DEFAULT);
                        asb.append("\t").append(this.getStyle(fg + line.substring(rgb ? 1 : 0)));
                        asb.append("\t").append(ss.toAnsi());
                        int[] rgb1 = this.rgb(org.jline.utils.Colors.DEFAULT_COLORS_256[idx]);
                        int[] hsl = this.rgb2hsl(rgb1[0], rgb1[1], rgb1[2]);
                        asb.append("\t").append(this.addLeftPadding(6, hsl[0] + ", ")).append(this.addLeftPadding(4, hsl[1] + "%")).append(", ").append(this.addLeftPadding(4, hsl[2] + "%"));
                    }
                    ++idx;
                    if ((++col + 1) * colWidth > width || col + lb > columns) {
                        col = 0;
                        asb.style(AttributedStyle.DEFAULT);
                        asb.append('\n');
                    }
                    if (findName != null) continue;
                    if (idx == 16) {
                        if (!small) {
                            if (col == 0) continue;
                            col = 0;
                            asb.style(AttributedStyle.DEFAULT);
                            asb.append('\n');
                            continue;
                        }
                        break;
                    }
                    if (idx != 232 || col == 0) continue;
                    col = 0;
                    asb.style(AttributedStyle.DEFAULT);
                    asb.append('\n');
                }
            }
            asb.toAttributedString().println(this.terminal);
        }

        private int[] rgb(long color) {
            int[] rgb = new int[]{0, 0, 0};
            rgb[0] = (int)(color >> 16 & 0xFFL);
            rgb[1] = (int)(color >> 8 & 0xFFL);
            rgb[2] = (int)(color & 0xFFL);
            return rgb;
        }

        private int[] hue2rgb(int degree) {
            int[] rgb = new int[]{0, 0, 0};
            double hue = (double)degree / 60.0;
            double a = Math.tan((double)degree / 360.0 * 2.0 * Math.PI) / Math.sqrt(3.0);
            if (hue >= 0.0 && hue < 1.0) {
                rgb[0] = 255;
                rgb[1] = (int)(2.0 * a * 255.0 / (1.0 + a));
            } else if (hue >= 1.0 && hue < 2.0) {
                rgb[0] = (int)(255.0 * (1.0 + a) / (2.0 * a));
                rgb[1] = 255;
            } else if (hue >= 2.0 && hue < 3.0) {
                rgb[1] = 255;
                rgb[2] = (int)(255.0 * (1.0 + a) / (1.0 - a));
            } else if (hue >= 3.0 && hue < 4.0) {
                rgb[1] = (int)(255.0 * (1.0 - a) / (1.0 + a));
                rgb[2] = 255;
            } else if (hue >= 4.0 && hue <= 5.0) {
                rgb[0] = (int)(255.0 * (a - 1.0) / (2.0 * a));
                rgb[2] = 255;
            } else if (hue > 5.0 && hue <= 6.0) {
                rgb[0] = 255;
                rgb[2] = (int)(510.0 * a / (a - 1.0));
            }
            return rgb;
        }

        private int[] rgb2hsl(int r, int g, int b) {
            double mn;
            double mx;
            double l;
            int[] hsl = new int[]{0, 0, 0};
            if (r != 0 || g != 0 || b != 0) {
                hsl[0] = (int)Math.round(57.29577951308232 * Math.atan2(Math.sqrt(3.0) * (double)(g - b), 2 * r - g - b));
                while (hsl[0] < 0) {
                    hsl[0] = hsl[0] + 360;
                }
            }
            hsl[1] = (l = ((mx = (double)Math.max(Math.max(r, g), b) / 255.0) + (mn = (double)Math.min(Math.min(r, g), b) / 255.0)) / 2.0) == 0.0 || l == 1.0 ? 0 : (int)Math.round(100.0 * (mx - mn) / (1.0 - Math.abs(2.0 * l - 1.0)));
            hsl[2] = (int)Math.round(100.0 * l);
            return hsl;
        }

        String getStyleRGB(String s) {
            if (this.fixedStyle == null) {
                double ry = Math.pow((double)this.r / 255.0, 2.2);
                double by = Math.pow((double)this.b / 255.0, 2.2);
                double gy = Math.pow((double)this.g / 255.0, 2.2);
                double y = 0.2126 * ry + 0.7151 * gy + 0.0721 * by;
                String fg = "black";
                if (1.05 / (y + 0.05) > (y + 0.05) / 0.05) {
                    fg = "white";
                }
                return "bg-rgb:" + String.format("#%02x%02x%02x", this.r, this.g, this.b) + ",fg:" + fg;
            }
            return (this.fixedBg ? "fg-rgb:" : "bg-rgb:") + String.format("#%02x%02x%02x", this.r, this.g, this.b) + "," + this.fixedStyle;
        }

        public void printColor(String name, String style) throws IOException {
            int hueAngle;
            this.setFixedStyle(style);
            double zoom = 1.0;
            int[] rgb = new int[]{0, 0, 0};
            if (name.matches(COLORS_24BIT)) {
                rgb = this.rgb(Long.parseLong(name, 16));
                zoom = 2.0;
            } else if ((name.startsWith("#") || name.startsWith("x")) && name.substring(1).matches(COLORS_24BIT)) {
                rgb = this.rgb(Long.parseLong(name.substring(1), 16));
                zoom = 2.0;
            } else if (COLORS_16.contains(name)) {
                for (int i = 0; i < 16; ++i) {
                    if (!COLORS_16.get(i).equals(name)) continue;
                    rgb = this.rgb(org.jline.utils.Colors.DEFAULT_COLORS_256[i]);
                    break;
                }
            } else if (name.matches("hue[1-3]?[0-9]{1,2}")) {
                hueAngle = Integer.parseInt(name.substring(3));
                if (hueAngle > 360) {
                    throw new IllegalArgumentException("Color not found: " + name);
                }
                rgb = this.hue2rgb(hueAngle);
            } else if (name.matches("[a-z0-9]+")) {
                List<String> colors = this.retrieveColorNames();
                if (colors.contains(name)) {
                    for (int i = 0; i < 256; ++i) {
                        if (!colors.get(i).equals(name)) continue;
                        rgb = this.rgb(org.jline.utils.Colors.DEFAULT_COLORS_256[i]);
                        break;
                    }
                } else {
                    int i;
                    boolean found = false;
                    for (i = 0; i < 256; ++i) {
                        if (!colors.get(i).startsWith(name)) continue;
                        rgb = this.rgb(org.jline.utils.Colors.DEFAULT_COLORS_256[i]);
                        found = true;
                        break;
                    }
                    if (!found) {
                        for (i = 0; i < 256; ++i) {
                            if (!colors.get(i).contains(name)) continue;
                            rgb = this.rgb(org.jline.utils.Colors.DEFAULT_COLORS_256[i]);
                            found = true;
                            break;
                        }
                    }
                    if (!found) {
                        throw new IllegalArgumentException("Color not found: " + name);
                    }
                }
            } else {
                throw new IllegalArgumentException("Color not found: " + name);
            }
            double step = 32.0;
            int barSize = 14;
            int width = this.terminal.getWidth();
            if (width > 287) {
                step = 8.0;
                barSize = 58;
            } else if (width > 143) {
                step = 16.0;
                barSize = 29;
            } else if (width > 98) {
                step = 24.0;
                barSize = 18;
            }
            this.r = rgb[0];
            this.g = rgb[1];
            this.b = rgb[2];
            int[] hsl = this.rgb2hsl(this.r, this.g, this.b);
            hueAngle = hsl[0];
            this.out.println("HSL: " + hsl[0] + "deg, " + hsl[1] + "%, " + hsl[2] + "%");
            if (hsl[2] > 85 || hsl[2] < 15 || hsl[1] < 15) {
                zoom = 1.0;
            }
            double div = zoom * 256.0 / step;
            int ndiv = (int)(div / zoom);
            double xrs = (double)(255 - this.r) / div;
            double xgs = (double)(255 - this.g) / div;
            double xbs = (double)(255 - this.b) / div;
            double[] yrs = new double[ndiv];
            double[] ygs = new double[ndiv];
            double[] ybs = new double[ndiv];
            double[] ro = new double[ndiv];
            double[] go = new double[ndiv];
            double[] bo = new double[ndiv];
            AttributedStringBuilder asb = new AttributedStringBuilder();
            for (int y = 0; y < ndiv; ++y) {
                for (int x = 0; x < ndiv; ++x) {
                    if (y == 0) {
                        yrs[x] = ((double)rgb[0] + (double)x * xrs) / div;
                        ygs[x] = ((double)rgb[1] + (double)x * xgs) / div;
                        ybs[x] = ((double)rgb[2] + (double)x * xbs) / div;
                        ro[x] = (double)rgb[0] + (double)x * xrs;
                        go[x] = (double)rgb[1] + (double)x * xgs;
                        bo[x] = (double)rgb[2] + (double)x * xbs;
                        this.r = (int)ro[x];
                        this.g = (int)go[x];
                        this.b = (int)bo[x];
                    } else {
                        this.r = (int)(ro[x] - (double)y * yrs[x]);
                        this.g = (int)(go[x] - (double)y * ygs[x]);
                        this.b = (int)(bo[x] - (double)y * ybs[x]);
                    }
                    String col = String.format("%02x%02x%02x", this.r, this.g, this.b);
                    AttributedStyle s = new StyleResolver(this::getStyleRGB).resolve(".rgb" + col);
                    asb.style(s);
                    asb.append(" ").append("#").append(col).append(" ");
                }
                asb.style(AttributedStyle.DEFAULT).append("\n");
            }
            asb.toAttributedString().println(this.terminal);
            if (hueAngle != -1) {
                int dAngle = 5;
                int zero = (int)((double)hueAngle - (double)dAngle / 2.0 * (double)(barSize - 1));
                zero -= zero % 5;
                AttributedStringBuilder asb2 = new AttributedStringBuilder();
                for (int i = 0; i < barSize; ++i) {
                    int angle;
                    for (angle = zero + dAngle * i; angle < 0; angle += 360) {
                    }
                    while (angle > 360) {
                        angle -= 360;
                    }
                    rgb = this.hue2rgb(angle);
                    this.r = rgb[0];
                    this.g = rgb[1];
                    this.b = rgb[2];
                    AttributedStyle s = new StyleResolver(this::getStyleRGB).resolve(".hue" + angle);
                    asb2.style(s);
                    asb2.append(" ").append(this.addPadding(3, "" + angle)).append(" ");
                }
                asb2.style(AttributedStyle.DEFAULT).append("\n");
                asb2.toAttributedString().println(this.terminal);
            }
        }
    }
}

