/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.publisher.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Charsets;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.publisher.Config;
import org.jetbrains.qodana.publisher.PublisherException;
import org.jetbrains.qodana.publisher.schemas.ReportFile;
import org.jetbrains.qodana.publisher.utils.UtilsKt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u001a3\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002H\u00040\bH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\n\u001a\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f*\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0000\u001a\f\u0010\u000f\u001a\u00020\u0006*\u00020\u0010H\u0000\u001aE\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\f*\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\t2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0015H\u0080@\u00f8\u0001\u0001\u00a2\u0006\u0002\u0010\u0016\u001a\u0018\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00180\u0015*\u00020\tH\u0000\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u009920\u0001\n\u0002\b\u0019\u00a8\u0006\u0019"}, d2={"logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "withTempDirectory", "T", "prefix", "", "action", "Lkotlin/Function1;", "Ljava/nio/file/Path;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "getReportFiles", "", "Lorg/jetbrains/qodana/publisher/schemas/ReportFile;", "gzipDir", "md5", "Ljava/io/File;", "publish", "config", "Lorg/jetbrains/qodana/publisher/Config;", "links", "", "(Ljava/util/List;Lorg/jetbrains/qodana/publisher/Config;Ljava/nio/file/Path;Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "recognizeDirLanguages", "", "publisher"})
public final class UtilsKt {
    private static final Logger logger = LoggerFactory.getLogger((String)new Object(){}.getClass().getPackage().getName());

    @NotNull
    public static final List<ReportFile> getReportFiles(@NotNull Path $this$getReportFiles, @NotNull Path gzipDir) {
        Intrinsics.checkNotNullParameter((Object)$this$getReportFiles, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)gzipDir, (String)"gzipDir");
        Stream<Path> stream = Files.walk($this$getReportFiles, new FileVisitOption[0]);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"walk(this)");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)StreamsKt.asSequence(stream), (Function1)getReportFiles.1.INSTANCE), (Function1)((Function1)new Function1<Path, ReportFile>($this$getReportFiles, gzipDir){
            final /* synthetic */ Path $this_getReportFiles;
            final /* synthetic */ Path $gzipDir;
            {
                this.$this_getReportFiles = $receiver;
                this.$gzipDir = $gzipDir;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final ReportFile invoke(Path raw) {
                Path path;
                String name = ((Object)this.$this_getReportFiles.relativize(raw)).toString();
                Path path2 = this.$gzipDir.resolve(name);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"this.resolve(other)");
                Path gzippedFile = path = path2;
                boolean bl = false;
                Path path3 = gzippedFile.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"gzippedFile.parent");
                Object object = path3;
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)object, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(this, *attributes)");
                Intrinsics.checkNotNullExpressionValue((Object)raw, (String)"raw");
                OpenOption[] openOptionArray = new OpenOption[]{};
                InputStream inputStream = Files.newInputStream(raw, Arrays.copyOf(openOptionArray, openOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(this, *options)");
                object = inputStream;
                int n = 8192;
                object = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
                Throwable throwable = null;
                try {
                    BufferedInputStream rawInputStream = (BufferedInputStream)object;
                    boolean bl2 = false;
                    OpenOption[] openOptionArray2 = new OpenOption[]{};
                    OutputStream outputStream = Files.newOutputStream(gzippedFile, Arrays.copyOf(openOptionArray2, openOptionArray2.length));
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(this, *options)");
                    Closeable closeable = outputStream;
                    int n2 = 8192;
                    BufferedOutputStream it = closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n2);
                    boolean bl3 = false;
                    closeable = new GZIPOutputStream(it);
                    Throwable throwable2 = null;
                    try {
                        GZIPOutputStream gzippedOutputStream = (GZIPOutputStream)closeable;
                        boolean bl4 = false;
                        rawInputStream.transferTo(gzippedOutputStream);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                Path gzipped = path;
                long size = Files.size(gzipped);
                File file = gzipped.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"gzipped.toFile()");
                String hash2 = UtilsKt.md5(file);
                Path path4 = Paths.get(name, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"get(path)");
                return new ReportFile(PathsKt.getInvariantSeparatorsPathString((Path)path4), size / (long)1024, hash2);
            }
        })));
    }

    @NotNull
    public static final Map<String, Integer> recognizeDirLanguages(@NotNull Path $this$recognizeDirLanguages) {
        Intrinsics.checkNotNullParameter((Object)$this$recognizeDirLanguages, (String)"<this>");
        return MapsKt.emptyMap();
    }

    @NotNull
    public static final String md5(@NotNull File $this$md5) {
        Intrinsics.checkNotNullParameter((Object)$this$md5, (String)"<this>");
        MessageDigest digest = MessageDigest.getInstance("MD5");
        byte[] hash2 = digest.digest(FilesKt.readBytes((File)$this$md5));
        byte[] byArray = Base64.getEncoder().encode(hash2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoder().encode(hash)");
        byte[] byArray2 = byArray;
        return new String(byArray2, Charsets.UTF_8);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object publish(@NotNull List<ReportFile> var0, @NotNull Config var1_1, @NotNull Path var2_2, @NotNull Map<String, String> var3_3, @NotNull Continuation<? super List<ReportFile>> var4_4) {
        if (!(var4_4 instanceof publish.1)) ** GOTO lbl-1000
        var24_5 = var4_4;
        if ((var24_5.label & -2147483648) != 0) {
            var24_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var4_4){
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return UtilsKt.publish(null, null, null, null, (Continuation<? super List<ReportFile>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var29_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends ReportFile.UploadResult>>, Object>($this$publish, (Map<String, String>)links, (Path)gzipDir, (Config)config, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ List<ReportFile> $this_publish;
                    final /* synthetic */ Map<String, String> $links;
                    final /* synthetic */ Path $gzipDir;
                    final /* synthetic */ Config $config;
                    {
                        this.$this_publish = $receiver;
                        this.$links = $links;
                        this.$gzipDir = $gzipDir;
                        this.$config = $config;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void $this$mapTo$iv$iv;
                                ResultKt.throwOnFailure((Object)object);
                                CoroutineScope $this$coroutineScope = (CoroutineScope)this.L$0;
                                Iterable $this$map$iv = this.$this_publish;
                                Map<String, String> map2 = this.$links;
                                Path path = this.$gzipDir;
                                Config config = this.$config;
                                boolean $i$f$map = false;
                                Iterable iterable = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void file;
                                    ReportFile reportFile = (ReportFile)item$iv$iv;
                                    Collection collection = destination$iv$iv;
                                    boolean bl = false;
                                    collection.add(BuildersKt.async$default((CoroutineScope)$this$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ReportFile.UploadResult>, Object>(map2, (ReportFile)file, path, config, null){
                                        int label;
                                        final /* synthetic */ Map<String, String> $links;
                                        final /* synthetic */ ReportFile $file;
                                        final /* synthetic */ Path $gzipDir;
                                        final /* synthetic */ Config $config;
                                        {
                                            this.$links = $links;
                                            this.$file = $file;
                                            this.$gzipDir = $gzipDir;
                                            this.$config = $config;
                                            super(2, $completion);
                                        }

                                        /*
                                         * Unable to fully structure code
                                         */
                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object var1_1) {
                                            block5: {
                                                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)var1_1);
                                                        link = this.$links.get(this.$file.getName());
                                                        if (link == null) break;
                                                        this.label = 1;
                                                        v0 = this.$file.publish(this.$gzipDir, link, this.$config.getClient(), this.$config.getUploadTimeout(), (Continuation<? super ReportFile.UploadResult>)((Continuation)this));
                                                        if (v0 == var3_2) {
                                                            return var3_2;
                                                        }
                                                        ** GOTO lbl15
                                                    }
                                                    case 1: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        v0 = $result;
lbl15:
                                                        // 2 sources

                                                        v1 = (ReportFile.UploadResult)v0;
                                                        break block5;
                                                    }
                                                }
                                                v1 = this.$file.getSkipped();
                                            }
                                            return v1;
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        @NotNull
                                        public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        @Nullable
                                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ReportFile.UploadResult> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (int)3, null));
                                }
                                this.label = 1;
                                Object object3 = AwaitKt.awaitAll((Collection)((List)destination$iv$iv), (Continuation)((Continuation)this));
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value2;
                        return (Continuation)var3_3;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<? extends ReportFile.UploadResult>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var29_7) {
                    return var29_7;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                processedFiles = (List)v0;
                $this$filterIsInstance$iv = processedFiles;
                $i$f$filterIsInstance = false;
                var9_13 = $this$filterIsInstance$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof ReportFile.UploadResult.Failed)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                failed = (List)destination$iv$iv;
                if (((Collection)failed).isEmpty() == false) {
                    $this$map$iv = failed;
                    $i$f$map = false;
                    $this$filterIsInstanceTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var14_25 = (ReportFile.UploadResult.Failed)item$iv$iv;
                        var22_29 = destination$iv$iv;
                        $i$a$-map-UtilsKt$publish$2 = false;
                        var22_29.add(it.getFile().getName());
                    }
                    var25_30 = null;
                    var26_31 = 2;
                    var27_32 = null;
                    var28_33 = "Some files failed to upload: " + (List)destination$iv$iv;
                    throw new PublisherException(var28_33, var27_32, var26_31, var25_30);
                }
                $this$filterIsInstance$iv = processedFiles;
                $i$f$filterIsInstance = false;
                $this$mapTo$iv$iv = $this$filterIsInstance$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof ReportFile.UploadResult.Success)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                uploadedFiles = (List)destination$iv$iv;
                $i$a$-let-UtilsKt$publish$3 = false;
                destination$iv$iv = uploadedFiles;
                $i$f$filterIsInstanceTo = UtilsKt.logger;
                $i$f$map = false;
                element$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var18_36 = (ReportFile.UploadResult.Success)item$iv$iv;
                    var19_37 = destination$iv$iv;
                    $i$a$-map-UtilsKt$publish$3$1 = false;
                    var19_37.add(result.getFile().getName());
                }
                $i$f$filterIsInstanceTo.debug("Uploaded following files: " + (List)destination$iv$iv);
                $this$filterIsInstance$iv = processedFiles;
                $i$f$filterIsInstance = false;
                $i$a$-let-UtilsKt$publish$3 = $this$filterIsInstance$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof ReportFile.UploadResult.Skipped)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$filterIsInstanceTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    destination$iv$iv = (ReportFile.UploadResult.Skipped)item$iv$iv;
                    var21_39 = destination$iv$iv;
                    $i$a$-map-UtilsKt$publish$4 = false;
                    var21_39.add((ReportFile)it.getFile());
                }
                return (List)destination$iv$iv;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T withTempDirectory(@NotNull String prefix, @NotNull Function1<? super Path, ? extends T> action) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$withTempDirectory = false;
        Path tmpDir = Files.createTempDirectory(prefix, new FileAttribute[0]);
        try {
            Intrinsics.checkNotNullExpressionValue((Object)tmpDir, (String)"tmpDir");
            Object object = action.invoke((Object)tmpDir);
            return (T)object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            File file = tmpDir.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"tmpDir.toFile()");
            FilesKt.deleteRecursively((File)file);
            InlineMarker.finallyEnd((int)1);
        }
    }
}

