/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.formatter.internal;

import com.vladsch.flexmark.ast.HtmlCommentBlock;
import com.vladsch.flexmark.ast.HtmlInnerBlockComment;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.formatter.FormatterOptions;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormatControlProcessor {
    public static final String OPEN_COMMENT = "<!--";
    public static final String CLOSE_COMMENT = "-->";
    private final String formatterOnTag;
    private final String formatterOffTag;
    private final boolean formatterTagsEnabled;
    private boolean myFormatterOff = false;
    private boolean justTurnedOffFormatting = false;
    private boolean justTurnedOnFormatting = false;
    private boolean formatterTagsAcceptRegexp;
    private volatile Pattern formatterOffPattern;
    private volatile Pattern formatterOnPattern;

    public FormatControlProcessor(@NotNull Document document2, @Nullable DataHolder options) {
        FormatterOptions formatterOptions = new FormatterOptions(options);
        this.formatterOnTag = formatterOptions.formatterOnTag;
        this.formatterOffTag = formatterOptions.formatterOffTag;
        this.formatterTagsEnabled = formatterOptions.formatterTagsEnabled;
        this.formatterTagsAcceptRegexp = formatterOptions.formatterTagsAcceptRegexp;
    }

    public boolean isFormattingOff() {
        return this.myFormatterOff;
    }

    @Nullable
    public Pattern getFormatterOffPattern() {
        if (this.formatterOffPattern == null && this.formatterTagsEnabled && this.formatterTagsAcceptRegexp) {
            this.formatterOffPattern = this.getPatternOrDisableRegexp(this.formatterOffTag);
        }
        return this.formatterOffPattern;
    }

    @Nullable
    public Pattern getFormatterOnPattern() {
        if (this.formatterOffPattern == null && this.formatterTagsEnabled && this.formatterTagsAcceptRegexp) {
            this.formatterOnPattern = this.getPatternOrDisableRegexp(this.formatterOnTag);
        }
        return this.formatterOnPattern;
    }

    @Nullable
    private Pattern getPatternOrDisableRegexp(@NotNull String markerText) {
        try {
            return Pattern.compile(markerText);
        }
        catch (PatternSyntaxException var3) {
            this.formatterTagsAcceptRegexp = false;
            return null;
        }
    }

    public boolean isFormattingRegion() {
        return !this.myFormatterOff;
    }

    public String getFormatterOnTag() {
        return this.formatterOnTag;
    }

    public String getFormatterOffTag() {
        return this.formatterOffTag;
    }

    public boolean getFormatterTagsEnabled() {
        return this.formatterTagsEnabled;
    }

    public boolean getFormatterRegExEnabled() {
        return this.formatterTagsAcceptRegexp;
    }

    public boolean isJustTurnedOffFormatting() {
        return this.justTurnedOffFormatting;
    }

    public boolean isJustTurnedOnFormatting() {
        return this.justTurnedOnFormatting;
    }

    @Nullable
    private Boolean isFormatterOffTag(@Nullable CharSequence commentText) {
        if (commentText == null) {
            return null;
        }
        String text2 = commentText.toString().trim();
        text2 = text2.substring(OPEN_COMMENT.length(), text2.length() - CLOSE_COMMENT.length()).trim();
        if (this.formatterTagsAcceptRegexp && this.formatterOffPattern != null && this.formatterOnPattern != null) {
            if (this.formatterOnPattern.matcher(text2).matches()) {
                return false;
            }
            if (this.formatterOffPattern.matcher(text2).matches()) {
                return true;
            }
        } else if (this.formatterTagsEnabled) {
            if (text2.equals(this.formatterOnTag)) {
                return false;
            }
            if (text2.equals(this.formatterOffTag)) {
                return true;
            }
        }
        return null;
    }

    public void initializeFrom(@NotNull Node element2) {
        this.myFormatterOff = !this.isFormattingRegion(element2.getStartOffset(), element2, true);
    }

    public void processFormatControl(@NotNull Node node) {
        this.justTurnedOffFormatting = false;
        this.justTurnedOnFormatting = false;
        if ((node instanceof HtmlCommentBlock || node instanceof HtmlInnerBlockComment) && this.formatterTagsEnabled) {
            boolean formatterOff = this.myFormatterOff;
            Boolean isFormatterOff = this.isFormatterOffTag(node.getChars());
            if (isFormatterOff == null) {
                return;
            }
            this.myFormatterOff = isFormatterOff;
            if (!formatterOff && this.myFormatterOff) {
                this.justTurnedOffFormatting = true;
            }
            if (formatterOff && !this.myFormatterOff) {
                this.justTurnedOnFormatting = true;
            }
        }
    }

    private boolean isFormattingRegion(int offset, @NotNull Node node, boolean checkParent) {
        while (node != null) {
            if (node.getStartOffset() <= offset) {
                Boolean formatterOff;
                if (node instanceof Block && !(node instanceof Paragraph) && node.hasChildren()) {
                    Node lastChild = node.getLastChild();
                    return lastChild != null && this.isFormattingRegion(offset, lastChild, false);
                }
                if ((node instanceof HtmlCommentBlock || node instanceof HtmlInnerBlockComment) && (formatterOff = this.isFormatterOffTag(node.getChars())) != null) {
                    return formatterOff == false;
                }
            }
            if (node.getPrevious() == null && checkParent) {
                if ((node = node.getParent()) instanceof Document) break;
                if (node == null) continue;
                node = node.getPrevious();
                continue;
            }
            node = node.getPrevious();
        }
        return true;
    }

    public boolean isFormattingRegion(@NotNull Node node) {
        if (!this.formatterTagsEnabled || node.getStartOffset() == 0) {
            return true;
        }
        return this.isFormattingRegion(node.getStartOffset(), node, true);
    }
}

