/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.css.newmatch;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.constants.MarginBoxName;
import com.openhtmltopdf.css.newmatch.CascadedStyle;
import com.openhtmltopdf.css.parser.PropertyValue;
import com.openhtmltopdf.css.sheet.PropertyDeclaration;
import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.css.style.EmptyStyle;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class PageInfo {
    private final CascadedStyle _pageStyle;
    private final Map<MarginBoxName, List<PropertyDeclaration>> _marginBoxes;
    private final List<PropertyDeclaration> _properties;
    private final List<PropertyDeclaration> _xmpPropertyList;
    private final List<PropertyDeclaration> _footnote;

    public PageInfo(List<PropertyDeclaration> properties, CascadedStyle pageStyle, Map<MarginBoxName, List<PropertyDeclaration>> marginBoxes, List<PropertyDeclaration> footnote) {
        this._properties = properties;
        this._pageStyle = pageStyle;
        this._marginBoxes = marginBoxes;
        this._footnote = footnote;
        this._xmpPropertyList = marginBoxes.remove(MarginBoxName.FS_PDF_XMP_METADATA);
    }

    public Map<MarginBoxName, List<PropertyDeclaration>> getMarginBoxes() {
        return this._marginBoxes;
    }

    public CascadedStyle getPageStyle() {
        return this._pageStyle;
    }

    public List<PropertyDeclaration> getProperties() {
        return this._properties;
    }

    public CalculatedStyle getFootnoteAreaRawMaxHeightStyle() {
        CascadedStyle cascaded = new CascadedStyle(this._footnote.iterator());
        if (cascaded.hasProperty(CSSName.MAX_HEIGHT)) {
            return new EmptyStyle().deriveStyle(cascaded);
        }
        return null;
    }

    public CascadedStyle createFootnoteAreaStyle() {
        PropertyDeclaration maxHeight = new PropertyDeclaration(CSSName.MAX_HEIGHT, new PropertyValue(IdentValue.NONE), true, 1);
        List<PropertyDeclaration> overrides = Arrays.asList(CascadedStyle.createLayoutPropertyDeclaration(CSSName.POSITION, IdentValue.ABSOLUTE), CascadedStyle.createLayoutPropertyDeclaration(CSSName.DISPLAY, IdentValue.BLOCK), maxHeight);
        if (this._footnote == null || this._footnote.isEmpty()) {
            return new CascadedStyle(overrides.iterator());
        }
        ArrayList<PropertyDeclaration> all = new ArrayList<PropertyDeclaration>(overrides.size() + this._footnote.size());
        for (PropertyDeclaration decl : this._footnote) {
            CSSName name = decl.getCSSName();
            PropertyValue value2 = (PropertyValue)decl.getValue();
            if (name.equals(CSSName.POSITION)) {
                if (value2.getPropertyValueType() == 4 && value2.getIdentValue() == IdentValue.ABSOLUTE) continue;
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId2Param.GENERAL_FOOTNOTE_AREA_INVALID_STYLE, (Object)value2.getCssText(), (Object)"position");
                continue;
            }
            if (name == CSSName.FLOAT) {
                if (value2.getPropertyValueType() == 4 && value2.getIdentValue() == IdentValue.BOTTOM) continue;
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId2Param.GENERAL_FOOTNOTE_AREA_INVALID_STYLE, (Object)value2.getCssText(), (Object)"float");
                continue;
            }
            if (name == CSSName.DISPLAY) {
                if (value2.getPropertyValueType() == 4 && value2.getIdentValue() == IdentValue.BLOCK) continue;
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId2Param.GENERAL_FOOTNOTE_AREA_INVALID_STYLE, (Object)value2.getCssText(), (Object)"display");
                continue;
            }
            all.add(decl);
        }
        all.addAll(overrides);
        return new CascadedStyle(all.iterator());
    }

    public CascadedStyle createMarginBoxStyle(MarginBoxName marginBox, boolean alwaysCreate) {
        ArrayList<PropertyDeclaration> all;
        List<PropertyDeclaration> marginProps = this._marginBoxes.get(marginBox);
        if (!(marginProps != null && marginProps.size() != 0 || alwaysCreate)) {
            return null;
        }
        if (marginProps != null) {
            all = new ArrayList(marginProps.size() + 3);
            all.addAll(marginProps);
        } else {
            all = new ArrayList<PropertyDeclaration>(3);
        }
        all.add(CascadedStyle.createLayoutPropertyDeclaration(CSSName.DISPLAY, IdentValue.TABLE_CELL));
        all.add(new PropertyDeclaration(CSSName.VERTICAL_ALIGN, new PropertyValue(marginBox.getInitialVerticalAlign()), false, 0));
        all.add(new PropertyDeclaration(CSSName.TEXT_ALIGN, new PropertyValue(marginBox.getInitialTextAlign()), false, 0));
        return new CascadedStyle(all.iterator());
    }

    public boolean hasAny(MarginBoxName[] marginBoxes) {
        for (MarginBoxName marginBox : marginBoxes) {
            if (!this._marginBoxes.containsKey(marginBox)) continue;
            return true;
        }
        return false;
    }

    public List<PropertyDeclaration> getXMPPropertyList() {
        return this._xmpPropertyList;
    }
}

