/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.components;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.graph.builder.GraphBundle;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.JBColor;
import com.intellij.ui.PaintingParent;
import com.intellij.uml.components.UmlGraphZoomableViewport;
import com.intellij.uml.dnd.UmlDnDSupport;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.dnd.DropTarget;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UmlGraphComponent
implements Disposable {
    private static final String GRAPH_CARD_ID = "view";
    private static final String COMPUTING_CARD_ID = "computing";
    @NotNull
    private final CardLayout myCard;
    @NotNull
    private final JComponent myComponent;
    @NotNull
    private final UmlGraphZoomableViewport myViewport;
    @NotNull
    private final ActionToolbarImpl myToolbar;
    private DiagramBuilder myBuilder;

    public UmlGraphComponent(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            UmlGraphComponent.$$$reportNull$$$0(0);
        }
        this(builder, UmlGraphComponent.createToolbar(builder));
    }

    public UmlGraphComponent(@NotNull DiagramBuilder builder, @NotNull ActionToolbar actionToolbar) {
        if (builder == null) {
            UmlGraphComponent.$$$reportNull$$$0(1);
        }
        if (actionToolbar == null) {
            UmlGraphComponent.$$$reportNull$$$0(2);
        }
        this.myCard = new CardLayout();
        this.myComponent = new JPanel(this.myCard);
        this.myBuilder = builder;
        this.myToolbar = (ActionToolbarImpl)actionToolbar;
        this.myViewport = new UmlGraphZoomableViewport(builder);
        this.myComponent.add((Component)new PaintingParent.Wrapper((Component)JBUI.Panels.simplePanel((Component)((Object)this.myViewport)).addToTop((Component)UmlGraphComponent.createToolbarComponent(builder, actionToolbar))), GRAPH_CARD_ID);
        JLabel label = new JLabel((Icon)new AnimatedIcon.Big());
        label.setText(GraphBundle.message((String)"graph.computing.layout", (Object[])new Object[0]));
        label.setFont((Font)JBFont.regular());
        label.setHorizontalTextPosition(0);
        label.setVerticalTextPosition(3);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(0);
        label.setOpaque(true);
        label.setBackground((Color)JBColor.WHITE);
        this.myComponent.add((Component)label, COMPUTING_CARD_ID);
        this.myCard.show(this.myComponent, GRAPH_CARD_ID);
        this.addDnDSupport();
    }

    private void addDnDSupport() {
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            new DropTarget(this.myBuilder.getView().getCanvasComponent(), new UmlDnDSupport(this.myBuilder));
        }
    }

    @NotNull
    public DiagramBuilder getBuilder() {
        DiagramBuilder diagramBuilder = this.myBuilder;
        if (diagramBuilder == null) {
            UmlGraphComponent.$$$reportNull$$$0(3);
        }
        return diagramBuilder;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            UmlGraphComponent.$$$reportNull$$$0(4);
        }
        return jComponent;
    }

    @NotNull
    public ActionToolbar getToolbar() {
        ActionToolbarImpl actionToolbarImpl = this.myToolbar;
        if (actionToolbarImpl == null) {
            UmlGraphComponent.$$$reportNull$$$0(5);
        }
        return actionToolbarImpl;
    }

    @Nullable
    public DefaultActionGroup getToolbarActionGroup() {
        return (DefaultActionGroup)ObjectUtils.tryCast((Object)this.myToolbar.getActionGroup(), DefaultActionGroup.class);
    }

    public void setLoading(boolean loading) {
        this.myCard.show(this.myComponent, loading ? COMPUTING_CARD_ID : GRAPH_CARD_ID);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myViewport);
        this.myBuilder = null;
    }

    @NotNull
    private static ActionToolbar createToolbar(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            UmlGraphComponent.$$$reportNull$$$0(6);
        }
        DefaultActionGroup toolbarActions = builder.getProvider().getExtras().getToolbarActionsProvider().createToolbarActions(builder);
        ActionToolbar toolbar = UmlGraphComponent.createToolbarPanel(toolbarActions);
        toolbar.setTargetComponent(builder.getView().getJComponent());
        ActionToolbar actionToolbar = toolbar;
        if (actionToolbar == null) {
            UmlGraphComponent.$$$reportNull$$$0(7);
        }
        return actionToolbar;
    }

    @NotNull
    private static JComponent createToolbarComponent(@NotNull DiagramBuilder builder, @NotNull ActionToolbar actionToolbar) {
        if (builder == null) {
            UmlGraphComponent.$$$reportNull$$$0(8);
        }
        if (actionToolbar == null) {
            UmlGraphComponent.$$$reportNull$$$0(9);
        }
        JComponent component = actionToolbar.getComponent();
        component.setBackground(builder.getProvider().getColorManager().getToolbarBackground());
        component.setBorder(JBUI.Borders.compound((Border)JBUI.Borders.customLineBottom((Color)JBColor.border()), (Border)JBUI.Borders.empty((int)1, (int)0)));
        JComponent jComponent = component;
        if (jComponent == null) {
            UmlGraphComponent.$$$reportNull$$$0(10);
        }
        return jComponent;
    }

    @NotNull
    public static ActionToolbar createToolbarPanel(@NotNull DefaultActionGroup actionsGroup) {
        if (actionsGroup == null) {
            UmlGraphComponent.$$$reportNull$$$0(11);
        }
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add((AnAction)actionsGroup);
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("Diagrams", (ActionGroup)actions, true);
        if (actionToolbar == null) {
            UmlGraphComponent.$$$reportNull$$$0(12);
        }
        return actionToolbar;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 7, 10, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionToolbar";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/components/UmlGraphComponent";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionsGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/components/UmlGraphComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbar";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarComponent";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createToolbar";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createToolbarComponent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createToolbarPanel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 7, 10, 12 -> new IllegalStateException(string);
        };
    }
}

