/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.DiagramRelationshipInfoAdapter;
import com.intellij.diagram.presentation.DiagramLineType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiFilter;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangeTracker<N extends PsiNamedElement, E extends PsiNamedElement, R extends PsiElement> {
    @Nullable
    private final PsiFile myBefore;
    @Nullable
    private final PsiFile myAfter;
    private final Project myProject;
    public static final DiagramRelationshipInfo EXTENDS_DELETED = new DiagramRelationshipInfoAdapter.Builder().setName("EXTENDS_DELETED").setSourceArrow(DiagramRelationshipInfo.DELTA).setUpperCenterLabel("removed").create();
    public static final DiagramRelationshipInfo IMPLEMENTS_DELETED = new DiagramRelationshipInfoAdapter.Builder().setName("IMPLEMENTS_DELETED").setLineType(DiagramLineType.DASHED).setSourceArrow(DiagramRelationshipInfo.DELTA).setUpperCenterLabel("removed").create();
    public static final DiagramRelationshipInfo EXTENDS_ADDED = new DiagramRelationshipInfoAdapter.Builder().setName("EXTENDS_ADDED").setSourceArrow(DiagramRelationshipInfo.DELTA).create();
    public static final DiagramRelationshipInfo IMPLEMENTS_ADDED = new DiagramRelationshipInfoAdapter.Builder().setName("IMPLEMENTS_ADDED").setLineType(DiagramLineType.DASHED).setSourceArrow(DiagramRelationshipInfo.DELTA).create();
    public static final DiagramRelationshipInfo INNER = new DiagramRelationshipInfoAdapter.Builder().setName("INNER").setLineType(DiagramLineType.SOLID).setSourceArrow(DiagramRelationshipInfo.INNER_CLASS_ARROW).create();

    public ChangeTracker(Project project, @Nullable PsiFile before, @Nullable PsiFile after) {
        this.myProject = project;
        assert (before != null || after != null) : "One of files must be not null";
        this.myBefore = before;
        this.myAfter = after;
    }

    @Nullable
    public PsiFile getBefore() {
        return this.myBefore;
    }

    @Nullable
    public PsiFile getAfter() {
        return this.myAfter;
    }

    public Project getProject() {
        return this.myProject;
    }

    public abstract PsiFilter<N>[] getNodeFilters();

    public abstract PsiFilter<E>[] getNodeContentFilters();

    public PsiFilter<R>[] getRelationshipFilters() {
        return PsiFilter.EMPTY;
    }

    @Nullable
    public String getQualifiedName(N e, VirtualFile containingFile) {
        return containingFile == null ? null : containingFile.getPath();
    }

    @NlsSafe
    public String getPresentableName(PsiNamedElement e) {
        return e.getName();
    }

    @Nullable
    @NlsSafe
    public String getType(E e) {
        return null;
    }

    public Icon getIcon(PsiNamedElement e) {
        return e.getIcon(1);
    }

    @NotNull
    public final PsiFile getNotNullFile() {
        assert (this.myAfter != null || this.myBefore != null);
        PsiFile psiFile = this.myAfter == null ? this.myBefore : this.myAfter;
        if (psiFile == null) {
            ChangeTracker.$$$reportNull$$$0(0);
        }
        return psiFile;
    }

    public abstract Map<N, FileStatus> getNodeElements();

    public abstract RelationshipInfo[] getRelationships();

    @Nullable
    public abstract PsiNamedElement findElementByFQN(Project var1, String var2);

    public boolean isContainerFor(N n, E e) {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagram/ChangeTracker", "getNotNullFile"));
    }

    public static class RelationshipInfo {
        public static final RelationshipInfo[] EMPTY = new RelationshipInfo[0];
        public final EdgeType type;
        public final FileStatus status;
        public final String fromFQN;
        public final String toFQN;

        public RelationshipInfo(String fromFQN, String toFQN, EdgeType type, FileStatus status) {
            this.fromFQN = fromFQN;
            this.toFQN = toFQN;
            this.type = type;
            this.status = status;
        }

        public DiagramRelationshipInfo getLineType() {
            if (this.type == EdgeType.INNER) {
                return INNER;
            }
            return this.type == EdgeType.EXTENDS ? (this.status == FileStatus.DELETED ? EXTENDS_DELETED : EXTENDS_ADDED) : (this.status == FileStatus.DELETED ? IMPLEMENTS_DELETED : IMPLEMENTS_ADDED);
        }
    }

    public static enum EdgeType {
        EXTENDS,
        IMPLEMENTS,
        INNER;

    }
}

