/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.service;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.packageChecker.model.SeverityFactory;
import com.intellij.packageChecker.service.Checked;
import com.intellij.packageChecker.service.Malicious;
import com.intellij.packageChecker.service.MaliciousPackage;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.problems.vulnerabilities.Severity;
import org.jetbrains.security.problems.vulnerabilities.Vulnerability;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0011\u001a\u00020\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0010\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lcom/intellij/packageChecker/service/Malicious;", "Lcom/intellij/packageChecker/service/Checked;", "maliciousPackage", "Lcom/intellij/packageChecker/service/MaliciousPackage;", "checkTime", "Ljava/util/Date;", "(Lcom/intellij/packageChecker/service/MaliciousPackage;Ljava/util/Date;)V", "getCheckTime", "()Ljava/util/Date;", "getMaliciousPackage", "()Lcom/intellij/packageChecker/service/MaliciousPackage;", "maxSeverity", "Lorg/jetbrains/security/problems/vulnerabilities/Severity;", "getMaxSeverity", "()Lorg/jetbrains/security/problems/vulnerabilities/Severity;", "maxSeverity$delegate", "Lkotlin/Lazy;", "problemHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "getProblemHighlightType", "()Lcom/intellij/codeInspection/ProblemHighlightType;", "problemHighlightType$delegate", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.packageChecker"})
public final class Malicious
extends Checked {
    @NotNull
    private final MaliciousPackage maliciousPackage;
    @NotNull
    private final Date checkTime;
    @NotNull
    private final Lazy maxSeverity$delegate;
    @NotNull
    private final Lazy problemHighlightType$delegate;

    public Malicious(@NotNull MaliciousPackage maliciousPackage, @NotNull Date checkTime) {
        Intrinsics.checkNotNullParameter((Object)maliciousPackage, (String)"maliciousPackage");
        Intrinsics.checkNotNullParameter((Object)checkTime, (String)"checkTime");
        super(maliciousPackage.getVulnerablePackage().getPkg(), checkTime, null);
        this.maliciousPackage = maliciousPackage;
        this.checkTime = checkTime;
        this.maxSeverity$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Severity>(this){
            final /* synthetic */ Malicious this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Severity invoke() {
                Iterator<T> iterator = ((Iterable)this.this$0.getMaliciousPackage().getVulnerablePackage().getVulnerabilities()).iterator();
                if (!iterator.hasNext()) {
                    throw new NoSuchElementException();
                }
                Vulnerability it = (Vulnerability)iterator.next();
                boolean bl = false;
                float f = it.getCvssScore();
                while (iterator.hasNext()) {
                    Vulnerability it2 = (Vulnerability)iterator.next();
                    $i$a$-maxOf-Malicious$maxSeverity$2$maxScore$1 = false;
                    float f2 = it2.getCvssScore();
                    f = Math.max(f, f2);
                }
                float maxScore = f;
                return SeverityFactory.Companion.fromScore(maxScore);
            }
        }));
        this.problemHighlightType$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ProblemHighlightType>(this){
            final /* synthetic */ Malicious this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ProblemHighlightType invoke() {
                return switch (problemHighlightType.WhenMappings.$EnumSwitchMapping$0[this.this$0.getMaxSeverity().getType().ordinal()]) {
                    case 1 -> ProblemHighlightType.WEAK_WARNING;
                    case 2 -> ProblemHighlightType.WEAK_WARNING;
                    case 3 -> ProblemHighlightType.WARNING;
                    case 4 -> ProblemHighlightType.ERROR;
                    default -> throw new NoWhenBranchMatchedException();
                };
            }
        }));
    }

    @NotNull
    public final MaliciousPackage getMaliciousPackage() {
        return this.maliciousPackage;
    }

    @Override
    @NotNull
    public Date getCheckTime() {
        return this.checkTime;
    }

    @NotNull
    public final Severity getMaxSeverity() {
        Lazy lazy = this.maxSeverity$delegate;
        return (Severity)lazy.getValue();
    }

    @NotNull
    public final ProblemHighlightType getProblemHighlightType() {
        Lazy lazy = this.problemHighlightType$delegate;
        return (ProblemHighlightType)lazy.getValue();
    }

    @NotNull
    public final MaliciousPackage component1() {
        return this.maliciousPackage;
    }

    @NotNull
    public final Date component2() {
        return this.checkTime;
    }

    @NotNull
    public final Malicious copy(@NotNull MaliciousPackage maliciousPackage, @NotNull Date checkTime) {
        Intrinsics.checkNotNullParameter((Object)maliciousPackage, (String)"maliciousPackage");
        Intrinsics.checkNotNullParameter((Object)checkTime, (String)"checkTime");
        return new Malicious(maliciousPackage, checkTime);
    }

    public static /* synthetic */ Malicious copy$default(Malicious malicious, MaliciousPackage maliciousPackage, Date date, int n, Object object) {
        if ((n & 1) != 0) {
            maliciousPackage = malicious.maliciousPackage;
        }
        if ((n & 2) != 0) {
            date = malicious.checkTime;
        }
        return malicious.copy(maliciousPackage, date);
    }

    @NotNull
    public String toString() {
        return "Malicious(maliciousPackage=" + this.maliciousPackage + ", checkTime=" + this.checkTime + ")";
    }

    public int hashCode() {
        int result = this.maliciousPackage.hashCode();
        result = result * 31 + this.checkTime.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Malicious)) {
            return false;
        }
        Malicious malicious = (Malicious)other;
        if (!Intrinsics.areEqual((Object)this.maliciousPackage, (Object)malicious.maliciousPackage)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.checkTime, (Object)malicious.checkTime);
    }
}

