/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.python;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageChecker.api.BuildFileProvider;
import com.intellij.packageChecker.api.PackageDeclaration;
import com.intellij.packageChecker.python.PoetryBuildFileProvider;
import com.intellij.packageChecker.python.TextedPythonDependenciesModel;
import com.intellij.packageChecker.service.PackageCheckerDisposable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.python.extensions.VirtualFileExtKt;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.sdk.poetry.PoetryKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.toml.lang.psi.TomlFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/packageChecker/python/PoetryDependenciesModel;", "Lcom/intellij/packageChecker/python/TextedPythonDependenciesModel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "declaredDependencies", "", "Lcom/intellij/packageChecker/api/PackageDeclaration;", "module", "Lcom/intellij/openapi/module/Module;", "findBuildFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "findCorrespondingBuildFileProvider", "Lcom/intellij/packageChecker/python/PoetryBuildFileProvider;", "intellij.packageChecker.python"})
public final class PoetryDependenciesModel
extends TextedPythonDependenciesModel
implements Disposable {
    @NotNull
    private final Project project;

    public PoetryDependenciesModel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.project = project;
        Disposer.register((Disposable)PackageCheckerDisposable.Companion.getInstance(this.project), (Disposable)this);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = PyPackageManager.PACKAGE_MANAGER_TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"PACKAGE_MANAGER_TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> PoetryDependenciesModel._init_$lambda$0(this, arg_0));
    }

    @Override
    @NotNull
    public PoetryBuildFileProvider findCorrespondingBuildFileProvider() {
        return (PoetryBuildFileProvider)BuildFileProvider.Companion.getEP_NAME().findExtensionOrFail(PoetryBuildFileProvider.class, (AreaInstance)this.project);
    }

    @Override
    @Nullable
    public VirtualFile findBuildFile(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return PoetryKt.getPyProjectToml((Module)module);
    }

    @Override
    @NotNull
    public List<PackageDeclaration> declaredDependencies(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Object object = ReadAction.compute(() -> PoetryDependenciesModel.declaredDependencies$lambda$1(module, this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (List)object;
    }

    private static final void _init_$lambda$0(PoetryDependenciesModel this$0, Sdk it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.refresh(this$0.project);
    }

    private static final List declaredDependencies$lambda$1(Module $module, PoetryDependenciesModel this$0) {
        Intrinsics.checkNotNullParameter((Object)$module, (String)"$module");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        VirtualFile virtualFile = PoetryKt.getPyProjectToml((Module)$module);
        PsiFileSystemItem psiFileSystemItem = virtualFile != null ? VirtualFileExtKt.toPsi((VirtualFile)virtualFile, (Project)this$0.project) : null;
        TomlFile tomlFile = psiFileSystemItem instanceof TomlFile ? (TomlFile)psiFileSystemItem : null;
        if (tomlFile == null) {
            return CollectionsKt.emptyList();
        }
        TomlFile tomlFile2 = tomlFile;
        return this$0.findCorrespondingBuildFileProvider().declaredDependencies((PsiFile)tomlFile2);
    }
}

