/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.visualEditing.templates;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.codeInsight.template.macro.CompleteMacro;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.swagger.core.visualEditing.SwGenerationRelativePosition;
import com.intellij.swagger.core.visualEditing.SwGutterActionData;
import com.intellij.swagger.core.visualEditing.templates.SwPreparedTemplate;
import com.intellij.swagger.core.visualEditing.templates.SwTemplateInsertionStrategy;
import com.intellij.swagger.core.visualEditing.templates.SwVariableExpressionData;
import com.intellij.swagger.core.visualEditing.templates.SwVersionAwareTemplateText;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u0005B\u000f\b\u0004\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0007J\u0017\u0010\u000b\u001a\u0004\u0018\u00018\u00012\u0006\u0010\f\u001a\u00020\rH$\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J;\u0010\u000f\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00028\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u001cJ\u001f\u0010\u001d\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010\u001fR\u0013\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\t\u0082\u0001\u0002 !\u00a8\u0006\""}, d2={"Lcom/intellij/swagger/core/visualEditing/templates/SwLanguageAwareTemplateAdapter;", "Psi", "Lcom/intellij/psi/PsiElement;", "Strategy", "Lcom/intellij/swagger/core/visualEditing/templates/SwTemplateInsertionStrategy;", "", "highlightedElement", "(Lcom/intellij/psi/PsiElement;)V", "getHighlightedElement", "()Lcom/intellij/psi/PsiElement;", "Lcom/intellij/psi/PsiElement;", "chooseInsertionStrategy", "relativePosition", "Lcom/intellij/swagger/core/visualEditing/SwGenerationRelativePosition;", "(Lcom/intellij/swagger/core/visualEditing/SwGenerationRelativePosition;)Lcom/intellij/swagger/core/visualEditing/templates/SwTemplateInsertionStrategy;", "createLiveTemplateWithVariables", "Lcom/intellij/swagger/core/visualEditing/templates/SwPreparedTemplate;", "actionData", "Lcom/intellij/swagger/core/visualEditing/SwGutterActionData;", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/codeInsight/template/Template;", "effectiveTemplateText", "", "completionMap", "", "Lcom/intellij/swagger/core/visualEditing/templates/SwVariableExpressionData;", "insertionStrategy", "(Ljava/lang/String;Ljava/util/Map;Lcom/intellij/swagger/core/visualEditing/templates/SwTemplateInsertionStrategy;Lcom/intellij/openapi/project/Project;)Lcom/intellij/codeInsight/template/Template;", "formatTemplateText", "templateText", "(Ljava/lang/String;Lcom/intellij/swagger/core/visualEditing/templates/SwTemplateInsertionStrategy;)Ljava/lang/String;", "Lcom/intellij/swagger/core/visualEditing/templates/SwJsonTemplateLanguageAdapter;", "Lcom/intellij/swagger/core/visualEditing/templates/SwYamlTemplateLanguageAdapter;", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwTemplateLanguageAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwTemplateLanguageAdapter.kt\ncom/intellij/swagger/core/visualEditing/templates/SwLanguageAwareTemplateAdapter\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,67:1\n215#2,2:68\n*S KotlinDebug\n*F\n+ 1 SwTemplateLanguageAdapter.kt\ncom/intellij/swagger/core/visualEditing/templates/SwLanguageAwareTemplateAdapter\n*L\n43#1:68,2\n*E\n"})
public abstract class SwLanguageAwareTemplateAdapter<Psi extends PsiElement, Strategy extends SwTemplateInsertionStrategy> {
    @NotNull
    private final Psi highlightedElement;

    private SwLanguageAwareTemplateAdapter(Psi highlightedElement) {
        this.highlightedElement = highlightedElement;
    }

    @NotNull
    public final Psi getHighlightedElement() {
        return this.highlightedElement;
    }

    @Nullable
    protected abstract Strategy chooseInsertionStrategy(@NotNull SwGenerationRelativePosition var1);

    @Nullable
    protected abstract String formatTemplateText(@NotNull String var1, @NotNull Strategy var2);

    @Nullable
    public final SwPreparedTemplate createLiveTemplateWithVariables(@NotNull SwGutterActionData actionData, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)actionData, (String)"actionData");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Strategy Strategy = this.chooseInsertionStrategy(actionData.getRelativePosition());
        if (Strategy == null) {
            return null;
        }
        Strategy insertionStrategy = Strategy;
        SwVersionAwareTemplateText swVersionAwareTemplateText = actionData.getTemplateData().templateTextForSpecification(actionData.getTargetSpecificationType());
        if (swVersionAwareTemplateText == null) {
            return null;
        }
        SwVersionAwareTemplateText templateData = swVersionAwareTemplateText;
        String string = this.formatTemplateText(templateData.getRawText(), insertionStrategy);
        if (string == null) {
            return null;
        }
        String effectiveTemplateText = string;
        Template template = this.createLiveTemplateWithVariables(effectiveTemplateText, templateData.getCompletionMap(), insertionStrategy, project);
        if (template == null) {
            return null;
        }
        Template liveTemplate = template;
        return new SwPreparedTemplate(((SwTemplateInsertionStrategy)insertionStrategy).getTemplateStartOffset(), liveTemplate);
    }

    private final Template createLiveTemplateWithVariables(String effectiveTemplateText, Map<String, ? extends SwVariableExpressionData> completionMap, Strategy insertionStrategy, Project project) {
        Template template;
        Template $this$createLiveTemplateWithVariables_u24lambda_u241 = template = TemplateManager.getInstance((Project)project).createTemplate("", "", effectiveTemplateText);
        boolean bl = false;
        Map<String, ? extends SwVariableExpressionData> $this$forEach$iv = completionMap;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends SwVariableExpressionData>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Expression expression2;
            Map.Entry<String, ? extends SwVariableExpressionData> element$iv;
            Map.Entry<String, ? extends SwVariableExpressionData> entry = element$iv = iterator.next();
            boolean bl2 = false;
            String variable = entry.getKey();
            SwVariableExpressionData variableData = entry.getValue();
            SwVariableExpressionData swVariableExpressionData = variableData;
            if (swVariableExpressionData instanceof SwVariableExpressionData.Constant) {
                String string = (String)ArraysKt.firstOrNull((Object[])((SwVariableExpressionData.Constant)variableData).getVariants());
                if (string == null) {
                    string = "";
                }
                String[] stringArray = ((SwVariableExpressionData.Constant)variableData).getVariants();
                expression2 = (Expression)new ConstantNode(string).withLookupStrings(Arrays.copyOf(stringArray, stringArray.length));
            } else if (swVariableExpressionData instanceof SwVariableExpressionData.CompletionCall) {
                expression2 = (Expression)new MacroCallNode((Macro)new CompleteMacro(){

                    @NotNull
                    public String getDefaultValue() {
                        return "";
                    }
                });
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Expression expression3 = expression2;
            Expression defaultExpression = variableData instanceof SwVariableExpressionData.CompletionCall && ((CharSequence)((SwVariableExpressionData.CompletionCall)variableData).getDefault()).length() > 0 ? (Expression)new ConstantNode(((SwVariableExpressionData.CompletionCall)variableData).getDefault()) : expression3;
            $this$createLiveTemplateWithVariables_u24lambda_u241.addVariable(new Variable(variable, expression3, defaultExpression, true, false));
        }
        $this$createLiveTemplateWithVariables_u24lambda_u241.setToReformat(((SwTemplateInsertionStrategy)insertionStrategy).getEnableIjTemplateFormatting());
        $this$createLiveTemplateWithVariables_u24lambda_u241.setToIndent(((SwTemplateInsertionStrategy)insertionStrategy).getEnableIjTemplateFormatting());
        return template;
    }

    public /* synthetic */ SwLanguageAwareTemplateAdapter(PsiElement highlightedElement, DefaultConstructorMarker $constructor_marker) {
        this(highlightedElement);
    }
}

