/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.ui.rest;

import com.intellij.swagger.core.ErrorType;
import com.intellij.swagger.core.SwaggerBundle;
import com.intellij.swagger.core.SwaggerFailure;
import com.intellij.swagger.core.SwaggerResource;
import com.intellij.swagger.core.SwaggerResult;
import com.intellij.swagger.core.ui.SwPreviewType;
import com.intellij.swagger.core.ui.rest.SwSpecFileProviderKt;
import com.intellij.swagger.core.ui.rest.SwUrlParser;
import com.intellij.swagger.core.ui.rest.SwWebServerRequestType;
import com.intellij.swagger.core.ui.rest.SwaggerRequestHandlerKt;
import com.intellij.swagger.core.ui.rest.resource.AsyncapiResourceProvider;
import com.intellij.swagger.core.ui.rest.resource.ErrorHandlerKt;
import com.intellij.swagger.core.ui.rest.resource.RedocResourceProvider;
import com.intellij.swagger.core.ui.rest.resource.SwPreviewResourceProvider;
import com.intellij.swagger.core.ui.rest.resource.SwPreviewResourceProviderKt;
import com.intellij.swagger.core.ui.rest.resource.SwaggerUiResourceProvider;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.stream.ChunkedStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J*\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u001c\u001a\u00020\u001dH\u0002JP\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\u0014\b\u0002\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0&H\u0002J\f\u0010'\u001a\u00020\u001b*\u00020(H\u0002\u00a8\u0006)"}, d2={"Lcom/intellij/swagger/core/ui/rest/SwaggerRequestHandler;", "Lorg/jetbrains/ide/HttpRequestHandler;", "()V", "getCustomBundledResource", "Lcom/intellij/swagger/core/SwaggerResult;", "Lcom/intellij/swagger/core/SwaggerResource;", "urlParser", "Lcom/intellij/swagger/core/ui/rest/SwUrlParser;", "resourceProvider", "Lcom/intellij/swagger/core/ui/rest/resource/SwPreviewResourceProvider;", "getHtml", "getLibraryResource", "isSupported", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "process", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "context", "Lio/netty/channel/ChannelHandlerContext;", "processRequest", "", "channel", "Lio/netty/channel/Channel;", "sendError", "status", "Lio/netty/handler/codec/http/HttpResponseStatus;", "error", "", "sendResponse", "Lio/netty/handler/codec/http/HttpRequest;", "inputStream", "Ljava/io/InputStream;", "contentType", "contentLength", "", "headers", "", "toStatus", "Lcom/intellij/swagger/core/ErrorType;", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwaggerRequestHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwaggerRequestHandler.kt\ncom/intellij/swagger/core/ui/rest/SwaggerRequestHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,195:1\n1#2:196\n215#3,2:197\n*S KotlinDebug\n*F\n+ 1 SwaggerRequestHandler.kt\ncom/intellij/swagger/core/ui/rest/SwaggerRequestHandler\n*L\n129#1:197,2\n*E\n"})
public final class SwaggerRequestHandler
extends HttpRequestHandler {
    public boolean isSupported(@NotNull FullHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return new SwUrlParser(request, null, 2, null).isRequestFromPreviewEditor();
    }

    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        block3: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (!Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.GET)) {
                Channel channel = context.channel();
                Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
                HttpResponseStatus httpResponseStatus = HttpResponseStatus.METHOD_NOT_ALLOWED;
                Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"METHOD_NOT_ALLOWED");
                this.sendError(channel, httpResponseStatus, request, SwaggerBundle.message("preview.error.only.get.method.is.supported", new Object[0]));
                return true;
            }
            Object object2 = this;
            try {
                SwaggerRequestHandler $this$process_u24lambda_u240 = object2;
                boolean bl = false;
                SwUrlParser swUrlParser = new SwUrlParser(request, urlDecoder);
                Channel channel = context.channel();
                Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
                $this$process_u24lambda_u240.processRequest(swUrlParser, request, channel);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block3;
            Object throwable2 = object = throwable;
            boolean bl = false;
            SwaggerRequestHandlerKt.access$getLogger().warn("Could not send response", (Throwable)throwable2);
            Channel channel = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.INTERNAL_SERVER_ERROR;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"INTERNAL_SERVER_ERROR");
            this.sendError(channel, httpResponseStatus, request, SwaggerBundle.message("preview.error.internal.server.error", new Object[0]));
        }
        return true;
    }

    private final void processRequest(SwUrlParser urlParser, FullHttpRequest request, Channel channel) {
        SwPreviewResourceProvider swPreviewResourceProvider;
        SwPreviewType swPreviewType = urlParser.recognizePreviewType();
        switch (swPreviewType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[swPreviewType.ordinal()]) {
            case 1: {
                swPreviewResourceProvider = new RedocResourceProvider();
                break;
            }
            case 2: {
                swPreviewResourceProvider = new SwaggerUiResourceProvider();
                break;
            }
            case 3: {
                swPreviewResourceProvider = new AsyncapiResourceProvider();
                break;
            }
            default: {
                HttpResponseStatus httpResponseStatus = HttpResponseStatus.BAD_REQUEST;
                Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"BAD_REQUEST");
                this.sendError(channel, httpResponseStatus, request, SwaggerBundle.message("preview.error.no.metadata.provided", new Object[0]));
                return;
            }
        }
        SwPreviewResourceProvider resourceProvider = swPreviewResourceProvider;
        SwWebServerRequestType swWebServerRequestType = urlParser.recognizeRequestType();
        SwaggerResult<SwaggerResource> swaggerResource = switch (swWebServerRequestType == null ? -1 : WhenMappings.$EnumSwitchMapping$1[swWebServerRequestType.ordinal()]) {
            case 1 -> SwSpecFileProviderKt.getSpecification(urlParser, resourceProvider);
            case 2 -> this.getLibraryResource(urlParser, resourceProvider);
            case 3 -> this.getHtml(urlParser, resourceProvider);
            case 4 -> ErrorHandlerKt.getErrorHandlingScript(resourceProvider);
            case 5 -> ErrorHandlerKt.getErrorHtmlTemplate();
            case 6 -> this.getCustomBundledResource(urlParser, resourceProvider);
            default -> {
                Object[] var7_5 = new Object[]{urlParser.getPresentableUrl$intellij_swagger_core()};
                yield SwaggerResult.Companion.failure(ErrorType.DOES_NOT_EXIST, SwaggerBundle.message("preview.error.unknown.path", var7_5), "Request was not processed because it has unrecognized type. Request url: " + urlParser.getPresentableUrl$intellij_swagger_core());
            }
        };
        if (swaggerResource.isFailure()) {
            SwaggerFailure $this$processRequest_u24lambda_u242 = swaggerResource.getFailureOrThrow();
            boolean bl = false;
            SwaggerRequestHandlerKt.access$getLogger().warn("Failed to retrieve resource: " + request.uri() + ", error: " + $this$processRequest_u24lambda_u242.getInternalMessage());
            String error = ErrorHandlerKt.generateErrorView($this$processRequest_u24lambda_u242);
            this.sendError(channel, this.toStatus($this$processRequest_u24lambda_u242.getType()), request, error);
        } else {
            SwaggerResource $this$processRequest_u24lambda_u243 = swaggerResource.getSuccessOrThrow();
            boolean bl = false;
            SwaggerRequestHandler.sendResponse$default(this, (HttpRequest)request, channel, new ByteArrayInputStream($this$processRequest_u24lambda_u243.getResource()), $this$processRequest_u24lambda_u243.getContentType(), $this$processRequest_u24lambda_u243.getResource().length, null, null, 96, null);
        }
    }

    private final HttpResponseStatus toStatus(ErrorType $this$toStatus) {
        HttpResponseStatus httpResponseStatus;
        switch (WhenMappings.$EnumSwitchMapping$2[$this$toStatus.ordinal()]) {
            case 1: {
                HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.NOT_FOUND;
                httpResponseStatus = httpResponseStatus2;
                Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus2, (String)"NOT_FOUND");
                break;
            }
            case 2: 
            case 3: {
                HttpResponseStatus httpResponseStatus3 = HttpResponseStatus.METHOD_NOT_ALLOWED;
                httpResponseStatus = httpResponseStatus3;
                Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus3, (String)"METHOD_NOT_ALLOWED");
                break;
            }
            case 4: 
            case 5: {
                HttpResponseStatus httpResponseStatus4 = HttpResponseStatus.BAD_REQUEST;
                httpResponseStatus = httpResponseStatus4;
                Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus4, (String)"BAD_REQUEST");
                break;
            }
            case 6: {
                HttpResponseStatus httpResponseStatus5 = HttpResponseStatus.INTERNAL_SERVER_ERROR;
                httpResponseStatus = httpResponseStatus5;
                Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus5, (String)"INTERNAL_SERVER_ERROR");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return httpResponseStatus;
    }

    private final void sendError(Channel channel, HttpResponseStatus status, FullHttpRequest request, @Nls String error) {
        SwaggerResult<SwaggerResource> prettyCustomErrorPage = ErrorHandlerKt.getErrorHtml(error);
        if (prettyCustomErrorPage.isFailure()) {
            byte[] byArray = error.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((byte[])byArray));
            Responses.send$default((HttpResponse)((HttpResponse)response), (Channel)channel, (HttpRequest)((HttpRequest)request), null, (int)4, null);
        } else {
            SwaggerResource success = prettyCustomErrorPage.getSuccessOrThrow();
            Map headers = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Show-Ide-Error", (Object)"true"));
            this.sendResponse((HttpRequest)request, channel, new ByteArrayInputStream(success.getResource()), success.getContentType(), success.getResource().length, status, headers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sendResponse(HttpRequest request, Channel channel, InputStream inputStream, String contentType, int contentLength, HttpResponseStatus status, Map<String, String> headers) {
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            DefaultHttpResponse response;
            InputStream stream = (InputStream)closeable;
            boolean bl = false;
            DefaultHttpResponse $this$sendResponse_u24lambda_u246_u24lambda_u245 = response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
            boolean bl2 = false;
            Map<String, String> $this$forEach$iv = headers;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> entry = element$iv = iterator.next();
                boolean bl3 = false;
                String name2 = entry.getKey();
                String value = entry.getValue();
                $this$sendResponse_u24lambda_u246_u24lambda_u245.headers().set(name2, (Object)value);
            }
            $this$sendResponse_u24lambda_u246_u24lambda_u245.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)(contentType + "; charset=" + Charsets.UTF_8.name()));
            $this$sendResponse_u24lambda_u246_u24lambda_u245.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)contentLength);
            $this$sendResponse_u24lambda_u246_u24lambda_u245.headers().set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"private, must-revalidate");
            $this$sendResponse_u24lambda_u246_u24lambda_u245.headers().set((CharSequence)HttpHeaderNames.LAST_MODIFIED, (Object)new Date(Calendar.getInstance().getTimeInMillis()));
            Responses.addCommonHeaders((HttpResponse)((HttpResponse)$this$sendResponse_u24lambda_u246_u24lambda_u245));
            channel.write((Object)response);
            channel.write((Object)new ChunkedStream(stream));
            Responses.send$default((HttpResponse)((HttpResponse)response), (Channel)channel, (HttpRequest)request, null, (int)4, null);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    static /* synthetic */ void sendResponse$default(SwaggerRequestHandler swaggerRequestHandler, HttpRequest httpRequest, Channel channel, InputStream inputStream, String string, int n, HttpResponseStatus httpResponseStatus, Map map2, int n2, Object object) {
        if ((n2 & 0x20) != 0) {
            HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.OK;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus2, (String)"OK");
            httpResponseStatus = httpResponseStatus2;
        }
        if ((n2 & 0x40) != 0) {
            map2 = MapsKt.emptyMap();
        }
        swaggerRequestHandler.sendResponse(httpRequest, channel, inputStream, string, n, httpResponseStatus, map2);
    }

    private final SwaggerResult<SwaggerResource> getCustomBundledResource(SwUrlParser urlParser, SwPreviewResourceProvider resourceProvider) {
        return resourceProvider.getDynamicResource(urlParser);
    }

    private final SwaggerResult<SwaggerResource> getLibraryResource(SwUrlParser urlParser, SwPreviewResourceProvider resourceProvider) {
        String string = urlParser.recognizeResourcePath();
        if (string == null) {
            return SwPreviewResourceProviderKt.unknownResourceRequested(urlParser.getPresentableUrl$intellij_swagger_core(), "Failed to recognize resourcePath");
        }
        String resourcePath = string;
        return SwPreviewResourceProviderKt.wrapVirtualFileResult(resourceProvider.getLibraryResource(resourcePath));
    }

    private final SwaggerResult<SwaggerResource> getHtml(SwUrlParser urlParser, SwPreviewResourceProvider resourceProvider) {
        UUID specificationId = urlParser.recognizeSpecificationId-2Wqz4Ao();
        if (specificationId == null) {
            Object[] objectArray = new Object[]{urlParser.getPresentableUrl$intellij_swagger_core()};
            return SwaggerResult.Companion.failure(ErrorType.DOES_NOT_EXIST, SwaggerBundle.message("preview.error.unknown.path", objectArray), "Unknown specification key was provided: " + urlParser.getPresentableUrl$intellij_swagger_core());
        }
        SwaggerResult<String> htmlResult = resourceProvider.getMainHtmlPage-Y7tB9Ug(specificationId);
        if (htmlResult.isFailure()) {
            return SwaggerResult.Companion.failure(htmlResult.getFailureOrThrow());
        }
        String html = htmlResult.getSuccessOrThrow();
        byte[] byArray = html.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return SwaggerResult.Companion.success(new SwaggerResource(byArray, "text/html"));
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[SwPreviewType.values().length];
            try {
                nArray[SwPreviewType.REDOC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SwPreviewType.SWAGGER_UI.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SwPreviewType.ASYNCAPI.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SwWebServerRequestType.values().length];
            try {
                nArray[SwWebServerRequestType.SPECIFICATION_FILE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SwWebServerRequestType.LIBRARY_RESOURCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SwWebServerRequestType.HTML_FILE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SwWebServerRequestType.ERROR_SCRIPT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SwWebServerRequestType.ERROR_PAGE_TEMPLATE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SwWebServerRequestType.CUSTOM_BUNDLED_RESOURCE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[ErrorType.values().length];
            try {
                nArray[ErrorType.DOES_NOT_EXIST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorType.NOT_ALLOWED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorType.NOT_IN_WHITE_LIST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorType.UNABLE_TO_CONVERT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorType.VALIDATION.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorType.UNKNOWN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

