/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.ui.browser;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.swagger.core.SwaggerBundle;
import com.intellij.swagger.core.ui.SwPreviewType;
import com.intellij.swagger.core.ui.browser.SwPreviewCefBrowser;
import com.intellij.swagger.core.ui.browser.strategy.SwPreviewCustomization;
import com.intellij.swagger.core.ui.browser.strategy.SwPreviewProviderStrategy;
import com.intellij.swagger.core.ui.rest.SwSpecFileProviderKt;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefClient;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\nH\u0002J\u000e\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\nJ\b\u0010\u001b\u001a\u00020\u0015H\u0016J\b\u0010\u001c\u001a\u00020\u0015H\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0004H\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u001eH\u0016J\u0006\u0010#\u001a\u00020$J\b\u0010%\u001a\u00020\rH\u0016J\b\u0010&\u001a\u00020\rH\u0016J\u0010\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u0004H\u0002J&\u0010)\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u00042\u0006\u0010*\u001a\u00020+2\u000e\b\u0002\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00150-J\u0006\u0010.\u001a\u00020\u0015J\u0010\u0010/\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u00100\u001a\u00020\u00152\u0006\u00101\u001a\u000202H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/swagger/core/ui/browser/SwPreviewCefBrowser;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "myFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "textEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "myProject", "Lcom/intellij/openapi/project/Project;", "previewProviderStrategy", "Lcom/intellij/swagger/core/ui/browser/strategy/SwPreviewProviderStrategy;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/fileEditor/TextEditor;Lcom/intellij/openapi/project/Project;Lcom/intellij/swagger/core/ui/browser/strategy/SwPreviewProviderStrategy;)V", "isDisposed", "", "myCefBrowser", "Lcom/intellij/ui/jcef/JBCefBrowser;", "myTaskQueue", "Lcom/intellij/openapi/progress/BackgroundTaskQueue;", "previewCustomization", "Lcom/intellij/swagger/core/ui/browser/strategy/SwPreviewCustomization;", "addPropertyChangeListener", "", "listener", "Ljava/beans/PropertyChangeListener;", "applyNewStrategy", "strategy", "applyStrategy", "dispose", "disposeOldStrategy", "getComponent", "Ljavax/swing/JComponent;", "getFile", "getName", "", "getPreferredFocusedComponent", "getSelectedPreviewType", "Lcom/intellij/swagger/core/ui/SwPreviewType;", "isModified", "isValid", "loadHtml", "specification", "loadHtmlInBackground", "backgroundOption", "Lcom/intellij/openapi/progress/PerformInBackgroundOption;", "handleSuccess", "Lkotlin/Function0;", "openDevTools", "removePropertyChangeListener", "setState", "state", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "intellij.swagger.core"})
public final class SwPreviewCefBrowser
extends UserDataHolderBase
implements FileEditor {
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final TextEditor textEditor;
    @NotNull
    private final Project myProject;
    private SwPreviewCustomization previewCustomization;
    private boolean isDisposed;
    @NotNull
    private final JBCefBrowser myCefBrowser;
    @NotNull
    private final BackgroundTaskQueue myTaskQueue;

    public SwPreviewCefBrowser(@NotNull VirtualFile myFile, @NotNull TextEditor textEditor, @NotNull Project myProject, @NotNull SwPreviewProviderStrategy previewProviderStrategy) {
        JBCefClient jBCefClient;
        Intrinsics.checkNotNullParameter((Object)myFile, (String)"myFile");
        Intrinsics.checkNotNullParameter((Object)textEditor, (String)"textEditor");
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)previewProviderStrategy, (String)"previewProviderStrategy");
        this.myFile = myFile;
        this.textEditor = textEditor;
        this.myProject = myProject;
        Object[] objectArray = new Object[]{"OpenAPI Preview Editor"};
        this.myTaskQueue = new BackgroundTaskQueue(this.myProject, SwaggerBundle.message("ui.preparing.component.task.title", objectArray));
        JBCefClient $this$_init__u24lambda_u240 = jBCefClient = JBCefApp.getInstance().createClient();
        boolean bl = false;
        $this$_init__u24lambda_u240.setProperty("JBCefClient.JSQuery.poolSize", (Object)100);
        JBCefClient jBCefClient2 = jBCefClient;
        Intrinsics.checkNotNullExpressionValue((Object)jBCefClient2, (String)"apply(...)");
        JBCefClient client = jBCefClient2;
        JBCefBrowser jBCefBrowser = JBCefBrowser.createBuilder().setUrl("about:blank").setClient(client).build();
        Intrinsics.checkNotNullExpressionValue((Object)jBCefBrowser, (String)"build(...)");
        this.myCefBrowser = jBCefBrowser;
        this.applyNewStrategy(previewProviderStrategy);
        PerformInBackgroundOption performInBackgroundOption = PerformInBackgroundOption.ALWAYS_BACKGROUND;
        Intrinsics.checkNotNullExpressionValue((Object)performInBackgroundOption, (String)"ALWAYS_BACKGROUND");
        SwPreviewCefBrowser.loadHtmlInBackground$default(this, this.myFile, performInBackgroundOption, null, 4, null);
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.textEditor);
        Topic topic = EditorColorsManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> SwPreviewCefBrowser._init_$lambda$1(this, arg_0));
    }

    public final void applyStrategy(@NotNull SwPreviewProviderStrategy strategy) {
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        Project project = this.myProject;
        Object[] objectArray = new Object[]{"OpenAPI Preview Editor"};
        String string = SwaggerBundle.message("ui.preparing.component.task.title", objectArray);
        objectArray = Task.Backgroundable.ALWAYS_BACKGROUND;
        this.myTaskQueue.run(new Task.Backgroundable(this, strategy, project, string, (PerformInBackgroundOption)objectArray){
            final /* synthetic */ SwPreviewCefBrowser this$0;
            final /* synthetic */ SwPreviewProviderStrategy $strategy;
            {
                this.this$0 = $receiver;
                this.$strategy = $strategy;
                super($super_call_param$1, $super_call_param$2, true, $super_call_param$3);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                SwPreviewCefBrowser.access$disposeOldStrategy(this.this$0);
                SwPreviewCefBrowser.access$applyNewStrategy(this.this$0, this.$strategy);
                SwPreviewCefBrowser.access$loadHtml(this.this$0, SwPreviewCefBrowser.access$getMyFile$p(this.this$0));
            }
        });
    }

    private final void disposeOldStrategy() {
        SwPreviewCustomization swPreviewCustomization = this.previewCustomization;
        if (swPreviewCustomization == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"previewCustomization");
            swPreviewCustomization = null;
        }
        swPreviewCustomization.removeFrom(this.textEditor, this.myCefBrowser);
    }

    private final void applyNewStrategy(SwPreviewProviderStrategy strategy) {
        this.previewCustomization = strategy.installOn(this.textEditor, this.myCefBrowser, this.myFile, this.myProject);
    }

    @NotNull
    public final SwPreviewType getSelectedPreviewType() {
        SwPreviewCustomization swPreviewCustomization = this.previewCustomization;
        if (swPreviewCustomization == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"previewCustomization");
            swPreviewCustomization = null;
        }
        return swPreviewCustomization.getPreviewType();
    }

    public final void loadHtmlInBackground(@NotNull VirtualFile specification, @NotNull PerformInBackgroundOption backgroundOption, @NotNull Function0<Unit> handleSuccess) {
        Intrinsics.checkNotNullParameter((Object)specification, (String)"specification");
        Intrinsics.checkNotNullParameter((Object)backgroundOption, (String)"backgroundOption");
        Intrinsics.checkNotNullParameter(handleSuccess, (String)"handleSuccess");
        this.myTaskQueue.clear();
        Project project = this.myProject;
        Object[] objectArray = new Object[]{"OpenAPI Preview Editor"};
        String string = SwaggerBundle.message("ui.preparing.component.task.title", objectArray);
        this.myTaskQueue.run(new Task.Backgroundable(backgroundOption, this, specification, handleSuccess, project, string){
            final /* synthetic */ SwPreviewCefBrowser this$0;
            final /* synthetic */ VirtualFile $specification;
            final /* synthetic */ Function0<Unit> $handleSuccess;
            {
                this.this$0 = $receiver;
                this.$specification = $specification;
                this.$handleSuccess = $handleSuccess;
                super($super_call_param$1, $super_call_param$2, true, $backgroundOption);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                SwPreviewCefBrowser.access$loadHtml(this.this$0, this.$specification);
            }

            public void onSuccess() {
                this.$handleSuccess.invoke();
            }
        });
    }

    public static /* synthetic */ void loadHtmlInBackground$default(SwPreviewCefBrowser swPreviewCefBrowser, VirtualFile virtualFile2, PerformInBackgroundOption performInBackgroundOption, Function0 function0, int n, Object object) {
        if ((n & 4) != 0) {
            function0 = loadHtmlInBackground.1.INSTANCE;
        }
        swPreviewCefBrowser.loadHtmlInBackground(virtualFile2, performInBackgroundOption, (Function0<Unit>)function0);
    }

    private final void loadHtml(VirtualFile specification) {
        SwPreviewCustomization swPreviewCustomization = this.previewCustomization;
        if (swPreviewCustomization == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"previewCustomization");
            swPreviewCustomization = null;
        }
        String string = SwSpecFileProviderKt.prepareUIWebPageUrl(specification, this.myProject, swPreviewCustomization.getPreviewType());
        if (string == null) {
            return;
        }
        String webPageUrl = string;
        this.myCefBrowser.loadURL(webPageUrl);
    }

    public final void openDevTools() {
        this.myCefBrowser.openDevtools();
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myCefBrowser.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.myCefBrowser.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    @NotNull
    public String getName() {
        return "OpenAPI";
    }

    public void setState(@NotNull FileEditorState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
    }

    public boolean isModified() {
        return false;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
    }

    public void dispose() {
        this.myTaskQueue.clear();
        Disposer.dispose((Disposable)((Disposable)this.myCefBrowser));
        this.isDisposed = true;
    }

    public boolean isValid() {
        return !this.isDisposed;
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    private static final void _init_$lambda$1(SwPreviewCefBrowser this$0, EditorColorsScheme it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        VirtualFile virtualFile2 = this$0.myFile;
        PerformInBackgroundOption performInBackgroundOption = PerformInBackgroundOption.ALWAYS_BACKGROUND;
        Intrinsics.checkNotNullExpressionValue((Object)performInBackgroundOption, (String)"ALWAYS_BACKGROUND");
        SwPreviewCefBrowser.loadHtmlInBackground$default(this$0, virtualFile2, performInBackgroundOption, null, 4, null);
    }

    public static final /* synthetic */ void access$disposeOldStrategy(SwPreviewCefBrowser $this) {
        $this.disposeOldStrategy();
    }

    public static final /* synthetic */ void access$applyNewStrategy(SwPreviewCefBrowser $this, SwPreviewProviderStrategy strategy) {
        $this.applyNewStrategy(strategy);
    }

    public static final /* synthetic */ void access$loadHtml(SwPreviewCefBrowser $this, VirtualFile specification) {
        $this.loadHtml(specification);
    }

    public static final /* synthetic */ VirtualFile access$getMyFile$p(SwPreviewCefBrowser $this) {
        return $this.myFile;
    }
}

