/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.ui;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiFile;
import com.intellij.swagger.core.ErrorType;
import com.intellij.swagger.core.SwaggerBundle;
import com.intellij.swagger.core.SwaggerFailure;
import com.intellij.swagger.core.SwaggerNavigableError;
import com.intellij.swagger.core.SwaggerValidationError;
import com.intellij.swagger.core.ui.SpecificationReferenceValidationHelperKt;
import com.intellij.swagger.core.ui.ValidationData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0002\u001a*\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0005H\u0000\u001a\"\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0007H\u0002\u001a\u001e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00052\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00010\u0012H\u0000\u00a8\u0006\u001d"}, d2={"generateValidationError", "Lcom/intellij/swagger/core/SwaggerValidationError;", "exception", "Lcom/fasterxml/jackson/core/JsonProcessingException;", "containingFile", "Lcom/intellij/psi/PsiFile;", "getPathRelativeToProjectRoot", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getReferenceOffsets", "Lkotlin/sequences/Sequence;", "", "fileContent", "reference", "getValidationResult", "", "validationResult", "", "Lcom/intellij/swagger/core/ui/ValidationData;", "originalSpecFile", "swaggerNavigableError", "Lcom/intellij/swagger/core/SwaggerNavigableError;", "referenceName", "swaggerValidationFailure", "Lcom/intellij/swagger/core/SwaggerFailure;", "validationErrors", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSpecificationReferenceValidationHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpecificationReferenceValidationHelper.kt\ncom/intellij/swagger/core/ui/SpecificationReferenceValidationHelperKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n1#2:95\n125#3:96\n152#3,3:97\n11065#4:100\n11400#4,3:101\n288#5,2:104\n*S KotlinDebug\n*F\n+ 1 SpecificationReferenceValidationHelper.kt\ncom/intellij/swagger/core/ui/SpecificationReferenceValidationHelperKt\n*L\n35#1:96\n35#1:97,3\n83#1:100\n83#1:101,3\n84#1:104,2\n*E\n"})
public final class SpecificationReferenceValidationHelperKt {
    @NotNull
    public static final SwaggerValidationError generateValidationError(@NotNull JsonProcessingException exception, @NotNull PsiFile containingFile) {
        Object object;
        String string;
        VirtualFile virtualFile2;
        block6: {
            block5: {
                LineColumn lineColumn;
                Intrinsics.checkNotNullParameter((Object)((Object)exception), (String)"exception");
                Intrinsics.checkNotNullParameter((Object)containingFile, (String)"containingFile");
                JsonLocation location = exception.getLocation();
                virtualFile2 = containingFile.getVirtualFile();
                JsonLocation jsonLocation = location;
                if (jsonLocation != null) {
                    JsonLocation it = jsonLocation;
                    boolean bl = false;
                    lineColumn = LineColumn.of((int)it.getLineNr(), (int)it.getColumnNr());
                } else {
                    lineColumn = null;
                }
                LineColumn coordinates = lineColumn;
                String string2 = exception.getOriginalMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getOriginalMessage(...)");
                string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                object = coordinates;
                if (object == null) break block5;
                LineColumn it = object;
                boolean bl = false;
                Set set = SetsKt.setOf((Object)it);
                object = set;
                if (set != null) break block6;
            }
            object = SetsKt.emptySet();
        }
        Object object2 = object;
        Project project = containingFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Intrinsics.checkNotNull((Object)virtualFile2);
        String string3 = SpecificationReferenceValidationHelperKt.getPathRelativeToProjectRoot(project, virtualFile2);
        return new SwaggerValidationError(string, "error", string3, (Set<LineColumn>)object2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<SwaggerValidationError> getValidationResult(@NotNull Map<String, ValidationData> validationResult, @NotNull PsiFile originalSpecFile) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(validationResult, (String)"validationResult");
        Intrinsics.checkNotNullParameter((Object)originalSpecFile, (String)"originalSpecFile");
        String fileContent = ((Object)LoadTextUtil.loadText((VirtualFile)originalSpecFile.getVirtualFile())).toString();
        Project project = originalSpecFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        VirtualFile virtualFile2 = originalSpecFile.getVirtualFile();
        Intrinsics.checkNotNull((Object)virtualFile2);
        String relativePath = SpecificationReferenceValidationHelperKt.getPathRelativeToProjectRoot(project2, virtualFile2);
        Map<String, ValidationData> $this$map$iv = validationResult;
        boolean $i$f$map = false;
        Map<String, ValidationData> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String currentFileReference = (String)entry.getKey();
            ValidationData validationData = (ValidationData)entry.getValue();
            Sequence<Integer> offsets = SpecificationReferenceValidationHelperKt.getReferenceOffsets(fileContent, currentFileReference);
            Sequence referenceCoordinates2 = SequencesKt.map(offsets, (Function1)((Function1)new Function1<Integer, LineColumn>(fileContent){
                final /* synthetic */ String $fileContent;
                {
                    this.$fileContent = $fileContent;
                    super(1);
                }

                public final LineColumn invoke(int offset) {
                    return StringUtil.offsetToLineColumn((CharSequence)this.$fileContent, (int)offset);
                }
            }));
            SwaggerNavigableError invalidSource = Intrinsics.areEqual((Object)validationData.getFile(), (Object)virtualFile2) ? null : SpecificationReferenceValidationHelperKt.swaggerNavigableError(project2, validationData.getFile(), validationData.getReferenceName());
            collection.add(new SwaggerValidationError(validationData.getError(), currentFileReference, relativePath, SequencesKt.toSet((Sequence)referenceCoordinates2), invalidSource));
        }
        List validationErrors2 = (List)destination$iv$iv;
        return validationErrors2;
    }

    @NotNull
    public static final SwaggerFailure swaggerValidationFailure(@NotNull PsiFile originalSpecFile, @NotNull List<SwaggerValidationError> validationErrors2) {
        Intrinsics.checkNotNullParameter((Object)originalSpecFile, (String)"originalSpecFile");
        Intrinsics.checkNotNullParameter(validationErrors2, (String)"validationErrors");
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)originalSpecFile.getName(), (String)"getName(...)");
        return new SwaggerFailure(ErrorType.VALIDATION, SwaggerBundle.message("preview.error.validation", objectArray), "Validation for file: " + originalSpecFile.getName() + " failed with errors: " + validationErrors2, validationErrors2);
    }

    private static final SwaggerNavigableError swaggerNavigableError(Project project, VirtualFile file2, String referenceName) {
        String fileContent = VirtualFileUtil.readText((VirtualFile)file2);
        Integer n = (Integer)SequencesKt.firstOrNull(SpecificationReferenceValidationHelperKt.getReferenceOffsets(fileContent, referenceName));
        if (n == null) {
            return null;
        }
        int offset = n;
        LineColumn lineColumn = StringUtil.offsetToLineColumn((CharSequence)fileContent, (int)offset);
        String string = SpecificationReferenceValidationHelperKt.getPathRelativeToProjectRoot(project, file2);
        Intrinsics.checkNotNull((Object)lineColumn);
        return new SwaggerNavigableError(referenceName, string, lineColumn);
    }

    /*
     * WARNING - void declaration
     */
    private static final String getPathRelativeToProjectRoot(Project project, VirtualFile file2) {
        String string;
        Object v3;
        block3: {
            void $this$mapTo$iv$iv;
            VirtualFile[] virtualFileArray = ProjectRootManager.getInstance((Project)project).getContentRoots();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
            Object[] $this$map$iv = virtualFileArray;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getPath());
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                String string2 = file2.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                CharSequence charSequence = string2;
                Intrinsics.checkNotNull((Object)it);
                if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                v3 = element$iv;
                break block3;
            }
            v3 = null;
        }
        if ((string = (String)v3) == null) {
            string = "";
        }
        String rootPath = string;
        String string3 = file2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
        return StringsKt.substringAfter$default((String)string3, (String)rootPath, null, (int)2, null);
    }

    private static final Sequence<Integer> getReferenceOffsets(String fileContent, String reference) {
        Sequence matches = Regex.findAll$default((Regex)new Regex("[\"']" + reference + "[\"']"), (CharSequence)fileContent, (int)0, (int)2, null);
        return SequencesKt.sorted((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)matches, (Function1)getReferenceOffsets.1.INSTANCE)));
    }
}

