/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.providers.httpClient.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.json.JsonFileType;
import com.intellij.json.psi.JsonObject;
import com.intellij.microservices.oas.serialization.OasSerializationUtilsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.swagger.core.SwJacksonObjectMapperFactoryKt;
import com.intellij.swagger.core.SwaggerUtilsKt;
import com.intellij.swagger.core.model.api.SwDefinition;
import com.intellij.swagger.core.model.api.SwModelElement;
import com.intellij.swagger.core.model.api.SwObjectSchema;
import com.intellij.swagger.core.providers.SwJsonSchemaPatchUtils;
import com.intellij.swagger.core.providers.httpClient.json.SwJsonMappingsFactory;
import com.intellij.swagger.core.providers.httpClient.json.SwRequestBodyToJsonSchemaConverterBase;
import com.intellij.swagger.core.ui.SpecificationReferencesInlineHelper;
import com.intellij.testFramework.LightVirtualFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\b\u0010#\u001a\u00020\u001fH\u0002J\n\u0010$\u001a\u0004\u0018\u00010%H\u0004J\b\u0010&\u001a\u00020\u001fH\u0002J\b\u0010'\u001a\u00020\u001fH\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010\u000f2\u0006\u0010)\u001a\u00020*H\u0002J\u0018\u0010+\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010,\u001a\u00020!H\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010!2\u0006\u0010.\u001a\u00020/H\u0002J\u001e\u00100\u001a\u0004\u0018\u00010\u00042\b\u00101\u001a\u0004\u0018\u00010\u00142\b\u0010)\u001a\u0004\u0018\u00010*H\u0002J\u0012\u00102\u001a\u0004\u0018\u00010\u00042\u0006\u00103\u001a\u00020!H\u0002J\u0012\u00104\u001a\u0004\u0018\u00010*2\u0006\u00101\u001a\u00020\u0014H\u0002J\u0018\u00105\u001a\u00020!2\u0006\u0010 \u001a\u00020!2\u0006\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u00020\u00042\u0006\u00109\u001a\u00020:H\u0002J\u0014\u0010;\u001a\u0004\u0018\u00010!2\b\u00101\u001a\u0004\u0018\u00010\u0014H\u0002J\u001a\u0010;\u001a\u0004\u0018\u00010!2\u0006\u0010<\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u000fH\u0002J\u0012\u0010>\u001a\u0004\u0018\u00010\u00042\u0006\u00101\u001a\u00020\u0014H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/intellij/swagger/core/providers/httpClient/json/SwRequestBodyToJsonSchemaConverterBase;", "", "prefix", "", "", "(Ljava/util/List;)V", "definitionNameGroup", "", "maximumAllowedLength", "", "myDynamicSchemaRootNode", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "myFactory", "Lcom/intellij/swagger/core/providers/httpClient/json/SwJsonMappingsFactory;", "myJsonObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "myReferencesInlineHelper", "Lcom/intellij/swagger/core/ui/SpecificationReferencesInlineHelper;", "myRootModelElements", "", "Lcom/intellij/swagger/core/model/api/SwModelElement;", "getMyRootModelElements", "()Ljava/util/Collection;", "setMyRootModelElements", "(Ljava/util/Collection;)V", "myYamlObjectMapper", "getPrefix", "()Ljava/util/List;", "referencePattern", "Ljava/util/regex/Pattern;", "assembleSchemaAndMerge", "", "schemaRootNode", "Lcom/fasterxml/jackson/databind/JsonNode;", "modelElements", "buildAffectedDefinitionsSchema", "buildFile", "Lcom/intellij/testFramework/LightVirtualFile;", "buildTopLevelSchema", "handlePrefixes", "mapperForFileType", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "mergeSchemas", "newNode", "prepareDefinitionToInline", "definition", "Lcom/intellij/swagger/core/model/api/SwDefinition;", "rawElementText", "modelElement", "schemaAsString", "schema", "specificationFileTypeFor", "substituteNodeToMerge", "isMultipleModels", "", "substituteReferences", "rawDefinitionText", "", "validateAndBuildSchema", "schemaText", "objectMapper", "validateAndConvertSchema", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwRequestBodyToJsonSchemaConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwRequestBodyToJsonSchemaConverter.kt\ncom/intellij/swagger/core/providers/httpClient/json/SwRequestBodyToJsonSchemaConverterBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 6 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,239:1\n1603#2,9:240\n1855#2:249\n1856#2:251\n1612#2:252\n1655#2,8:253\n1#3:250\n1#3:270\n1313#4,2:261\n23#5:263\n23#5:264\n23#5:265\n23#5:266\n23#5:267\n436#6:268\n436#6:269\n*S KotlinDebug\n*F\n+ 1 SwRequestBodyToJsonSchemaConverter.kt\ncom/intellij/swagger/core/providers/httpClient/json/SwRequestBodyToJsonSchemaConverterBase\n*L\n59#1:240,9\n59#1:249\n59#1:251\n59#1:252\n60#1:253,8\n59#1:250\n74#1:261,2\n92#1:263\n144#1:264\n148#1:265\n158#1:266\n162#1:267\n183#1:268\n186#1:269\n*E\n"})
public abstract class SwRequestBodyToJsonSchemaConverterBase {
    @NotNull
    private final List<String> prefix;
    protected Collection<? extends SwModelElement> myRootModelElements;
    @NotNull
    private final SwJsonMappingsFactory myFactory;
    @NotNull
    private final ObjectMapper myJsonObjectMapper;
    @NotNull
    private final ObjectMapper myYamlObjectMapper;
    @NotNull
    private final ObjectNode myDynamicSchemaRootNode;
    @NotNull
    private final SpecificationReferencesInlineHelper myReferencesInlineHelper;
    private final long maximumAllowedLength;
    @NotNull
    private final Pattern referencePattern;
    private final int definitionNameGroup;

    public SwRequestBodyToJsonSchemaConverterBase(@NotNull List<String> prefix) {
        Intrinsics.checkNotNullParameter(prefix, (String)"prefix");
        this.prefix = prefix;
        this.myFactory = new SwJsonMappingsFactory();
        this.myJsonObjectMapper = SwJacksonObjectMapperFactoryKt.createJsonJacksonMapper();
        this.myYamlObjectMapper = SwJacksonObjectMapperFactoryKt.createYamlJacksonMapper();
        this.myDynamicSchemaRootNode = this.myFactory.schemaRoot();
        this.myReferencesInlineHelper = new SpecificationReferencesInlineHelper(0, 1, null);
        this.maximumAllowedLength = Registry.intValue((String)"definition.for.schema.length.limit", (int)1000);
        String string = "[^\"'\\n]*#/(\\S+/)*([^/\\s'\"]*)";
        int n = 0;
        Pattern pattern = Pattern.compile(string, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        this.referencePattern = pattern;
        this.definitionNameGroup = 2;
    }

    @NotNull
    public final List<String> getPrefix() {
        return this.prefix;
    }

    @NotNull
    protected final Collection<SwModelElement> getMyRootModelElements() {
        Collection<SwModelElement> collection = this.myRootModelElements;
        if (collection != null) {
            return collection;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"myRootModelElements");
        return null;
    }

    protected final void setMyRootModelElements(@NotNull Collection<? extends SwModelElement> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"<set-?>");
        this.myRootModelElements = collection;
    }

    @Nullable
    protected final LightVirtualFile buildFile() {
        LightVirtualFile lightVirtualFile;
        this.buildTopLevelSchema();
        this.buildAffectedDefinitionsSchema();
        this.handlePrefixes();
        String string = this.schemaAsString((JsonNode)this.myDynamicSchemaRootNode);
        if (string == null) {
            return null;
        }
        String validatedSchema = string;
        LightVirtualFile $this$buildFile_u24lambda_u240 = lightVirtualFile = new LightVirtualFile("OpenapiRequestBodySchema.json", (CharSequence)validatedSchema);
        boolean bl = false;
        $this$buildFile_u24lambda_u240.setWritable(false);
        return lightVirtualFile;
    }

    private final void handlePrefixes() {
        if (this.prefix.isEmpty()) {
            return;
        }
        JsonNode ref = this.myDynamicSchemaRootNode.remove("$ref");
        OasSerializationUtilsKt.createNestedNodeWithSchemaPrefixes((ObjectNode)this.myDynamicSchemaRootNode, this.prefix).replace("$ref", ref);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildTopLevelSchema() {
        void $this$distinctBy$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Iterable iterable = this.getMyRootModelElements();
        JsonNode jsonNode = (JsonNode)this.myDynamicSchemaRootNode;
        SwRequestBodyToJsonSchemaConverterBase swRequestBodyToJsonSchemaConverterBase = this;
        boolean $i$f$mapNotNull = false;
        void var3_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            SwObjectSchema it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            SwModelElement p0 = (SwModelElement)element$iv$iv;
            boolean bl2 = false;
            if (p0.getSchema() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv;
        $this$mapNotNull$iv = list;
        boolean $i$f$distinctBy = false;
        HashSet<SmartPsiElementPointer<? extends PsiElement>> set$iv = new HashSet<SmartPsiElementPointer<? extends PsiElement>>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            SmartPsiElementPointer<? extends PsiElement> key$iv;
            SwObjectSchema it = (SwObjectSchema)e$iv;
            boolean bl = false;
            Object object = it.getPsiPointer();
            if (object == null) {
                object = it;
            }
            if (!set$iv.add(key$iv = object)) continue;
            list$iv.add(e$iv);
        }
        list = list$iv;
        swRequestBodyToJsonSchemaConverterBase.assembleSchemaAndMerge(jsonNode, list);
    }

    private final void buildAffectedDefinitionsSchema() {
        SwModelElement swModelElement = (SwModelElement)CollectionsKt.firstOrNull((Iterable)this.getMyRootModelElements());
        PsiManager psiManager = swModelElement != null && (swModelElement = swModelElement.getSourcePsi()) != null ? swModelElement.getManager() : null;
        if (psiManager == null) {
            return;
        }
        PsiManager psiManager2 = psiManager;
        Sequence $this$forEach$iv = SequencesKt.mapNotNull((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.distinctBy((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.onEach((Sequence)CollectionsKt.asSequence((Iterable)this.getMyRootModelElements()), (Function1)buildAffectedDefinitionsSchema.1.INSTANCE), (Function1)buildAffectedDefinitionsSchema.2.INSTANCE), (Function1)buildAffectedDefinitionsSchema.3.INSTANCE), (Function1)((Function1)new Function1<PsiFile, String>(this){
            final /* synthetic */ SwRequestBodyToJsonSchemaConverterBase this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final String invoke(@NotNull PsiFile specPsi) {
                Intrinsics.checkNotNullParameter((Object)specPsi, (String)"specPsi");
                return SwRequestBodyToJsonSchemaConverterBase.access$getMyReferencesInlineHelper$p(this.this$0).prepareSpecificationText$intellij_swagger_core(specPsi).getSuccessOrNull();
            }
        })), (Function1)((Function1)new Function1<String, PsiFile>(psiManager2){
            final /* synthetic */ PsiManager $psiManager;
            {
                this.$psiManager = $psiManager;
                super(1);
            }

            @Nullable
            public final PsiFile invoke(@NotNull String selfContainedSpec) {
                Intrinsics.checkNotNullParameter((Object)selfContainedSpec, (String)"selfContainedSpec");
                return this.$psiManager.findFile((VirtualFile)new LightVirtualFile("self-contained.json", (CharSequence)selfContainedSpec));
            }
        })), (Function1)buildAffectedDefinitionsSchema.6.INSTANCE), (Function1)buildAffectedDefinitionsSchema.7.INSTANCE), (Function1)((Function1)new Function1<SwDefinition, JsonNode>((Object)this){

            @Nullable
            public final JsonNode invoke(@NotNull SwDefinition p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return SwRequestBodyToJsonSchemaConverterBase.access$prepareDefinitionToInline((SwRequestBodyToJsonSchemaConverterBase)this.receiver, p0);
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsonNode modelSchema = (JsonNode)element$iv;
            boolean bl = false;
            this.mergeSchemas((JsonNode)this.myDynamicSchemaRootNode, modelSchema);
        }
    }

    private final JsonNode prepareDefinitionToInline(SwDefinition definition) {
        String string = this.validateAndConvertSchema(definition);
        if (string == null) {
            return null;
        }
        String definitionSchema = string;
        String definitionName = definition.getName().getValue();
        return this.myFactory.definition(definitionName, definitionSchema);
    }

    private final void assembleSchemaAndMerge(JsonNode schemaRootNode, Collection<? extends SwModelElement> modelElements) {
        JsonNode effectiveNodeToMerge = this.substituteNodeToMerge(schemaRootNode, modelElements.size() > 1);
        for (SwModelElement swModelElement : modelElements) {
            ProgressManager.checkCanceled();
            JsonNode validSchemaOrNull = this.validateAndBuildSchema(swModelElement);
            if (validSchemaOrNull != null) {
                this.mergeSchemas(effectiveNodeToMerge, validSchemaOrNull);
                continue;
            }
            SwRequestBodyToJsonSchemaConverterBase $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(SwRequestBodyToJsonSchemaConverterBase.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.warn("Invalid schema assembled for data model of type " + swModelElement.getClass().getName() + ". Particular schema will be skipped");
        }
    }

    private final JsonNode substituteNodeToMerge(JsonNode schemaRootNode, boolean isMultipleModels) {
        JsonNode jsonNode;
        if (isMultipleModels) {
            JsonNode jsonNode2 = schemaRootNode.withArray("oneOf");
            Intrinsics.checkNotNull((Object)jsonNode2);
            jsonNode = jsonNode2;
        } else {
            jsonNode = schemaRootNode;
        }
        return jsonNode;
    }

    private final void mergeSchemas(JsonNode schemaRootNode, JsonNode newNode) {
        SwJsonSchemaPatchUtils.INSTANCE.mergeTrees(schemaRootNode, newNode, true);
    }

    private final String validateAndConvertSchema(SwModelElement modelElement) {
        JsonNode jsonNode = this.validateAndBuildSchema(modelElement);
        if (jsonNode == null) {
            return null;
        }
        JsonNode validSchemaObject = jsonNode;
        return this.schemaAsString(validSchemaObject);
    }

    private final JsonNode validateAndBuildSchema(SwModelElement modelElement) {
        if (modelElement == null) {
            return null;
        }
        FileType fileType = this.specificationFileTypeFor(modelElement);
        if (fileType == null) {
            return null;
        }
        FileType fileType2 = fileType;
        ObjectMapper objectMapper = this.mapperForFileType(fileType2);
        if (objectMapper == null) {
            return null;
        }
        ObjectMapper mapperForFileType = objectMapper;
        String string = this.rawElementText(modelElement, fileType2);
        if (string == null) {
            return null;
        }
        String rawDefinitionText = string;
        String definitionWithSubstitutedReferences = this.substituteReferences(rawDefinitionText);
        return this.validateAndBuildSchema(definitionWithSubstitutedReferences, mapperForFileType);
    }

    private final String substituteReferences(CharSequence rawDefinitionText) {
        if ((long)rawDefinitionText.length() > this.maximumAllowedLength) {
            return "";
        }
        Matcher matcher = this.referencePattern.matcher(StringUtil.newBombedCharSequence((CharSequence)rawDefinitionText, (long)300L));
        String string = matcher.replaceAll(arg_0 -> SwRequestBodyToJsonSchemaConverterBase.substituteReferences$lambda$4(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replaceAll(...)");
        return string;
    }

    private final JsonNode validateAndBuildSchema(String schemaText, ObjectMapper objectMapper) {
        JsonNode jsonNode;
        try {
            jsonNode = objectMapper.readTree(schemaText);
        }
        catch (JsonParseException parseException) {
            SwRequestBodyToJsonSchemaConverterBase $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(SwRequestBodyToJsonSchemaConverterBase.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.debug("Unable to assemble json schema from syntactically invalid element", (Throwable)parseException);
            jsonNode = null;
        }
        catch (IOException exception) {
            SwRequestBodyToJsonSchemaConverterBase $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger3 = Logger.getInstance(SwRequestBodyToJsonSchemaConverterBase.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(...)");
            logger3.warn("Unable to assemble json schema", (Throwable)exception);
            jsonNode = null;
        }
        return jsonNode;
    }

    private final String schemaAsString(JsonNode schema2) {
        String string;
        try {
            string = this.myJsonObjectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)schema2);
        }
        catch (JsonParseException parseException) {
            SwRequestBodyToJsonSchemaConverterBase $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(SwRequestBodyToJsonSchemaConverterBase.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.debug("Unable to assemble json schema from syntactically invalid element", (Throwable)parseException);
            string = null;
        }
        catch (IOException exception) {
            SwRequestBodyToJsonSchemaConverterBase $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger3 = Logger.getInstance(SwRequestBodyToJsonSchemaConverterBase.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(...)");
            logger3.warn("Unable to assemble json schema from syntactically invalid element", (Throwable)exception);
            string = null;
        }
        return string;
    }

    private final FileType specificationFileTypeFor(SwModelElement modelElement) {
        PsiElement psiElement = modelElement.getSourcePsi();
        return psiElement != null && (psiElement = psiElement.getContainingFile()) != null ? psiElement.getFileType() : null;
    }

    private final ObjectMapper mapperForFileType(FileType fileType) {
        ObjectMapper objectMapper;
        FileType fileType2 = fileType;
        if (fileType2 instanceof JsonFileType) {
            objectMapper = this.myJsonObjectMapper;
        } else if (fileType2 instanceof YAMLFileType) {
            objectMapper = this.myYamlObjectMapper;
        } else {
            return null;
        }
        return objectMapper;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String rawElementText(SwModelElement modelElement, FileType fileType) {
        Object object;
        if (modelElement == null) {
            return null;
        }
        FileType fileType2 = fileType;
        if (fileType2 instanceof JsonFileType) {
            PsiElement psiElement = modelElement.getSourcePsi();
            Object object2 = psiElement;
            if (psiElement == null) return null;
            PsiElement $this$childrenOfType$iv = object2;
            boolean $i$f$childrenOfType = false;
            List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, JsonObject.class);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
            object2 = list;
            if (list == null) return null;
            JsonObject jsonObject = (JsonObject)CollectionsKt.singleOrNull((List)object2);
            object2 = jsonObject;
            if (jsonObject == null) return null;
            object = object2.getText();
            return object;
        } else {
            YAMLMapping yAMLMapping;
            if (!(fileType2 instanceof YAMLFileType)) return null;
            PsiElement psiElement = modelElement.getSourcePsi();
            if (psiElement == null) return null;
            PsiElement $this$childrenOfType$iv = psiElement;
            boolean $i$f$childrenOfType = false;
            List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, YAMLMapping.class);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
            List list2 = list;
            if (list2 == null) return null;
            YAMLMapping yAMLMapping2 = (YAMLMapping)CollectionsKt.singleOrNull((List)list2);
            if (yAMLMapping2 == null) return null;
            YAMLMapping it = yAMLMapping = yAMLMapping2;
            boolean bl = false;
            if (it.getTextRange().getLength() >= 1000) return null;
            boolean bl2 = true;
            if (!bl2) return null;
            YAMLMapping yAMLMapping3 = yAMLMapping;
            YAMLMapping yAMLMapping4 = yAMLMapping3;
            if (yAMLMapping4 == null) return null;
            YAMLMapping childMapping = yAMLMapping4;
            String indent = SwaggerUtilsKt.getYamlIndent((YAMLPsiElement)childMapping);
            object = indent + childMapping.getText();
        }
        return object;
    }

    private static final String substituteReferences$lambda$4(SwRequestBodyToJsonSchemaConverterBase this$0, MatchResult matchResult) {
        MatchResult matchResult2;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        MatchResult it = matchResult2 = matchResult;
        boolean bl = false;
        MatchResult matchResult3 = it.groupCount() >= this$0.definitionNameGroup ? matchResult2 : null;
        String string = matchResult3 != null ? matchResult3.group(this$0.definitionNameGroup) : null;
        String definitionName = string == null ? "Unknown" : string;
        return "#/definitions/" + definitionName;
    }

    public static final /* synthetic */ SpecificationReferencesInlineHelper access$getMyReferencesInlineHelper$p(SwRequestBodyToJsonSchemaConverterBase $this) {
        return $this.myReferencesInlineHelper;
    }

    public static final /* synthetic */ JsonNode access$prepareDefinitionToInline(SwRequestBodyToJsonSchemaConverterBase $this, SwDefinition definition) {
        return $this.prepareDefinitionToInline(definition);
    }
}

