/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.model.specification.light;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.swagger.core.meta.SwElementProvider;
import com.intellij.swagger.core.model.api.SwLazyResolvedElement;
import com.intellij.swagger.core.model.api.SwLeafElement;
import com.intellij.swagger.core.model.api.SwMediaType;
import com.intellij.swagger.core.model.api.SwModelElement;
import com.intellij.swagger.core.model.specification.SpecificationHttpOperation;
import com.intellij.swagger.core.model.specification.SwStringLeafElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u00012\u0006\u0010!\u001a\u00020\"H\u0016R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006#"}, d2={"Lcom/intellij/swagger/core/model/specification/light/SwLazyResolvedHttpOperation;", "Lcom/intellij/swagger/core/model/specification/SpecificationHttpOperation;", "Lcom/intellij/swagger/core/model/api/SwLazyResolvedElement;", "url", "", "httpMethodString", "resolver", "Lkotlin/Function0;", "Lcom/intellij/psi/PsiElement;", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "consumes", "", "Lcom/intellij/swagger/core/model/api/SwMediaType;", "getConsumes", "()Ljava/util/Collection;", "httpMethod", "Lcom/intellij/swagger/core/model/api/SwLeafElement;", "getHttpMethod", "()Lcom/intellij/swagger/core/model/api/SwLeafElement;", "getResolver", "()Lkotlin/jvm/functions/Function0;", "sourcePsi", "getSourcePsi", "()Lcom/intellij/psi/PsiElement;", "getUrl", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "substitute", "project", "Lcom/intellij/openapi/project/Project;", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwLazyResolvedHttpOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwLazyResolvedHttpOperation.kt\ncom/intellij/swagger/core/model/specification/light/SwLazyResolvedHttpOperation\n+ 2 SwElementProvider.kt\ncom/intellij/swagger/core/meta/SwElementProvider\n*L\n1#1,42:1\n36#2:43\n*S KotlinDebug\n*F\n+ 1 SwLazyResolvedHttpOperation.kt\ncom/intellij/swagger/core/model/specification/light/SwLazyResolvedHttpOperation\n*L\n31#1:43\n*E\n"})
public final class SwLazyResolvedHttpOperation
extends SpecificationHttpOperation
implements SwLazyResolvedElement {
    @NotNull
    private final String url;
    @NotNull
    private final String httpMethodString;
    @NotNull
    private final Function0<PsiElement> resolver;

    public SwLazyResolvedHttpOperation(@NotNull String url2, @NotNull String httpMethodString, @NotNull Function0<? extends PsiElement> resolver) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        Intrinsics.checkNotNullParameter((Object)httpMethodString, (String)"httpMethodString");
        Intrinsics.checkNotNullParameter(resolver, (String)"resolver");
        super(null);
        this.url = url2;
        this.httpMethodString = httpMethodString;
        this.resolver = resolver;
    }

    @Override
    @NotNull
    public String getUrl() {
        return this.url;
    }

    @Override
    @NotNull
    public Function0<PsiElement> getResolver() {
        return this.resolver;
    }

    @Override
    @NotNull
    public Collection<SwMediaType> getConsumes() {
        PsiElement psiElement = this.getSourcePsi();
        if (psiElement == null || (psiElement = psiElement.getProject()) == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement project = psiElement;
        SpecificationHttpOperation specificationHttpOperation = this.substitute((Project)project);
        Collection collection = specificationHttpOperation != null ? specificationHttpOperation.getConsumes() : null;
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    @Override
    @NotNull
    public SwLeafElement<String> getHttpMethod() {
        return new SwStringLeafElement(this.httpMethodString, null);
    }

    @Override
    @Nullable
    public PsiElement getSourcePsi() {
        return SwLazyResolvedElement.super.getSourcePsi();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public SpecificationHttpOperation substitute(@NotNull Project project) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SwElementProvider swElementProvider = SwElementProvider.INSTANCE;
        PsiElement psiElement$iv = this.getSourcePsi();
        boolean $i$f$getTypedModelElement = false;
        SwModelElement swModelElement = this_$iv.getModelElement(psiElement$iv);
        if (!(swModelElement instanceof SpecificationHttpOperation)) {
            swModelElement = null;
        }
        return (SpecificationHttpOperation)((SwModelElement)((SpecificationHttpOperation)swModelElement));
    }

    @Override
    public int hashCode() {
        return this.getUrl().hashCode();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof SwLazyResolvedHttpOperation)) {
            return false;
        }
        return Intrinsics.areEqual((Object)((SwLazyResolvedHttpOperation)other).getUrl(), (Object)this.getUrl()) && Intrinsics.areEqual((Object)((SwLazyResolvedHttpOperation)other).httpMethodString, (Object)this.httpMethodString);
    }
}

