/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.index;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.swagger.core.index.SwIndexUtilsKt;
import com.intellij.swagger.core.index.SwReferenceData;
import com.intellij.swagger.core.index.SwReferenceDataWithSource;
import com.intellij.swagger.core.index.SwReferencesIndexKt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0001\u00a8\u0006\u0007"}, d2={"findReferencesToCurrentFile", "Lkotlin/sequences/Sequence;", "Lcom/intellij/swagger/core/index/SwReferenceDataWithSource;", "maybeSecondarySpecification", "Lcom/intellij/psi/PsiFile;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "intellij.swagger.core"})
public final class SwReferenceIndexAccessorKt {
    @RequiresReadLock
    @NotNull
    public static final Sequence<SwReferenceDataWithSource> findReferencesToCurrentFile(@NotNull PsiFile maybeSecondarySpecification, @NotNull GlobalSearchScope searchScope) {
        Intrinsics.checkNotNullParameter((Object)maybeSecondarySpecification, (String)"maybeSecondarySpecification");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        Project project = maybeSecondarySpecification.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (SwIndexUtilsKt.isIndexingRightNow(project)) {
            return SequencesKt.emptySequence();
        }
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        String string = maybeSecondarySpecification.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String fileNameToSearch = string;
        PsiManager psiManager = maybeSecondarySpecification.getManager();
        Iterator iterator = fileBasedIndex.getContainingFilesIterator(SwReferencesIndexKt.getSW_REFERENCES_INDEX_ID(), (Object)fileNameToSearch, searchScope);
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"getContainingFilesIterator(...)");
        return SequencesKt.filter((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function1)((Function1)new Function1<VirtualFile, Sequence<? extends SwReferenceDataWithSource>>(fileBasedIndex, maybeSecondarySpecification, fileNameToSearch, psiManager){
            final /* synthetic */ FileBasedIndex $fileBasedIndex;
            final /* synthetic */ PsiFile $maybeSecondarySpecification;
            final /* synthetic */ String $fileNameToSearch;
            final /* synthetic */ PsiManager $psiManager;
            {
                this.$fileBasedIndex = $fileBasedIndex;
                this.$maybeSecondarySpecification = $maybeSecondarySpecification;
                this.$fileNameToSearch = $fileNameToSearch;
                this.$psiManager = $psiManager;
                super(1);
            }

            @NotNull
            public final Sequence<SwReferenceDataWithSource> invoke(VirtualFile indexedFileWithKey) {
                ProgressManager.checkCanceled();
                List list = (List)this.$fileBasedIndex.getFileData(SwReferencesIndexKt.getSW_REFERENCES_INDEX_ID(), indexedFileWithKey, this.$maybeSecondarySpecification.getProject()).get(this.$fileNameToSearch);
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<SwReferenceData, SwReferenceDataWithSource>(this.$psiManager, indexedFileWithKey){
                    final /* synthetic */ PsiManager $psiManager;
                    final /* synthetic */ VirtualFile $indexedFileWithKey;
                    {
                        this.$psiManager = $psiManager;
                        this.$indexedFileWithKey = $indexedFileWithKey;
                        super(1);
                    }

                    @Nullable
                    public final SwReferenceDataWithSource invoke(@NotNull SwReferenceData referenceData) {
                        Intrinsics.checkNotNullParameter((Object)referenceData, (String)"referenceData");
                        ProgressManager.checkCanceled();
                        PsiFile psiFile2 = this.$psiManager.findFile(this.$indexedFileWithKey);
                        if (psiFile2 == null) {
                            return null;
                        }
                        PsiFile indexedPsiFile = psiFile2;
                        return new SwReferenceDataWithSource(indexedPsiFile, referenceData);
                    }
                }));
            }
        })), (Function1)((Function1)new Function1<SwReferenceDataWithSource, Boolean>(maybeSecondarySpecification){
            final /* synthetic */ PsiFile $maybeSecondarySpecification;
            {
                this.$maybeSecondarySpecification = $maybeSecondarySpecification;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull SwReferenceDataWithSource referenceDataWithSource) {
                Intrinsics.checkNotNullParameter((Object)referenceDataWithSource, (String)"referenceDataWithSource");
                VirtualFile targetFile = VfsUtil.findRelativeFile((String)referenceDataWithSource.getReferenceData().getTargetFileRelativePath(), (VirtualFile)referenceDataWithSource.getSourcePsiFile().getVirtualFile());
                return Intrinsics.areEqual((Object)this.$maybeSecondarySpecification.getVirtualFile(), (Object)targetFile);
            }
        }));
    }
}

