/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.diff.vcs;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.psi.PsiFile;
import com.intellij.swagger.core.diff.collectors.FileRevision;
import com.intellij.swagger.core.diff.collectors.SwFileHistoryCollector;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/swagger/core/diff/vcs/VcsFileRevisionCollector;", "Lcom/intellij/swagger/core/diff/collectors/SwFileHistoryCollector;", "()V", "collectFileSnapshots", "", "Lcom/intellij/swagger/core/diff/collectors/FileRevision;", "psiFile", "Lcom/intellij/psi/PsiFile;", "getDiffProvider", "Lcom/intellij/openapi/vcs/diff/DiffProvider;", "isAvailableFor", "", "intellij.swagger.core"})
public final class VcsFileRevisionCollector
implements SwFileHistoryCollector {
    @Override
    public boolean isAvailableFor(@NotNull PsiFile psiFile2) {
        Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
        return this.getDiffProvider(psiFile2) != null;
    }

    @Override
    @NotNull
    public Collection<FileRevision> collectFileSnapshots(@NotNull PsiFile psiFile2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
        DiffProvider diffProvider = this.getDiffProvider(psiFile2);
        if (diffProvider == null) {
            return CollectionsKt.emptyList();
        }
        DiffProvider diffProvider2 = diffProvider;
        ItemLatestState itemLatestState = diffProvider2.getLastRevision(psiFile2.getVirtualFile());
        Object object = itemLatestState != null ? itemLatestState.getNumber() : null;
        if (object == null) {
            return CollectionsKt.emptyList();
        }
        VcsRevisionNumber lastRevision = object;
        ContentRevision contentRevision = diffProvider2.createFileContent(lastRevision, psiFile2.getVirtualFile());
        if (contentRevision == null) {
            return CollectionsKt.emptyList();
        }
        ContentRevision revision = contentRevision;
        try {
            string = revision.getContent();
        }
        catch (VcsException ex) {
            string = null;
        }
        String string2 = string;
        if (string2 == null) {
            return CollectionsKt.emptyList();
        }
        String content = string2;
        String string3 = revision.getRevisionNumber().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
        FileType fileType = revision.getFile().getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        return CollectionsKt.listOf((Object)new FileRevision(content, string3, fileType));
    }

    private final DiffProvider getDiffProvider(PsiFile psiFile2) {
        AbstractVcs abstractVcs = ProjectLevelVcsManager.getInstance((Project)psiFile2.getProject()).getVcsFor(psiFile2.getVirtualFile());
        return abstractVcs != null ? abstractVcs.getDiffProvider() : null;
    }
}

