/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.codegen;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.WithoutOwnBeforeRunSteps;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.swagger.core.SwaggerUtilsKt;
import com.intellij.swagger.core.codegen.CliArgumentViewModel;
import com.intellij.swagger.core.codegen.CodegenSettingsProxy;
import com.intellij.swagger.core.codegen.RunConfigurationValidatorKt;
import com.intellij.swagger.core.codegen.SwCodeGeneratorType;
import com.intellij.swagger.core.codegen.SwCodegenDefaultSettingsKt;
import com.intellij.swagger.core.codegen.SwaggerCodegenState;
import com.intellij.swagger.core.codegen.ui.SwaggerCodegenFragmentSettingsEditor;
import com.intellij.util.PathUtil;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020.0-H\u0016J\u0018\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u00020\nH\u0016J\b\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020+2\u0006\u00109\u001a\u00020\u0002H\u0016J\n\u0010:\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010;\u001a\u00020+2\u0006\u00109\u001a\u00020\u0002H\u0016R\u001e\u0010\f\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001e\u0010!\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u000e\"\u0004\b#\u0010\u0010R\u001e\u0010$\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u000e\"\u0004\b&\u0010\u0010R\u001e\u0010'\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u000e\"\u0004\b)\u0010\u0010\u00a8\u0006<"}, d2={"Lcom/intellij/swagger/core/codegen/SwaggerCodegenRunConfiguration;", "Lcom/intellij/execution/configurations/LocatableConfigurationBase;", "Lorg/jdom/Element;", "Lcom/intellij/swagger/core/codegen/CodegenSettingsProxy;", "Lcom/intellij/execution/configurations/WithoutOwnBeforeRunSteps;", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "name", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;Ljava/lang/String;)V", "customTemplatesPath", "getCustomTemplatesPath", "()Ljava/lang/String;", "setCustomTemplatesPath", "(Ljava/lang/String;)V", "generateToPath", "getGenerateToPath", "setGenerateToPath", "generationParameters", "", "Lcom/intellij/swagger/core/codegen/CliArgumentViewModel;", "getGenerationParameters$intellij_swagger_core", "()Ljava/util/List;", "setGenerationParameters$intellij_swagger_core", "(Ljava/util/List;)V", "generatorType", "Lcom/intellij/swagger/core/codegen/SwCodeGeneratorType;", "getGeneratorType", "()Lcom/intellij/swagger/core/codegen/SwCodeGeneratorType;", "setGeneratorType", "(Lcom/intellij/swagger/core/codegen/SwCodeGeneratorType;)V", "jdkPath", "getJdkPath", "setJdkPath", "language", "getLanguage", "setLanguage", "specificationPath", "getSpecificationPath", "setSpecificationPath", "checkConfiguration", "", "getConfigurationEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/intellij/execution/configurations/RunConfiguration;", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "getWorkingDirectory", "isGeneratedName", "", "readExternal", "element", "suggestedName", "writeExternal", "intellij.swagger.core"})
@ApiStatus.Internal
public final class SwaggerCodegenRunConfiguration
extends LocatableConfigurationBase<Element>
implements CodegenSettingsProxy,
WithoutOwnBeforeRunSteps {
    @NotNull
    private SwCodeGeneratorType generatorType;
    @NotNull
    private List<CliArgumentViewModel> generationParameters;
    @NlsSafe
    @NotNull
    private String language;
    @NlsSafe
    @NotNull
    private String jdkPath;
    @NlsSafe
    @NotNull
    private String specificationPath;
    @NlsSafe
    @NotNull
    private String generateToPath;
    @NlsSafe
    @NotNull
    private String customTemplatesPath;

    public SwaggerCodegenRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        super(project, factory, name2);
        this.generatorType = SwCodegenDefaultSettingsKt.defaultGeneratorType();
        this.generationParameters = CollectionsKt.emptyList();
        this.language = "";
        this.jdkPath = "";
        this.specificationPath = "";
        this.generateToPath = "";
        this.customTemplatesPath = "";
    }

    @NotNull
    public final SwCodeGeneratorType getGeneratorType() {
        return this.generatorType;
    }

    public final void setGeneratorType(@NotNull SwCodeGeneratorType swCodeGeneratorType) {
        Intrinsics.checkNotNullParameter((Object)((Object)swCodeGeneratorType), (String)"<set-?>");
        this.generatorType = swCodeGeneratorType;
    }

    @NotNull
    public final List<CliArgumentViewModel> getGenerationParameters$intellij_swagger_core() {
        return this.generationParameters;
    }

    public final void setGenerationParameters$intellij_swagger_core(@NotNull List<CliArgumentViewModel> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.generationParameters = list;
    }

    @NotNull
    public final String getLanguage() {
        return this.language;
    }

    public final void setLanguage(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.language = string;
    }

    @NotNull
    public final String getJdkPath() {
        return this.jdkPath;
    }

    public final void setJdkPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.jdkPath = string;
    }

    @NotNull
    public final String getSpecificationPath() {
        return this.specificationPath;
    }

    public final void setSpecificationPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.specificationPath = string;
    }

    @NotNull
    public final String getGenerateToPath() {
        return this.generateToPath;
    }

    public final void setGenerateToPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.generateToPath = string;
    }

    @NotNull
    public final String getCustomTemplatesPath() {
        return this.customTemplatesPath;
    }

    public final void setCustomTemplatesPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.customTemplatesPath = string;
    }

    public void checkConfiguration() {
        RunConfigurationValidatorKt.checkSwaggerCodegenRunConfiguration(this);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return (SettingsEditor)new SwaggerCodegenFragmentSettingsEditor(this);
    }

    @NotNull
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        return (RunProfileState)new SwaggerCodegenState(this, environment);
    }

    @Nullable
    public String suggestedName() {
        String specificationPath = this.specificationPath;
        return !StringsKt.isBlank((CharSequence)specificationPath) ? PathUtil.getFileName((String)specificationPath) : null;
    }

    public boolean isGeneratedName() {
        return Intrinsics.areEqual((Object)this.getName(), (Object)this.suggestedName());
    }

    public void readExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.readExternal(element);
        XmlSerializer.deserializeInto((Object)this, (Element)element);
    }

    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.writeExternal(element);
        XmlSerializer.serializeInto((Object)this, (Element)element);
    }

    @NotNull
    public String getWorkingDirectory() {
        String specification = this.specificationPath;
        String string = new File(specification).getParent();
        if (string == null) {
            string = specification;
        }
        String parentOrSelf = string;
        return SwaggerUtilsKt.toSystemDependentPath(parentOrSelf);
    }
}

