/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.swagger.core.FileCoordinates;
import com.intellij.swagger.core.SwConnectionTuner;
import com.intellij.swagger.core.SwDownloadManager;
import com.intellij.swagger.core.SwDownloadableFileType;
import com.intellij.swagger.core.SwUrlTuner;
import com.intellij.util.PathUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.HttpRequests;
import java.io.File;
import java.io.IOException;
import java.net.URLConnection;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J$\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007J\u001c\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00072\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u0004H\u0002J$\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u000e2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u0013J,\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u0013J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0011H\u0002J\u0010\u0010%\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H\u0002J+\u0010&\u001a\u0004\u0018\u0001H'\"\u0004\b\u0000\u0010'2\u0006\u0010(\u001a\u00020\u00052\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H'0*H\u0002\u00a2\u0006\u0002\u0010+J\f\u0010,\u001a\u00020\u0005*\u00020\u0005H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/swagger/core/SwDownloadManager;", "", "()V", "allowedSchemes", "", "", "myDownloadDirectory", "Ljava/nio/file/Path;", "adjustFileExtension", "Ljava/io/File;", "path", "connection", "Ljava/net/URLConnection;", "calculateLocalUrlFromRemote", "Lcom/intellij/swagger/core/FileCoordinates;", "urlString", "fileType", "Lcom/intellij/swagger/core/SwDownloadableFileType;", "asLocalIfNoScheme", "", "deleteOutdatedDownloads", "", "filesToIgnore", "deleteSpecificationDir", "startDir", "downloadFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileCoordinates", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "force", "ensureAppropriateSubDirectoryExists", "getFilePathByUrl", "url", "Lcom/intellij/util/Url;", "getFullPath", "downloadableFileType", "isAcceptableUrl", "performIoOperationSafely", "T", "customDescription", "operation", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getFileName", "intellij.swagger.core"})
public final class SwDownloadManager {
    @NotNull
    public static final SwDownloadManager INSTANCE = new SwDownloadManager();
    @NotNull
    private static final Path myDownloadDirectory;
    @NotNull
    private static final Set<String> allowedSchemes;

    private SwDownloadManager() {
    }

    @Deprecated(message="In some cases it's impossible to compute a precise file path before actually making a http-request because of unknown file type, another approach should be introduced")
    @Nullable
    public final FileCoordinates calculateLocalUrlFromRemote(@NotNull String urlString, @NotNull SwDownloadableFileType fileType, boolean asLocalIfNoScheme) {
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        Intrinsics.checkNotNullParameter((Object)((Object)fileType), (String)"fileType");
        Path path = this.ensureAppropriateSubDirectoryExists(fileType);
        if (path == null) {
            return null;
        }
        Path downloadDirectory = path;
        String tunedUrl = SwUrlTuner.INSTANCE.tuneUrl(urlString);
        Url url2 = Urls.parse((String)tunedUrl, (boolean)asLocalIfNoScheme);
        if (url2 == null) {
            return null;
        }
        Url url3 = url2;
        if (!this.isAcceptableUrl(url3)) {
            return null;
        }
        Path path2 = downloadDirectory.resolve(this.getFilePathByUrl(url3));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return new FileCoordinates(path2, url3);
    }

    public static /* synthetic */ FileCoordinates calculateLocalUrlFromRemote$default(SwDownloadManager swDownloadManager, String string, SwDownloadableFileType swDownloadableFileType, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return swDownloadManager.calculateLocalUrlFromRemote(string, swDownloadableFileType, bl);
    }

    @Nullable
    public final VirtualFile downloadFile(@NotNull String urlString, @NotNull SwDownloadableFileType fileType, @Nullable ProgressIndicator progressIndicator, boolean force) {
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        Intrinsics.checkNotNullParameter((Object)((Object)fileType), (String)"fileType");
        FileCoordinates fileCoordinates = SwDownloadManager.calculateLocalUrlFromRemote$default(this, urlString, fileType, false, 4, null);
        if (fileCoordinates == null) {
            return null;
        }
        FileCoordinates fileInfo = fileCoordinates;
        return this.downloadFile(fileInfo, progressIndicator, force);
    }

    public static /* synthetic */ VirtualFile downloadFile$default(SwDownloadManager swDownloadManager, String string, SwDownloadableFileType swDownloadableFileType, ProgressIndicator progressIndicator, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return swDownloadManager.downloadFile(string, swDownloadableFileType, progressIndicator, bl);
    }

    @Nullable
    public final VirtualFile downloadFile(@NotNull FileCoordinates fileCoordinates, @Nullable ProgressIndicator progressIndicator, boolean force) {
        Intrinsics.checkNotNullParameter((Object)fileCoordinates, (String)"fileCoordinates");
        ProgressIndicator progressIndicator2 = progressIndicator;
        boolean bl = progressIndicator2 != null ? progressIndicator2.isCanceled() : false;
        if (bl) {
            return null;
        }
        File downloadedFile2 = (File)this.performIoOperationSafely("Unable to download file from url: " + fileCoordinates.getRemoteUrl(), (Function0)new Function0<File>(fileCoordinates, force, progressIndicator){
            final /* synthetic */ FileCoordinates $fileCoordinates;
            final /* synthetic */ boolean $force;
            final /* synthetic */ ProgressIndicator $progressIndicator;
            {
                this.$fileCoordinates = $fileCoordinates;
                this.$force = $force;
                this.$progressIndicator = $progressIndicator;
                super(0);
            }

            public final File invoke() {
                return (File)HttpRequests.request((Url)this.$fileCoordinates.getRemoteUrl()).tuner(downloadFile.downloadedFile.1::invoke$lambda$0).connect(arg_0 -> downloadFile.downloadedFile.1.invoke$lambda$1(this.$fileCoordinates, this.$force, this.$progressIndicator, arg_0));
            }

            private static final void invoke$lambda$0(URLConnection it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                SwConnectionTuner.tuneConnection$default(SwConnectionTuner.INSTANCE, it, null, 2, null);
            }

            private static final File invoke$lambda$1(FileCoordinates $fileCoordinates, boolean $force, ProgressIndicator $progressIndicator, HttpRequests.Request it) {
                Intrinsics.checkNotNullParameter((Object)$fileCoordinates, (String)"$fileCoordinates");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Path path = $fileCoordinates.getPath();
                URLConnection uRLConnection = it.getConnection();
                Intrinsics.checkNotNullExpressionValue((Object)uRLConnection, (String)"getConnection(...)");
                File targetFile = SwDownloadManager.access$adjustFileExtension(SwDownloadManager.INSTANCE, path, uRLConnection);
                if (targetFile.exists()) {
                    if (!$force) {
                        return targetFile;
                    }
                    Files.delete(targetFile.toPath());
                }
                return it.saveToFile(targetFile, $progressIndicator);
            }
        });
        return downloadedFile2 != null && downloadedFile2.exists() ? VfsUtil.findFile((Path)downloadedFile2.toPath(), (boolean)false) : null;
    }

    public static /* synthetic */ VirtualFile downloadFile$default(SwDownloadManager swDownloadManager, FileCoordinates fileCoordinates, ProgressIndicator progressIndicator, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return swDownloadManager.downloadFile(fileCoordinates, progressIndicator, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteOutdatedDownloads(@NotNull Set<? extends File> filesToIgnore, @NotNull SwDownloadableFileType fileType) {
        Path downloadDirectory;
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter(filesToIgnore, (String)"filesToIgnore");
                Intrinsics.checkNotNullParameter((Object)((Object)fileType), (String)"fileType");
                downloadDirectory = this.getFullPath(fileType);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(downloadDirectory, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block8;
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (Files.isDirectory(downloadDirectory, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) break block9;
            }
            return;
        }
        AutoCloseable autoCloseable = Files.list(downloadDirectory);
        Throwable throwable = null;
        try {
            Stream filesStream = (Stream)autoCloseable;
            boolean bl = false;
            filesStream.filter(arg_0 -> SwDownloadManager.deleteOutdatedDownloads$lambda$2$lambda$0((Function1)new Function1<Path, Boolean>(filesToIgnore){
                final /* synthetic */ Set<File> $filesToIgnore;
                {
                    this.$filesToIgnore = $filesToIgnore;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(Path it) {
                    return !this.$filesToIgnore.contains(it.toFile());
                }
            }, arg_0)).forEach(arg_0 -> SwDownloadManager.deleteOutdatedDownloads$lambda$2$lambda$1((Function1)new Function1<Path, Unit>(filesToIgnore){
                final /* synthetic */ Set<File> $filesToIgnore;
                {
                    this.$filesToIgnore = $filesToIgnore;
                    super(1);
                }

                public final void invoke(Path it) {
                    SwDownloadManager.access$performIoOperationSafely(SwDownloadManager.INSTANCE, "Can not delete outdated file \"" + it.getFileName() + "\"", (Function0)new Function0<Object>(it, this.$filesToIgnore){
                        final /* synthetic */ Path $it;
                        final /* synthetic */ Set<File> $filesToIgnore;
                        {
                            this.$it = $it;
                            this.$filesToIgnore = $filesToIgnore;
                            super(0);
                        }

                        @NotNull
                        public final Object invoke() {
                            Boolean bl;
                            Path path = this.$it;
                            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"$it");
                            Path path2 = path;
                            LinkOption[] linkOptionArray = new LinkOption[]{};
                            if (Files.isDirectory(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                                Path path3 = this.$it;
                                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"$it");
                                SwDownloadManager.access$deleteSpecificationDir(SwDownloadManager.INSTANCE, path3, this.$filesToIgnore);
                                bl = Unit.INSTANCE;
                            } else {
                                bl = Files.deleteIfExists(this.$it);
                            }
                            return bl;
                        }
                    });
                }
            }, arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final File adjustFileExtension(Path path, URLConnection connection) {
        v0 = PathUtil.toSystemIndependentName((String)path.toString());
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"toSystemIndependentName(...)");
        defaultFileName = this.getFileName(v0);
        v1 = FileUtilRt.getExtension((String)defaultFileName);
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getExtension(...)");
        originalExtension = v1;
        if (((CharSequence)originalExtension).length() > 0) {
            v2 = path.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"toFile(...)");
            return v2;
        }
        var6_5 = connection.getHeaderField("content-type");
        if (var6_5 == null) ** GOTO lbl-1000
        tmp = -1;
        switch (var6_5.hashCode()) {
            case 2049276534: {
                if (var6_5.equals("application/java-archive")) {
                    tmp = 1;
                }
                break;
            }
            case -43840953: {
                if (var6_5.equals("application/json")) {
                    tmp = 2;
                }
                break;
            }
            case 2096181599: {
                if (var6_5.equals("application/tar+gzip")) {
                    tmp = 3;
                }
                break;
            }
            case -43411450: {
                if (var6_5.equals("application/yaml")) {
                    tmp = 4;
                }
                break;
            }
        }
        switch (tmp) {
            case 2: {
                v3 = ".json";
                break;
            }
            case 4: {
                v3 = ".yaml";
                break;
            }
            case 1: {
                v3 = ".jar";
                break;
            }
            case 3: {
                v3 = ".tgz";
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                v3 = ".tmp";
            }
        }
        extensionByContentType = v3;
        v4 = FileUtilRt.getNameWithoutExtension((String)defaultFileName);
        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getNameWithoutExtension(...)");
        originalFileName = v4;
        v5 = path.getParent();
        if ((v5 != null && (v5 = v5.resolve(originalFileName + extensionByContentType)) != null ? v5.toFile() : (v6 = null)) == null) {
            v7 = path.toFile();
            v6 = v7;
            Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"toFile(...)");
        }
        return v6;
    }

    private final String getFileName(String $this$getFileName) {
        String[] stringArray = new String[]{"/"};
        return (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)$this$getFileName, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
    }

    private final void deleteSpecificationDir(Path startDir, Set<? extends File> filesToIgnore) {
        Files.walkFileTree(startDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(filesToIgnore){
            final /* synthetic */ Set<File> $filesToIgnore;
            {
                this.$filesToIgnore = $filesToIgnore;
            }

            @NotNull
            public FileVisitResult visitFile(@NotNull Path path, @NotNull BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                if (!this.$filesToIgnore.contains(path.toFile())) {
                    Files.deleteIfExists(path);
                }
                return FileVisitResult.CONTINUE;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public FileVisitResult postVisitDirectory(@NotNull Path dir, @Nullable IOException exception) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                if (exception != null) {
                    throw exception;
                }
                AutoCloseable autoCloseable = Files.list(dir);
                Throwable throwable = null;
                try {
                    Stream it = (Stream)autoCloseable;
                    boolean bl2 = false;
                    bl = it.findAny().isEmpty();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                if (bl) {
                    Files.deleteIfExists(dir);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private final Path getFullPath(SwDownloadableFileType downloadableFileType) {
        Path path = myDownloadDirectory.resolve(downloadableFileType.getRelativePath());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private final boolean isAcceptableUrl(Url url2) {
        boolean bl;
        if (!CollectionsKt.contains((Iterable)allowedSchemes, (Object)url2.getScheme())) {
            bl = false;
        } else {
            String string = url2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            bl = !(((CharSequence)string).length() == 0);
        }
        return bl;
    }

    private final Path ensureAppropriateSubDirectoryExists(SwDownloadableFileType fileType) {
        return (Path)this.performIoOperationSafely("Unable to create directory for downloadable file of type \"" + fileType + "\"", (Function0)new Function0<Path>(fileType){
            final /* synthetic */ SwDownloadableFileType $fileType;
            {
                this.$fileType = $fileType;
                super(0);
            }

            public final Path invoke() {
                return Files.createDirectories(SwDownloadManager.access$getFullPath(SwDownloadManager.INSTANCE, this.$fileType), new FileAttribute[0]);
            }
        });
    }

    private final String getFilePathByUrl(Url url2) {
        String string = url2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String fileName = this.getFileName(string);
        MessageDigest digest = DigestUtil.md5();
        String string2 = url2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        String string3 = string2;
        byte[] byArray = string3.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        digest.update(byArray);
        String dirName = DigestUtil.digestToHash((MessageDigest)digest);
        return dirName + "/" + fileName;
    }

    private final <T> T performIoOperationSafely(String customDescription, Function0<? extends T> operation) {
        try {
            return (T)operation.invoke();
        }
        catch (IOException ex) {
            Logger.getInstance(SwDownloadManager.class).warn("Unable to process file. " + customDescription, (Throwable)ex);
        }
        catch (SecurityException ex) {
            Logger.getInstance(SwDownloadManager.class).warn("Unable to access file. " + customDescription, (Throwable)ex);
        }
        return null;
    }

    private static final boolean deleteOutdatedDownloads$lambda$2$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void deleteOutdatedDownloads$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ File access$adjustFileExtension(SwDownloadManager $this, Path path, URLConnection connection) {
        return $this.adjustFileExtension(path, connection);
    }

    public static final /* synthetic */ Path access$getFullPath(SwDownloadManager $this, SwDownloadableFileType downloadableFileType) {
        return $this.getFullPath(downloadableFileType);
    }

    public static final /* synthetic */ Object access$performIoOperationSafely(SwDownloadManager $this, String customDescription, Function0 operation) {
        return $this.performIoOperationSafely(customDescription, operation);
    }

    public static final /* synthetic */ void access$deleteSpecificationDir(SwDownloadManager $this, Path startDir, Set filesToIgnore) {
        $this.deleteSpecificationDir(startDir, filesToIgnore);
    }

    static {
        Path path = Paths.get(PathManager.getSystemPath(), new String[0]).resolve("openapi");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        myDownloadDirectory = path;
        Files.createDirectories(myDownloadDirectory, new FileAttribute[0]);
        Object[] objectArray = new String[]{"http", "https", "file"};
        allowedSchemes = SetsKt.setOf((Object[])objectArray);
    }
}

