/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.ultimate.git;

import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHash;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHashExporter;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHashExporterContext;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHashProvider;
import com.intellij.indexing.shared.ultimate.git.GitBlobSet;
import com.intellij.indexing.shared.ultimate.git.GitHashesProjectService;
import com.intellij.indexing.shared.ultimate.git.SharedIndexGitBackedHash;
import com.intellij.indexing.shared.ultimate.git.SharedIndexGitBackedHashProviderForExporter;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/intellij/indexing/shared/ultimate/git/SharedIndexGitBackedHashExporter;", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHashExporter;", "()V", "info", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHash;", "getInfo", "()Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHash;", "createHashProvider", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHashProvider;", "context", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHashExporterContext;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.indexing.shared.ultimate.git"})
@SourceDebugExtension(value={"SMAP\nSharedIndexGitBackedHash.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexGitBackedHash.kt\ncom/intellij/indexing/shared/ultimate/git/SharedIndexGitBackedHashExporter\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ProgressIndicatorEx.kt\ncom/intellij/openapi/progress/ProgressIndicatorForCollections\n*L\n1#1,78:1\n31#2,2:79\n23#3:81\n23#3:85\n766#4:82\n857#4,2:83\n13#5,8:86\n*S KotlinDebug\n*F\n+ 1 SharedIndexGitBackedHash.kt\ncom/intellij/indexing/shared/ultimate/git/SharedIndexGitBackedHashExporter\n*L\n58#1:79,2\n60#1:81\n66#1:85\n64#1:82\n64#1:83,2\n70#1:86,8\n*E\n"})
public final class SharedIndexGitBackedHashExporter
implements SharedIndexContentHashExporter {
    @NotNull
    private final SharedIndexContentHash info = SharedIndexGitBackedHash.INSTANCE;

    @NotNull
    public SharedIndexContentHash getInfo() {
        return this.info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public SharedIndexContentHashProvider createHashProvider(@NotNull SharedIndexContentHashExporterContext context, @NotNull ProgressIndicator indicator) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        ComponentManager $this$service$iv = (ComponentManager)context.getProject();
        boolean $i$f$service = false;
        Class<GitHashesProjectService> serviceClass$iv = GitHashesProjectService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        GitHashesProjectService gitHashService = (GitHashesProjectService)object;
        if (!gitHashService.isValid()) {
            SharedIndexGitBackedHashExporter $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SharedIndexGitBackedHashExporter.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("No git root found for " + context.getProject());
            return null;
        }
        Iterable $this$filter$iv = context.getAllFiles();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!(it.getFileSystem() instanceof LocalFileSystem)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        int files = ((List)destination$iv$iv).size();
        if (files <= Registry.intValue((String)"shared.index.git.hashes.minFiles")) {
            SharedIndexGitBackedHashExporter $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SharedIndexGitBackedHashExporter.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("Too few (" + files + ") local files. It makes no sense for Git Hashes");
            return null;
        }
        ProgressIndicator $this$withPushPop$iv = indicator;
        boolean $i$f$withPushPop = false;
        boolean wasIndeterminate$iv = $this$withPushPop$iv.isIndeterminate();
        $this$withPushPop$iv.pushState();
        try {
            GitBlobSet gitBlobSet;
            boolean bl = false;
            indicator.setText(SharedIndexesBundle.message((String)"progress.text.resolving.recent.git.hashes", (Object[])new Object[0]));
            if (gitHashService.resolveGitHashes(indicator) == null) {
                SharedIndexContentHashProvider sharedIndexContentHashProvider = null;
                return sharedIndexContentHashProvider;
            }
            GitBlobSet hashes = gitBlobSet;
            SharedIndexContentHashProvider sharedIndexContentHashProvider = new SharedIndexGitBackedHashProviderForExporter(hashes);
            return sharedIndexContentHashProvider;
        }
        finally {
            $this$withPushPop$iv.setIndeterminate(wasIndeterminate$iv);
            $this$withPushPop$iv.popState();
        }
    }
}

