/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.ultimate.git;

import com.intellij.indexing.shared.git.GitHashesProjectServiceWrapperDriver;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.ultimate.git.GitBlobSet;
import com.intellij.indexing.shared.ultimate.git.GitBlobSetBuilder;
import com.intellij.indexing.shared.ultimate.git.GitHashesProjectServiceKt;
import com.intellij.indexing.shared.ultimate.git.GitHashesServiceBase;
import com.intellij.indexing.shared.ultimate.git.GitProjectRecentCommitsKt;
import com.intellij.indexing.shared.ultimate.git.ProjectGitHelper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.nio.file.Path;
import java.util.Set;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u001e\u0010\u0016\u001a\u00020\u000f2\u0014\u0010\u0017\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0004\u0012\u00020\u000f0\u0018H\u0016R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/indexing/shared/ultimate/git/GitHashesServiceBase;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/indexing/shared/git/GitHashesProjectServiceWrapperDriver;", "project", "Lcom/intellij/openapi/project/Project;", "gitRoot", "Ljava/nio/file/Path;", "(Lcom/intellij/openapi/project/Project;Ljava/nio/file/Path;)V", "getGitRoot", "()Ljava/nio/file/Path;", "gitRootFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getGitRootFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "dispose", "", "isValid", "", "resolveGitHashes", "Lcom/intellij/indexing/shared/ultimate/git/GitBlobSet;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "resolveGitHashesInBackground", "callback", "Lkotlin/Function1;", "intellij.indexing.shared.ultimate.git"})
@SourceDebugExtension(value={"SMAP\nGitHashesProjectService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitHashesProjectService.kt\ncom/intellij/indexing/shared/ultimate/git/GitHashesServiceBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,218:1\n1#2:219\n*E\n"})
public class GitHashesServiceBase
implements Disposable,
GitHashesProjectServiceWrapperDriver {
    @NotNull
    private final Project project;
    @Nullable
    private final Path gitRoot;

    public GitHashesServiceBase(@NotNull Project project, @Nullable Path gitRoot) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.gitRoot = gitRoot;
    }

    public /* synthetic */ GitHashesServiceBase(Project project, Path path, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            path = GitProjectRecentCommitsKt.resolveProjectGitRoot(project);
        }
        this(project, path);
    }

    @Nullable
    protected final Path getGitRoot() {
        return this.gitRoot;
    }

    public void dispose() {
    }

    public final boolean isValid() {
        return this.gitRoot != null && Registry.is((String)"shared.index.git.hashes") && !this.project.isDisposed() && !this.project.isDefault();
    }

    @Nullable
    public final VirtualFile getGitRootFile() {
        VirtualFile virtualFile;
        Path path = this.gitRoot;
        if (path != null) {
            Path it = path;
            boolean bl = false;
            virtualFile = VirtualFileManager.getInstance().findFileByNioPath(it);
        } else {
            virtualFile = null;
        }
        return virtualFile;
    }

    @Override
    public void resolveGitHashesInBackground(@NotNull Function1<? super GitBlobSet, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (!this.isValid()) {
            callback.invoke(null);
            return;
        }
        if (!DumbService.Companion.isDumb(this.project)) {
            callback.invoke(null);
            return;
        }
        Project project = this.project;
        String string = SharedIndexesBundle.message((String)"progress.title.git.hashes.resolve", (Object[])new Object[0]);
        new Task.Backgroundable(callback, this, project, string){
            final /* synthetic */ Function1<GitBlobSet, Unit> $callback;
            final /* synthetic */ GitHashesServiceBase this$0;
            {
                this.$callback = $callback;
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, true);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Object object2 = this;
                GitHashesServiceBase gitHashesServiceBase = this.this$0;
                try {
                    resolveGitHashesInBackground.1 $this$run_u24lambda_u240 = object2;
                    boolean bl = false;
                    object = Result.constructor-impl((Object)gitHashesServiceBase.resolveGitHashes(indicator));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                object2 = object;
                GitBlobSet result = (GitBlobSet)(Result.isFailure-impl((Object)object2) ? null : object2);
                GitHashesProjectServiceKt.access$getLOG$p().info("Collected Git Blobs: " + result);
                this.$callback.invoke((Object)result);
            }
        }.queue();
    }

    @Nullable
    public final GitBlobSet resolveGitHashes(@NotNull ProgressIndicator indicator) {
        Set gitChanged;
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        if (!this.isValid()) {
            return null;
        }
        if (this.gitRoot == null) {
            return null;
        }
        VirtualFile virtualFile = this.getGitRootFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile gitRootFile = virtualFile;
        Future<GitBlobSet> listBlobs2 = AppExecutorUtil.getAppExecutorService().submit(() -> GitHashesServiceBase.resolveGitHashes$lambda$1(gitRootFile, this, indicator));
        Future<Set> listFiles = AppExecutorUtil.getAppExecutorService().submit(() -> GitHashesServiceBase.resolveGitHashes$lambda$2(this));
        GitBlobSet gitBlobs = (GitBlobSet)ProgressIndicatorUtils.awaitWithCheckCanceled(listBlobs2);
        Set set = gitChanged = (Set)ProgressIndicatorUtils.awaitWithCheckCanceled(listFiles);
        Intrinsics.checkNotNull((Object)set);
        return gitBlobs.withIgnoredItems-Strings(set);
    }

    private static final GitBlobSet resolveGitHashes$lambda$1(VirtualFile $gitRootFile, GitHashesServiceBase this$0, ProgressIndicator $indicator) {
        Intrinsics.checkNotNullParameter((Object)$gitRootFile, (String)"$gitRootFile");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$indicator, (String)"$indicator");
        GitBlobSetBuilder builder = new GitBlobSetBuilder($gitRootFile);
        ProjectGitHelper.INSTANCE.logGitBlobHashes(this$0.project, this$0.gitRoot, $indicator, (Function2<? super String, ? super String, Unit>)((Function2)new Function2<String, String, Unit>(this$0, builder){
            final /* synthetic */ GitHashesServiceBase this$0;
            final /* synthetic */ GitBlobSetBuilder $builder;
            {
                this.this$0 = $receiver;
                this.$builder = $builder;
                super(2);
            }

            public final void invoke(@NotNull String relPath, @NotNull String hash2) {
                Object $this$invoke_u24lambda_u240;
                Intrinsics.checkNotNullParameter((Object)relPath, (String)"relPath");
                Intrinsics.checkNotNullParameter((Object)hash2, (String)"hash");
                Object object = this.this$0;
                try {
                    $this$invoke_u24lambda_u240 = object;
                    boolean bl = false;
                    $this$invoke_u24lambda_u240 = Result.constructor-impl((Object)StringUtil.parseHexString((String)hash2));
                }
                catch (Throwable bl) {
                    $this$invoke_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                object = $this$invoke_u24lambda_u240;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                if (throwable != null) {
                    Throwable it = throwable;
                    boolean bl = false;
                    return;
                }
                byte[] hashBytes = (byte[])object;
                Intrinsics.checkNotNull((Object)hashBytes);
                this.$builder.add(relPath, hashBytes);
            }
        }));
        return builder.build();
    }

    private static final Set resolveGitHashes$lambda$2(GitHashesServiceBase this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return ProjectGitHelper.INSTANCE.logGitModifiedFiles(this$0.project, this$0.gitRoot);
    }
}

