/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.ultimate.git;

import com.intellij.indexing.shared.ultimate.git.ProjectGitHelper;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/indexing/shared/ultimate/git/DumpGitRecentCommitsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.indexing.shared.ultimate.git"})
public final class DumpGitRecentCommitsAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        e.getPresentation().setEnabled(project != null && GitRepositoryManager.getInstance((Project)project).getRepositories().size() == 1);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        List list = GitRepositoryManager.getInstance((Project)project2).getRepositories();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRepositories(...)");
        GitRepository gitRepository = (GitRepository)CollectionsKt.singleOrNull((List)list);
        if (gitRepository == null) {
            return;
        }
        GitRepository repo = gitRepository;
        Path path = repo.getRoot().toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
        List commits = ProjectGitHelper.logRecentCommits$default(ProjectGitHelper.INSTANCE, project2, path, 0, 4, null);
        Messages.showInfoMessage((Project)project2, (String)("Detected the following commits\n" + CollectionsKt.joinToString$default((Iterable)commits, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)), (String)"Shared Project Indexes");
    }
}

