/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.intellij.indexing.shared.metadata.SharedIndexMetadata;
import com.intellij.indexing.shared.platform.api.AttachChunkResult;
import com.intellij.indexing.shared.platform.api.SharedIndexInfrastructureVersion;
import com.intellij.indexing.shared.platform.api.SharedIndexStats;
import com.intellij.indexing.shared.platform.impl.EmptyIndexEnumerator;
import com.intellij.indexing.shared.platform.impl.FileContentHashIndex;
import com.intellij.indexing.shared.platform.impl.SharedIndex;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.stubs.StubIndexEx;
import com.intellij.psi.stubs.StubIndexExtension;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.ID;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SharedIndexStorageUtil {
    private static final Logger LOG = Logger.getInstance(SharedIndexStorageUtil.class);
    private static final AtomicInteger CORRUPTION_COUNTER = new AtomicInteger();
    @VisibleForTesting
    public static volatile boolean FAIL_ON_CORRUPTED_CHUNK_ATTACHMENT = true;

    @NotNull
    static AttachChunkResult openFileBasedIndexChunks(int chunkId, @NotNull Path chunkRoot, @NotNull SharedIndexStats sharedIndexStats) throws IOException {
        SharedIndexMetadata metadata;
        if (chunkRoot == null) {
            SharedIndexStorageUtil.$$$reportNull$$$0(0);
        }
        if (sharedIndexStats == null) {
            SharedIndexStorageUtil.$$$reportNull$$$0(1);
        }
        if ((metadata = SharedIndexMetadata.readSharedIndexMetadata(chunkRoot)) == null) {
            AttachChunkResult.Incompatible incompatible = AttachChunkResult.Incompatible.INSTANCE;
            if (incompatible == null) {
                SharedIndexStorageUtil.$$$reportNull$$$0(2);
            }
            return incompatible;
        }
        SharedIndexInfrastructureVersion chunkVersion = metadata.getIndexInfrastructureVersion();
        SharedIndexInfrastructureVersion ideVersion = SharedIndexInfrastructureVersion.getIdeVersion();
        if (!ideVersion.isSuitableMetadata(metadata)) {
            AttachChunkResult.Incompatible incompatible = AttachChunkResult.Incompatible.INSTANCE;
            if (incompatible == null) {
                SharedIndexStorageUtil.$$$reportNull$$$0(3);
            }
            return incompatible;
        }
        return new AttachChunkResult.Success(chunkRoot, metadata, (ThrowableComputable<AttachChunkResult.Success.Indexes, IOException>)((ThrowableComputable)() -> SharedIndexStorageUtil.buildPayload(chunkId, chunkRoot, chunkVersion, ideVersion)), sharedIndexStats);
    }

    @NotNull
    private static AttachChunkResult.Success.Indexes buildPayload(int chunkId, @NotNull Path chunkRoot, @NotNull SharedIndexInfrastructureVersion chunkVersion, @NotNull SharedIndexInfrastructureVersion ideVersion) throws IOException {
        if (chunkRoot == null) {
            SharedIndexStorageUtil.$$$reportNull$$$0(4);
        }
        if (chunkVersion == null) {
            SharedIndexStorageUtil.$$$reportNull$$$0(5);
        }
        if (ideVersion == null) {
            SharedIndexStorageUtil.$$$reportNull$$$0(6);
        }
        Set suitableFbIndexes = Maps.filterEntries(chunkVersion.getFileBasedIndexVersions(), e -> {
            assert (e != null);
            boolean areVersionsEqual = ((String)e.getValue()).equals(ideVersion.getFileBasedIndexVersions().get(e.getKey()));
            if (!StubUpdatingIndex.INDEX_ID.getName().equals(e.getKey())) {
                return areVersionsEqual;
            }
            return areVersionsEqual && ideVersion.isStubIndexVersionMatch(chunkVersion);
        }).keySet();
        Set<String> suitableStubIndexes = Maps.filterEntries(chunkVersion.getStubIndexVersions(), e -> {
            assert (e != null);
            return ((String)e.getValue()).equals(ideVersion.getStubIndexVersions().get(e.getKey()));
        }).keySet();
        ArrayList matchingFbIndexes = new ArrayList();
        ArrayList<ID> mismatchingFbIndexes = new ArrayList<ID>();
        ArrayList<String> redundantFbIndexes = new ArrayList<String>();
        ArrayList matchingStubIndexes = new ArrayList();
        ArrayList mismatchingStubIndexes = new ArrayList();
        ArrayList<String> redundantStubIndexes = new ArrayList<String>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(chunkRoot);){
            for (Path indexDir : directoryStream) {
                String indexId = indexDir.getFileName().toString();
                ID id2 = ID.findByName((String)indexId);
                if (id2 == null) {
                    redundantFbIndexes.add(indexId);
                    continue;
                }
                if (suitableFbIndexes.contains(id2.getName()) || id2.equals(StubUpdatingIndex.INDEX_ID)) {
                    FileBasedIndexExtension<?, ?> extension2 = SharedIndexStorageUtil.findExtension(id2);
                    if (extension2 != null) {
                        try {
                            matchingFbIndexes.add(new SharedIndex.Impl(chunkRoot, id2, chunkId, extension2, FileContentHashIndex.getFileContentHashIndex(id2), chunkVersion));
                        }
                        catch (Exception e2) {
                            SharedIndexStorageUtil.logAttachError("failed to open shared index: extension = " + id2 + ", chunk = " + chunkRoot, e2);
                        }
                    }
                    if (!id2.equals(StubUpdatingIndex.INDEX_ID)) continue;
                    StubChunks stubChunks = SharedIndexStorageUtil.openStubIndexChunks(indexDir, chunkVersion, chunkId, suitableStubIndexes);
                    matchingStubIndexes.addAll(stubChunks.matchingStubIndexes);
                    mismatchingStubIndexes.addAll(stubChunks.mismatchingStubIndexes);
                    redundantStubIndexes.addAll(stubChunks.redundantStubIndexes);
                    continue;
                }
                mismatchingFbIndexes.add(id2);
            }
        }
        Set<String> emptyIndexNames = EmptyIndexEnumerator.readEmptyIndexes(chunkRoot);
        Set<String> emptyStubIndexNames = EmptyIndexEnumerator.readEmptyStubIndexes(chunkRoot);
        List matchingEmptyStubIndexes = emptyStubIndexNames.stream().map(ID::findByName).filter(id -> id instanceof StubIndexKey).map(id -> SharedIndexStorageUtil.findStubExtension(id)).filter(Objects::nonNull).map(extension -> new SharedIndex.Empty(extension.getName(), chunkId)).collect(Collectors.toList());
        List<SharedIndex.Empty> matchingEmptyFbIndexes = emptyIndexNames.stream().map(ID::findByName).filter(id -> Objects.nonNull(id) && suitableFbIndexes.contains(id.getName())).map(id -> new SharedIndex.Empty(id, chunkId)).toList();
        return new AttachChunkResult.Success.Indexes(ContainerUtil.concat((List[])new List[]{matchingFbIndexes, matchingStubIndexes, matchingEmptyFbIndexes, matchingEmptyStubIndexes}), Streams.concat((Stream[])new Stream[]{matchingFbIndexes.stream(), matchingEmptyFbIndexes.stream()}).map(i -> i.getIndexName()).collect(Collectors.toList()), Streams.concat((Stream[])new Stream[]{matchingStubIndexes.stream(), matchingEmptyStubIndexes.stream()}).map(i -> i.getIndexName()).collect(Collectors.toList()), mismatchingFbIndexes, mismatchingStubIndexes, redundantFbIndexes, redundantStubIndexes);
    }

    @NotNull
    private static StubChunks openStubIndexChunks(@NotNull Path stubIndexDir, @NotNull SharedIndexInfrastructureVersion chunkVersion, int chunkId, @NotNull Set<String> suitableStubIndexes) throws IOException {
        if (stubIndexDir == null) {
            SharedIndexStorageUtil.$$$reportNull$$$0(7);
        }
        if (chunkVersion == null) {
            SharedIndexStorageUtil.$$$reportNull$$$0(8);
        }
        if (suitableStubIndexes == null) {
            SharedIndexStorageUtil.$$$reportNull$$$0(9);
        }
        ArrayList matchingStubIndexes = new ArrayList();
        ArrayList mismatchingStubIndexes = new ArrayList();
        ArrayList<String> redundantStubIndexes = new ArrayList<String>();
        try (Stream<Path> dirs = Files.list(stubIndexDir);){
            dirs.forEach(stubIndexExDir -> {
                String stubIndexId = stubIndexExDir.getFileName().toString();
                ID id = ID.findByName((String)stubIndexId);
                if (id instanceof StubIndexKey) {
                    FileBasedIndexExtension<?, Void> extension = SharedIndexStorageUtil.findStubExtension(id);
                    if (extension != null) {
                        try {
                            SharedIndex.Impl sharedIndex = new SharedIndex.Impl(stubIndexDir, extension.getName(), chunkId, extension, FileContentHashIndex.getFileContentHashIndex(extension.getName()), chunkVersion);
                            matchingStubIndexes.add(sharedIndex);
                        }
                        catch (Exception e) {
                            SharedIndexStorageUtil.logAttachError("failed to open shared stub index: extension = " + id + ", chunk = " + stubIndexDir.getParent().getFileName().toString(), e);
                        }
                        if (!suitableStubIndexes.contains(stubIndexId)) {
                            mismatchingStubIndexes.add((StubIndexKey)id);
                        }
                    }
                } else {
                    redundantStubIndexes.add(stubIndexId);
                }
            });
        }
        return new StubChunks(matchingStubIndexes, mismatchingStubIndexes, redundantStubIndexes);
    }

    @Nullable
    private static FileBasedIndexExtension<?, ?> findExtension(@Nullable ID<?, ?> id) {
        if (id == null) {
            return null;
        }
        return (FileBasedIndexExtension)FileBasedIndexExtension.EXTENSION_POINT_NAME.findFirstSafe(ex -> ex.getName().equals(id));
    }

    @Nullable
    private static FileBasedIndexExtension<?, Void> findStubExtension(@Nullable ID<?, ?> id) {
        if (id == null) {
            return null;
        }
        StubIndexExtension stubEx = (StubIndexExtension)StubIndexExtension.EP_NAME.findFirstSafe(ex -> ex.getKey().equals(id));
        return stubEx == null ? null : StubIndexEx.wrapStubIndexExtension((StubIndexExtension)stubEx);
    }

    static void logAttachError(@NotNull String message, @NotNull Throwable error) {
        if (message == null) {
            SharedIndexStorageUtil.$$$reportNull$$$0(10);
        }
        if (error == null) {
            SharedIndexStorageUtil.$$$reportNull$$$0(11);
        }
        CORRUPTION_COUNTER.incrementAndGet();
        if (FAIL_ON_CORRUPTED_CHUNK_ATTACHMENT) {
            LOG.error(message, error);
        } else {
            LOG.warn(message, error);
        }
    }

    @VisibleForTesting
    public static int getCorruptionCount() {
        return CORRUPTION_COUNTER.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunkRoot";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sharedIndexStats";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/platform/impl/SharedIndexStorageUtil";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunkVersion";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideVersion";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubIndexDir";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suitableStubIndexes";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/platform/impl/SharedIndexStorageUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "openFileBasedIndexChunks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "openFileBasedIndexChunks";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildPayload";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "openStubIndexChunks";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "logAttachError";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    private static class StubChunks {
        public final List<SharedIndex<?, ?>> matchingStubIndexes;
        public final List<StubIndexKey<?, ?>> mismatchingStubIndexes;
        public final List<String> redundantStubIndexes;

        private StubChunks(List<SharedIndex<?, ?>> matchingStubIndexes, List<StubIndexKey<?, ?>> mismatchingStubIndexes, List<String> redundantStubIndexes) {
            this.matchingStubIndexes = matchingStubIndexes;
            this.mismatchingStubIndexes = mismatchingStubIndexes;
            this.redundantStubIndexes = redundantStubIndexes;
        }
    }
}

