/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download;

import com.intellij.indexing.shared.download.SharedIndexCompression;
import com.intellij.indexing.shared.download.SharedIndexLineup;
import com.intellij.indexing.shared.download.SharedIndexLookupRequest;
import com.intellij.indexing.shared.metadata.SharedIndexMetadata;
import com.intellij.indexing.shared.platform.api.SharedIndexInfrastructureVersion;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u0005H\u0016R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0015\u001a\u00020\u00168FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u001a*\u0004\b\u0017\u0010\u0018R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0012\u00a8\u0006)"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexLookupResult;", "", "request", "Lcom/intellij/indexing/shared/download/SharedIndexLookupRequest;", "url", "", "sha256", "size", "", "compression", "Lcom/intellij/indexing/shared/download/SharedIndexCompression;", "sharedIndexMetadata", "Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata;", "lineup", "Lcom/intellij/indexing/shared/download/SharedIndexLineup;", "(Lcom/intellij/indexing/shared/download/SharedIndexLookupRequest;Ljava/lang/String;Ljava/lang/String;JLcom/intellij/indexing/shared/download/SharedIndexCompression;Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata;Lcom/intellij/indexing/shared/download/SharedIndexLineup;)V", "chunkUniqueId", "getChunkUniqueId", "()Ljava/lang/String;", "getCompression", "()Lcom/intellij/indexing/shared/download/SharedIndexCompression;", "indexVersion", "Lcom/intellij/indexing/shared/platform/api/SharedIndexInfrastructureVersion;", "getIndexVersion$delegate", "(Lcom/intellij/indexing/shared/download/SharedIndexLookupResult;)Ljava/lang/Object;", "getIndexVersion", "()Lcom/intellij/indexing/shared/platform/api/SharedIndexInfrastructureVersion;", "getRequest", "()Lcom/intellij/indexing/shared/download/SharedIndexLookupRequest;", "getSha256", "getSharedIndexMetadata", "()Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata;", "getSize", "()J", "getUrl", "equals", "", "other", "hashCode", "", "toString", "intellij.indexing.shared"})
public final class SharedIndexLookupResult {
    @NotNull
    private final SharedIndexLookupRequest request;
    @NotNull
    private final String url;
    @NotNull
    private final String sha256;
    private final long size;
    @NotNull
    private final SharedIndexCompression compression;
    @NotNull
    private final SharedIndexMetadata sharedIndexMetadata;
    @Nullable
    private final SharedIndexLineup lineup;
    @NotNull
    private final String chunkUniqueId;

    public SharedIndexLookupResult(@NotNull SharedIndexLookupRequest request, @NotNull String url, @NotNull String sha256, long size, @NotNull SharedIndexCompression compression, @NotNull SharedIndexMetadata sharedIndexMetadata, @Nullable SharedIndexLineup lineup) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)sha256, (String)"sha256");
        Intrinsics.checkNotNullParameter((Object)((Object)compression), (String)"compression");
        Intrinsics.checkNotNullParameter((Object)sharedIndexMetadata, (String)"sharedIndexMetadata");
        this.request = request;
        this.url = url;
        this.sha256 = sha256;
        this.size = size;
        this.compression = compression;
        this.sharedIndexMetadata = sharedIndexMetadata;
        this.lineup = lineup;
        this.chunkUniqueId = this.request.getKind() + "-" + this.sharedIndexMetadata.getIndexName() + "-" + this.getIndexVersion().getWeakVersionHash() + "-" + StringUtil.first((String)this.sha256, (int)8, (boolean)false);
    }

    @NotNull
    public final SharedIndexLookupRequest getRequest() {
        return this.request;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final String getSha256() {
        return this.sha256;
    }

    public final long getSize() {
        return this.size;
    }

    @NotNull
    public final SharedIndexCompression getCompression() {
        return this.compression;
    }

    @NotNull
    public final SharedIndexMetadata getSharedIndexMetadata() {
        return this.sharedIndexMetadata;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SharedIndexLookupResult)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.url, (Object)((SharedIndexLookupResult)other).url) && Intrinsics.areEqual((Object)this.sha256, (Object)((SharedIndexLookupResult)other).sha256);
    }

    @NotNull
    public final SharedIndexInfrastructureVersion getIndexVersion() {
        return this.sharedIndexMetadata.getIndexInfrastructureVersion();
    }

    private static Object getIndexVersion$delegate(SharedIndexLookupResult sharedIndexLookupResult) {
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)sharedIndexLookupResult.sharedIndexMetadata, SharedIndexMetadata.class, "indexInfrastructureVersion", "getIndexInfrastructureVersion()Lcom/intellij/indexing/shared/platform/api/SharedIndexInfrastructureVersion;", 0)));
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.url, this.sha256};
        return Objects.hash(objectArray);
    }

    @NotNull
    public final String getChunkUniqueId() {
        return this.chunkUniqueId;
    }

    @NotNull
    public String toString() {
        return "SharedIndexResult(request='" + this.request + "', url='" + this.url + "', weakHash=" + this.getIndexVersion().getWeakVersionHash() + ", sha256='" + this.sha256 + "')";
    }
}

