/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ContentChange;
import com.intellij.history.core.changes.CreateDirectoryChange;
import com.intellij.history.core.changes.CreateFileChange;
import com.intellij.history.core.changes.DeleteChange;
import com.intellij.history.core.changes.MoveChange;
import com.intellij.history.core.changes.PutLabelChange;
import com.intellij.history.core.changes.PutSystemLabelChange;
import com.intellij.history.core.changes.ROStatusChange;
import com.intellij.history.core.changes.RenameChange;
import com.intellij.history.core.tree.DirectoryEntry;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.FileEntry;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataStreamUtil {
    public static Entry readEntry(DataInput in) throws IOException {
        int type = DataInputOutputUtil.readINT((DataInput)in);
        return switch (type) {
            case 0 -> new FileEntry(in, true);
            case 1 -> new DirectoryEntry(in, true);
            default -> throw new IOException("unexpected entry type: " + type);
        };
    }

    public static void writeEntry(@NotNull DataOutput out, Entry e) throws IOException {
        if (out == null) {
            DataStreamUtil.$$$reportNull$$$0(0);
        }
        int id = -1;
        Class<?> c = e.getClass();
        if (c.equals(FileEntry.class)) {
            id = 0;
        }
        if (c.equals(DirectoryEntry.class)) {
            id = 1;
        }
        if (id == -1) {
            throw new IOException("unexpected entry type: " + c);
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)id);
        e.write(out);
    }

    public static Change readChange(DataInput in) throws IOException {
        int type = DataInputOutputUtil.readINT((DataInput)in);
        return switch (type) {
            case 1 -> new CreateFileChange(in);
            case 2 -> new CreateDirectoryChange(in);
            case 3 -> new ContentChange(in);
            case 4 -> new RenameChange(in);
            case 5 -> new ROStatusChange(in);
            case 6 -> new MoveChange(in);
            case 7 -> new DeleteChange(in);
            case 8 -> new PutLabelChange(in);
            case 9 -> new PutSystemLabelChange(in);
            default -> throw new IOException("unexpected change type: " + type);
        };
    }

    public static void writeChange(DataOutput out, Change change) throws IOException {
        int id = -1;
        Class<?> c = change.getClass();
        if (c.equals(CreateFileChange.class)) {
            id = 1;
        }
        if (c.equals(CreateDirectoryChange.class)) {
            id = 2;
        }
        if (c.equals(ContentChange.class)) {
            id = 3;
        }
        if (c.equals(RenameChange.class)) {
            id = 4;
        }
        if (c.equals(ROStatusChange.class)) {
            id = 5;
        }
        if (c.equals(MoveChange.class)) {
            id = 6;
        }
        if (c.equals(DeleteChange.class)) {
            id = 7;
        }
        if (c.equals(PutLabelChange.class)) {
            id = 8;
        }
        if (c.equals(PutSystemLabelChange.class)) {
            id = 9;
        }
        if (id == -1) {
            throw new IOException("unexpected change type: " + c);
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)id);
        change.write(out);
    }

    @NotNull
    public static String readString(DataInput in) throws IOException {
        String string = IOUtil.readUTF((DataInput)in);
        if (string == null) {
            DataStreamUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static void writeString(DataOutput out, @NotNull String s) throws IOException {
        if (s == null) {
            DataStreamUtil.$$$reportNull$$$0(2);
        }
        IOUtil.writeUTF((DataOutput)out, (String)s);
    }

    @Nullable
    public static String readStringOrNull(DataInput in) throws IOException {
        if (!in.readBoolean()) {
            return null;
        }
        return DataStreamUtil.readString(in);
    }

    public static void writeStringOrNull(DataOutput out, @Nullable String s) throws IOException {
        out.writeBoolean(s != null);
        if (s != null) {
            DataStreamUtil.writeString(out, s);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/history/core/DataStreamUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/history/core/DataStreamUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "readString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeEntry";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

