/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.spec;

import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.formatting.string.StringFormat;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Geom;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.geom.AreaGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.AreaRidgesGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.BoxplotGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.CrossBarGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.CurveGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.DensityGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.DotplotGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.ErrorBarGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.ImageGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.LabelGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.LineRangeGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.LollipopGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.PathGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.PieGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.PointGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.PointRangeGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.RibbonGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.SegmentGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.SpokeGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.StepGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.TextGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.ViolinGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.YDotplotGeom;
import org.jetbrains.letsPlot.core.plot.base.stat.DotplotStat;
import org.jetbrains.letsPlot.core.plot.builder.assemble.geom.GeomProvider;
import org.jetbrains.letsPlot.core.spec.Option;
import org.jetbrains.letsPlot.core.spec.config.ArrowSpecConfig;
import org.jetbrains.letsPlot.core.spec.config.OptionsAccessor;
import org.jetbrains.letsPlot.core.spec.conversion.AesOptionConversion;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J&\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/letsPlot/core/spec/GeomProviderFactory;", "", "()V", "PROVIDER", "Ljava/util/HashMap;", "Lorg/jetbrains/letsPlot/core/plot/base/GeomKind;", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/geom/GeomProvider;", "Lkotlin/collections/HashMap;", "applyTextOptions", "", "opts", "Lorg/jetbrains/letsPlot/core/spec/config/OptionsAccessor;", "geom", "Lorg/jetbrains/letsPlot/core/plot/base/geom/TextGeom;", "superscriptExponent", "", "createGeomProvider", "geomKind", "layerConfig", "aopConversion", "Lorg/jetbrains/letsPlot/core/spec/conversion/AesOptionConversion;", "isVertical", "ctx", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/geom/GeomProvider$Context;", "geomName", "", "plot-stem"})
@SourceDebugExtension(value={"SMAP\nGeomProviderFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeomProviderFactory.kt\norg/jetbrains/letsPlot/core/spec/GeomProviderFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,420:1\n1#2:421\n1747#3,3:422\n1747#3,3:425\n*S KotlinDebug\n*F\n+ 1 GeomProviderFactory.kt\norg/jetbrains/letsPlot/core/spec/GeomProviderFactory\n*L\n412#1:422,3\n413#1:425,3\n*E\n"})
public final class GeomProviderFactory {
    @NotNull
    public static final GeomProviderFactory INSTANCE = new GeomProviderFactory();
    @NotNull
    private static final HashMap<GeomKind, GeomProvider> PROVIDER = new HashMap();

    private GeomProviderFactory() {
    }

    @NotNull
    public final GeomProvider createGeomProvider(@NotNull GeomKind geomKind, @NotNull OptionsAccessor layerConfig, @NotNull AesOptionConversion aopConversion, boolean superscriptExponent) {
        GeomProvider geomProvider;
        Intrinsics.checkNotNullParameter((Object)((Object)geomKind), (String)"geomKind");
        Intrinsics.checkNotNullParameter((Object)layerConfig, (String)"layerConfig");
        Intrinsics.checkNotNullParameter((Object)aopConversion, (String)"aopConversion");
        switch (WhenMappings.$EnumSwitchMapping$0[geomKind.ordinal()]) {
            case 1: {
                geomProvider = GeomProvider.Companion.area((Function1<? super GeomProvider.Context, ? extends Geom>)((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig){
                    final /* synthetic */ OptionsAccessor $layerConfig;
                    {
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        AreaGeom geom2 = new AreaGeom();
                        if (this.$layerConfig.hasOwn("flat")) {
                            geom2.setFlat(OptionsAccessor.getBoolean$default(this.$layerConfig, "flat", false, 2, null));
                        }
                        return geom2;
                    }
                }));
                break;
            }
            case 2: {
                geomProvider = GeomProvider.Companion.density((Function1<? super GeomProvider.Context, ? extends Geom>)((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig){
                    final /* synthetic */ OptionsAccessor $layerConfig;
                    {
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        DensityGeom geom2 = new DensityGeom();
                        if (this.$layerConfig.hasOwn("quantiles")) {
                            geom2.setQuantiles(this.$layerConfig.getBoundedDoubleList("quantiles", 0.0, 1.0));
                        }
                        if (this.$layerConfig.hasOwn("quantile_lines")) {
                            geom2.setQuantileLines(this.$layerConfig.getBoolean("quantile_lines", false));
                        }
                        return geom2;
                    }
                }));
                break;
            }
            case 3: {
                geomProvider = GeomProvider.Companion.dotplot((Function1<? super GeomProvider.Context, ? extends Geom>)((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig){
                    final /* synthetic */ OptionsAccessor $layerConfig;
                    {
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        DotplotGeom geom2;
                        block20: {
                            DotplotGeom.Stackdir stackdir;
                            void it2;
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            geom2 = new DotplotGeom();
                            if (this.$layerConfig.hasOwn("dotsize")) {
                                Double d = this.$layerConfig.getDouble("dotsize");
                                Intrinsics.checkNotNull((Object)d);
                                geom2.setDotSize(d);
                            }
                            if (this.$layerConfig.hasOwn("stackratio")) {
                                Double d = this.$layerConfig.getDouble("stackratio");
                                Intrinsics.checkNotNull((Object)d);
                                geom2.setStackRatio(d);
                            }
                            if (this.$layerConfig.hasOwn("stackgroups")) {
                                geom2.setStackGroups(OptionsAccessor.getBoolean$default(this.$layerConfig, "stackgroups", false, 2, null));
                            }
                            if (!this.$layerConfig.hasOwn("stackdir")) break block20;
                            String string = this.$layerConfig.getString("stackdir");
                            Intrinsics.checkNotNull((Object)string);
                            String string2 = string;
                            DotplotGeom dotplotGeom = geom2;
                            boolean bl = false;
                            String string3 = it2.toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                            switch (string3) {
                                case "up": {
                                    stackdir = DotplotGeom.Stackdir.UP;
                                    break;
                                }
                                case "down": {
                                    stackdir = DotplotGeom.Stackdir.DOWN;
                                    break;
                                }
                                case "center": {
                                    stackdir = DotplotGeom.Stackdir.CENTER;
                                    break;
                                }
                                case "centerwhole": {
                                    stackdir = DotplotGeom.Stackdir.CENTERWHOLE;
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("Unsupported stackdir: '" + (String)it2 + "'. Use one of: up, down, center, centerwhole.");
                                }
                            }
                            dotplotGeom.setStackDir(stackdir);
                        }
                        if (this.$layerConfig.hasOwn("method")) {
                            String string = this.$layerConfig.getString("method");
                            Intrinsics.checkNotNull((Object)string);
                            geom2.setMethod(DotplotStat.Method.Companion.safeValueOf(string));
                        }
                        return geom2;
                    }
                }));
                break;
            }
            case 4: {
                geomProvider = GeomProvider.Companion.errorBar((Function1<? super GeomProvider.Context, ? extends Geom>)((Function1)new Function1<GeomProvider.Context, Geom>(geomKind){
                    final /* synthetic */ GeomKind $geomKind;
                    {
                        this.$geomKind = $geomKind;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context ctx2) {
                        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
                        return new ErrorBarGeom(GeomProviderFactory.access$isVertical(GeomProviderFactory.INSTANCE, ctx2, this.$geomKind.name()));
                    }
                }));
                break;
            }
            case 5: {
                geomProvider = GeomProvider.Companion.lineRange((Function1<? super GeomProvider.Context, ? extends Geom>)((Function1)new Function1<GeomProvider.Context, Geom>(geomKind){
                    final /* synthetic */ GeomKind $geomKind;
                    {
                        this.$geomKind = $geomKind;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context ctx2) {
                        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
                        return new LineRangeGeom(GeomProviderFactory.access$isVertical(GeomProviderFactory.INSTANCE, ctx2, this.$geomKind.name()));
                    }
                }));
                break;
            }
            case 6: {
                geomProvider = GeomProvider.Companion.ribbon((Function1<? super GeomProvider.Context, ? extends Geom>)((Function1)new Function1<GeomProvider.Context, Geom>(geomKind){
                    final /* synthetic */ GeomKind $geomKind;
                    {
                        this.$geomKind = $geomKind;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context ctx2) {
                        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
                        return new RibbonGeom(GeomProviderFactory.access$isVertical(GeomProviderFactory.INSTANCE, ctx2, this.$geomKind.name()));
                    }
                }));
                break;
            }
            case 7: {
                geomProvider = GeomProvider.Companion.crossBar((Function1<? super GeomProvider.Context, ? extends Geom>)((Function1)new Function1<GeomProvider.Context, Geom>(geomKind, layerConfig){
                    final /* synthetic */ GeomKind $geomKind;
                    final /* synthetic */ OptionsAccessor $layerConfig;
                    {
                        this.$geomKind = $geomKind;
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context ctx2) {
                        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
                        CrossBarGeom geom2 = new CrossBarGeom(GeomProviderFactory.access$isVertical(GeomProviderFactory.INSTANCE, ctx2, this.$geomKind.name()));
                        if (this.$layerConfig.hasOwn("fatten")) {
                            Double d = this.$layerConfig.getDouble("fatten");
                            Intrinsics.checkNotNull((Object)d);
                            geom2.setFattenMidline(d);
                        }
                        return geom2;
                    }
                }));
                break;
            }
            case 8: {
                geomProvider = GeomProvider.Companion.pointRange((Function1<? super GeomProvider.Context, ? extends Geom>)((Function1)new Function1<GeomProvider.Context, Geom>(geomKind, layerConfig){
                    final /* synthetic */ GeomKind $geomKind;
                    final /* synthetic */ OptionsAccessor $layerConfig;
                    {
                        this.$geomKind = $geomKind;
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context ctx2) {
                        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
                        PointRangeGeom geom2 = new PointRangeGeom(GeomProviderFactory.access$isVertical(GeomProviderFactory.INSTANCE, ctx2, this.$geomKind.name()));
                        if (this.$layerConfig.hasOwn("fatten")) {
                            Double d = this.$layerConfig.getDouble("fatten");
                            Intrinsics.checkNotNull((Object)d);
                            geom2.setFattenMidPoint(d);
                        }
                        return geom2;
                    }
                }));
                break;
            }
            case 9: {
                geomProvider = GeomProvider.Companion.boxplot((Function1<? super GeomProvider.Context, ? extends Geom>)((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig){
                    final /* synthetic */ OptionsAccessor $layerConfig;
                    {
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context ctx2) {
                        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
                        BoxplotGeom geom2 = new BoxplotGeom();
                        if (this.$layerConfig.hasOwn("fatten")) {
                            Double d = this.$layerConfig.getDouble("fatten");
                            Intrinsics.checkNotNull((Object)d);
                            geom2.setFattenMidline(d);
                        }
                        if (this.$layerConfig.hasOwn("whisker_width")) {
                            Double d = this.$layerConfig.getDouble("whisker_width");
                            Intrinsics.checkNotNull((Object)d);
                            geom2.setWhiskerWidth(d);
                        }
                        return geom2;
                    }
                }));
                break;
            }
            case 10: {
                geomProvider = GeomProvider.Companion.arearidges((Function1<? super GeomProvider.Context, ? extends Geom>)((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig){
                    final /* synthetic */ OptionsAccessor $layerConfig;
                    {
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        AreaRidgesGeom geom2 = new AreaRidgesGeom();
                        if (this.$layerConfig.hasOwn("scale")) {
                            geom2.setScale(this.$layerConfig.getDoubleDef("scale", 1.0));
                        }
                        if (this.$layerConfig.hasOwn("min_height")) {
                            geom2.setMinHeight(this.$layerConfig.getDoubleDef("min_height", 0.0));
                        }
                        if (this.$layerConfig.hasOwn("quantiles")) {
                            geom2.setQuantiles(this.$layerConfig.getBoundedDoubleList("quantiles", 0.0, 1.0));
                        }
                        if (this.$layerConfig.hasOwn("quantile_lines")) {
                            geom2.setQuantileLines(this.$layerConfig.getBoolean("quantile_lines", false));
                        }
                        return geom2;
                    }
                }));
                break;
            }
            case 11: {
                geomProvider = GeomProvider.Companion.violin((Function1<? super GeomProvider.Context, ? extends Geom>)((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig){
                    final /* synthetic */ OptionsAccessor $layerConfig;
                    {
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        ViolinGeom geom2 = new ViolinGeom();
                        if (this.$layerConfig.hasOwn("quantiles")) {
                            geom2.setQuantiles(this.$layerConfig.getBoundedDoubleList("quantiles", 0.0, 1.0));
                        }
                        if (this.$layerConfig.hasOwn("quantile_lines")) {
                            geom2.setQuantileLines(this.$layerConfig.getBoolean("quantile_lines", false));
                        }
                        if (this.$layerConfig.hasOwn("show_half")) {
                            Double d = this.$layerConfig.getDouble("show_half");
                            Intrinsics.checkNotNull((Object)d);
                            geom2.setShowHalf(d);
                        }
                        return geom2;
                    }
                }));
                break;
            }
            case 12: {
                geomProvider = GeomProvider.Companion.ydotplot((Function1<? super GeomProvider.Context, ? extends Geom>)((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig){
                    final /* synthetic */ OptionsAccessor $layerConfig;
                    {
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        YDotplotGeom geom2;
                        block20: {
                            YDotplotGeom.YStackdir yStackdir;
                            void it2;
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            geom2 = new YDotplotGeom();
                            if (this.$layerConfig.hasOwn("dotsize")) {
                                Double d = this.$layerConfig.getDouble("dotsize");
                                Intrinsics.checkNotNull((Object)d);
                                geom2.setDotSize(d);
                            }
                            if (this.$layerConfig.hasOwn("stackratio")) {
                                Double d = this.$layerConfig.getDouble("stackratio");
                                Intrinsics.checkNotNull((Object)d);
                                geom2.setStackRatio(d);
                            }
                            if (this.$layerConfig.hasOwn("stackgroups")) {
                                geom2.setStackGroups(OptionsAccessor.getBoolean$default(this.$layerConfig, "stackgroups", false, 2, null));
                            }
                            if (!this.$layerConfig.hasOwn("stackdir")) break block20;
                            String string = this.$layerConfig.getString("stackdir");
                            Intrinsics.checkNotNull((Object)string);
                            String string2 = string;
                            YDotplotGeom yDotplotGeom = geom2;
                            boolean bl = false;
                            String string3 = it2.toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                            switch (string3) {
                                case "left": {
                                    yStackdir = YDotplotGeom.YStackdir.LEFT;
                                    break;
                                }
                                case "right": {
                                    yStackdir = YDotplotGeom.YStackdir.RIGHT;
                                    break;
                                }
                                case "center": {
                                    yStackdir = YDotplotGeom.YStackdir.CENTER;
                                    break;
                                }
                                case "centerwhole": {
                                    yStackdir = YDotplotGeom.YStackdir.CENTERWHOLE;
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("Unsupported stackdir: '" + (String)it2 + "'. Use one of: left, right, center, centerwhole.");
                                }
                            }
                            yDotplotGeom.setYStackDir(yStackdir);
                        }
                        if (this.$layerConfig.hasOwn("method")) {
                            String string = this.$layerConfig.getString("method");
                            Intrinsics.checkNotNull((Object)string);
                            geom2.setMethod(DotplotStat.Method.Companion.safeValueOf(string));
                        }
                        return geom2;
                    }
                }));
                break;
            }
            case 13: {
                geomProvider = GeomProvider.Companion.step((Function1<? super GeomProvider.Context, ? extends Geom>)((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig){
                    final /* synthetic */ OptionsAccessor $layerConfig;
                    {
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        StepGeom geom2 = new StepGeom();
                        if (this.$layerConfig.hasOwn("direction")) {
                            String string = this.$layerConfig.getString("direction");
                            Intrinsics.checkNotNull((Object)string);
                            geom2.setDirection(string);
                        }
                        if (this.$layerConfig.hasOwn("pad")) {
                            geom2.setPadded(this.$layerConfig.getBoolean("pad", false));
                        }
                        return geom2;
                    }
                }));
                break;
            }
            case 14: {
                geomProvider = GeomProvider.Companion.segment((Function1<? super GeomProvider.Context, ? extends Geom>)((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig){
                    final /* synthetic */ OptionsAccessor $layerConfig;
                    {
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        SegmentGeom geom2;
                        block4: {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            geom2 = new SegmentGeom();
                            if (this.$layerConfig.has("arrow")) {
                                Object object = this.$layerConfig.get("arrow");
                                Intrinsics.checkNotNull((Object)object);
                                ArrowSpecConfig arrowConfig = ArrowSpecConfig.Companion.create(object);
                                geom2.setArrowSpec(arrowConfig.createArrowSpec());
                            }
                            if (this.$layerConfig.has("animation")) {
                                geom2.setAnimation(this.$layerConfig.get("animation"));
                            }
                            if (this.$layerConfig.has("flat")) {
                                geom2.setFlat(OptionsAccessor.getBoolean$default(this.$layerConfig, "flat", false, 2, null));
                            }
                            if (this.$layerConfig.has("geodesic")) {
                                geom2.setGeodesic(OptionsAccessor.getBoolean$default(this.$layerConfig, "geodesic", false, 2, null));
                            }
                            Double d = this.$layerConfig.getDouble("spacer");
                            if (d == null) break block4;
                            double it2 = ((Number)d).doubleValue();
                            boolean bl = false;
                            geom2.setSpacer(it2);
                        }
                        return geom2;
                    }
                }));
                break;
            }
            case 15: {
                return GeomProvider.Companion.curve((Function1<? super GeomProvider.Context, ? extends Geom>)((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig){
                    final /* synthetic */ OptionsAccessor $layerConfig;
                    {
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        CurveGeom geom2;
                        block4: {
                            double it2;
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            geom2 = new CurveGeom();
                            Double d = this.$layerConfig.getDouble("curvature");
                            if (d != null) {
                                it2 = ((Number)d).doubleValue();
                                boolean bl = false;
                                geom2.setCurvature(it2);
                            }
                            Double d2 = this.$layerConfig.getDouble("angle");
                            if (d2 != null) {
                                it2 = ((Number)d2).doubleValue();
                                boolean bl = false;
                                geom2.setAngle(it2);
                            }
                            Integer n = this.$layerConfig.getInteger("ncp");
                            if (n != null) {
                                int it3 = ((Number)n).intValue();
                                boolean bl = false;
                                geom2.setNcp(it3);
                            }
                            if (this.$layerConfig.has("arrow")) {
                                Object object = this.$layerConfig.get("arrow");
                                Intrinsics.checkNotNull((Object)object);
                                ArrowSpecConfig arrowConfig = ArrowSpecConfig.Companion.create(object);
                                geom2.setArrowSpec(arrowConfig.createArrowSpec());
                            }
                            Double d3 = this.$layerConfig.getDouble("spacer");
                            if (d3 == null) break block4;
                            double it4 = ((Number)d3).doubleValue();
                            boolean bl = false;
                            geom2.setSpacer(it4);
                        }
                        return geom2;
                    }
                }));
            }
            case 16: {
                geomProvider = GeomProvider.Companion.path((Function1<? super GeomProvider.Context, ? extends Geom>)((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig){
                    final /* synthetic */ OptionsAccessor $layerConfig;
                    {
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        PathGeom geom2 = new PathGeom();
                        if (this.$layerConfig.has("animation")) {
                            geom2.setAnimation(this.$layerConfig.get("animation"));
                        }
                        if (this.$layerConfig.has("flat")) {
                            geom2.setFlat(OptionsAccessor.getBoolean$default(this.$layerConfig, "flat", false, 2, null));
                        }
                        if (this.$layerConfig.has("geodesic")) {
                            geom2.setGeodesic(OptionsAccessor.getBoolean$default(this.$layerConfig, "geodesic", false, 2, null));
                        }
                        return geom2;
                    }
                }));
                break;
            }
            case 17: {
                geomProvider = GeomProvider.Companion.point((Function1<? super GeomProvider.Context, ? extends Geom>)((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig){
                    final /* synthetic */ OptionsAccessor $layerConfig;
                    {
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        String string;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        PointGeom geom2 = new PointGeom();
                        if (this.$layerConfig.has("animation")) {
                            geom2.setAnimation(this.$layerConfig.get("animation"));
                        }
                        String string2 = this.$layerConfig.getString("size_unit");
                        if (string2 != null) {
                            String string3 = string2.toLowerCase(Locale.ROOT);
                            string = string3;
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                        } else {
                            string = null;
                        }
                        geom2.setSizeUnit(string);
                        return geom2;
                    }
                }));
                break;
            }
            case 18: {
                geomProvider = GeomProvider.Companion.text((Function1<? super GeomProvider.Context, ? extends Geom>)((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig, superscriptExponent){
                    final /* synthetic */ OptionsAccessor $layerConfig;
                    final /* synthetic */ boolean $superscriptExponent;
                    {
                        this.$layerConfig = $layerConfig;
                        this.$superscriptExponent = $superscriptExponent;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        TextGeom geom2 = new TextGeom();
                        GeomProviderFactory.access$applyTextOptions(GeomProviderFactory.INSTANCE, this.$layerConfig, geom2, this.$superscriptExponent);
                        return geom2;
                    }
                }));
                break;
            }
            case 19: {
                geomProvider = GeomProvider.Companion.label((Function1<? super GeomProvider.Context, ? extends Geom>)((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig, superscriptExponent){
                    final /* synthetic */ OptionsAccessor $layerConfig;
                    final /* synthetic */ boolean $superscriptExponent;
                    {
                        this.$layerConfig = $layerConfig;
                        this.$superscriptExponent = $superscriptExponent;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        double it2;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        LabelGeom geom2 = new LabelGeom();
                        GeomProviderFactory.access$applyTextOptions(GeomProviderFactory.INSTANCE, this.$layerConfig, geom2, this.$superscriptExponent);
                        Double d = this.$layerConfig.getDouble("label_padding");
                        if (d != null) {
                            it2 = ((Number)d).doubleValue();
                            boolean bl = false;
                            geom2.setPaddingFactor(it2);
                        }
                        Double d2 = this.$layerConfig.getDouble("label_r");
                        if (d2 != null) {
                            it2 = ((Number)d2).doubleValue();
                            boolean bl = false;
                            geom2.setRadiusFactor(it2);
                        }
                        Double d3 = this.$layerConfig.getDouble("label_size");
                        if (d3 != null) {
                            it2 = ((Number)d3).doubleValue();
                            boolean bl = false;
                            geom2.setBorderWidth(it2);
                        }
                        if (this.$layerConfig.hasOwn("alpha_stroke")) {
                            geom2.setAlphaStroke(OptionsAccessor.getBoolean$default(this.$layerConfig, "alpha_stroke", false, 2, null));
                        }
                        return geom2;
                    }
                }));
                break;
            }
            case 20: {
                geomProvider = GeomProvider.Companion.image((Function1<? super GeomProvider.Context, ? extends Geom>)((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig){
                    final /* synthetic */ OptionsAccessor $layerConfig;
                    {
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        if (!this.$layerConfig.hasOwn("href")) {
                            boolean $i$a$-require-GeomProviderFactory$createGeomProvider$20$32 = false;
                            String $i$a$-require-GeomProviderFactory$createGeomProvider$20$32 = "Image reference URL (href) is not specified.";
                            throw new IllegalArgumentException($i$a$-require-GeomProviderFactory$createGeomProvider$20$32.toString());
                        }
                        Object[] $i$a$-require-GeomProviderFactory$createGeomProvider$20$32 = new String[]{Option.Geom.Image.INSTANCE.getXMIN(), Option.Geom.Image.INSTANCE.getXMAX(), Option.Geom.Image.INSTANCE.getYMIN(), Option.Geom.Image.INSTANCE.getYMAX()};
                        for (String s : CollectionsKt.listOf((Object[])$i$a$-require-GeomProviderFactory$createGeomProvider$20$32)) {
                            if (this.$layerConfig.hasOwn(s)) continue;
                            boolean bl = false;
                            String string = '\'' + s + "' is not specified.";
                            throw new IllegalArgumentException(string.toString());
                        }
                        String string = this.$layerConfig.getString("href");
                        Intrinsics.checkNotNull((Object)string);
                        return new ImageGeom(string, DoubleRectangle.Companion.span(new DoubleVector(this.$layerConfig.getDoubleSafe(Option.Geom.Image.INSTANCE.getXMIN()), this.$layerConfig.getDoubleSafe(Option.Geom.Image.INSTANCE.getYMIN())), new DoubleVector(this.$layerConfig.getDoubleSafe(Option.Geom.Image.INSTANCE.getXMAX()), this.$layerConfig.getDoubleSafe(Option.Geom.Image.INSTANCE.getYMAX()))));
                    }
                }));
                break;
            }
            case 21: {
                geomProvider = GeomProvider.Companion.pie((Function1<? super GeomProvider.Context, ? extends Geom>)((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig, aopConversion){
                    final /* synthetic */ OptionsAccessor $layerConfig;
                    final /* synthetic */ AesOptionConversion $aopConversion;
                    {
                        this.$layerConfig = $layerConfig;
                        this.$aopConversion = $aopConversion;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        String string;
                        PieGeom geom2;
                        block18: {
                            PieGeom.StrokeSide strokeSide;
                            double it2;
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            geom2 = new PieGeom();
                            Double d = this.$layerConfig.getDouble("hole");
                            if (d != null) {
                                it2 = ((Number)d).doubleValue();
                                boolean bl = false;
                                geom2.setHoleSize(it2);
                            }
                            Double d2 = this.$layerConfig.getDouble("spacer_width");
                            if (d2 != null) {
                                it2 = ((Number)d2).doubleValue();
                                boolean bl = false;
                                geom2.setSpacerWidth(it2);
                            }
                            Color color = this.$layerConfig.getColor("spacer_color", this.$aopConversion);
                            if (color != null) {
                                Color it3 = color;
                                boolean bl = false;
                                geom2.setSpacerColor(it3);
                            }
                            String string2 = this.$layerConfig.getString("stroke_side");
                            if (string2 == null) break block18;
                            String it4 = string2;
                            boolean bl = false;
                            String string3 = it4.toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                            switch (string3) {
                                case "outer": {
                                    strokeSide = PieGeom.StrokeSide.OUTER;
                                    break;
                                }
                                case "inner": {
                                    strokeSide = PieGeom.StrokeSide.INNER;
                                    break;
                                }
                                case "both": {
                                    strokeSide = PieGeom.StrokeSide.BOTH;
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("Unsupported value for stroke_side parameter: '" + it4 + "'. Use one of: outer, inner, both.");
                                }
                            }
                            geom2.setStrokeSide(strokeSide);
                        }
                        String string4 = this.$layerConfig.getString("size_unit");
                        if (string4 != null) {
                            String string5 = string4.toLowerCase(Locale.ROOT);
                            string = string5;
                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
                        } else {
                            string = null;
                        }
                        geom2.setSizeUnit(string);
                        return geom2;
                    }
                }));
                break;
            }
            case 22: {
                geomProvider = GeomProvider.Companion.lollipop((Function1<? super GeomProvider.Context, ? extends Geom>)((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig){
                    final /* synthetic */ OptionsAccessor $layerConfig;
                    {
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        Object object;
                        block23: {
                            block21: {
                                LollipopGeom.Direction direction;
                                String directionValue;
                                String string;
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                String string2 = this.$layerConfig.getString("dir");
                                if (string2 != null) {
                                    String string3 = string2.toLowerCase(Locale.ROOT);
                                    string = string3;
                                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                                } else {
                                    string = null;
                                }
                                if ((object = (directionValue = string)) == null) break block21;
                                String it2 = object;
                                boolean bl = false;
                                switch (it2) {
                                    case "v": {
                                        direction = LollipopGeom.Direction.ORTHOGONAL_TO_AXIS;
                                        break;
                                    }
                                    case "h": {
                                        direction = LollipopGeom.Direction.ALONG_AXIS;
                                        break;
                                    }
                                    case "s": {
                                        direction = LollipopGeom.Direction.SLOPE;
                                        break;
                                    }
                                    default: {
                                        throw new IllegalArgumentException("Unsupported value for dir parameter: '" + it2 + "'. Use one of: v, h, s.");
                                    }
                                }
                                object = direction;
                                if (direction != null) break block23;
                            }
                            object = LollipopGeom.Direction.ORTHOGONAL_TO_AXIS;
                        }
                        Object direction = object;
                        Double d = this.$layerConfig.getDouble("slope");
                        double slope = d != null ? d : 0.0;
                        LollipopGeom lollipopGeom = new LollipopGeom();
                        OptionsAccessor optionsAccessor = this.$layerConfig;
                        LollipopGeom $this$invoke_u24lambda_u241 = lollipopGeom;
                        boolean bl = false;
                        $this$invoke_u24lambda_u241.setDirection((LollipopGeom.Direction)((Object)direction));
                        $this$invoke_u24lambda_u241.setSlope(slope);
                        if (optionsAccessor.hasOwn("intercept")) {
                            Double d2 = optionsAccessor.getDouble("intercept");
                            Intrinsics.checkNotNull((Object)d2);
                            $this$invoke_u24lambda_u241.setIntercept(d2);
                        }
                        if (optionsAccessor.hasOwn("fatten")) {
                            Double d3 = optionsAccessor.getDouble("fatten");
                            Intrinsics.checkNotNull((Object)d3);
                            $this$invoke_u24lambda_u241.setFatten(d3);
                        }
                        return lollipopGeom;
                    }
                }));
                break;
            }
            case 23: {
                geomProvider = GeomProvider.Companion.spoke((Function1<? super GeomProvider.Context, ? extends Geom>)((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig){
                    final /* synthetic */ OptionsAccessor $layerConfig;
                    {
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        SpokeGeom geom2;
                        block16: {
                            SpokeGeom.Pivot pivot;
                            Object it2;
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            geom2 = new SpokeGeom();
                            Object object = this.$layerConfig.get("arrow");
                            if (object != null) {
                                it2 = object;
                                boolean bl = false;
                                ArrowSpecConfig arrowConfig = ArrowSpecConfig.Companion.create(it2);
                                geom2.setArrowSpec(arrowConfig.createArrowSpec());
                            }
                            String string = this.$layerConfig.getString("pivot");
                            if (string == null) break block16;
                            it2 = string;
                            boolean bl = false;
                            String string2 = ((String)it2).toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                            switch (string2) {
                                case "tail": {
                                    pivot = SpokeGeom.Pivot.TAIL;
                                    break;
                                }
                                case "middle": 
                                case "mid": {
                                    pivot = SpokeGeom.Pivot.MIDDLE;
                                    break;
                                }
                                case "tip": {
                                    pivot = SpokeGeom.Pivot.TIP;
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("Unsupported value for pivot parameter: '" + (String)it2 + "'. Use one of: tail, middle, mid, tip.");
                                }
                            }
                            geom2.setPivot(pivot);
                        }
                        return geom2;
                    }
                }));
                break;
            }
            default: {
                if (!PROVIDER.containsKey((Object)geomKind)) {
                    boolean bl = false;
                    String string = "Provider doesn't support geom kind: '" + (Object)((Object)geomKind) + '\'';
                    throw new IllegalArgumentException(string.toString());
                }
                geomProvider = (GeomProvider)MapsKt.getValue((Map)PROVIDER, (Object)((Object)geomKind));
            }
        }
        return geomProvider;
    }

    private final void applyTextOptions(OptionsAccessor opts, TextGeom geom2, boolean superscriptExponent) {
        String string;
        String it;
        String string2 = opts.getString("label_format");
        if (string2 != null) {
            it = string2;
            boolean bl = false;
            geom2.setFormatter((Function1<Object, String>)((Function1)new Function1<Object, String>((Object)StringFormat.Companion.forOneArg$default(StringFormat.Companion, it, null, null, superscriptExponent, 6, null)){

                @NotNull
                public final String invoke(@NotNull Object p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((StringFormat)this.receiver).format(p0);
                }
            }));
        }
        String string3 = opts.getString("na_text");
        if (string3 != null) {
            it = string3;
            boolean bl = false;
            geom2.setNaValue(it);
        }
        String string4 = opts.getString("size_unit");
        if (string4 != null) {
            String string5 = string4.toLowerCase(Locale.ROOT);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        geom2.setSizeUnit(string);
    }

    private final boolean isVertical(GeomProvider.Context ctx2, String geomName) {
        boolean isHorizontal;
        boolean isVertical;
        block8: {
            boolean bl;
            boolean bl2;
            block7: {
                Object[] objectArray = new Aes[]{Aes.Companion.getYMIN(), Aes.Companion.getYMAX()};
                Iterable $this$any$iv = SetsKt.setOf((Object[])objectArray);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Aes aes2 = (Aes)element$iv;
                        boolean bl3 = false;
                        if (!(ctx2.hasBinding(aes2) || ctx2.hasConstant(aes2))) continue;
                        bl2 = true;
                        break block7;
                    }
                    bl2 = false;
                }
            }
            isVertical = bl2;
            Object[] $i$f$any = new Aes[]{Aes.Companion.getXMIN(), Aes.Companion.getXMAX()};
            Iterable $this$any$iv = SetsKt.setOf((Object[])$i$f$any);
            boolean $i$f$any2 = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Aes aes3 = (Aes)element$iv;
                    boolean bl4 = false;
                    if (!(ctx2.hasBinding(aes3) || ctx2.hasConstant(aes3))) continue;
                    bl = true;
                    break block8;
                }
                bl = isHorizontal = false;
            }
        }
        if (!(!isVertical || !isHorizontal)) {
            boolean bl = false;
            String string = "Either ymin, ymax or xmin, xmax must be specified for the " + geomName + '.';
            throw new IllegalArgumentException(string.toString());
        }
        return isVertical;
    }

    public static final /* synthetic */ boolean access$isVertical(GeomProviderFactory $this, GeomProvider.Context ctx2, String geomName) {
        return $this.isVertical(ctx2, geomName);
    }

    public static final /* synthetic */ void access$applyTextOptions(GeomProviderFactory $this, OptionsAccessor opts, TextGeom geom2, boolean superscriptExponent) {
        $this.applyTextOptions(opts, geom2, superscriptExponent);
    }

    static {
        ((Map)PROVIDER).put(GeomKind.LINE, GeomProvider.Companion.line());
        ((Map)PROVIDER).put(GeomKind.SMOOTH, GeomProvider.Companion.smooth());
        ((Map)PROVIDER).put(GeomKind.BAR, GeomProvider.Companion.bar());
        ((Map)PROVIDER).put(GeomKind.HISTOGRAM, GeomProvider.Companion.histogram());
        ((Map)PROVIDER).put(GeomKind.TILE, GeomProvider.Companion.tile());
        ((Map)PROVIDER).put(GeomKind.BIN_2D, GeomProvider.Companion.bin2d());
        ((Map)PROVIDER).put(GeomKind.CONTOUR, GeomProvider.Companion.contour());
        ((Map)PROVIDER).put(GeomKind.CONTOURF, GeomProvider.Companion.contourf());
        ((Map)PROVIDER).put(GeomKind.POLYGON, GeomProvider.Companion.polygon());
        ((Map)PROVIDER).put(GeomKind.MAP, GeomProvider.Companion.map());
        ((Map)PROVIDER).put(GeomKind.AB_LINE, GeomProvider.Companion.abline());
        ((Map)PROVIDER).put(GeomKind.H_LINE, GeomProvider.Companion.hline());
        ((Map)PROVIDER).put(GeomKind.V_LINE, GeomProvider.Companion.vline());
        ((Map)PROVIDER).put(GeomKind.DENSITY2D, GeomProvider.Companion.density2d());
        ((Map)PROVIDER).put(GeomKind.DENSITY2DF, GeomProvider.Companion.density2df());
        ((Map)PROVIDER).put(GeomKind.JITTER, GeomProvider.Companion.jitter());
        ((Map)PROVIDER).put(GeomKind.Q_Q, GeomProvider.Companion.qq());
        ((Map)PROVIDER).put(GeomKind.Q_Q_2, GeomProvider.Companion.qq2());
        ((Map)PROVIDER).put(GeomKind.Q_Q_LINE, GeomProvider.Companion.qqline());
        ((Map)PROVIDER).put(GeomKind.Q_Q_2_LINE, GeomProvider.Companion.qq2line());
        ((Map)PROVIDER).put(GeomKind.FREQPOLY, GeomProvider.Companion.freqpoly());
        ((Map)PROVIDER).put(GeomKind.RECT, GeomProvider.Companion.rect());
        ((Map)PROVIDER).put(GeomKind.RASTER, GeomProvider.Companion.raster());
        ((Map)PROVIDER).put(GeomKind.LIVE_MAP, GeomProvider.Companion.livemap());
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GeomKind.values().length];
            try {
                nArray[GeomKind.AREA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.DENSITY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.DOT_PLOT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.ERROR_BAR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.LINE_RANGE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.RIBBON.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.CROSS_BAR.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.POINT_RANGE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.BOX_PLOT.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.AREA_RIDGES.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.VIOLIN.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.Y_DOT_PLOT.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.STEP.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.SEGMENT.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.CURVE.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.PATH.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.POINT.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.TEXT.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.LABEL.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.IMAGE.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.PIE.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.LOLLIPOP.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.SPOKE.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

