/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.coord;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangles;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.spatial.projections.Projection;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.algorithms.AdaptiveResampler;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001\u00a8\u0006\u0005"}, d2={"projectDomain", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "projection", "Lorg/jetbrains/letsPlot/commons/intern/spatial/projections/Projection;", "domain", "plot-base"})
@SourceDebugExtension(value={"SMAP\nCoordinatesMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoordinatesMapper.kt\norg/jetbrains/letsPlot/core/plot/base/coord/CoordinatesMapperKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n1549#2:180\n1620#2,3:181\n1549#2:184\n1620#2,3:185\n1549#2:188\n1620#2,3:189\n1549#2:192\n1620#2,3:193\n*S KotlinDebug\n*F\n+ 1 CoordinatesMapper.kt\norg/jetbrains/letsPlot/core/plot/base/coord/CoordinatesMapperKt\n*L\n163#1:180\n163#1:181,3\n164#1:184\n164#1:185,3\n165#1:188\n165#1:189,3\n160#1:192\n160#1:193,3\n*E\n"})
public final class CoordinatesMapperKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DoubleRectangle projectDomain(@NotNull Projection projection, @NotNull DoubleRectangle domain) {
        Intrinsics.checkNotNullParameter((Object)projection, (String)"projection");
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        DoubleVector leftTop = null;
        DoubleVector rightBottom = null;
        if (projection.getNonlinear()) {
            void $this$mapTo$iv$iv;
            void $this$mapTo$iv$iv2;
            Collection collection;
            void $this$mapTo$iv$iv3;
            Iterable $this$map$iv = CoordinatesMapperKt.projectDomain$points$default(domain.getTop(), domain.getBottom(), 0, 4, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it;
                double d = ((Number)item$iv$iv).doubleValue();
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to((Object)new DoubleVector(domain.getLeft(), (double)it), (Object)new DoubleVector(domain.getRight(), (double)it)));
            }
            List hLines = (List)destination$iv$iv;
            Iterable $this$map$iv2 = CoordinatesMapperKt.projectDomain$points$default(domain.getLeft(), domain.getRight(), 0, 4, null);
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                double d = ((Number)item$iv$iv).doubleValue();
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(TuplesKt.to((Object)new DoubleVector((double)it, domain.getTop()), (Object)new DoubleVector((double)it, domain.getBottom())));
            }
            List vLines = (List)destination$iv$iv2;
            Iterable $this$map$iv3 = CollectionsKt.plus((Collection)hLines, (Iterable)vLines);
            boolean $i$f$map3 = false;
            destination$iv$iv2 = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair2 = (Pair)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl = false;
                DoubleVector p1 = (DoubleVector)pair2.component1();
                DoubleVector p2 = (DoubleVector)pair2.component2();
                collection.add(AdaptiveResampler.Companion.resample(p1, p2, 0.95, (Function1<? super DoubleVector, DoubleVector>)((Function1)new Function1<DoubleVector, DoubleVector>((Object)projection){

                    @Nullable
                    public final DoubleVector invoke(@NotNull DoubleVector p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return ((Projection)this.receiver).project(p0);
                    }
                })));
            }
            List grid2 = (List)destination$iv$iv3;
            DoubleRectangle doubleRectangle = DoubleRectangles.INSTANCE.boundingBox(CollectionsKt.flatten((Iterable)grid2));
            if (doubleRectangle == null) {
                throw new IllegalStateException("Can't calculate bounding box for projected domain".toString());
            }
            DoubleRectangle projectedDomain = doubleRectangle;
            leftTop = new DoubleVector(projectedDomain.getLeft(), projectedDomain.getTop());
            rightBottom = new DoubleVector(projectedDomain.getRight(), projectedDomain.getBottom());
        } else {
            DoubleVector domainRB = domain.getOrigin().add(domain.getDimension());
            DoubleVector doubleVector = projection.project(domain.getOrigin());
            if (doubleVector == null) {
                throw new IllegalStateException(("Can't project domain left-top: " + domain.getOrigin()).toString());
            }
            leftTop = doubleVector;
            DoubleVector doubleVector2 = projection.project(domainRB);
            if (doubleVector2 == null) {
                throw new IllegalStateException(("Can't project domain right-bottom: " + domainRB).toString());
            }
            rightBottom = doubleVector2;
        }
        return DoubleRectangle.Companion.span(leftTop, rightBottom);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Double> projectDomain$points(double min, double max, int n) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        double step2 = (max - min) / (double)n;
        Iterable iterable = (Iterable)new IntRange(0, n);
        Collection collection = CollectionsKt.listOf((Object)min);
        boolean $i$f$map = false;
        void var9_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n2 = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(min + (double)it * step2);
        }
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv)), (Iterable)CollectionsKt.listOf((Object)max));
    }

    static /* synthetic */ List projectDomain$points$default(double d, double d2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 10;
        }
        return CoordinatesMapperKt.projectDomain$points(d, d2, n);
    }
}

