/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.geometry;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.Rectangle;
import org.jetbrains.letsPlot.commons.geometry.Vector;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u0016\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\rJ\u0016\u0010\u0013\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0017\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u000e\u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006J\u0016\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u001b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/commons/geometry/Rectangles;", "", "()V", "assertOuterInner", "", "outer", "Lorg/jetbrains/letsPlot/commons/geometry/Rectangle;", "inner", "bottomLeft", "Lorg/jetbrains/letsPlot/commons/geometry/Vector;", "r", "extendDown", "distance", "", "extendLeft", "extendRight", "extendSides", "left", "right", "extendUp", "leftDistance", "lowerDistance", "rightDistance", "shrinkRight", "topLeft", "topRight", "upperDistance", "zeroOrigin", "commons"})
public final class Rectangles {
    @NotNull
    public static final Rectangles INSTANCE = new Rectangles();

    private Rectangles() {
    }

    @NotNull
    public final Rectangle zeroOrigin(@NotNull Rectangle r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return new Rectangle(Vector.Companion.getZERO(), r.getDimension());
    }

    public final int upperDistance(@NotNull Rectangle inner2, @NotNull Rectangle outer) {
        Intrinsics.checkNotNullParameter((Object)inner2, (String)"inner");
        Intrinsics.checkNotNullParameter((Object)outer, (String)"outer");
        this.assertOuterInner(outer, inner2);
        return this.topLeft(inner2).getY() - this.topLeft(outer).getY();
    }

    public final int lowerDistance(@NotNull Rectangle inner2, @NotNull Rectangle outer) {
        Intrinsics.checkNotNullParameter((Object)inner2, (String)"inner");
        Intrinsics.checkNotNullParameter((Object)outer, (String)"outer");
        this.assertOuterInner(outer, inner2);
        return this.bottomLeft(outer).getY() - this.bottomLeft(inner2).getY();
    }

    public final int leftDistance(@NotNull Rectangle inner2, @NotNull Rectangle outer) {
        Intrinsics.checkNotNullParameter((Object)inner2, (String)"inner");
        Intrinsics.checkNotNullParameter((Object)outer, (String)"outer");
        this.assertOuterInner(outer, inner2);
        return this.topLeft(inner2).getX() - this.topLeft(outer).getX();
    }

    public final int rightDistance(@NotNull Rectangle inner2, @NotNull Rectangle outer) {
        Intrinsics.checkNotNullParameter((Object)inner2, (String)"inner");
        Intrinsics.checkNotNullParameter((Object)outer, (String)"outer");
        this.assertOuterInner(outer, inner2);
        return this.topRight(outer).getX() - this.topRight(inner2).getX();
    }

    private final void assertOuterInner(Rectangle outer, Rectangle inner2) {
        if (!outer.contains(inner2)) {
            throw new IllegalArgumentException("Outer does not contain inner: outer = " + outer + ", inner = " + inner2);
        }
    }

    @NotNull
    public final Rectangle extendUp(@NotNull Rectangle r, int distance) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Vector change = new Vector(0, distance);
        return new Rectangle(r.getOrigin().sub(change), r.getDimension().add(change));
    }

    @NotNull
    public final Rectangle extendDown(@NotNull Rectangle r, int distance) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return r.changeDimension(r.getDimension().add(new Vector(0, distance)));
    }

    @NotNull
    public final Rectangle extendLeft(@NotNull Rectangle r, int distance) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Vector change = new Vector(distance, 0);
        return new Rectangle(r.getOrigin().sub(change), r.getDimension().add(change));
    }

    @NotNull
    public final Rectangle extendRight(@NotNull Rectangle r, int distance) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return r.changeDimension(r.getDimension().add(new Vector(distance, 0)));
    }

    @NotNull
    public final Rectangle extendSides(int left, @NotNull Rectangle r, int right) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return this.extendRight(this.extendLeft(r, left), right);
    }

    @NotNull
    public final Rectangle shrinkRight(@NotNull Rectangle r, int distance) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        if (r.getDimension().getX() < distance) {
            throw new IllegalArgumentException("To small rectangle = " + r + ", distance = " + distance);
        }
        return r.changeDimension(r.getDimension().sub(new Vector(distance, 0)));
    }

    private final Vector topLeft(Rectangle r) {
        return r.getOrigin();
    }

    @NotNull
    public final Vector topRight(@NotNull Rectangle r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return r.getOrigin().add(new Vector(r.getDimension().getX(), 0));
    }

    private final Vector bottomLeft(Rectangle r) {
        return r.getOrigin().add(new Vector(0, r.getDimension().getY()));
    }
}

