/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.bigdatatools.visualization.charts.settings.data;

import com.google.gson.JsonObject;
import com.intellij.bigdatatools.visualization.charts.core.utils.GroupingUtils;
import com.intellij.bigdatatools.visualization.charts.settings.data.ColumnSettings;
import com.intellij.bigdatatools.visualization.charts.settings.data.SeriesSettings;
import com.intellij.bigdatatools.visualization.charts.settings.data.type.HeatmapSeriesType;
import com.intellij.bigdatatools.visualization.charts.style.ChartsConfig;
import com.intellij.bigdatatools.visualization.charts.utils.ChartJsonUtilsKt;
import com.intellij.bigdatatools.visualization.dataframe.DataFrame;
import com.intellij.bigdatatools.visualization.dataframe.columns.Column;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.geom.geomPoint;
import org.jetbrains.letsPlot.intern.Layer;
import org.jetbrains.letsPlot.intern.layer.SamplingOptions;
import org.jetbrains.letsPlot.intern.layer.geom.PointMapping;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B5\b\u0016\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\u001a\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\u0010\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020$H\u0016J\b\u0010&\u001a\u00020\u0007H\u0016J\b\u0010'\u001a\u00020\nH\u0016R\u0013\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000e\u00a8\u0006("}, d2={"Lcom/intellij/bigdatatools/visualization/charts/settings/data/HeatmapSeriesSettings;", "Lcom/intellij/bigdatatools/visualization/charts/settings/data/SeriesSettings;", "x", "Lcom/intellij/bigdatatools/visualization/charts/settings/data/ColumnSettings;", "y", "sizes", "showLegend", "", "(Lcom/intellij/bigdatatools/visualization/charts/settings/data/ColumnSettings;Lcom/intellij/bigdatatools/visualization/charts/settings/data/ColumnSettings;Lcom/intellij/bigdatatools/visualization/charts/settings/data/ColumnSettings;Z)V", "json", "Lcom/google/gson/JsonObject;", "(Lcom/google/gson/JsonObject;)V", "keys", "getKeys", "()Lcom/intellij/bigdatatools/visualization/charts/settings/data/ColumnSettings;", "getShowLegend", "()Z", "setShowLegend", "(Z)V", "getSizes", "type", "Lcom/intellij/bigdatatools/visualization/charts/settings/data/type/HeatmapSeriesType;", "getType", "()Lcom/intellij/bigdatatools/visualization/charts/settings/data/type/HeatmapSeriesType;", "values", "getValues", "equals", "other", "", "filterByNewDataFrame", "dataFrame", "Lcom/intellij/bigdatatools/visualization/dataframe/DataFrame;", "getLetsPlotLayer", "", "Lorg/jetbrains/letsPlot/intern/Layer;", "chartIndex", "", "hashCode", "isEmpty", "toJson", "intellij.charts"})
@SourceDebugExtension(value={"SMAP\nHeatmapSeriesSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeatmapSeriesSettings.kt\ncom/intellij/bigdatatools/visualization/charts/settings/data/HeatmapSeriesSettings\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,105:1\n23#2:106\n*S KotlinDebug\n*F\n+ 1 HeatmapSeriesSettings.kt\ncom/intellij/bigdatatools/visualization/charts/settings/data/HeatmapSeriesSettings\n*L\n69#1:106\n*E\n"})
public final class HeatmapSeriesSettings
extends SeriesSettings {
    @NotNull
    private final HeatmapSeriesType type;
    @Nullable
    private final ColumnSettings keys;
    @Nullable
    private final ColumnSettings values;
    @Nullable
    private final ColumnSettings sizes;
    private boolean showLegend;

    @Override
    @NotNull
    public HeatmapSeriesType getType() {
        return this.type;
    }

    @Nullable
    public final ColumnSettings getKeys() {
        return this.keys;
    }

    @Nullable
    public final ColumnSettings getValues() {
        return this.values;
    }

    @Nullable
    public final ColumnSettings getSizes() {
        return this.sizes;
    }

    public final boolean getShowLegend() {
        return this.showLegend;
    }

    public final void setShowLegend(boolean bl) {
        this.showLegend = bl;
    }

    public HeatmapSeriesSettings(@Nullable ColumnSettings x2, @Nullable ColumnSettings y2, @Nullable ColumnSettings sizes, boolean showLegend) {
        this.type = HeatmapSeriesType.Companion.getInstance();
        this.keys = x2;
        this.values = y2;
        this.sizes = sizes;
        this.showLegend = showLegend;
    }

    public /* synthetic */ HeatmapSeriesSettings(ColumnSettings columnSettings, ColumnSettings columnSettings2, ColumnSettings columnSettings3, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            columnSettings = null;
        }
        if ((n & 2) != 0) {
            columnSettings2 = null;
        }
        if ((n & 4) != 0) {
            columnSettings3 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        this(columnSettings, columnSettings2, columnSettings3, bl);
    }

    public HeatmapSeriesSettings(@NotNull JsonObject json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.type = HeatmapSeriesType.Companion.getInstance();
        this.keys = ChartJsonUtilsKt.optColumnSettings(json, "keys");
        this.values = ChartJsonUtilsKt.optColumnSettings(json, "values");
        this.sizes = ChartJsonUtilsKt.optColumnSettings(json, "sizes");
        this.showLegend = ChartJsonUtilsKt.optBoolean(json, "showLegend");
    }

    @Override
    @NotNull
    public JsonObject toJson() {
        JsonObject jsonObject;
        JsonObject $this$toJson_u24lambda_u240 = jsonObject = new JsonObject();
        boolean bl = false;
        $this$toJson_u24lambda_u240.addProperty("type", this.getType().getId());
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u240, "keys", this.keys);
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u240, "values", this.values);
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u240, "sizes", this.sizes);
        ChartJsonUtilsKt.optSetProperty($this$toJson_u24lambda_u240, "showLegend", this.showLegend);
        return jsonObject;
    }

    @Override
    public boolean isEmpty() {
        return this.keys == null && this.sizes == null && this.values == null;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof HeatmapSeriesSettings && Intrinsics.areEqual((Object)((HeatmapSeriesSettings)other).keys, (Object)this.keys) && Intrinsics.areEqual((Object)((HeatmapSeriesSettings)other).values, (Object)this.values) && Intrinsics.areEqual((Object)((HeatmapSeriesSettings)other).sizes, (Object)this.sizes) && ((HeatmapSeriesSettings)other).showLegend == this.showLegend;
    }

    @Override
    @NotNull
    public HeatmapSeriesSettings filterByNewDataFrame(@NotNull DataFrame dataFrame) {
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        return new HeatmapSeriesSettings(SeriesSettings.Companion.filterByDataFrame(this.keys, dataFrame), SeriesSettings.Companion.filterByDataFrame(this.values, dataFrame), SeriesSettings.Companion.filterByDataFrame(this.sizes, dataFrame), this.showLegend);
    }

    @NotNull
    public List<Layer> getLetsPlotLayer(@NotNull DataFrame dataFrame, int chartIndex) {
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        if (this.keys == null || this.values == null || this.sizes == null) {
            HeatmapSeriesSettings $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(HeatmapSeriesSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.warn("Heatmap series should have one x, y and sizes data");
            return CollectionsKt.emptyList();
        }
        ColumnSettings[] $this$thisLogger$iv = new ColumnSettings[]{this.keys, this.values, this.sizes};
        if (!SeriesSettings.Companion.dataFrameHasAllColumns(dataFrame, $this$thisLogger$iv)) {
            return CollectionsKt.emptyList();
        }
        DataFrame df = GroupingUtils.INSTANCE.getGroupedDataFrame(this.keys, dataFrame);
        Column<?> xColumn2 = df.get(this.keys.getColumnId());
        Column<Object> yColumn = SeriesSettings.Companion.getAggregatedColumn(this.values, df).cast();
        Column<Object> sizesColumn = SeriesSettings.Companion.getAggregatedColumn(this.sizes, df).cast();
        Color color = ChartsConfig.Companion.getInstance().getSettings().getPaletteColor(chartIndex);
        Object object = new Pair[]{TuplesKt.to((Object)xColumn2.getName(), xColumn2.toList()), TuplesKt.to((Object)yColumn.getName(), yColumn.toList()), TuplesKt.to((Object)sizesColumn.getName(), sizesColumn.toList())};
        Map map2 = MapsKt.mapOf((Pair[])object);
        object = SeriesSettings.Companion.getSampling(xColumn2);
        return CollectionsKt.listOf((Object)new geomPoint(map2, null, null, false, (SamplingOptions)object, null, null, null, null, null, null, null, null, color, null, null, null, null, null, null, null, (Function1)new Function1<PointMapping, Unit>(xColumn2, yColumn, sizesColumn){
            final /* synthetic */ Column<?> $xColumn;
            final /* synthetic */ Column<? extends Number> $yColumn;
            final /* synthetic */ Column<? extends Number> $sizesColumn;
            {
                this.$xColumn = $xColumn;
                this.$yColumn = $yColumn;
                this.$sizesColumn = $sizesColumn;
                super(1);
            }

            public final void invoke(@NotNull PointMapping $this$$receiver) {
                Intrinsics.checkNotNullParameter((Object)$this$$receiver, (String)"$this$$receiver");
                $this$$receiver.setX(this.$xColumn.getName());
                $this$$receiver.setY(this.$yColumn.getName());
                $this$$receiver.setFill(this.$sizesColumn.getName());
            }
        }, 2088934, null));
    }

    public int hashCode() {
        int result2 = this.getType().hashCode();
        ColumnSettings columnSettings = this.keys;
        result2 = 31 * result2 + (columnSettings != null ? columnSettings.hashCode() : 0);
        ColumnSettings columnSettings2 = this.values;
        result2 = 31 * result2 + (columnSettings2 != null ? columnSettings2.hashCode() : 0);
        ColumnSettings columnSettings3 = this.sizes;
        result2 = 31 * result2 + (columnSettings3 != null ? columnSettings3.hashCode() : 0);
        result2 = 31 * result2 + Boolean.hashCode(this.showLegend);
        return result2;
    }
}

