/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.FileReader;
import com.intellij.util.io.CountingInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\bH\u0002J\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/profiler/ZIPExtractor;", "Lcom/intellij/profiler/FileReader;", "file", "Ljava/util/zip/ZipFile;", "(Ljava/util/zip/ZipFile;)V", "countingStream", "Lcom/intellij/util/io/CountingInputStream;", "zipEntry", "Ljava/util/zip/ZipEntry;", "createReader", "Ljava/io/BufferedReader;", "getEntry", "progressFraction", "", "withProgressFraction", "", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nProfilerDumpUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfilerDumpUtil.kt\ncom/intellij/profiler/ZIPExtractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n766#2:100\n857#2,2:101\n*S KotlinDebug\n*F\n+ 1 ProfilerDumpUtil.kt\ncom/intellij/profiler/ZIPExtractor\n*L\n57#1:100\n57#1:101,2\n*E\n"})
public final class ZIPExtractor
extends FileReader {
    @NotNull
    private final ZipFile file;
    @NotNull
    private final ZipEntry zipEntry;
    private CountingInputStream countingStream;

    public ZIPExtractor(@NotNull ZipFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.file = file2;
        this.zipEntry = this.getEntry();
    }

    @Override
    @NotNull
    protected BufferedReader createReader() {
        InputStream decompressedStream = this.file.getInputStream(this.zipEntry);
        this.countingStream = new CountingInputStream(decompressedStream);
        CountingInputStream countingInputStream = this.countingStream;
        if (countingInputStream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"countingStream");
            countingInputStream = null;
        }
        InputStream inputStream = (InputStream)countingInputStream;
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader(inputStream, charset);
        int n = 8192;
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
    }

    /*
     * WARNING - void declaration
     */
    private final ZipEntry getEntry() {
        void $this$filterTo$iv$iv;
        Enumeration<? extends ZipEntry> enumeration = this.file.entries();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries(...)");
        ArrayList<? extends ZipEntry> arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
        Iterable $this$filter$iv = arrayList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ZipEntry it = (ZipEntry)element$iv$iv;
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!(!StringsKt.startsWith$default((String)string, (String)"__MACOSX/", (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List entries = (List)destination$iv$iv;
        if (entries.isEmpty()) {
            throw new IllegalArgumentException(CommonProfilerBundleKt.profilerMessage("zip.is.empty", new Object[0]));
        }
        if (entries.size() > 1) {
            throw new IllegalArgumentException(CommonProfilerBundleKt.profilerMessage("zip.too.many.files", new Object[0]));
        }
        Object object = CollectionsKt.first((List)entries);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
        return (ZipEntry)object;
    }

    @Override
    protected boolean withProgressFraction() {
        return this.zipEntry.getSize() > 1L;
    }

    @Override
    protected double progressFraction() {
        CountingInputStream countingInputStream = this.countingStream;
        if (countingInputStream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"countingStream");
            countingInputStream = null;
        }
        return (double)countingInputStream.getBytesRead() / (double)this.zipEntry.getSize();
    }
}

