/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate.tri;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.io.WKTWriter;

class TriEdge {
    public Coordinate p0;
    public Coordinate p1;

    public TriEdge(Coordinate a, Coordinate b2) {
        this.p0 = a;
        this.p1 = b2;
        this.normalize();
    }

    private void normalize() {
        if (this.p0.compareTo(this.p1) < 0) {
            Coordinate tmp = this.p0;
            this.p0 = this.p1;
            this.p1 = tmp;
        }
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 37 * result2 + Coordinate.hashCode(this.p0.x);
        result2 = 37 * result2 + Coordinate.hashCode(this.p1.x);
        result2 = 37 * result2 + Coordinate.hashCode(this.p0.y);
        result2 = 37 * result2 + Coordinate.hashCode(this.p1.y);
        return result2;
    }

    public boolean equals(Object arg) {
        if (!(arg instanceof TriEdge)) {
            return false;
        }
        TriEdge other = (TriEdge)arg;
        return this.p0.equals(other.p0) && this.p1.equals(other.p1);
    }

    public String toString() {
        return WKTWriter.toLineString(new Coordinate[]{this.p0, this.p1});
    }
}

