/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.operation.overlayng.OverlayEdge;
import org.locationtech.jts.operation.overlayng.OverlayLabel;

class OverlayGraph {
    private List<OverlayEdge> edges = new ArrayList<OverlayEdge>();
    private Map<Coordinate, OverlayEdge> nodeMap = new HashMap<Coordinate, OverlayEdge>();

    public Collection<OverlayEdge> getEdges() {
        return this.edges;
    }

    public Collection<OverlayEdge> getNodeEdges() {
        return this.nodeMap.values();
    }

    public OverlayEdge getNodeEdge(Coordinate nodePt) {
        return this.nodeMap.get(nodePt);
    }

    public List<OverlayEdge> getResultAreaEdges() {
        ArrayList<OverlayEdge> resultEdges = new ArrayList<OverlayEdge>();
        for (OverlayEdge edge : this.getEdges()) {
            if (!edge.isInResultArea()) continue;
            resultEdges.add(edge);
        }
        return resultEdges;
    }

    public OverlayEdge addEdge(Coordinate[] pts, OverlayLabel label2) {
        OverlayEdge e2 = OverlayEdge.createEdgePair(pts, label2);
        this.insert(e2);
        this.insert(e2.symOE());
        return e2;
    }

    private void insert(OverlayEdge e2) {
        this.edges.add(e2);
        OverlayEdge nodeEdge = this.nodeMap.get(e2.orig());
        if (nodeEdge != null) {
            nodeEdge.insert(e2);
        } else {
            this.nodeMap.put(e2.orig(), e2);
        }
    }
}

