/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer.validate;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.buffer.validate.PointPairDistance;

public class DistanceToPointFinder {
    public static void computeDistance(Geometry geom, Coordinate pt, PointPairDistance ptDist) {
        if (geom instanceof LineString) {
            DistanceToPointFinder.computeDistance((LineString)geom, pt, ptDist);
        } else if (geom instanceof Polygon) {
            DistanceToPointFinder.computeDistance((Polygon)geom, pt, ptDist);
        } else if (geom instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)geom;
            for (int i2 = 0; i2 < gc.getNumGeometries(); ++i2) {
                Geometry g2 = gc.getGeometryN(i2);
                DistanceToPointFinder.computeDistance(g2, pt, ptDist);
            }
        } else {
            ptDist.setMinimum(geom.getCoordinate(), pt);
        }
    }

    public static void computeDistance(LineString line, Coordinate pt, PointPairDistance ptDist) {
        Coordinate[] coords = line.getCoordinates();
        LineSegment tempSegment = new LineSegment();
        for (int i2 = 0; i2 < coords.length - 1; ++i2) {
            tempSegment.setCoordinates(coords[i2], coords[i2 + 1]);
            Coordinate closestPt = tempSegment.closestPoint(pt);
            ptDist.setMinimum(closestPt, pt);
        }
    }

    public static void computeDistance(LineSegment segment, Coordinate pt, PointPairDistance ptDist) {
        Coordinate closestPt = segment.closestPoint(pt);
        ptDist.setMinimum(closestPt, pt);
    }

    public static void computeDistance(Polygon poly, Coordinate pt, PointPairDistance ptDist) {
        DistanceToPointFinder.computeDistance(poly.getExteriorRing(), pt, ptDist);
        for (int i2 = 0; i2 < poly.getNumInteriorRing(); ++i2) {
            DistanceToPointFinder.computeDistance(poly.getInteriorRingN(i2), pt, ptDist);
        }
    }
}

