/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.math;

import org.locationtech.jts.algorithm.Angle;
import org.locationtech.jts.algorithm.CGAlgorithmsDD;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.util.Assert;

public class Vector2D {
    private double x;
    private double y;

    public static Vector2D create(double x, double y) {
        return new Vector2D(x, y);
    }

    public static Vector2D create(Vector2D v2) {
        return new Vector2D(v2);
    }

    public static Vector2D create(Coordinate coord) {
        return new Vector2D(coord);
    }

    public static Vector2D create(Coordinate from, Coordinate to) {
        return new Vector2D(from, to);
    }

    public Vector2D() {
        this(0.0, 0.0);
    }

    public Vector2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector2D(Vector2D v2) {
        this.x = v2.x;
        this.y = v2.y;
    }

    public Vector2D(Coordinate from, Coordinate to) {
        this.x = to.x - from.x;
        this.y = to.y - from.y;
    }

    public Vector2D(Coordinate v2) {
        this.x = v2.x;
        this.y = v2.y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getComponent(int index2) {
        if (index2 == 0) {
            return this.x;
        }
        return this.y;
    }

    public Vector2D add(Vector2D v2) {
        return Vector2D.create(this.x + v2.x, this.y + v2.y);
    }

    public Vector2D subtract(Vector2D v2) {
        return Vector2D.create(this.x - v2.x, this.y - v2.y);
    }

    public Vector2D multiply(double d2) {
        return Vector2D.create(this.x * d2, this.y * d2);
    }

    public Vector2D divide(double d2) {
        return Vector2D.create(this.x / d2, this.y / d2);
    }

    public Vector2D negate() {
        return Vector2D.create(-this.x, -this.y);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public Vector2D normalize() {
        double length = this.length();
        if (length > 0.0) {
            return this.divide(length);
        }
        return Vector2D.create(0.0, 0.0);
    }

    public Vector2D average(Vector2D v2) {
        return this.weightedSum(v2, 0.5);
    }

    public Vector2D weightedSum(Vector2D v2, double frac) {
        return Vector2D.create(frac * this.x + (1.0 - frac) * v2.x, frac * this.y + (1.0 - frac) * v2.y);
    }

    public double distance(Vector2D v2) {
        double delx = v2.x - this.x;
        double dely = v2.y - this.y;
        return Math.sqrt(delx * delx + dely * dely);
    }

    public double dot(Vector2D v2) {
        return this.x * v2.x + this.y * v2.y;
    }

    public double angle() {
        return Math.atan2(this.y, this.x);
    }

    public double angle(Vector2D v2) {
        return Angle.diff(v2.angle(), this.angle());
    }

    public double angleTo(Vector2D v2) {
        double a1 = this.angle();
        double a2 = v2.angle();
        double angDel = a2 - a1;
        if (angDel <= -Math.PI) {
            return angDel + Math.PI * 2;
        }
        if (angDel > Math.PI) {
            return angDel - Math.PI * 2;
        }
        return angDel;
    }

    public Vector2D rotate(double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        return Vector2D.create(this.x * cos - this.y * sin, this.x * sin + this.y * cos);
    }

    public Vector2D rotateByQuarterCircle(int numQuarters) {
        int nQuad = numQuarters % 4;
        if (numQuarters < 0 && nQuad != 0) {
            nQuad += 4;
        }
        switch (nQuad) {
            case 0: {
                return Vector2D.create(this.x, this.y);
            }
            case 1: {
                return Vector2D.create(-this.y, this.x);
            }
            case 2: {
                return Vector2D.create(-this.x, -this.y);
            }
            case 3: {
                return Vector2D.create(this.y, -this.x);
            }
        }
        Assert.shouldNeverReachHere();
        return null;
    }

    public boolean isParallel(Vector2D v2) {
        return 0.0 == (double)CGAlgorithmsDD.signOfDet2x2(this.x, this.y, v2.x, v2.y);
    }

    public Coordinate translate(Coordinate coord) {
        return new Coordinate(this.x + coord.x, this.y + coord.y);
    }

    public Coordinate toCoordinate() {
        return new Coordinate(this.x, this.y);
    }

    public Object clone() {
        return new Vector2D(this);
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + "]";
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof Vector2D)) {
            return false;
        }
        Vector2D v2 = (Vector2D)o2;
        return this.x == v2.x && this.y == v2.y;
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 37 * result2 + Coordinate.hashCode(this.x);
        result2 = 37 * result2 + Coordinate.hashCode(this.y);
        return result2;
    }
}

