/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.math;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.math.Vector3D;

public class Plane3D {
    public static final int XY_PLANE = 1;
    public static final int YZ_PLANE = 2;
    public static final int XZ_PLANE = 3;
    private Vector3D normal;
    private Coordinate basePt;

    public Plane3D(Vector3D normal, Coordinate basePt) {
        this.normal = normal;
        this.basePt = basePt;
    }

    public double orientedDistance(Coordinate p2) {
        Vector3D pb = new Vector3D(p2, this.basePt);
        double pbdDotNormal = pb.dot(this.normal);
        if (Double.isNaN(pbdDotNormal)) {
            throw new IllegalArgumentException("3D Coordinate has NaN ordinate");
        }
        double d2 = pbdDotNormal / this.normal.length();
        return d2;
    }

    public int closestAxisPlane() {
        double xmag = Math.abs(this.normal.getX());
        double ymag = Math.abs(this.normal.getY());
        double zmag = Math.abs(this.normal.getZ());
        if (xmag > ymag) {
            if (xmag > zmag) {
                return 2;
            }
            return 1;
        }
        if (zmag > ymag) {
            return 1;
        }
        return 3;
    }
}

