/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.awt;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.util.ArrayList;
import org.locationtech.jts.awt.ShapeReader;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class FontGlyphReader {
    public static final String FONT_SERIF = "Serif";
    public static final String FONT_SANSERIF = "SansSerif";
    public static final String FONT_SANSSERIF = "SansSerif";
    public static final String FONT_MONOSPACED = "Monospaced";
    private static final double FLATNESS_FACTOR = 400.0;

    private FontGlyphReader() {
    }

    public static Geometry read(String text2, String fontName, int pointSize, GeometryFactory geomFact) {
        return FontGlyphReader.read(text2, new Font(fontName, 0, pointSize), geomFact);
    }

    public static Geometry read(String text2, Font font2, GeometryFactory geomFact) {
        double flatness = (double)font2.getSize() / 400.0;
        return FontGlyphReader.read(text2, font2, flatness, geomFact);
    }

    public static Geometry read(String text2, Font font2, double flatness, GeometryFactory geomFact) {
        char[] chs = text2.toCharArray();
        FontRenderContext fontContext = new FontRenderContext(null, false, true);
        GlyphVector gv = font2.createGlyphVector(fontContext, chs);
        ArrayList<Geometry> polys = new ArrayList<Geometry>();
        for (int i2 = 0; i2 < gv.getNumGlyphs(); ++i2) {
            Geometry geom = ShapeReader.read(gv.getGlyphOutline(i2), flatness, geomFact);
            for (int j = 0; j < geom.getNumGeometries(); ++j) {
                polys.add(geom.getGeometryN(j));
            }
        }
        return geomFact.buildGeometry(polys);
    }
}

