/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm.locate;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.algorithm.RayCrossingCounter;
import org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.util.LinearComponentExtracter;
import org.locationtech.jts.index.ArrayListVisitor;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.index.intervalrtree.SortedPackedIntervalRTree;

public class IndexedPointInAreaLocator
implements PointOnGeometryLocator {
    private Geometry geom;
    private volatile IntervalIndexedGeometry index = null;

    public IndexedPointInAreaLocator(Geometry g2) {
        if (!(g2 instanceof Polygonal) && !(g2 instanceof LinearRing)) {
            throw new IllegalArgumentException("Argument must be Polygonal or LinearRing");
        }
        this.geom = g2;
    }

    @Override
    public int locate(Coordinate p2) {
        if (this.index == null) {
            this.createIndex();
        }
        RayCrossingCounter rcc = new RayCrossingCounter(p2);
        SegmentVisitor visitor2 = new SegmentVisitor(rcc);
        this.index.query(p2.y, p2.y, visitor2);
        return rcc.getLocation();
    }

    private synchronized void createIndex() {
        if (this.index == null) {
            this.index = new IntervalIndexedGeometry(this.geom);
            this.geom = null;
        }
    }

    private static class IntervalIndexedGeometry {
        private final boolean isEmpty;
        private final SortedPackedIntervalRTree index = new SortedPackedIntervalRTree();

        public IntervalIndexedGeometry(Geometry geom) {
            if (geom.isEmpty()) {
                this.isEmpty = true;
            } else {
                this.isEmpty = false;
                this.init(geom);
            }
        }

        private void init(Geometry geom) {
            List lines = LinearComponentExtracter.getLines(geom);
            for (LineString line : lines) {
                Coordinate[] pts = line.getCoordinates();
                this.addLine(pts);
            }
        }

        private void addLine(Coordinate[] pts) {
            for (int i2 = 1; i2 < pts.length; ++i2) {
                LineSegment seg = new LineSegment(pts[i2 - 1], pts[i2]);
                double min = Math.min(seg.p0.y, seg.p1.y);
                double max = Math.max(seg.p0.y, seg.p1.y);
                this.index.insert(min, max, seg);
            }
        }

        public List query(double min, double max) {
            if (this.isEmpty) {
                return new ArrayList();
            }
            ArrayListVisitor visitor2 = new ArrayListVisitor();
            this.index.query(min, max, visitor2);
            return visitor2.getItems();
        }

        public void query(double min, double max, ItemVisitor visitor2) {
            if (this.isEmpty) {
                return;
            }
            this.index.query(min, max, visitor2);
        }
    }

    private static class SegmentVisitor
    implements ItemVisitor {
        private final RayCrossingCounter counter;

        public SegmentVisitor(RayCrossingCounter counter) {
            this.counter = counter;
        }

        @Override
        public void visitItem(Object item) {
            LineSegment seg = (LineSegment)item;
            this.counter.countSegment(seg.getCoordinate(0), seg.getCoordinate(1));
        }
    }
}

