/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.wire;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.inject.BeanLocator;
import org.eclipse.sisu.inject.TypeArguments;
import org.eclipse.sisu.wire.EntryListAdapter;
import org.eclipse.sisu.wire.EntryMapAdapter;
import org.eclipse.sisu.wire.EntrySetAdapter;
import org.eclipse.sisu.wire.NamedIterableAdapter;
import org.eclipse.sisu.wire.PlaceholderBeanProvider;
import org.eclipse.sisu.wire.ProviderIterableAdapter;

final class BeanProviders {
    final Provider<BeanLocator> locator;

    BeanProviders(Binder binder) {
        this.locator = binder.getProvider(BeanLocator.class);
    }

    public <K extends Annotation, V> Provider<Iterable<? extends BeanEntry<K, V>>> beanEntriesOf(final Key<V> key2) {
        return new Provider<Iterable<? extends BeanEntry<K, V>>>(){

            public Iterable<? extends BeanEntry<K, V>> get() {
                return ((BeanLocator)BeanProviders.this.locator.get()).locate(key2);
            }
        };
    }

    public <K extends Annotation, V> Provider<Iterable<Map.Entry<K, V>>> entriesOf(Key key2) {
        TypeLiteral type2 = key2.getTypeLiteral();
        Class clazz = type2.getRawType();
        if (javax.inject.Provider.class != clazz && Provider.class != clazz) {
            return this.beanEntriesOf(key2);
        }
        final Provider<Iterable<BeanEntry<K, V>>> beanEntries = this.beanEntriesOf(key2.ofType(TypeArguments.get(type2, 0)));
        return new Provider<Iterable<Map.Entry<K, V>>>(){

            public Iterable<Map.Entry<K, V>> get() {
                return new ProviderIterableAdapter((Iterable)beanEntries.get());
            }
        };
    }

    public <K extends Annotation, V> Provider<List<V>> listOf(Key<V> key2) {
        final Provider<Iterable<Map.Entry<K, V>>> entries = this.entriesOf(key2);
        return new Provider<List<V>>(){

            public List<V> get() {
                return new EntryListAdapter((Iterable)entries.get());
            }
        };
    }

    public <K extends Annotation, V> Provider<Set<V>> setOf(Key<V> key2) {
        final Provider<Iterable<Map.Entry<K, V>>> entries = this.entriesOf(key2);
        return new Provider<Set<V>>(){

            public Set<V> get() {
                return new EntrySetAdapter((Iterable)entries.get());
            }
        };
    }

    public <K extends Annotation, V> Provider<Map<K, V>> mapOf(Key<V> key2) {
        final Provider<Iterable<Map.Entry<K, V>>> entries = this.entriesOf(key2);
        return new Provider<Map<K, V>>(){

            public Map<K, V> get() {
                return new EntryMapAdapter((Iterable)entries.get());
            }
        };
    }

    public <V> Provider<Map<String, V>> stringMapOf(TypeLiteral<V> type2) {
        final Provider entries = this.entriesOf(Key.get(type2, Named.class));
        return new Provider<Map<String, V>>(){

            public Map<String, V> get() {
                return new EntryMapAdapter(new NamedIterableAdapter((Iterable)entries.get()));
            }
        };
    }

    <V> Provider<V> firstOf(Key<V> key2) {
        final Provider beanEntries = this.beanEntriesOf(key2);
        return new Provider<V>(){

            public V get() {
                return BeanProviders.firstOf((Iterable)beanEntries.get());
            }
        };
    }

    public <V> Provider<V> placeholderOf(Key<V> key2) {
        return new PlaceholderBeanProvider<V>(this.locator, key2);
    }

    public static <V> V firstOf(Iterable<? extends Map.Entry<?, V>> entries) {
        Iterator<Map.Entry<?, V>> itr = entries.iterator();
        return itr.hasNext() ? (V)itr.next().getValue() : null;
    }
}

