/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.sisu.inject.DeferredClass;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.URLClassSpace;
import org.eclipse.sisu.space.asm.ClassWriter;
import org.eclipse.sisu.space.asm.MethodVisitor;

public final class CloningClassSpace
extends URLClassSpace {
    private static final String CLONE_MARKER = "$__sisu";
    private int cloneCount;

    public CloningClassSpace(final ClassSpace parent2) {
        super(AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return new CloningClassLoader(parent2);
            }
        }), null);
    }

    public DeferredClass<?> cloneClass(String name2) {
        StringBuilder buf = new StringBuilder();
        if (name2.startsWith("java")) {
            buf.append('$');
        }
        return this.deferLoadClass(buf.append(name2).append(CLONE_MARKER).append(++this.cloneCount).toString());
    }

    public static String originalName(String proxyName) {
        int cloneMarker = proxyName.lastIndexOf(CLONE_MARKER);
        if (cloneMarker < 0) {
            return proxyName;
        }
        int i2 = cloneMarker + CLONE_MARKER.length();
        int end = proxyName.length();
        while (i2 < end) {
            char c2 = proxyName.charAt(i2);
            if (c2 < '0' || c2 > '9') {
                return proxyName;
            }
            ++i2;
        }
        return proxyName.substring('$' == proxyName.charAt(0) ? 1 : 0, cloneMarker);
    }

    private static final class CloningClassLoader
    extends ClassLoader {
        private final ClassSpace parent;

        CloningClassLoader(ClassSpace parent2) {
            this.parent = parent2;
        }

        public String toString() {
            return this.parent.toString();
        }

        @Override
        protected synchronized Class<?> loadClass(String name2, boolean resolve2) throws ClassNotFoundException {
            if (!name2.contains(CloningClassSpace.CLONE_MARKER)) {
                try {
                    return this.parent.loadClass(name2);
                }
                catch (TypeNotPresentException typeNotPresentException) {
                    throw new ClassNotFoundException(name2);
                }
            }
            return super.loadClass(name2, resolve2);
        }

        @Override
        protected Class<?> findClass(String name2) throws ClassNotFoundException {
            String proxyName = name2.replace('.', '/');
            String superName = CloningClassSpace.originalName(proxyName);
            if (superName.equals(proxyName)) {
                throw new ClassNotFoundException(name2);
            }
            ClassWriter cw = new ClassWriter(0);
            cw.visit(50, 1, proxyName, null, superName, null);
            MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, superName, "<init>", "()V", false);
            mv.visitInsn(177);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
            cw.visitEnd();
            byte[] buf = cw.toByteArray();
            return this.defineClass(name2, buf, 0, buf.length);
        }
    }
}

